/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.coerce;

import org.codehaus.groovy.reflection.CachedClass;
import org.gradle.api.internal.coerce.MethodArgumentsTransformer;
import org.gradle.api.internal.coerce.PropertySetTransformer;
import org.gradle.internal.Cast;
import org.gradle.util.GUtil;

public class StringToEnumTransformer
implements MethodArgumentsTransformer,
PropertySetTransformer {
    public static final StringToEnumTransformer INSTANCE = new StringToEnumTransformer();

    @Override
    public Object[] transform(CachedClass[] types, Object[] args) {
        boolean needsTransform = false;
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            Class type = types[i].getTheClass();
            if (type.isInstance(arg) || arg == null) continue;
            if (!(arg instanceof CharSequence) || !type.isEnum()) {
                return args;
            }
            needsTransform = true;
        }
        if (!needsTransform) {
            return args;
        }
        Object[] transformed = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            Class type = types[i].getTheClass();
            transformed[i] = type.isEnum() && arg instanceof CharSequence ? StringToEnumTransformer.toEnumValue((Class)Cast.uncheckedNonnullCast(type), arg) : args[i];
        }
        return transformed;
    }

    @Override
    public boolean canTransform(Object[] args) {
        for (Object arg : args) {
            if (!(arg instanceof CharSequence)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object transformValue(Class<?> type, Object value) {
        if (value instanceof CharSequence && type.isEnum()) {
            Class<?> enumType = type;
            return StringToEnumTransformer.toEnumValue((Class)Cast.uncheckedNonnullCast(enumType), value);
        }
        return value;
    }

    public static <T extends Enum<T>> T toEnumValue(Class<T> enumType, Object value) {
        return GUtil.toEnum(enumType, value);
    }
}

