/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import groovy.lang.Closure;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.file.AbstractFileTree;
import org.gradle.api.internal.file.CompositeFileCollection;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.FilteredFileTree;
import org.gradle.api.internal.file.UnionFileTree;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.Cast;
import org.gradle.internal.Factory;
import org.gradle.util.ConfigureUtil;

public abstract class CompositeFileTree
extends CompositeFileCollection
implements FileTreeInternal {
    public CompositeFileTree(Factory<PatternSet> patternSetFactory) {
        super(patternSetFactory);
    }

    public CompositeFileTree() {
    }

    protected List<? extends FileTreeInternal> getSourceCollections() {
        return (List)Cast.uncheckedNonnullCast(super.getSourceCollections());
    }

    @Override
    public FileTree plus(FileTree fileTree) {
        return new UnionFileTree(this, Cast.cast(FileTreeInternal.class, fileTree));
    }

    @Override
    public FileTree matching(Closure filterConfigClosure) {
        return new FilteredFileTree(this, () -> ConfigureUtil.configure(filterConfigClosure, (PatternSet)this.patternSetFactory.create()));
    }

    @Override
    public FileTree matching(Action<? super PatternFilterable> filterConfigAction) {
        return new FilteredFileTree(this, () -> {
            PatternSet patternSet = (PatternSet)this.patternSetFactory.create();
            filterConfigAction.execute(patternSet);
            return patternSet;
        });
    }

    @Override
    public FileTree matching(PatternFilterable patterns) {
        return new FilteredFileTree(this, () -> {
            if (patterns instanceof PatternSet) {
                return (PatternSet)patterns;
            }
            PatternSet patternSet = (PatternSet)this.patternSetFactory.create();
            patternSet.copyFrom(patterns);
            return patternSet;
        });
    }

    @Override
    public FileTree visit(Closure visitor) {
        return this.visit(AbstractFileTree.fileVisitorFrom(visitor));
    }

    @Override
    public FileTree visit(Action<? super FileVisitDetails> visitor) {
        for (FileTree fileTree : this.getSourceCollections()) {
            fileTree.visit(visitor);
        }
        return this;
    }

    @Override
    public FileTree visit(FileVisitor visitor) {
        for (FileTree fileTree : this.getSourceCollections()) {
            fileTree.visit(visitor);
        }
        return this;
    }

    @Override
    public FileTree getAsFileTree() {
        return this;
    }
}

