/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.AbstractFileCollection;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;

public class SubtractingFileCollection
extends AbstractFileCollection {
    private final AbstractFileCollection left;
    private final FileCollection right;

    public SubtractingFileCollection(AbstractFileCollection left, FileCollection right) {
        super(left.patternSetFactory);
        this.left = left;
        this.right = right;
    }

    public AbstractFileCollection getLeft() {
        return this.left;
    }

    public FileCollection getRight() {
        return this.right;
    }

    @Override
    public String getDisplayName() {
        return "file collection";
    }

    @Override
    public void visitDependencies(TaskDependencyResolveContext context) {
        this.left.visitDependencies(context);
    }

    @Override
    public Set<File> getFiles() {
        LinkedHashSet<File> files = new LinkedHashSet<File>(this.left.getFiles());
        files.removeAll(this.right.getFiles());
        return files;
    }

    @Override
    public boolean contains(File file) {
        return this.left.contains(file) && !this.right.contains(file);
    }
}

