/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.collections;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.CompositeFileCollection;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.UnionFileCollection;
import org.gradle.api.internal.file.collections.DefaultFileCollectionResolveContext;
import org.gradle.api.internal.file.collections.FileCollectionResolveContext;
import org.gradle.api.internal.file.collections.ManagedFactories;
import org.gradle.api.internal.file.collections.UnpackingVisitor;
import org.gradle.api.internal.provider.HasConfigurableValueInternal;
import org.gradle.api.internal.provider.PropertyHost;
import org.gradle.api.internal.tasks.DefaultTaskDependency;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.Factory;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.state.Managed;

public class DefaultConfigurableFileCollection
extends CompositeFileCollection
implements ConfigurableFileCollection,
Managed,
HasConfigurableValueInternal {
    public static final EmptyCollector EMPTY_COLLECTOR = new EmptyCollector();
    private final PathSet filesWrapper;
    private final String displayName;
    private final PathToFileResolver resolver;
    private final PropertyHost host;
    private final DefaultTaskDependency buildDependency;
    private State state = State.Mutable;
    private boolean disallowChanges;
    private boolean disallowUnsafeRead;
    private ValueCollector value = EMPTY_COLLECTOR;

    public DefaultConfigurableFileCollection(@Nullable String displayName, PathToFileResolver fileResolver, TaskDependencyFactory dependencyFactory, Factory<PatternSet> patternSetFactory, PropertyHost host) {
        super(patternSetFactory);
        this.displayName = displayName;
        this.resolver = fileResolver;
        this.host = host;
        this.filesWrapper = new PathSet();
        this.buildDependency = dependencyFactory.configurableDependency();
    }

    @Override
    public boolean isImmutable() {
        return false;
    }

    @Override
    public Class<?> publicType() {
        return ConfigurableFileCollection.class;
    }

    @Override
    public Object unpackState() {
        return this.getFiles();
    }

    @Override
    public void finalizeValue() {
        String reason;
        if (this.state == State.Final) {
            return;
        }
        if (this.disallowUnsafeRead && (reason = this.host.beforeRead(null)) != null) {
            throw new IllegalStateException("Cannot finalize the value for " + this.displayNameForThisCollection() + " because " + reason + ".");
        }
        this.calculateFinalizedValue();
        this.state = State.Final;
        this.disallowChanges = true;
    }

    @Override
    public void disallowChanges() {
        this.disallowChanges = true;
    }

    @Override
    public void finalizeValueOnRead() {
        if (this.state == State.Mutable || this.state == State.ImplicitFinalizeNextQuery) {
            this.state = State.FinalizeNextQuery;
        }
    }

    @Override
    public void implicitFinalizeValue() {
        if (this.state == State.Mutable) {
            this.state = State.ImplicitFinalizeNextQuery;
        }
    }

    @Override
    public void disallowUnsafeRead() {
        this.disallowUnsafeRead = true;
        this.finalizeValueOnRead();
    }

    @Override
    public int getFactoryId() {
        return ManagedFactories.ConfigurableFileCollectionManagedFactory.FACTORY_ID;
    }

    @Override
    public String getDisplayName() {
        return this.displayName == null ? "file collection" : this.displayName;
    }

    @Override
    public Set<Object> getFrom() {
        return this.filesWrapper;
    }

    @Override
    public void setFrom(Iterable<?> path) {
        if (this.assertMutable()) {
            this.value = this.value.setFrom(this, this.resolver, path);
        }
    }

    @Override
    public void setFrom(Object ... paths) {
        if (this.assertMutable()) {
            this.value = this.value.setFrom(this.resolver, paths);
        }
    }

    @Override
    public ConfigurableFileCollection from(Object ... paths) {
        if (this.assertMutable()) {
            this.value = this.value.plus(this.resolver, paths);
        }
        return this;
    }

    private boolean assertMutable() {
        if (this.state == State.Final && this.disallowChanges) {
            throw new IllegalStateException("The value for " + this.displayNameForThisCollection() + " is final and cannot be changed.");
        }
        if (this.disallowChanges) {
            throw new IllegalStateException("The value for " + this.displayNameForThisCollection() + " cannot be changed.");
        }
        if (this.state == State.Final) {
            DeprecationLogger.deprecateAction("Changing the value for a FileCollection with a final value").willBecomeAnErrorInGradle7().withUserManual("lazy_configuration", "unmodifiable_property").nagUser();
            return false;
        }
        return true;
    }

    private String displayNameForThisCollection() {
        return this.displayName == null ? "this file collection" : this.displayName;
    }

    @Override
    public ConfigurableFileCollection builtBy(Object ... tasks) {
        this.buildDependency.add(tasks);
        return this;
    }

    @Override
    public Set<Object> getBuiltBy() {
        return this.buildDependency.getMutableValues();
    }

    @Override
    public ConfigurableFileCollection setBuiltBy(Iterable<?> tasks) {
        this.buildDependency.setValues(tasks);
        return this;
    }

    private void calculateFinalizedValue() {
        DefaultFileCollectionResolveContext context = new DefaultFileCollectionResolveContext(this.patternSetFactory);
        this.value.visitContents(context);
        this.value = new ResolvedItemsCollector(context.resolveAsFileCollections());
    }

    @Override
    public void visitContents(FileCollectionResolveContext context) {
        String reason;
        if (this.disallowUnsafeRead && this.state != State.Final && (reason = this.host.beforeRead(null)) != null) {
            throw new IllegalStateException("Cannot query the value for " + this.displayNameForThisCollection() + " because " + reason + ".");
        }
        if (this.state == State.ImplicitFinalizeNextQuery) {
            this.calculateFinalizedValue();
            this.state = State.Final;
        } else if (this.state == State.FinalizeNextQuery) {
            this.calculateFinalizedValue();
            this.state = State.Final;
            this.disallowChanges = true;
        }
        this.value.visitContents(context);
    }

    @Override
    public void visitDependencies(TaskDependencyResolveContext context) {
        context.add(this.buildDependency);
        super.visitDependencies(context);
    }

    private class PathSet
    extends AbstractSet<Object> {
        private PathSet() {
        }

        private Set<Object> delegate() {
            LinkedHashSet<Object> sources = new LinkedHashSet<Object>();
            DefaultConfigurableFileCollection.this.value.collectSource(sources);
            return sources;
        }

        @Override
        public Iterator<Object> iterator() {
            final Iterator<Object> iterator = this.delegate().iterator();
            return new Iterator<Object>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public Object next() {
                    return iterator.next();
                }

                @Override
                public void remove() {
                    if (DefaultConfigurableFileCollection.this.assertMutable()) {
                        iterator.remove();
                    }
                }
            };
        }

        @Override
        public int size() {
            return this.delegate().size();
        }

        @Override
        public boolean contains(Object o) {
            return this.delegate().contains(o);
        }

        @Override
        public boolean add(Object o) {
            if (DefaultConfigurableFileCollection.this.assertMutable() && !this.delegate().contains(o)) {
                DefaultConfigurableFileCollection.this.value = DefaultConfigurableFileCollection.this.value.plus(DefaultConfigurableFileCollection.this.resolver, o);
                return true;
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            if (DefaultConfigurableFileCollection.this.assertMutable()) {
                return DefaultConfigurableFileCollection.this.value.remove(o);
            }
            return false;
        }

        @Override
        public void clear() {
            if (DefaultConfigurableFileCollection.this.assertMutable()) {
                DefaultConfigurableFileCollection.this.value = EMPTY_COLLECTOR;
            }
        }
    }

    private static class ResolvedItemsCollector
    implements ValueCollector {
        private final ImmutableList<FileCollectionInternal> fileCollections;

        public ResolvedItemsCollector(ImmutableList<FileCollectionInternal> fileCollections) {
            this.fileCollections = fileCollections;
        }

        @Override
        public void collectSource(Collection<Object> dest) {
            dest.addAll((Collection<Object>)this.fileCollections);
        }

        @Override
        public void visitContents(FileCollectionResolveContext context) {
            context.addAll((Iterable<?>)this.fileCollections);
        }

        @Override
        public ValueCollector setFrom(DefaultConfigurableFileCollection owner, PathToFileResolver resolver, Iterable<?> path) {
            throw new UnsupportedOperationException("Should not be called");
        }

        @Override
        public ValueCollector setFrom(PathToFileResolver resolver, Object[] paths) {
            throw new UnsupportedOperationException("Should not be called");
        }

        @Override
        public ValueCollector plus(PathToFileResolver resolver, Object ... paths) {
            throw new UnsupportedOperationException("Should not be called");
        }

        @Override
        public boolean remove(Object source) {
            throw new UnsupportedOperationException("Should not be called");
        }
    }

    private static class UnresolvedItemsCollector
    implements ValueCollector {
        private final PathToFileResolver resolver;
        private final Set<Object> items = new LinkedHashSet<Object>();

        public UnresolvedItemsCollector(DefaultConfigurableFileCollection owner, PathToFileResolver resolver, Iterable<?> item) {
            this.resolver = resolver;
            this.setFrom(owner, resolver, item);
        }

        public UnresolvedItemsCollector(PathToFileResolver resolver, Object[] item) {
            this.resolver = resolver;
            Collections.addAll(this.items, item);
        }

        @Override
        public void collectSource(Collection<Object> dest) {
            dest.addAll(this.items);
        }

        @Override
        public void visitContents(FileCollectionResolveContext context) {
            UnpackingVisitor nested = new UnpackingVisitor(context, this.resolver);
            for (Object item : this.items) {
                nested.add(item);
            }
        }

        @Override
        public boolean remove(Object source) {
            return this.items.remove(source);
        }

        @Override
        public ValueCollector setFrom(DefaultConfigurableFileCollection owner, PathToFileResolver resolver, Iterable<?> path) {
            ImmutableSet oldItems = ImmutableSet.copyOf(this.items);
            this.items.clear();
            if (path instanceof UnionFileCollection) {
                Set<FileCollection> sources = ((UnionFileCollection)path).getSources();
                for (FileCollection source : sources) {
                    if (source != owner) {
                        this.items.add(source);
                        continue;
                    }
                    this.items.addAll((Collection<Object>)oldItems);
                }
            } else {
                this.items.add(path);
            }
            return this;
        }

        @Override
        public ValueCollector setFrom(PathToFileResolver resolver, Object[] paths) {
            this.items.clear();
            Collections.addAll(this.items, paths);
            return this;
        }

        @Override
        public ValueCollector plus(PathToFileResolver resolver, Object ... paths) {
            Collections.addAll(this.items, paths);
            return this;
        }
    }

    private static class EmptyCollector
    implements ValueCollector {
        private EmptyCollector() {
        }

        @Override
        public void collectSource(Collection<Object> dest) {
        }

        @Override
        public void visitContents(FileCollectionResolveContext context) {
        }

        @Override
        public boolean remove(Object source) {
            return false;
        }

        @Override
        public ValueCollector setFrom(DefaultConfigurableFileCollection owner, PathToFileResolver resolver, Iterable<?> path) {
            return new UnresolvedItemsCollector(owner, resolver, path);
        }

        @Override
        public ValueCollector setFrom(PathToFileResolver resolver, Object[] paths) {
            return new UnresolvedItemsCollector(resolver, paths);
        }

        @Override
        public ValueCollector plus(PathToFileResolver resolver, Object ... paths) {
            return this.setFrom(resolver, paths);
        }
    }

    private static interface ValueCollector {
        public void collectSource(Collection<Object> var1);

        public void visitContents(FileCollectionResolveContext var1);

        public boolean remove(Object var1);

        public ValueCollector setFrom(DefaultConfigurableFileCollection var1, PathToFileResolver var2, Iterable<?> var3);

        public ValueCollector setFrom(PathToFileResolver var1, Object[] var2);

        public ValueCollector plus(PathToFileResolver var1, Object ... var2);
    }

    private static enum State {
        Mutable,
        ImplicitFinalizeNextQuery,
        FinalizeNextQuery,
        Final;

    }
}

