/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.deps;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassSetAnalysisData;
import org.gradle.api.internal.tasks.compile.incremental.deps.DependentsSet;
import org.gradle.api.internal.tasks.compile.incremental.processing.AnnotationProcessingData;
import org.gradle.api.internal.tasks.compile.incremental.processing.GeneratedResource;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSetMultimap;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.impldep.it.unimi.dsi.fastutil.ints.IntSet;

public class ClassSetAnalysis {
    private final ClassSetAnalysisData classAnalysis;
    private final AnnotationProcessingData annotationProcessingData;
    private final ImmutableSetMultimap<String, String> classDependenciesFromAnnotationProcessing;
    private final ImmutableSetMultimap<String, GeneratedResource> resourceDependenciesFromAnnotationProcessing;

    public ClassSetAnalysis(ClassSetAnalysisData classAnalysis) {
        this(classAnalysis, new AnnotationProcessingData());
    }

    public ClassSetAnalysis(ClassSetAnalysisData classAnalysis, AnnotationProcessingData annotationProcessingData) {
        this.classAnalysis = classAnalysis;
        this.annotationProcessingData = annotationProcessingData;
        ImmutableSetMultimap.Builder classDependenciesFromAnnotationProcessing = ImmutableSetMultimap.builder();
        for (Map.Entry<String, Set<String>> entry : annotationProcessingData.getGeneratedTypesByOrigin().entrySet()) {
            for (String generated : entry.getValue()) {
                String origin = entry.getKey();
                classDependenciesFromAnnotationProcessing.put((Object)origin, (Object)generated);
                classDependenciesFromAnnotationProcessing.put((Object)generated, (Object)origin);
            }
        }
        this.classDependenciesFromAnnotationProcessing = classDependenciesFromAnnotationProcessing.build();
        ImmutableSetMultimap.Builder resourceDependenciesFromAnnotationProcessing = ImmutableSetMultimap.builder();
        for (Map.Entry<String, Set<GeneratedResource>> entry : annotationProcessingData.getGeneratedResourcesByOrigin().entrySet()) {
            for (GeneratedResource generated : entry.getValue()) {
                String origin = entry.getKey();
                resourceDependenciesFromAnnotationProcessing.put((Object)origin, (Object)generated);
            }
        }
        this.resourceDependenciesFromAnnotationProcessing = resourceDependenciesFromAnnotationProcessing.build();
    }

    public ClassSetAnalysis withAnnotationProcessingData(AnnotationProcessingData annotationProcessingData) {
        return new ClassSetAnalysis(this.classAnalysis, annotationProcessingData);
    }

    public DependentsSet getRelevantDependents(Iterable<String> classes, IntSet constants) {
        LinkedHashSet accessibleResultClasses = Sets.newLinkedHashSet();
        LinkedHashSet privateResultClasses = Sets.newLinkedHashSet();
        LinkedHashSet resultResources = Sets.newLinkedHashSet();
        for (String cls : classes) {
            DependentsSet d = this.getRelevantDependents(cls, constants);
            if (d.isDependencyToAll()) {
                return d;
            }
            if (d.isEmpty()) continue;
            Set<String> accessibleDependentClasses = d.getAccessibleDependentClasses();
            Set<String> privateDependentClasses = d.getPrivateDependentClasses();
            Set<GeneratedResource> dependentResources = d.getDependentResources();
            accessibleResultClasses.addAll(accessibleDependentClasses);
            privateResultClasses.addAll(privateDependentClasses);
            resultResources.addAll(dependentResources);
        }
        return DependentsSet.dependents(privateResultClasses, accessibleResultClasses, resultResources);
    }

    public DependentsSet getRelevantDependents(String className, IntSet constants) {
        String fullRebuildCause = this.annotationProcessingData.getFullRebuildCause();
        if (fullRebuildCause != null) {
            return DependentsSet.dependencyToAll(fullRebuildCause);
        }
        DependentsSet deps = this.getDependents(className);
        if (deps.isDependencyToAll()) {
            return deps;
        }
        if (!constants.isEmpty()) {
            return DependentsSet.dependencyToAll();
        }
        Set<String> classesDependingOnAllOthers = this.annotationProcessingData.getGeneratedTypesDependingOnAllOthers();
        Set<GeneratedResource> resourcesDependingOnAllOthers = this.annotationProcessingData.getGeneratedResourcesDependingOnAllOthers();
        if (!deps.hasDependentClasses() && classesDependingOnAllOthers.isEmpty() && resourcesDependingOnAllOthers.isEmpty()) {
            return deps;
        }
        HashSet<String> privateResultClasses = new HashSet<String>();
        HashSet<String> accessibleResultClasses = new HashSet<String>();
        HashSet<GeneratedResource> resultResources = new HashSet<GeneratedResource>(resourcesDependingOnAllOthers);
        this.processDependentClasses(new HashSet<String>(), privateResultClasses, accessibleResultClasses, resultResources, deps.getPrivateDependentClasses(), deps.getAccessibleDependentClasses());
        this.processDependentClasses(new HashSet<String>(), privateResultClasses, accessibleResultClasses, resultResources, Collections.emptySet(), classesDependingOnAllOthers);
        accessibleResultClasses.remove(className);
        privateResultClasses.remove(className);
        return DependentsSet.dependents(privateResultClasses, accessibleResultClasses, resultResources);
    }

    public Set<String> getTypesToReprocess() {
        return this.annotationProcessingData.getAggregatedTypes();
    }

    public boolean isDependencyToAll(String className) {
        return this.classAnalysis.getDependents(className).isDependencyToAll();
    }

    private void processDependentClasses(Set<String> visitedClasses, Set<String> privateResultClasses, Set<String> accessibleResultClasses, Set<GeneratedResource> resultResources, Iterable<String> privateDependentClasses, Iterable<String> accessibleDependentClasses) {
        DependentsSet currentDependents;
        for (String d : privateDependentClasses) {
            if (!visitedClasses.add(d)) continue;
            privateResultClasses.add(d);
            currentDependents = this.getDependents(d);
            if (currentDependents.isDependencyToAll()) continue;
            resultResources.addAll(currentDependents.getDependentResources());
        }
        for (String d : accessibleDependentClasses) {
            if (!visitedClasses.add(d)) continue;
            accessibleResultClasses.add(d);
            currentDependents = this.getDependents(d);
            if (currentDependents.isDependencyToAll()) continue;
            resultResources.addAll(currentDependents.getDependentResources());
            this.processDependentClasses(visitedClasses, privateResultClasses, accessibleResultClasses, resultResources, Collections.emptySet(), currentDependents.getAccessibleDependentClasses());
        }
    }

    private DependentsSet getDependents(String className) {
        DependentsSet dependents = this.classAnalysis.getDependents(className);
        if (dependents.isDependencyToAll()) {
            return dependents;
        }
        ImmutableSet additionalClassDeps = this.classDependenciesFromAnnotationProcessing.get((Object)className);
        ImmutableSet additionalResourceDeps = this.resourceDependenciesFromAnnotationProcessing.get((Object)className);
        if (additionalClassDeps.isEmpty() && additionalResourceDeps.isEmpty()) {
            return dependents;
        }
        return DependentsSet.dependents(dependents.getPrivateDependentClasses(), (Set<String>)Sets.union(dependents.getAccessibleDependentClasses(), (Set)additionalClassDeps), (Set<GeneratedResource>)Sets.union(dependents.getDependentResources(), (Set)additionalResourceDeps));
    }

    public IntSet getConstants(String className) {
        return this.classAnalysis.getConstants(className);
    }
}

