/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.internal;

import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Bundling;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.attributes.Usage;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.component.AdhocComponentWithVariants;
import org.gradle.api.component.SoftwareComponentContainer;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.dsl.LazyPublishArtifact;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.internal.FeatureSpecInternal;
import org.gradle.api.plugins.internal.JavaConfigurationVariantMapping;
import org.gradle.api.plugins.internal.JvmPluginsHelper;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.internal.component.external.model.ImmutableCapability;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.util.TextUtil;

public class DefaultJavaFeatureSpec
implements FeatureSpecInternal {
    private final String name;
    private final JavaPluginConvention javaPluginConvention;
    private final JavaPluginExtension javaPluginExtension;
    private final ConfigurationContainer configurationContainer;
    private final ObjectFactory objectFactory;
    private final SoftwareComponentContainer components;
    private final TaskContainer tasks;
    private final List<Capability> capabilities = Lists.newArrayListWithExpectedSize((int)2);
    private boolean overrideDefaultCapability = true;
    private SourceSet sourceSet;
    private boolean withJavadocJar = false;
    private boolean withSourcesJar = false;

    public DefaultJavaFeatureSpec(String name, Capability defaultCapability, JavaPluginConvention javaPluginConvention, JavaPluginExtension javaPluginExtension, ConfigurationContainer configurationContainer, ObjectFactory objectFactory, SoftwareComponentContainer components, TaskContainer tasks) {
        this.name = name;
        this.javaPluginConvention = javaPluginConvention;
        this.javaPluginExtension = javaPluginExtension;
        this.configurationContainer = configurationContainer;
        this.objectFactory = objectFactory;
        this.components = components;
        this.tasks = tasks;
        this.capabilities.add(defaultCapability);
    }

    @Override
    public void usingSourceSet(SourceSet sourceSet) {
        this.sourceSet = sourceSet;
    }

    @Override
    public void capability(String group, String name, String version) {
        if (this.overrideDefaultCapability) {
            this.capabilities.clear();
            this.overrideDefaultCapability = false;
        }
        this.capabilities.add(new ImmutableCapability(group, name, version));
    }

    @Override
    public void create() {
        this.setupConfigurations(this.sourceSet);
    }

    @Override
    public void withJavadocJar() {
        this.withJavadocJar = true;
    }

    @Override
    public void withSourcesJar() {
        this.withSourcesJar = true;
    }

    private void setupConfigurations(SourceSet sourceSet) {
        String runtimeElementsConfigurationName;
        String apiElementsConfigurationName;
        String implConfigurationName;
        String apiConfigurationName;
        if (sourceSet == null) {
            throw new InvalidUserCodeException("You must specify which source set to use for feature '" + this.name + "'");
        }
        AdhocComponentWithVariants component = JvmPluginsHelper.findJavaComponent(this.components);
        boolean mainSourceSet = this.isMainSourceSet(sourceSet);
        if (mainSourceSet) {
            apiConfigurationName = this.name + "Api";
            implConfigurationName = this.name + "Implementation";
            apiElementsConfigurationName = apiConfigurationName + "Elements";
            runtimeElementsConfigurationName = this.name + "RuntimeElements";
        } else {
            apiConfigurationName = sourceSet.getApiConfigurationName();
            implConfigurationName = sourceSet.getImplementationConfigurationName();
            apiElementsConfigurationName = sourceSet.getApiElementsConfigurationName();
            runtimeElementsConfigurationName = sourceSet.getRuntimeElementsConfigurationName();
        }
        Configuration api = this.bucket("API", apiConfigurationName);
        Configuration impl = this.bucket("Implementation", implConfigurationName);
        impl.extendsFrom(api);
        Configuration apiElements = this.export(apiElementsConfigurationName);
        apiElements.extendsFrom(api);
        Configuration runtimeElements = this.export(runtimeElementsConfigurationName);
        runtimeElements.extendsFrom(impl);
        this.configureUsage(apiElements, "java-api");
        this.configureUsage(runtimeElements, "java-runtime");
        this.configurePacking(apiElements);
        this.configurePacking(runtimeElements);
        this.configureTargetPlatform(apiElements, sourceSet);
        this.configureTargetPlatform(runtimeElements, sourceSet);
        this.configureCategory(apiElements);
        this.configureCategory(runtimeElements);
        this.configureCapabilities(apiElements);
        this.configureCapabilities(runtimeElements);
        this.attachArtifactToConfiguration(apiElements);
        this.attachArtifactToConfiguration(runtimeElements);
        JvmPluginsHelper.configureJavaDocTask(this.name, sourceSet, this.tasks, this.javaPluginExtension);
        if (this.withJavadocJar) {
            JvmPluginsHelper.configureDocumentationVariantWithArtifact(sourceSet.getJavadocElementsConfigurationName(), this.name, "javadoc", this.capabilities, sourceSet.getJavadocJarTaskName(), this.tasks.named(sourceSet.getJavadocTaskName()), component, this.configurationContainer, this.tasks, this.objectFactory);
        }
        if (this.withSourcesJar) {
            JvmPluginsHelper.configureDocumentationVariantWithArtifact(sourceSet.getSourcesElementsConfigurationName(), this.name, "sources", this.capabilities, sourceSet.getSourcesJarTaskName(), sourceSet.getAllSource(), component, this.configurationContainer, this.tasks, this.objectFactory);
        }
        JvmPluginsHelper.configureClassesDirectoryVariant(sourceSet, this.javaPluginConvention.getProject(), apiElementsConfigurationName, "java-api");
        if (mainSourceSet) {
            this.configurationContainer.getByName("compileClasspath").extendsFrom(impl);
            this.configurationContainer.getByName("runtimeClasspath").extendsFrom(impl);
            this.configurationContainer.getByName("testCompileClasspath").extendsFrom(impl);
            this.configurationContainer.getByName("testRuntimeClasspath").extendsFrom(impl);
        }
        if (component != null) {
            component.addVariantsFromConfiguration(apiElements, new JavaConfigurationVariantMapping("compile", true));
            component.addVariantsFromConfiguration(runtimeElements, new JavaConfigurationVariantMapping("runtime", true));
        }
    }

    private void configureTargetPlatform(Configuration configuration, SourceSet sourceSet) {
        ((ConfigurationInternal)configuration).beforeLocking(JvmPluginsHelper.configureDefaultTargetPlatform(this.javaPluginConvention, true, (TaskProvider<JavaCompile>)this.tasks.named(sourceSet.getCompileJavaTaskName(), JavaCompile.class)));
    }

    private void configurePacking(Configuration configuration) {
        configuration.getAttributes().attribute(Bundling.BUNDLING_ATTRIBUTE, this.objectFactory.named(Bundling.class, "external"));
    }

    private void configureCategory(Configuration configuration) {
        configuration.getAttributes().attribute(Category.CATEGORY_ATTRIBUTE, this.objectFactory.named(Category.class, "library"));
    }

    private void attachArtifactToConfiguration(Configuration configuration) {
        String jarTaskName = this.sourceSet.getJarTaskName();
        if (!this.tasks.getNames().contains(jarTaskName)) {
            this.tasks.register(jarTaskName, Jar.class, new Action<Jar>(){

                @Override
                public void execute(Jar jar) {
                    jar.setDescription("Assembles a jar archive containing the classes of the '" + DefaultJavaFeatureSpec.this.name + "' feature.");
                    jar.setGroup("build");
                    jar.from(DefaultJavaFeatureSpec.this.sourceSet.getOutput());
                    jar.getArchiveClassifier().set(TextUtil.camelToKebabCase(DefaultJavaFeatureSpec.this.name));
                }
            });
        }
        NamedDomainObjectProvider jar = this.tasks.named(jarTaskName);
        configuration.getArtifacts().add(new LazyPublishArtifact(jar));
    }

    private void configureCapabilities(Configuration apiElements) {
        for (Capability capability : this.capabilities) {
            apiElements.getOutgoing().capability(capability);
        }
    }

    private Configuration export(String configName) {
        Configuration configuration = (Configuration)this.configurationContainer.maybeCreate(configName);
        configuration.setCanBeConsumed(true);
        configuration.setCanBeResolved(false);
        return configuration;
    }

    private Configuration bucket(String kind, String configName) {
        Configuration configuration = (Configuration)this.configurationContainer.maybeCreate(configName);
        configuration.setDescription(kind + " dependencies for feature " + this.name);
        configuration.setCanBeResolved(false);
        configuration.setCanBeConsumed(false);
        return configuration;
    }

    private void configureUsage(Configuration conf, final String usage) {
        conf.attributes((Action<AttributeContainer>)new Action<AttributeContainer>(){

            @Override
            public void execute(AttributeContainer attrs) {
                attrs.attribute(Usage.USAGE_ATTRIBUTE, DefaultJavaFeatureSpec.this.objectFactory.named(Usage.class, usage));
                attrs.attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, DefaultJavaFeatureSpec.this.objectFactory.named(LibraryElements.class, "jar"));
            }
        });
    }

    private boolean isMainSourceSet(SourceSet sourceSet) {
        return sourceSet.getName().equals("main");
    }
}

