/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import javax.annotation.Nullable;
import org.gradle.api.Transformer;
import org.gradle.cache.AsyncCacheAccess;
import org.gradle.cache.FileLock;
import org.gradle.cache.MultiProcessSafePersistentIndexedCache;
import org.gradle.cache.internal.MultiProcessSafeAsyncPersistentIndexedCache;
import org.gradle.internal.Factory;

public class AsyncCacheAccessDecoratedCache<K, V>
implements MultiProcessSafeAsyncPersistentIndexedCache<K, V> {
    private final AsyncCacheAccess asyncCacheAccess;
    private final MultiProcessSafePersistentIndexedCache<K, V> persistentCache;

    public AsyncCacheAccessDecoratedCache(AsyncCacheAccess asyncCacheAccess, MultiProcessSafePersistentIndexedCache<K, V> persistentCache) {
        this.asyncCacheAccess = asyncCacheAccess;
        this.persistentCache = persistentCache;
    }

    public String toString() {
        return "{async-cache cache: " + this.persistentCache + "}";
    }

    @Override
    @Nullable
    public V get(final K key) {
        return (V)this.asyncCacheAccess.read(new Factory<V>(){

            @Override
            public V create() {
                return AsyncCacheAccessDecoratedCache.this.persistentCache.get(key);
            }
        });
    }

    @Override
    public V get(K key, Transformer<? extends V, ? super K> producer, Runnable completion) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putLater(final K key, final V value, final Runnable completion) {
        try {
            this.asyncCacheAccess.enqueue(new Runnable(){

                @Override
                public void run() {
                    try {
                        AsyncCacheAccessDecoratedCache.this.persistentCache.put(key, value);
                    }
                    finally {
                        completion.run();
                    }
                }
            });
        }
        catch (RuntimeException e) {
            completion.run();
            throw e;
        }
    }

    @Override
    public void removeLater(final K key, final Runnable completion) {
        try {
            this.asyncCacheAccess.enqueue(new Runnable(){

                @Override
                public void run() {
                    try {
                        AsyncCacheAccessDecoratedCache.this.persistentCache.remove(key);
                    }
                    finally {
                        completion.run();
                    }
                }
            });
        }
        catch (RuntimeException e) {
            completion.run();
            throw e;
        }
    }

    @Override
    public void afterLockAcquire(FileLock.State currentCacheState) {
        this.persistentCache.afterLockAcquire(currentCacheState);
    }

    @Override
    public void finishWork() {
        this.persistentCache.finishWork();
    }

    @Override
    public void beforeLockRelease(FileLock.State currentCacheState) {
        this.persistentCache.beforeLockRelease(currentCacheState);
    }
}

