/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath;

import java.io.Closeable;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.SynchronousQueue;
import java.util.function.Consumer;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.PersistentCache;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.classpath.CachedClasspathTransformer;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.ClasspathBuilder;
import org.gradle.internal.classpath.ClasspathFileTransformer;
import org.gradle.internal.classpath.ClasspathTransformerCacheFactory;
import org.gradle.internal.classpath.ClasspathWalker;
import org.gradle.internal.classpath.CompositeTransformer;
import org.gradle.internal.classpath.CopyingClasspathFileTransformer;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.classpath.InstrumentingClasspathFileTransformer;
import org.gradle.internal.classpath.InstrumentingTransformer;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.ManagedExecutor;
import org.gradle.internal.file.FileAccessTimeJournal;
import org.gradle.internal.file.FileType;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.resource.local.FileAccessTracker;
import org.gradle.internal.snapshot.CompleteFileSystemLocationSnapshot;
import org.gradle.internal.vfs.AdditiveCache;
import org.gradle.internal.vfs.VirtualFileSystem;

public class DefaultCachedClasspathTransformer
implements CachedClasspathTransformer,
Closeable {
    private final PersistentCache cache;
    private final FileAccessTracker fileAccessTracker;
    private final ClasspathWalker classpathWalker;
    private final ClasspathBuilder classpathBuilder;
    private final VirtualFileSystem virtualFileSystem;
    private final List<AdditiveCache> otherCaches;
    private final ManagedExecutor executor;

    public DefaultCachedClasspathTransformer(CacheRepository cacheRepository, ClasspathTransformerCacheFactory classpathTransformerCacheFactory, FileAccessTimeJournal fileAccessTimeJournal, ClasspathWalker classpathWalker, ClasspathBuilder classpathBuilder, VirtualFileSystem virtualFileSystem, ExecutorFactory executorFactory, List<AdditiveCache> otherCaches) {
        this.classpathWalker = classpathWalker;
        this.classpathBuilder = classpathBuilder;
        this.virtualFileSystem = virtualFileSystem;
        this.otherCaches = otherCaches;
        this.cache = classpathTransformerCacheFactory.createCache(cacheRepository, fileAccessTimeJournal);
        this.fileAccessTracker = classpathTransformerCacheFactory.createFileAccessTracker(fileAccessTimeJournal);
        this.executor = executorFactory.create("jar transforms");
    }

    @Override
    public ClassPath transform(ClassPath classPath, CachedClasspathTransformer.StandardTransform transform) {
        return this.transformFiles(classPath, this.fileTransformerFor(transform));
    }

    @Override
    public ClassPath transform(ClassPath classPath, CachedClasspathTransformer.StandardTransform transform, CachedClasspathTransformer.Transform additional) {
        return this.transformFiles(classPath, new InstrumentingClasspathFileTransformer(this.classpathWalker, this.classpathBuilder, new CompositeTransformer(additional, this.transformerFor(transform))));
    }

    @Override
    public Collection<URL> transform(Collection<URL> urls, CachedClasspathTransformer.StandardTransform transform) {
        if (urls.isEmpty()) {
            return ImmutableList.of();
        }
        ClasspathFileTransformer transformer = this.fileTransformerFor(transform);
        return (Collection)this.cache.useCache(() -> {
            ArrayList<CacheOperation> operations = new ArrayList<CacheOperation>(urls.size());
            for (URL url : urls) {
                CacheOperation operation = this.cached(url, transformer);
                operation.schedule(this.executor);
                operations.add(operation);
            }
            ImmutableList.Builder cachedFiles = ImmutableList.builderWithExpectedSize((int)urls.size());
            for (CacheOperation operation : operations) {
                operation.collectUrl(arg_0 -> ((ImmutableList.Builder)cachedFiles).add(arg_0));
            }
            return cachedFiles.build();
        });
    }

    private CachedClasspathTransformer.Transform transformerFor(CachedClasspathTransformer.StandardTransform transform) {
        if (transform == CachedClasspathTransformer.StandardTransform.BuildLogic) {
            return new InstrumentingTransformer();
        }
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    private ClassPath transformFiles(ClassPath classPath, ClasspathFileTransformer transformer) {
        if (classPath.isEmpty()) {
            return classPath;
        }
        return this.cache.useCache(() -> {
            List<File> originalFiles = classPath.getAsFiles();
            ArrayList<CacheOperation> operations = new ArrayList<CacheOperation>(originalFiles.size());
            for (File file : originalFiles) {
                CacheOperation operation = this.cached(file, transformer);
                operation.schedule(this.executor);
                operations.add(operation);
            }
            ArrayList<File> cachedFiles = new ArrayList<File>(originalFiles.size());
            for (CacheOperation operation : operations) {
                operation.collect(cachedFiles::add);
            }
            return DefaultClassPath.of(cachedFiles);
        });
    }

    private ClasspathFileTransformer fileTransformerFor(CachedClasspathTransformer.StandardTransform transform) {
        switch (transform) {
            case BuildLogic: {
                return new InstrumentingClasspathFileTransformer(this.classpathWalker, this.classpathBuilder, new InstrumentingTransformer());
            }
            case None: {
                return new CopyingClasspathFileTransformer(this.otherCaches);
            }
        }
        throw new IllegalArgumentException();
    }

    private CacheOperation cached(URL original, ClasspathFileTransformer transformer) {
        if (original.getProtocol().equals("file")) {
            try {
                return this.cached(new File(original.toURI()), transformer);
            }
            catch (URISyntaxException e) {
                throw UncheckedException.throwAsUncheckedException(e);
            }
        }
        return new RetainUrl(original);
    }

    private CacheOperation cached(File original, ClasspathFileTransformer transformer) {
        CompleteFileSystemLocationSnapshot snapshot = this.virtualFileSystem.read(original.getAbsolutePath(), s -> s);
        if (snapshot.getType() == FileType.Missing) {
            return new EmptyOperation();
        }
        if (this.shouldUseFromCache(original)) {
            return this.getCachedJar(transformer, original, snapshot, this.cache.getBaseDir());
        }
        return new RetainFile(original);
    }

    private CacheOperation getCachedJar(ClasspathFileTransformer transformer, File original, CompleteFileSystemLocationSnapshot snapshot, File cacheDir) {
        return new TransformFile(transformer, original, snapshot, cacheDir);
    }

    private boolean shouldUseFromCache(File original) {
        return !original.toPath().startsWith(this.cache.getBaseDir().toPath());
    }

    @Override
    public void close() {
        CompositeStoppable.stoppable(this.executor, this.cache).stop();
    }

    private class TransformFile
    implements CacheOperation {
        private final SynchronousQueue<Object> queue;
        private final ClasspathFileTransformer transformer;
        private final File original;
        private final CompleteFileSystemLocationSnapshot snapshot;
        private final File cacheDir;

        public TransformFile(ClasspathFileTransformer transformer, File original, CompleteFileSystemLocationSnapshot snapshot, File cacheDir) {
            this.transformer = transformer;
            this.original = original;
            this.snapshot = snapshot;
            this.cacheDir = cacheDir;
            this.queue = new SynchronousQueue();
        }

        @Override
        public void schedule(Executor executor) {
            executor.execute(() -> {
                try {
                    try {
                        File result = this.transformer.transform(this.original, this.snapshot, this.cacheDir);
                        this.queue.put(result);
                    }
                    catch (Throwable t) {
                        this.queue.put(t);
                    }
                }
                catch (InterruptedException e) {
                    throw UncheckedException.throwAsUncheckedException(e);
                }
            });
        }

        @Override
        public void collect(Consumer<File> consumer) {
            Object message;
            try {
                message = this.queue.take();
            }
            catch (InterruptedException e) {
                throw UncheckedException.throwAsUncheckedException(e);
            }
            if (message instanceof Throwable) {
                throw UncheckedException.throwAsUncheckedException((Throwable)message);
            }
            File result = (File)message;
            if (!result.equals(this.original)) {
                DefaultCachedClasspathTransformer.this.fileAccessTracker.markAccessed(result);
            }
            consumer.accept(result);
        }
    }

    private static class EmptyOperation
    implements CacheOperation {
        private EmptyOperation() {
        }

        @Override
        public void schedule(Executor executor) {
        }

        @Override
        public void collect(Consumer<File> consumer) {
        }
    }

    private static class RetainFile
    implements CacheOperation {
        private final File original;

        public RetainFile(File original) {
            this.original = original;
        }

        @Override
        public void schedule(Executor executor) {
        }

        @Override
        public void collect(Consumer<File> consumer) {
            consumer.accept(this.original);
        }
    }

    private static class RetainUrl
    implements CacheOperation {
        private final URL original;

        public RetainUrl(URL original) {
            this.original = original;
        }

        @Override
        public void schedule(Executor executor) {
        }

        @Override
        public void collect(Consumer<File> consumer) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void collectUrl(Consumer<URL> consumer) {
            consumer.accept(this.original);
        }
    }

    static interface CacheOperation {
        public void schedule(Executor var1);

        public void collect(Consumer<File> var1);

        default public void collectUrl(Consumer<URL> consumer) {
            this.collect(file -> {
                try {
                    consumer.accept(file.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    throw UncheckedException.throwAsUncheckedException(e);
                }
            });
        }
    }
}

