/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.typeconversion;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;
import org.gradle.api.Describable;
import org.gradle.internal.Cast;
import org.gradle.internal.typeconversion.CharSequenceNotationConverter;
import org.gradle.internal.typeconversion.CharSequenceNotationParser;
import org.gradle.internal.typeconversion.CompositeNotationConverter;
import org.gradle.internal.typeconversion.ErrorHandlingNotationParser;
import org.gradle.internal.typeconversion.FlatteningNotationParser;
import org.gradle.internal.typeconversion.JustReturningConverter;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.NotationConverterToNotationParserAdapter;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.typeconversion.TypeFilteringNotationConverter;
import org.gradle.internal.typeconversion.TypeInfo;

public class NotationParserBuilder<N, T> {
    private final Class<N> notationType;
    private final TypeInfo<T> resultingType;
    private String invalidNotationMessage;
    private Object typeDisplayName;
    private boolean implicitConverters = true;
    private boolean allowNullInput;
    private final Collection<NotationConverter<? super N, ? extends T>> notationParsers = new LinkedList<NotationConverter<? super N, ? extends T>>();

    public static <T> NotationParserBuilder<Object, T> toType(Class<T> resultingType) {
        return new NotationParserBuilder(Object.class, new TypeInfo(resultingType));
    }

    public static <T> NotationParserBuilder<Object, T> toType(TypeInfo<T> resultingType) {
        return new NotationParserBuilder<Object, T>(Object.class, resultingType);
    }

    public static <N, T> NotationParserBuilder<N, T> builder(Class<N> notationType, Class<T> resultingType) {
        return new NotationParserBuilder(notationType, new TypeInfo(resultingType));
    }

    private NotationParserBuilder(Class<N> notationType, TypeInfo<T> resultingType) {
        this.notationType = notationType;
        this.resultingType = resultingType;
    }

    public NotationParserBuilder<N, T> typeDisplayName(String name) {
        this.typeDisplayName = name;
        return this;
    }

    public NotationParserBuilder<N, T> noImplicitConverters() {
        this.implicitConverters = false;
        return this;
    }

    public NotationParserBuilder<N, T> allowNullInput() {
        this.allowNullInput = true;
        return this;
    }

    public NotationParserBuilder<N, T> converter(NotationConverter<? super N, ? extends T> converter) {
        this.notationParsers.add(converter);
        return this;
    }

    public <S extends N> NotationParserBuilder<N, T> fromType(Class<S> notationType, NotationConverter<? super S, ? extends T> converter) {
        this.notationParsers.add(new TypeFilteringNotationConverter(notationType, converter));
        return this;
    }

    public NotationParserBuilder<N, T> fromCharSequence(NotationConverter<? super String, ? extends T> converter) {
        if (!this.notationType.isAssignableFrom(String.class)) {
            throw new IllegalArgumentException(String.format("Cannot convert from String when notation is %s.", this.notationType.getSimpleName()));
        }
        this.notationParsers.add(new CharSequenceNotationConverter(converter));
        return this;
    }

    public NotationParserBuilder<N, T> fromCharSequence() {
        if (!this.resultingType.getTargetType().equals(String.class)) {
            throw new UnsupportedOperationException("Can only convert from CharSequence when the target type is String.");
        }
        if (!this.notationType.isAssignableFrom(String.class)) {
            throw new IllegalArgumentException(String.format("Cannot convert from String when notation is %s.", this.notationType.getSimpleName()));
        }
        NotationConverter notationParser = (NotationConverter)Cast.uncheckedNonnullCast(new CharSequenceNotationParser());
        this.fromCharSequence(notationParser);
        return this;
    }

    public NotationParserBuilder<N, T> invalidNotationMessage(String invalidNotationMessage) {
        this.invalidNotationMessage = invalidNotationMessage;
        return this;
    }

    public NotationParser<N, Set<T>> toFlatteningComposite() {
        return this.wrapInErrorHandling(new FlatteningNotationParser<N, T>(this.create()));
    }

    public NotationParser<N, T> toComposite() {
        return this.wrapInErrorHandling(this.create());
    }

    private <S> NotationParser<N, S> wrapInErrorHandling(NotationParser<N, S> parser) {
        if (this.typeDisplayName == null) {
            this.typeDisplayName = new LazyDisplayName<T>(this.resultingType);
        }
        return new ErrorHandlingNotationParser<N, S>(this.typeDisplayName, this.invalidNotationMessage, this.allowNullInput, parser);
    }

    private NotationParser<N, T> create() {
        LinkedList composites = new LinkedList();
        if (this.notationType.isAssignableFrom(this.resultingType.getTargetType()) && this.implicitConverters) {
            composites.add(new JustReturningConverter(this.resultingType.getTargetType()));
        }
        composites.addAll(this.notationParsers);
        CompositeNotationConverter notationConverter = composites.size() == 1 ? (CompositeNotationConverter)composites.get(0) : new CompositeNotationConverter(composites);
        return new NotationConverterToNotationParserAdapter(notationConverter);
    }

    private static class LazyDisplayName<T>
    implements Describable {
        private final TypeInfo<T> resultingType;
        private String displayName;

        public LazyDisplayName(TypeInfo<T> resultingType) {
            this.resultingType = resultingType;
        }

        public String toString() {
            return this.getDisplayName();
        }

        @Override
        public String getDisplayName() {
            if (this.displayName == null) {
                this.displayName = this.resultingType.getTargetType().equals(String.class) ? "a String" : "an object of type " + this.resultingType.getTargetType().getSimpleName();
            }
            return this.displayName;
        }
    }
}

