/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.vfs;

import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.internal.snapshot.CompleteFileSystemLocationSnapshot;
import org.gradle.internal.snapshot.SnapshottingFilter;
import org.gradle.internal.vfs.AdditiveCacheLocations;
import org.gradle.internal.vfs.VirtualFileSystem;

public class RoutingVirtualFileSystem
implements VirtualFileSystem {
    private final AdditiveCacheLocations additiveCacheLocations;
    private final VirtualFileSystem gradleUserHomeVirtualFileSystem;
    private final VirtualFileSystem buildScopedVirtualFileSystem;
    private final BooleanSupplier vfsRetained;

    public RoutingVirtualFileSystem(AdditiveCacheLocations additiveCacheLocations, VirtualFileSystem gradleUserHomeVirtualFileSystem, VirtualFileSystem buildScopedVirtualFileSystem, BooleanSupplier vfsRetained) {
        this.additiveCacheLocations = additiveCacheLocations;
        this.gradleUserHomeVirtualFileSystem = gradleUserHomeVirtualFileSystem;
        this.buildScopedVirtualFileSystem = buildScopedVirtualFileSystem;
        this.vfsRetained = vfsRetained;
    }

    @Override
    public <T> T read(String location, Function<CompleteFileSystemLocationSnapshot, T> visitor) {
        return this.getVirtualFileSystemFor(location).read(location, visitor);
    }

    @Override
    public <T> Optional<T> readRegularFileContentHash(String location, Function<HashCode, T> visitor) {
        return this.getVirtualFileSystemFor(location).readRegularFileContentHash(location, visitor);
    }

    @Override
    public void read(String location, SnapshottingFilter filter, Consumer<CompleteFileSystemLocationSnapshot> visitor) {
        this.getVirtualFileSystemFor(location).read(location, filter, visitor);
    }

    @Override
    public void update(Iterable<String> locations, Runnable action) {
        if (Iterables.isEmpty(locations)) {
            return;
        }
        if (this.vfsRetained.getAsBoolean()) {
            this.gradleUserHomeVirtualFileSystem.update(locations, action);
        } else {
            Iterable immutableLocations = Iterables.filter(locations, this.additiveCacheLocations::isInsideAdditiveCache);
            int immutableLocationsSize = Iterables.size((Iterable)immutableLocations);
            if (immutableLocationsSize == 0) {
                this.buildScopedVirtualFileSystem.update(locations, action);
            } else if (immutableLocationsSize == Iterables.size(locations)) {
                this.gradleUserHomeVirtualFileSystem.update(locations, action);
            } else {
                Iterable mutableLocations = Iterables.filter(locations, location -> !this.additiveCacheLocations.isInsideAdditiveCache((String)location));
                this.gradleUserHomeVirtualFileSystem.update(immutableLocations, action);
                this.buildScopedVirtualFileSystem.update(mutableLocations, action);
            }
        }
    }

    @Override
    public void invalidateAll() {
        if (this.vfsRetained.getAsBoolean()) {
            this.gradleUserHomeVirtualFileSystem.invalidateAll();
        } else {
            this.buildScopedVirtualFileSystem.invalidateAll();
        }
    }

    @Override
    public void updateWithKnownSnapshot(CompleteFileSystemLocationSnapshot snapshot) {
        this.getVirtualFileSystemFor(snapshot.getAbsolutePath()).updateWithKnownSnapshot(snapshot);
    }

    private VirtualFileSystem getVirtualFileSystemFor(String location) {
        return this.vfsRetained.getAsBoolean() ? this.gradleUserHomeVirtualFileSystem : (this.additiveCacheLocations.isInsideAdditiveCache(location) ? this.gradleUserHomeVirtualFileSystem : this.buildScopedVirtualFileSystem);
    }
}

