/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.vfs.impl;

import java.util.Optional;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.snapshot.CaseSensitivity;
import org.gradle.internal.snapshot.FileSystemNode;
import org.gradle.internal.snapshot.MetadataSnapshot;
import org.gradle.internal.snapshot.SnapshotHierarchy;
import org.gradle.internal.snapshot.SnapshotUtil;
import org.gradle.internal.snapshot.VfsRelativePath;

public class DefaultSnapshotHierarchy
implements SnapshotHierarchy {
    @VisibleForTesting
    final FileSystemNode rootNode;
    private final CaseSensitivity caseSensitivity;

    public static SnapshotHierarchy from(FileSystemNode rootNode, CaseSensitivity caseSensitivity) {
        return new DefaultSnapshotHierarchy(rootNode, caseSensitivity);
    }

    private DefaultSnapshotHierarchy(FileSystemNode rootNode, CaseSensitivity caseSensitivity) {
        this.rootNode = rootNode;
        this.caseSensitivity = caseSensitivity;
    }

    public static SnapshotHierarchy empty(CaseSensitivity caseSensitivity) {
        switch (caseSensitivity) {
            case CASE_SENSITIVE: {
                return EmptySnapshotHierarchy.CASE_SENSITIVE;
            }
            case CASE_INSENSITIVE: {
                return EmptySnapshotHierarchy.CASE_INSENSITIVE;
            }
        }
        throw new AssertionError((Object)("Unknown case sensitivity: " + (Object)((Object)caseSensitivity)));
    }

    @Override
    public Optional<MetadataSnapshot> getMetadata(String absolutePath) {
        String pathToParent;
        VfsRelativePath relativePath = VfsRelativePath.of(absolutePath);
        if (!relativePath.hasPrefix(pathToParent = this.rootNode.getPathToParent(), this.caseSensitivity)) {
            return Optional.empty();
        }
        return SnapshotUtil.getSnapshotFromChild(this.rootNode, relativePath, this.caseSensitivity);
    }

    @Override
    public SnapshotHierarchy store(String absolutePath, MetadataSnapshot snapshot, SnapshotHierarchy.NodeDiffListener diffListener) {
        VfsRelativePath relativePath = VfsRelativePath.of(absolutePath);
        return new DefaultSnapshotHierarchy(SnapshotUtil.storeSingleChild(this.rootNode, relativePath, this.caseSensitivity, snapshot, diffListener), this.caseSensitivity);
    }

    @Override
    public SnapshotHierarchy invalidate(String absolutePath, SnapshotHierarchy.NodeDiffListener diffListener) {
        VfsRelativePath relativePath = VfsRelativePath.of(absolutePath);
        return SnapshotUtil.invalidateSingleChild(this.rootNode, relativePath, this.caseSensitivity, diffListener).map(newRootNode -> new DefaultSnapshotHierarchy((FileSystemNode)newRootNode, this.caseSensitivity)).orElse(this.empty());
    }

    @Override
    public SnapshotHierarchy empty() {
        return DefaultSnapshotHierarchy.empty(this.caseSensitivity);
    }

    @Override
    public void visitSnapshotRoots(SnapshotHierarchy.SnapshotVisitor snapshotVisitor) {
        this.rootNode.accept(snapshotVisitor);
    }

    private static enum EmptySnapshotHierarchy implements SnapshotHierarchy
    {
        CASE_SENSITIVE(CaseSensitivity.CASE_SENSITIVE),
        CASE_INSENSITIVE(CaseSensitivity.CASE_INSENSITIVE);

        private final CaseSensitivity caseSensitivity;

        private EmptySnapshotHierarchy(CaseSensitivity caseInsensitive) {
            this.caseSensitivity = caseInsensitive;
        }

        @Override
        public Optional<MetadataSnapshot> getMetadata(String absolutePath) {
            return Optional.empty();
        }

        @Override
        public SnapshotHierarchy store(String absolutePath, MetadataSnapshot snapshot, SnapshotHierarchy.NodeDiffListener diffListener) {
            VfsRelativePath relativePath = VfsRelativePath.of(absolutePath);
            FileSystemNode rootNode = snapshot.asFileSystemNode(relativePath.getAsString());
            diffListener.nodeAdded(rootNode);
            return DefaultSnapshotHierarchy.from(rootNode, this.caseSensitivity);
        }

        @Override
        public SnapshotHierarchy invalidate(String absolutePath, SnapshotHierarchy.NodeDiffListener diffListener) {
            return this;
        }

        @Override
        public SnapshotHierarchy empty() {
            return this;
        }

        @Override
        public void visitSnapshotRoots(SnapshotHierarchy.SnapshotVisitor snapshotVisitor) {
        }
    }
}

