/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.tasks;

import groovy.lang.Closure;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.copy.CopySpecInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.java.archives.Manifest;
import org.gradle.api.java.archives.internal.CustomManifestInternalWrapper;
import org.gradle.api.java.archives.internal.DefaultManifest;
import org.gradle.api.java.archives.internal.ManifestInternal;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.bundling.Zip;
import org.gradle.internal.execution.OutputChangeListener;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.util.ConfigureUtil;

public class Jar
extends Zip {
    public static final String DEFAULT_EXTENSION = "jar";
    private String manifestContentCharset = "UTF-8";
    private Manifest manifest;
    private final CopySpecInternal metaInf;

    public Jar() {
        this.getArchiveExtension().set(DEFAULT_EXTENSION);
        this.setMetadataCharset("UTF-8");
        this.manifest = new DefaultManifest(this.getFileResolver());
        this.metaInf = (CopySpecInternal)this.getRootSpec().addFirst().into("META-INF");
        OutputChangeListener outputChangeListener = this.getServices().get(OutputChangeListener.class);
        FileCollectionFactory fileCollectionFactory = this.getServices().get(FileCollectionFactory.class);
        this.metaInf.addChild().from(fileCollectionFactory.generated(this.getTemporaryDirFactory(), "MANIFEST.MF", file -> outputChangeListener.beforeOutputChange((Iterable<String>)ImmutableList.of((Object)file.getAbsolutePath())), outputStream -> {
            Manifest manifest1 = this.getManifest();
            if (manifest1 == null) {
                manifest1 = new DefaultManifest(null);
            }
            ManifestInternal manifestInternal = manifest1 instanceof ManifestInternal ? (ManifestInternal)manifest1 : new CustomManifestInternalWrapper(manifest1);
            manifestInternal.setContentCharset(this.manifestContentCharset);
            manifestInternal.writeTo((OutputStream)outputStream);
        }));
        this.getMainSpec().appendCachingSafeCopyAction(new ExcludeManifestAction());
    }

    @Override
    public String getMetadataCharset() {
        return super.getMetadataCharset();
    }

    @Override
    public void setMetadataCharset(String metadataCharset) {
        super.setMetadataCharset(metadataCharset);
    }

    @Input
    public String getManifestContentCharset() {
        return this.manifestContentCharset;
    }

    public void setManifestContentCharset(String manifestContentCharset) {
        if (manifestContentCharset == null) {
            throw new InvalidUserDataException("manifestContentCharset must not be null");
        }
        if (!Charset.isSupported(manifestContentCharset)) {
            throw new InvalidUserDataException(String.format("Charset for manifestContentCharset '%s' is not supported by your JVM", manifestContentCharset));
        }
        this.manifestContentCharset = manifestContentCharset;
    }

    @Internal
    public Manifest getManifest() {
        return this.manifest;
    }

    public void setManifest(Manifest manifest) {
        this.manifest = manifest;
    }

    public Jar manifest(Closure<?> configureClosure) {
        ConfigureUtil.configure(configureClosure, this.forceManifest());
        return this;
    }

    public Jar manifest(Action<? super Manifest> configureAction) {
        configureAction.execute(this.forceManifest());
        return this;
    }

    private Manifest forceManifest() {
        if (this.manifest == null) {
            this.manifest = new DefaultManifest(((ProjectInternal)this.getProject()).getFileResolver());
        }
        return this.manifest;
    }

    @Internal
    public CopySpec getMetaInf() {
        return this.metaInf.addChild();
    }

    public CopySpec metaInf(Closure<?> configureClosure) {
        return ConfigureUtil.configure(configureClosure, this.getMetaInf());
    }

    public CopySpec metaInf(Action<? super CopySpec> configureAction) {
        CopySpec metaInf = this.getMetaInf();
        configureAction.execute(metaInf);
        return metaInf;
    }

    private static class ExcludeManifestAction
    implements Action<FileCopyDetails> {
        private ExcludeManifestAction() {
        }

        @Override
        public void execute(FileCopyDetails details) {
            if (details.getPath().equalsIgnoreCase("META-INF/MANIFEST.MF")) {
                details.exclude();
            }
        }
    }
}

