/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.registry;

import java.io.EOFException;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import javax.annotation.Nullable;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationStatus;

public class DaemonStopEvent
implements Serializable {
    public static final org.gradle.internal.serialize.Serializer<DaemonStopEvent> SERIALIZER = new Serializer();
    private final Date timestamp;
    @Nullable
    private final Long pid;
    @Nullable
    private final DaemonExpirationStatus status;
    @Nullable
    private final String reason;

    public DaemonStopEvent(Date timestamp, @Nullable Long pid, @Nullable DaemonExpirationStatus status, @Nullable String reason) {
        this.timestamp = timestamp;
        this.status = status;
        this.reason = reason;
        this.pid = pid;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    @Nullable
    public Long getPid() {
        return this.pid;
    }

    @Nullable
    public DaemonExpirationStatus getStatus() {
        return this.status;
    }

    @Nullable
    public String getReason() {
        if (this.reason == null) {
            return "";
        }
        return this.reason;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DaemonStopEvent stopEvent = (DaemonStopEvent)o;
        return this.timestamp.equals(stopEvent.timestamp) && (this.reason != null ? this.reason.equals(stopEvent.reason) : stopEvent.reason == null);
    }

    public int hashCode() {
        int result = this.timestamp.hashCode();
        result = 31 * result + (this.reason != null ? this.reason.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "DaemonStopEvent{timestamp=" + this.timestamp + ", pid=" + this.pid + ", status=" + (Object)((Object)this.status) + "}";
    }

    boolean occurredInLastHours(int numHours) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(System.currentTimeMillis()));
        cal.add(11, -1 * numHours);
        return this.timestamp.after(cal.getTime());
    }

    private static class Serializer
    implements org.gradle.internal.serialize.Serializer<DaemonStopEvent> {
        private Serializer() {
        }

        @Override
        public DaemonStopEvent read(Decoder decoder) throws EOFException, Exception {
            long timestamp = decoder.readLong();
            long pid = decoder.readLong();
            DaemonExpirationStatus status = decoder.readBoolean() ? DaemonExpirationStatus.values()[decoder.readByte()] : null;
            String reason = decoder.readNullableString();
            return new DaemonStopEvent(new Date(timestamp), pid, status, reason);
        }

        @Override
        public void write(Encoder encoder, DaemonStopEvent value) throws Exception {
            encoder.writeLong(value.timestamp.getTime());
            encoder.writeLong(value.pid);
            encoder.writeBoolean(value.status != null);
            if (value.status != null) {
                encoder.writeByte((byte)value.status.ordinal());
            }
            encoder.writeNullableString(value.reason);
        }
    }
}

