/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.internal;

import java.util.Arrays;
import java.util.List;
import org.gradle.api.IllegalDependencyNotation;
import org.gradle.api.artifacts.component.LibraryBinaryIdentifier;
import org.gradle.internal.impldep.com.google.common.base.Joiner;
import org.gradle.internal.impldep.org.apache.commons.lang.ObjectUtils;
import org.gradle.platform.base.DependencySpec;
import org.gradle.platform.base.LibraryBinaryDependencySpec;

public class DefaultLibraryBinaryDependencySpec
implements LibraryBinaryDependencySpec {
    private final String projectPath;
    private final String libraryName;
    private final String variant;

    public DefaultLibraryBinaryDependencySpec(String projectPath, String libraryName, String variant) {
        if (libraryName == null || projectPath == null || variant == null) {
            throw new IllegalDependencyNotation("A direct library binary dependency must have all of project, library name and variant specified.");
        }
        this.libraryName = libraryName;
        this.projectPath = projectPath;
        this.variant = variant;
    }

    @Override
    public String getProjectPath() {
        return this.projectPath;
    }

    @Override
    public String getLibraryName() {
        return this.libraryName;
    }

    @Override
    public String getVariant() {
        return this.variant;
    }

    @Override
    public String getDisplayName() {
        List<String> parts = Arrays.asList("project '" + this.getProjectPath() + "'", "library '" + this.getLibraryName() + "'", "variant '" + this.getVariant() + "'");
        return Joiner.on((char)' ').join(parts);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultLibraryBinaryDependencySpec that = (DefaultLibraryBinaryDependencySpec)o;
        return ObjectUtils.equals((Object)this.projectPath, (Object)that.projectPath) && ObjectUtils.equals((Object)this.libraryName, (Object)that.libraryName) && ObjectUtils.equals((Object)this.variant, (Object)that.variant);
    }

    public int hashCode() {
        int result = ObjectUtils.hashCode((Object)this.projectPath);
        result = 31 * result + ObjectUtils.hashCode((Object)this.libraryName);
        result = 31 * result + ObjectUtils.hashCode((Object)this.variant);
        return result;
    }

    public static DependencySpec of(LibraryBinaryIdentifier id) {
        return new DefaultLibraryBinaryDependencySpec(id.getProjectPath(), id.getLibraryName(), id.getVariant());
    }
}

