/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.scala.internal.reflect;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.gradle.api.GradleException;
import org.gradle.internal.UncheckedException;
import org.gradle.scala.internal.reflect.ScalaObject;

public class ScalaMethod {
    private final String description;
    private final Method method;
    private final Object instance;

    public ScalaMethod(ScalaObject scalaObject, String methodName, Class<?> ... typeParameters) {
        this.description = scalaObject.getClassName() + "." + methodName + "()";
        this.instance = scalaObject.getInstance();
        this.method = this.getMethod(scalaObject.getType(), methodName, typeParameters);
    }

    public ScalaMethod(ClassLoader classLoader, String className, String methodName, Class<?> ... typeParameters) {
        this(new ScalaObject(classLoader, className), methodName, typeParameters);
    }

    private Method getMethod(Class<?> type, String methodName, Class<?>[] typeParameters) {
        try {
            return type.getMethod(methodName, typeParameters);
        }
        catch (NoSuchMethodException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
    }

    public Object invoke(Object ... args) {
        try {
            return this.method.invoke(this.instance, args);
        }
        catch (InvocationTargetException e) {
            throw UncheckedException.throwAsUncheckedException(e.getCause());
        }
        catch (Exception e) {
            throw new GradleException(String.format("Could not invoke Scala method %s.", this.description), e);
        }
    }
}

