/*
 * Decompiled with CFR 0.152.
 */
package git4idea.index;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThrowableConsumer;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.checkin.GitCheckinEnvironment;
import git4idea.i18n.GitBundle;
import git4idea.index.CommitListener;
import git4idea.index.GitCommitUtilKt;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lgit4idea/index/CommitTask;", "Lcom/intellij/openapi/progress/Task$Backgroundable;", "project", "Lcom/intellij/openapi/project/Project;", "roots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "commitMessage", "", "amend", "", "commitHandler", "Lgit4idea/index/CommitListener;", "(Lcom/intellij/openapi/project/Project;Ljava/util/Collection;Ljava/lang/String;ZLgit4idea/index/CommitListener;)V", "failedRoots", "", "Lcom/intellij/openapi/vcs/VcsException;", "successfulRoots", "", "onFinished", "", "run", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.vcs.git"})
public final class CommitTask
extends Task.Backgroundable {
    private final Set<VirtualFile> successfulRoots;
    private final Map<VirtualFile, VcsException> failedRoots;
    private final Collection<VirtualFile> roots;
    private final String commitMessage;
    private final boolean amend;
    private final CommitListener commitHandler;

    public void run(@NotNull ProgressIndicator indicator) {
        Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
        for (VirtualFile root : this.roots) {
            try {
                GitCheckinEnvironment.runWithMessageFile(this.getProject(), root, this.commitMessage, (ThrowableConsumer<? super File, ? extends VcsException>)((ThrowableConsumer)new ThrowableConsumer<File, VcsException>(this, root){
                    final /* synthetic */ CommitTask this$0;
                    final /* synthetic */ VirtualFile $root;

                    public final void consume(@NotNull File commitMessageFile) {
                        Intrinsics.checkParameterIsNotNull((Object)commitMessageFile, (String)"commitMessageFile");
                        Project project = this.this$0.getProject();
                        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                        GitCommitUtilKt.access$doCommit(project, this.$root, commitMessageFile, CommitTask.access$getAmend$p(this.this$0));
                    }
                    {
                        this.this$0 = commitTask;
                        this.$root = virtualFile;
                    }
                }));
                this.successfulRoots.add(root);
            }
            catch (VcsException e) {
                this.failedRoots.put(root, e);
            }
            catch (ProcessCanceledException p) {
                throw (Throwable)p;
            }
            catch (Throwable t) {
                this.failedRoots.put(root, new VcsException(t));
            }
        }
        VcsFileUtil.markFilesDirty((Project)this.getProject(), this.roots);
    }

    public void onFinished() {
        this.commitHandler.commitProcessFinished((Collection<? extends VirtualFile>)this.successfulRoots, this.failedRoots);
    }

    public CommitTask(@NotNull Project project, @NotNull Collection<? extends VirtualFile> roots, @NotNull String commitMessage, boolean amend, @NotNull CommitListener commitHandler) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(roots, (String)"roots");
        Intrinsics.checkParameterIsNotNull((Object)commitMessage, (String)"commitMessage");
        Intrinsics.checkParameterIsNotNull((Object)commitHandler, (String)"commitHandler");
        super(project, GitBundle.message("stage.commit.process", new Object[0]));
        this.roots = roots;
        this.commitMessage = commitMessage;
        this.amend = amend;
        this.commitHandler = commitHandler;
        CommitTask commitTask = this;
        boolean bl = false;
        Object object = new LinkedHashSet();
        commitTask.successfulRoots = object;
        commitTask = this;
        bl = false;
        commitTask.failedRoots = object = (Map)new LinkedHashMap();
    }

    public static final /* synthetic */ boolean access$getAmend$p(CommitTask $this) {
        return $this.amend;
    }
}

