/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.ExceptionInfo;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrayCopyIndexOutOfBoundsExceptionInfo
extends ExceptionInfo {
    private static final String SOURCE_INDEX_PREFIX = "source index ";
    private static final String DESTINATION_INDEX_PREFIX = "destination index ";
    private static final String COMMON_PREFIX = "arraycopy: ";
    private static final String LENGTH_PREFIX = "length ";
    private final int myValue;
    private final int myParameter;

    public ArrayCopyIndexOutOfBoundsExceptionInfo(int offset, String message, int value, int parameter) {
        super(offset, "java.lang.ArrayIndexOutOfBoundsException", message);
        this.myValue = value;
        this.myParameter = parameter;
    }

    public int getValue() {
        return this.myValue;
    }

    @Override
    @Nullable
    PsiElement matchSpecificExceptionElement(@NotNull PsiElement element) {
        if (element == null) {
            ArrayCopyIndexOutOfBoundsExceptionInfo.$$$reportNull$$$0(0);
        }
        if (!(element instanceof PsiIdentifier)) {
            return null;
        }
        if (!element.textMatches((CharSequence)"arraycopy")) {
            return null;
        }
        PsiElement ref = element.getParent();
        if (!(ref instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)ref.getParent(), PsiMethodCallExpression.class);
        if (call == null) {
            return null;
        }
        PsiExpression[] args = call.getArgumentList().getExpressions();
        if (args.length != 5) {
            return null;
        }
        PsiMethod method = call.resolveMethod();
        if (method == null) {
            return null;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null || !"java.lang.System".equals(containingClass.getQualifiedName())) {
            return null;
        }
        return args[this.myParameter];
    }

    public static ExceptionInfo tryCreate(int offset, String message) {
        int index;
        int parameter;
        if (!message.startsWith(COMMON_PREFIX)) {
            return null;
        }
        int indexOffset = COMMON_PREFIX.length();
        if (message.startsWith(SOURCE_INDEX_PREFIX, COMMON_PREFIX.length())) {
            parameter = 1;
            indexOffset += SOURCE_INDEX_PREFIX.length();
        } else if (message.startsWith(DESTINATION_INDEX_PREFIX, COMMON_PREFIX.length())) {
            parameter = 3;
            indexOffset += DESTINATION_INDEX_PREFIX.length();
        } else if (message.startsWith(LENGTH_PREFIX, COMMON_PREFIX.length())) {
            parameter = 4;
            indexOffset += LENGTH_PREFIX.length();
        } else {
            return null;
        }
        int indexEndOffset = message.indexOf(32, indexOffset);
        if (indexEndOffset == -1) {
            return null;
        }
        String indexStr = message.substring(indexOffset, indexEndOffset);
        try {
            index = Integer.parseInt(indexStr);
        }
        catch (NumberFormatException ignored) {
            return null;
        }
        return new ArrayCopyIndexOutOfBoundsExceptionInfo(offset, message, index, parameter);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/execution/filters/ArrayCopyIndexOutOfBoundsExceptionInfo", "matchSpecificExceptionElement"));
    }
}

