/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.libraries;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.LibrariesHelper;
import com.intellij.openapi.util.io.JarUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JarVersionDetectionUtil {
    private JarVersionDetectionUtil() {
    }

    @Nullable
    public static String detectJarVersion(@NotNull String detectionClass, @NotNull Module module) {
        if (detectionClass == null) {
            JarVersionDetectionUtil.$$$reportNull$$$0(0);
        }
        if (module == null) {
            JarVersionDetectionUtil.$$$reportNull$$$0(1);
        }
        for (OrderEntry library : ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
            VirtualFile jar;
            if (!(library instanceof LibraryOrderEntry) || (jar = LibrariesHelper.getInstance().findJarByClass(((LibraryOrderEntry)library).getLibrary(), detectionClass)) == null || !(jar.getFileSystem() instanceof JarFileSystem)) continue;
            return JarVersionDetectionUtil.getMainAttribute(jar, Attributes.Name.IMPLEMENTATION_VERSION);
        }
        return null;
    }

    @Nullable
    public static String detectJarVersion(@NotNull String detectionClass, @NotNull List<? extends VirtualFile> files) {
        VirtualFile jarRoot;
        if (detectionClass == null) {
            JarVersionDetectionUtil.$$$reportNull$$$0(2);
        }
        if (files == null) {
            JarVersionDetectionUtil.$$$reportNull$$$0(3);
        }
        return (jarRoot = LibrariesHelper.getInstance().findRootByClass(files, detectionClass)) != null && jarRoot.getFileSystem() instanceof JarFileSystem ? JarVersionDetectionUtil.getMainAttribute(jarRoot, Attributes.Name.IMPLEMENTATION_VERSION) : null;
    }

    @Nullable
    public static String getMainAttribute(@NotNull VirtualFile jarRoot, @NotNull Attributes.Name attribute) {
        VirtualFile manifestFile;
        if (jarRoot == null) {
            JarVersionDetectionUtil.$$$reportNull$$$0(4);
        }
        if (attribute == null) {
            JarVersionDetectionUtil.$$$reportNull$$$0(5);
        }
        if ((manifestFile = jarRoot.findFileByRelativePath("META-INF/MANIFEST.MF")) != null) {
            String string;
            block11: {
                InputStream stream = manifestFile.getInputStream();
                try {
                    string = new Manifest(stream).getMainAttributes().getValue(attribute);
                    if (stream == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        Logger.getInstance(JarVersionDetectionUtil.class).debug((Throwable)e);
                    }
                }
                stream.close();
            }
            return string;
        }
        return null;
    }

    @Nullable
    public static String getBundleVersion(@NotNull File jar) {
        if (jar == null) {
            JarVersionDetectionUtil.$$$reportNull$$$0(6);
        }
        return JarUtil.getJarAttribute((File)jar, (Attributes.Name)new Attributes.Name("Bundle-Version"));
    }

    @Nullable
    public static String getImplementationVersion(@NotNull File jar) {
        if (jar == null) {
            JarVersionDetectionUtil.$$$reportNull$$$0(7);
        }
        return JarUtil.getJarAttribute((File)jar, (Attributes.Name)Attributes.Name.IMPLEMENTATION_VERSION);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detectionClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jarRoot";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jar";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/roots/libraries/JarVersionDetectionUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "detectJarVersion";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getMainAttribute";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getBundleVersion";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getImplementationVersion";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

