/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.UtilKt;
import java.io.File;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnProgressCanceller;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.ClientFactory;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.dialogs.SelectCreateExternalTargetDialog;
import org.jetbrains.idea.svn.properties.ExternalsDefinitionParser;
import org.jetbrains.idea.svn.properties.PropertyValue;
import org.jetbrains.idea.svn.update.UpdateClient;

public class CreateExternalAction
extends DumbAwareAction {
    public CreateExternalAction() {
        super(SvnBundle.message("svn.create.external.below.action", new Object[0]), SvnBundle.message("svn.create.external.below.description", new Object[0]), null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile file;
        Project project;
        SelectCreateExternalTargetDialog dialog;
        if (e == null) {
            CreateExternalAction.$$$reportNull$$$0(0);
        }
        if ((dialog = new SelectCreateExternalTargetDialog(project = (Project)e.getRequiredData(CommonDataKeys.PROJECT), file = Objects.requireNonNull((VirtualFile)UtilKt.getIfSingle((Stream)((Stream)e.getData(VcsDataKeys.VIRTUAL_FILE_STREAM)))))).showAndGet()) {
            final String url = dialog.getSelectedURL();
            final boolean checkout = dialog.isCheckout();
            final String target = dialog.getLocalTarget().trim();
            new Task.Backgroundable(project, "Creating External"){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    CreateExternalAction.doInBackground(project, file, url, checkout, target);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/idea/svn/actions/CreateExternalAction$1", "run"));
                }
            }.queue();
        }
    }

    private static void doInBackground(@NotNull Project project, @NotNull VirtualFile file, String url, boolean checkout, String target) {
        if (project == null) {
            CreateExternalAction.$$$reportNull$$$0(1);
        }
        if (file == null) {
            CreateExternalAction.$$$reportNull$$$0(2);
        }
        SvnVcs vcs = SvnVcs.getInstance(project);
        VcsDirtyScopeManager dirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)project);
        File ioFile = VfsUtilCore.virtualToIoFile((VirtualFile)file);
        try {
            CreateExternalAction.addToExternalProperty(vcs, ioFile, target, url);
            dirtyScopeManager.fileDirty(file);
            if (checkout) {
                UpdateClient client = vcs.getFactory(ioFile).createUpdateClient();
                client.setEventHandler(new SvnProgressCanceller());
                client.doUpdate(ioFile, Revision.HEAD, Depth.UNKNOWN, false, false);
                file.refresh(true, true, () -> dirtyScopeManager.dirDirtyRecursively(file));
            }
        }
        catch (VcsException e) {
            AbstractVcsHelper.getInstance((Project)project).showError(e, "Create External");
        }
    }

    public static void addToExternalProperty(@NotNull SvnVcs vcs, @NotNull File ioFile, String target, String url) throws VcsException {
        ClientFactory factory;
        PropertyValue propertyValue;
        if (vcs == null) {
            CreateExternalAction.$$$reportNull$$$0(3);
        }
        if (ioFile == null) {
            CreateExternalAction.$$$reportNull$$$0(4);
        }
        boolean hasExternals = (propertyValue = (factory = vcs.getFactory(ioFile)).createPropertyClient().getProperty(Target.on(ioFile), "svn:externals", false, Revision.UNDEFINED)) != null && !StringUtil.isEmptyOrSpaces((String)propertyValue.toString());
        String newExternals = "";
        if (hasExternals) {
            String externalsForTarget = ExternalsDefinitionParser.parseExternalsProperty(propertyValue.toString()).get(target);
            if (externalsForTarget != null) {
                throw new VcsException("Selected destination conflicts with existing: " + externalsForTarget);
            }
            newExternals = propertyValue.toString().trim() + "\n";
        }
        newExternals = newExternals + CommandUtil.escape(url) + " " + target;
        factory.createPropertyClient().setProperty(ioFile, "svn:externals", PropertyValue.create(newExternals), Depth.EMPTY, false);
    }

    public void update(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            CreateExternalAction.$$$reportNull$$$0(5);
        }
        boolean visible = (project = e.getProject()) != null && CreateExternalAction.isSvnActive(project);
        boolean enabled = visible && CreateExternalAction.isEnabled(project, (VirtualFile)UtilKt.getIfSingle((Stream)((Stream)e.getData(VcsDataKeys.VIRTUAL_FILE_STREAM))));
        e.getPresentation().setVisible(visible);
        e.getPresentation().setEnabled(enabled);
    }

    private static boolean isSvnActive(@NotNull Project project) {
        if (project == null) {
            CreateExternalAction.$$$reportNull$$$0(6);
        }
        return ProjectLevelVcsManager.getInstance((Project)project).checkVcsIsActive("svn");
    }

    private static boolean isEnabled(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            CreateExternalAction.$$$reportNull$$$0(7);
        }
        return file != null && file.isDirectory() && ChangesUtil.getVcsForFile((VirtualFile)file, (Project)project) instanceof SvnVcs && CreateExternalAction.isEnabled(FileStatusManager.getInstance((Project)project).getStatus(file));
    }

    private static boolean isEnabled(@Nullable FileStatus status) {
        return status != null && !FileStatus.DELETED.equals(status) && !FileStatus.IGNORED.equals(status) && !FileStatus.MERGED_WITH_PROPERTY_CONFLICTS.equals(status) && !FileStatus.OBSOLETE.equals(status) && !FileStatus.UNKNOWN.equals(status);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ioFile";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/svn/actions/CreateExternalAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "doInBackground";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addToExternalProperty";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isSvnActive";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

