/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.branchConfig.SelectBranchPopup;
import org.jetbrains.idea.svn.branchConfig.SvnBranchMapperManager;
import org.jetbrains.idea.svn.dialogs.WCInfoWithBranches;
import org.jetbrains.idea.svn.integrate.IntegratedSelectedOptionsDialog;
import org.jetbrains.idea.svn.integrate.WorkingCopyInfo;

public class SvnMergeInfoRootPanelManual {
    private JCheckBox myInclude;
    private TextFieldWithBrowseButton myBranchField;
    private FixedSizeButton myFixedSelectLocal;
    private JPanel myContentPanel;
    private JTextArea myUrlText;
    private JTextArea myLocalArea;
    private JTextArea myMixedRevisions;
    @NotNull
    private final Project myProject;
    @NotNull
    private final NotNullFunction<? super WCInfoWithBranches, ? extends WCInfoWithBranches> myRefresher;
    @NotNull
    private final Runnable myListener;
    private boolean myOnlyOneRoot;
    @NotNull
    private WCInfoWithBranches myInfo;
    @NotNull
    private final Map<Url, String> myBranchToLocal;
    private WCInfoWithBranches.Branch mySelectedBranch;

    public SvnMergeInfoRootPanelManual(@NotNull Project project, @NotNull NotNullFunction<? super WCInfoWithBranches, ? extends WCInfoWithBranches> refresher, @NotNull Runnable listener2, boolean onlyOneRoot, @NotNull WCInfoWithBranches info2) {
        if (project == null) {
            SvnMergeInfoRootPanelManual.$$$reportNull$$$0(0);
        }
        if (refresher == null) {
            SvnMergeInfoRootPanelManual.$$$reportNull$$$0(1);
        }
        if (listener2 == null) {
            SvnMergeInfoRootPanelManual.$$$reportNull$$$0(2);
        }
        if (info2 == null) {
            SvnMergeInfoRootPanelManual.$$$reportNull$$$0(3);
        }
        this.myOnlyOneRoot = onlyOneRoot;
        this.myInfo = info2;
        this.myProject = project;
        this.myRefresher = refresher;
        this.myListener = listener2;
        this.myBranchToLocal = new HashMap<Url, String>();
        this.init();
        this.myInclude.setVisible(!onlyOneRoot);
        this.initWithData();
    }

    private void initWithData() {
        this.myInclude.addActionListener(e -> this.myListener.run());
        this.myUrlText.setText(this.myInfo.getUrl().toString());
        this.myFixedSelectLocal.addActionListener(e -> {
            if (this.mySelectedBranch != null) {
                Pair<WorkingCopyInfo, Url> info2 = IntegratedSelectedOptionsDialog.selectWorkingCopy(this.myProject, this.myInfo.getUrl(), this.mySelectedBranch.getUrl(), false, null, null);
                if (info2 != null) {
                    this.calculateBranchPathByBranch(this.mySelectedBranch.getUrl(), ((WorkingCopyInfo)info2.getFirst()).getLocalPath());
                }
                this.myListener.run();
            }
        });
        this.myBranchField.getTextField().setEditable(false);
        this.myBranchField.addActionListener(e -> {
            VirtualFile vf = SvnUtil.getVirtualFile(this.myInfo.getPath());
            if (vf != null) {
                SelectBranchPopup.show(this.myProject, vf, (project, configuration, url, revision) -> {
                    this.refreshSelectedBranch(new WCInfoWithBranches.Branch(url));
                    this.calculateBranchPathByBranch(this.mySelectedBranch.getUrl(), null);
                    this.myListener.run();
                }, SvnBundle.message("select.branch.popup.general.title", new Object[0]));
            }
        });
        if (this.myInfo.getBranches().isEmpty()) {
            this.calculateBranchPathByBranch(null, null);
        } else {
            this.refreshSelectedBranch(this.myInfo.getBranches().get(0));
            this.calculateBranchPathByBranch(this.mySelectedBranch.getUrl(), null);
        }
    }

    private void init() {
        this.myContentPanel = new JPanel(new GridBagLayout());
        this.myContentPanel.setMinimumSize(new Dimension(200, 100));
        GridBagConstraints gb = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insets((int)1), 0, 0);
        this.myInclude = new JCheckBox();
        gb.fill = 0;
        gb.weightx = 0.0;
        this.myContentPanel.add((Component)this.myInclude, gb);
        JLabel hereLabel = new JLabel("From:");
        ++gb.gridy;
        gb.gridx = 0;
        this.myContentPanel.add((Component)hereLabel, gb);
        this.myUrlText = new JTextArea();
        this.myUrlText.setLineWrap(true);
        this.myUrlText.setBackground(UIUtil.getLabelBackground());
        this.myUrlText.setWrapStyleWord(true);
        gb.weightx = 1.0;
        ++gb.gridx;
        gb.gridwidth = 2;
        gb.fill = 2;
        this.myContentPanel.add((Component)this.myUrlText, gb);
        gb.fill = 0;
        JLabel thereLabel = new JLabel("To:");
        gb.weightx = 0.0;
        gb.gridwidth = 1;
        ++gb.gridy;
        gb.gridx = 0;
        this.myContentPanel.add((Component)thereLabel, gb);
        this.myBranchField = new TextFieldWithBrowseButton();
        gb.weightx = 1.0;
        ++gb.gridx;
        gb.gridwidth = 2;
        gb.fill = 2;
        this.myContentPanel.add((Component)this.myBranchField, gb);
        gb.gridx = 1;
        ++gb.gridy;
        gb.gridwidth = 1;
        this.myLocalArea = new JTextArea();
        this.myLocalArea.setBackground(UIUtil.getLabelBackground());
        this.myLocalArea.setLineWrap(true);
        this.myLocalArea.setWrapStyleWord(true);
        this.myContentPanel.add((Component)this.myLocalArea, gb);
        ++gb.gridx;
        gb.weightx = 0.0;
        gb.fill = 0;
        this.myFixedSelectLocal = new FixedSizeButton(20);
        this.myContentPanel.add((Component)this.myFixedSelectLocal, gb);
        ++gb.gridy;
        gb.gridx = 0;
        gb.gridwidth = 2;
        this.myMixedRevisions = new JTextArea("Mixed Revision Working Copy");
        this.myMixedRevisions.setForeground((Color)JBColor.RED);
        this.myMixedRevisions.setBackground(this.myContentPanel.getBackground());
        this.myContentPanel.add((Component)this.myMixedRevisions, gb);
        this.myMixedRevisions.setVisible(false);
    }

    public void setMixedRevisions(boolean value) {
        this.myMixedRevisions.setVisible(value);
    }

    @Nullable
    private static String getLocal(@NotNull Url url, @Nullable String localPath) {
        if (url == null) {
            SvnMergeInfoRootPanelManual.$$$reportNull$$$0(4);
        }
        String result = null;
        Set<String> paths = SvnBranchMapperManager.getInstance().get(url);
        if (!ContainerUtil.isEmpty(paths)) {
            result = localPath != null ? (String)ContainerUtil.find(paths, (Object)localPath) : (String)ContainerUtil.getFirstItem((List)ContainerUtil.sorted(paths));
        }
        return result;
    }

    private void calculateBranchPathByBranch(@Nullable Url url, @Nullable String localPath) {
        String local;
        String string = url == null ? null : (local = SvnMergeInfoRootPanelManual.getLocal(url, localPath == null ? this.myBranchToLocal.get(url) : localPath));
        if (local == null) {
            this.myLocalArea.setForeground((Color)JBColor.RED);
            this.myLocalArea.setText(SvnBundle.message("tab.repository.merge.panel.root.panel.select.local", new Object[0]));
        } else {
            this.myLocalArea.setForeground(UIUtil.getInactiveTextColor());
            this.myLocalArea.setText(local);
            this.myBranchToLocal.put(url, local);
        }
    }

    private void refreshSelectedBranch(@NotNull WCInfoWithBranches.Branch branch) {
        if (branch == null) {
            SvnMergeInfoRootPanelManual.$$$reportNull$$$0(5);
        }
        this.myBranchField.setText(branch.getName());
        if (!this.initSelectedBranch(branch)) {
            this.myInfo = (WCInfoWithBranches)this.myRefresher.fun((Object)this.myInfo);
            this.initSelectedBranch(branch);
        }
    }

    private boolean initSelectedBranch(@NotNull WCInfoWithBranches.Branch branch) {
        boolean found;
        if (branch == null) {
            SvnMergeInfoRootPanelManual.$$$reportNull$$$0(6);
        }
        if (found = this.myInfo.getBranches().contains(branch)) {
            this.mySelectedBranch = branch;
        }
        return found;
    }

    public void setOnlyOneRoot(boolean onlyOneRoot) {
        this.myOnlyOneRoot = onlyOneRoot;
        this.myInclude.setEnabled(!this.myOnlyOneRoot);
        this.myInclude.setSelected(true);
    }

    public JPanel getContentPanel() {
        return this.myContentPanel;
    }

    private void createUIComponents() {
        this.myFixedSelectLocal = new FixedSizeButton(20);
    }

    @NotNull
    public InfoHolder getInfo() {
        return new InfoHolder(this.mySelectedBranch, this.getLocalBranch(), this.myInclude.isSelected());
    }

    public void initSelection(@NotNull InfoHolder holder) {
        if (holder == null) {
            SvnMergeInfoRootPanelManual.$$$reportNull$$$0(7);
        }
        this.myInclude.setSelected(holder.isEnabled());
        if (holder.getBranch() != null) {
            this.refreshSelectedBranch(holder.getBranch());
            this.calculateBranchPathByBranch(this.mySelectedBranch.getUrl(), holder.getLocal());
        }
    }

    @NotNull
    public WCInfoWithBranches getWcInfo() {
        WCInfoWithBranches wCInfoWithBranches = this.myInfo;
        if (wCInfoWithBranches == null) {
            SvnMergeInfoRootPanelManual.$$$reportNull$$$0(8);
        }
        return wCInfoWithBranches;
    }

    @Nullable
    public WCInfoWithBranches.Branch getBranch() {
        return this.mySelectedBranch;
    }

    @Nullable
    public String getLocalBranch() {
        return this.mySelectedBranch != null ? this.myBranchToLocal.get(this.mySelectedBranch.getUrl()) : null;
    }

    public boolean isEnabled() {
        return this.myOnlyOneRoot || this.myInclude.isSelected();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refresher";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branch";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/history/SvnMergeInfoRootPanelManual";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/history/SvnMergeInfoRootPanelManual";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getWcInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLocal";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "refreshSelectedBranch";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "initSelectedBranch";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "initSelection";
                break;
            }
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class InfoHolder {
        @Nullable
        private final WCInfoWithBranches.Branch myBranch;
        @Nullable
        private final String myLocal;
        private final boolean myEnabled;

        public InfoHolder(@Nullable WCInfoWithBranches.Branch branch, @Nullable String local, boolean enabled) {
            this.myBranch = branch;
            this.myLocal = local;
            this.myEnabled = enabled;
        }

        @Nullable
        public WCInfoWithBranches.Branch getBranch() {
            return this.myBranch;
        }

        @Nullable
        public String getLocal() {
            return this.myLocal;
        }

        public boolean isEnabled() {
            return this.myEnabled;
        }
    }
}

