/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.conflicts;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictDialog;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.WritingAccessProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class ChangelistConflictAccessProvider
extends WritingAccessProvider {
    private final Project myProject;

    ChangelistConflictAccessProvider(Project project) {
        this.myProject = project;
    }

    @NotNull
    public Collection<VirtualFile> requestWriting(@NotNull Collection<? extends VirtualFile> files) {
        if (files == null) {
            ChangelistConflictAccessProvider.$$$reportNull$$$0(0);
        }
        ChangeListManagerImpl changeListManager = ChangeListManagerImpl.getInstanceImpl(this.myProject);
        ChangelistConflictTracker.Options options = changeListManager.getConflictTracker().getOptions();
        if (!options.SHOW_DIALOG) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                ChangelistConflictAccessProvider.$$$reportNull$$$0(1);
            }
            return list;
        }
        ArrayList<VirtualFile> denied = new ArrayList<VirtualFile>();
        for (VirtualFile virtualFile : files) {
            if (virtualFile == null || changeListManager.getConflictTracker().isWritingAllowed(virtualFile)) continue;
            denied.add(virtualFile);
        }
        if (!denied.isEmpty()) {
            ChangelistConflictDialog dialog;
            HashSet<LocalChangeList> changeLists = new HashSet<LocalChangeList>();
            ArrayList<Change> arrayList = new ArrayList<Change>();
            for (VirtualFile file : denied) {
                changeLists.add(changeListManager.getChangeList(file));
                arrayList.add(changeListManager.getChange(file));
            }
            int savedEventCount = IdeEventQueue.getInstance().getEventCount();
            do {
                dialog = new ChangelistConflictDialog(this.myProject, new ArrayList<ChangeList>(changeLists), denied);
                dialog.show();
            } while (dialog.isOK() && !dialog.getResolution().resolveConflict(this.myProject, arrayList, null));
            IdeEventQueue.getInstance().setEventCount(savedEventCount);
            if (dialog.isOK()) {
                options.LAST_RESOLUTION = dialog.getResolution();
                List<VirtualFile> list = Collections.emptyList();
                if (list == null) {
                    ChangelistConflictAccessProvider.$$$reportNull$$$0(2);
                }
                return list;
            }
        }
        ArrayList<VirtualFile> arrayList = denied;
        if (arrayList == null) {
            ChangelistConflictAccessProvider.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/conflicts/ChangelistConflictAccessProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/conflicts/ChangelistConflictAccessProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "requestWriting";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "requestWriting";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

