/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.GenericPatchApplier;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.patch.DefaultPatchBaseVersionProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplyPatchForBaseRevisionTexts {
    private static final Logger LOG = Logger.getInstance(ApplyPatchForBaseRevisionTexts.class);
    @NotNull
    private final String myLocal;
    @Nullable
    private final String myBase;
    @NotNull
    private final String myPatched;
    private final boolean myIsAppliedSomehow;

    public ApplyPatchForBaseRevisionTexts(@NotNull String patched, @NotNull String local, @Nullable String base, boolean isAppliedSomehow) {
        if (patched == null) {
            ApplyPatchForBaseRevisionTexts.$$$reportNull$$$0(0);
        }
        if (local == null) {
            ApplyPatchForBaseRevisionTexts.$$$reportNull$$$0(1);
        }
        this.myLocal = local;
        this.myBase = base;
        this.myPatched = patched;
        this.myIsAppliedSomehow = isAppliedSomehow;
    }

    @NotNull
    public String getLocal() {
        String string = this.myLocal;
        if (string == null) {
            ApplyPatchForBaseRevisionTexts.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public String getBase() {
        return this.myBase;
    }

    @NotNull
    public String getPatched() {
        String string = this.myPatched;
        if (string == null) {
            ApplyPatchForBaseRevisionTexts.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean isAppliedSomehow() {
        return this.myIsAppliedSomehow;
    }

    public boolean isBaseRevisionLoaded() {
        return this.myBase != null;
    }

    @NotNull
    public static ApplyPatchForBaseRevisionTexts create(@NotNull Project project, @NotNull VirtualFile file, @NotNull FilePath pathBeforeRename, @NotNull TextFilePatch patch, @Nullable CharSequence baseContents) {
        ApplyPatchForBaseRevisionTexts result2;
        ApplyPatchForBaseRevisionTexts result3;
        if (project == null) {
            ApplyPatchForBaseRevisionTexts.$$$reportNull$$$0(4);
        }
        if (file == null) {
            ApplyPatchForBaseRevisionTexts.$$$reportNull$$$0(5);
        }
        if (pathBeforeRename == null) {
            ApplyPatchForBaseRevisionTexts.$$$reportNull$$$0(6);
        }
        if (patch == null) {
            ApplyPatchForBaseRevisionTexts.$$$reportNull$$$0(7);
        }
        assert (!patch.isNewFile());
        String localContent = ApplyPatchForBaseRevisionTexts.getLocalFileContent(file);
        if (baseContents != null && (result3 = ApplyPatchForBaseRevisionTexts.createFromStoredBase(localContent, patch, baseContents)) != null) {
            ApplyPatchForBaseRevisionTexts applyPatchForBaseRevisionTexts = result3;
            if (applyPatchForBaseRevisionTexts == null) {
                ApplyPatchForBaseRevisionTexts.$$$reportNull$$$0(8);
            }
            return applyPatchForBaseRevisionTexts;
        }
        String beforeVersionId = patch.getBeforeVersionId();
        if (beforeVersionId != null && (result2 = ApplyPatchForBaseRevisionTexts.createFromBaseVersionProvider(project, localContent, patch, beforeVersionId, file, pathBeforeRename)) != null) {
            ApplyPatchForBaseRevisionTexts applyPatchForBaseRevisionTexts = result2;
            if (applyPatchForBaseRevisionTexts == null) {
                ApplyPatchForBaseRevisionTexts.$$$reportNull$$$0(9);
            }
            return applyPatchForBaseRevisionTexts;
        }
        return ApplyPatchForBaseRevisionTexts.createFromLocal(localContent, patch);
    }

    @NotNull
    private static ApplyPatchForBaseRevisionTexts createFromLocal(@NotNull String localContent, @NotNull TextFilePatch patch) {
        if (localContent == null) {
            ApplyPatchForBaseRevisionTexts.$$$reportNull$$$0(10);
        }
        if (patch == null) {
            ApplyPatchForBaseRevisionTexts.$$$reportNull$$$0(11);
        }
        GenericPatchApplier.AppliedSomehowPatch appliedPatch = GenericPatchApplier.applySomehow(localContent, patch.getHunks());
        String patchedContent = StringUtil.convertLineSeparators((String)appliedPatch.patchedText);
        return new ApplyPatchForBaseRevisionTexts(patchedContent, localContent, null, appliedPatch.isAppliedSomehow);
    }

    @Nullable
    private static ApplyPatchForBaseRevisionTexts createFromBaseVersionProvider(@NotNull Project project, @NotNull String localContent, @NotNull TextFilePatch patch, @NotNull String beforeVersionId, @NotNull VirtualFile file, @NotNull FilePath pathBeforeRename) {
        if (project == null) {
            ApplyPatchForBaseRevisionTexts.$$$reportNull$$$0(12);
        }
        if (localContent == null) {
            ApplyPatchForBaseRevisionTexts.$$$reportNull$$$0(13);
        }
        if (patch == null) {
            ApplyPatchForBaseRevisionTexts.$$$reportNull$$$0(14);
        }
        if (beforeVersionId == null) {
            ApplyPatchForBaseRevisionTexts.$$$reportNull$$$0(15);
        }
        if (file == null) {
            ApplyPatchForBaseRevisionTexts.$$$reportNull$$$0(16);
        }
        if (pathBeforeRename == null) {
            ApplyPatchForBaseRevisionTexts.$$$reportNull$$$0(17);
        }
        try {
            List hunks = patch.getHunks();
            Ref baseRef = new Ref();
            Ref patchedRef = new Ref();
            DefaultPatchBaseVersionProvider.getBaseVersionContent(project, beforeVersionId, file, pathBeforeRename, (Processor<? super String>)((Processor)base -> {
                GenericPatchApplier.AppliedPatch appliedPatch = GenericPatchApplier.apply(base, hunks);
                if (appliedPatch == null) {
                    return true;
                }
                baseRef.set(base);
                patchedRef.set((Object)StringUtil.convertLineSeparators((String)appliedPatch.patchedText));
                return false;
            }));
            String base2 = (String)baseRef.get();
            String patched = (String)patchedRef.get();
            if (base2 == null || patched == null) {
                return null;
            }
            return new ApplyPatchForBaseRevisionTexts(patched, localContent, base2, false);
        }
        catch (VcsException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    @Nullable
    private static ApplyPatchForBaseRevisionTexts createFromStoredBase(@NotNull String localContent, @NotNull TextFilePatch patch, @NotNull CharSequence baseContents) {
        if (localContent == null) {
            ApplyPatchForBaseRevisionTexts.$$$reportNull$$$0(18);
        }
        if (patch == null) {
            ApplyPatchForBaseRevisionTexts.$$$reportNull$$$0(19);
        }
        if (baseContents == null) {
            ApplyPatchForBaseRevisionTexts.$$$reportNull$$$0(20);
        }
        List hunks = patch.getHunks();
        String base = baseContents.toString();
        GenericPatchApplier.AppliedPatch appliedPatch = GenericPatchApplier.apply(base, hunks);
        if (appliedPatch == null) {
            LOG.warn(VcsBundle.message((String)"patch.apply.wrong.base.and.can.t.be.applied.warning", (Object[])new Object[]{ObjectUtils.chooseNotNull((Object)patch.getBeforeName(), (Object)patch.getAfterName())}));
            return null;
        }
        String patched = StringUtil.convertLineSeparators((String)appliedPatch.patchedText);
        return new ApplyPatchForBaseRevisionTexts(patched, localContent, base, false);
    }

    @NotNull
    private static String getLocalFileContent(@NotNull VirtualFile file) {
        if (file == null) {
            ApplyPatchForBaseRevisionTexts.$$$reportNull$$$0(21);
        }
        String string = (String)ReadAction.compute(() -> {
            Document document = FileDocumentManager.getInstance().getDocument(file);
            if (document != null) {
                return document.getText();
            }
            return LoadTextUtil.loadText((VirtualFile)file).toString();
        });
        if (string == null) {
            ApplyPatchForBaseRevisionTexts.$$$reportNull$$$0(22);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patched";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "local";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/ApplyPatchForBaseRevisionTexts";
                break;
            }
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathBeforeRename";
                break;
            }
            case 7: 
            case 11: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patch";
                break;
            }
            case 10: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localContent";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeVersionId";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseContents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/ApplyPatchForBaseRevisionTexts";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocal";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatched";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalFileContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 22: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createFromLocal";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createFromBaseVersionProvider";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createFromStoredBase";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getLocalFileContent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

