/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.EmptyConsumer;
import com.intellij.util.concurrency.FutureResult;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.VcsGoToRefComparator;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogImpl
implements VcsLog {
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final AbstractVcsLogUi myUi;

    public VcsLogImpl(@NotNull VcsLogData manager, @NotNull AbstractVcsLogUi ui2) {
        if (manager == null) {
            VcsLogImpl.$$$reportNull$$$0(0);
        }
        if (ui2 == null) {
            VcsLogImpl.$$$reportNull$$$0(1);
        }
        this.myLogData = manager;
        this.myUi = ui2;
    }

    @NotNull
    public List<CommitId> getSelectedCommits() {
        List<CommitId> list = this.myUi.getTable().getModel().getCommitIds(this.myUi.getTable().getSelectedRows());
        if (list == null) {
            VcsLogImpl.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public List<VcsCommitMetadata> getSelectedShortDetails() {
        List<VcsCommitMetadata> list = this.myUi.getTable().getModel().getCommitMetadata(this.myUi.getTable().getSelectedRows());
        if (list == null) {
            VcsLogImpl.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public List<VcsFullCommitDetails> getSelectedDetails() {
        List<VcsFullCommitDetails> list = this.myUi.getTable().getModel().getFullDetails(this.myUi.getTable().getSelectedRows());
        if (list == null) {
            VcsLogImpl.$$$reportNull$$$0(4);
        }
        return list;
    }

    public void requestSelectedDetails(@NotNull Consumer<? super List<VcsFullCommitDetails>> consumer) {
        if (consumer == null) {
            VcsLogImpl.$$$reportNull$$$0(5);
        }
        List rowsList = Ints.asList((int[])this.myUi.getTable().getSelectedRows());
        this.myLogData.getCommitDetailsGetter().loadCommitsData((List)this.getTable().getModel().convertToCommitIds(rowsList), (Consumer)consumer, EmptyConsumer.getInstance(), (ProgressIndicator)null);
    }

    @Nullable
    public Collection<String> getContainingBranches(@NotNull Hash commitHash, @NotNull VirtualFile root) {
        if (commitHash == null) {
            VcsLogImpl.$$$reportNull$$$0(6);
        }
        if (root == null) {
            VcsLogImpl.$$$reportNull$$$0(7);
        }
        return this.myLogData.getContainingBranchesGetter().getContainingBranchesQuickly(root, commitHash);
    }

    @NotNull
    public Future<Boolean> jumpToReference(String reference) {
        if (StringUtil.isEmptyOrSpaces((String)reference)) {
            return new FutureResult((Object)false);
        }
        SettableFuture future2 = SettableFuture.create();
        VcsLogRefs refs = this.myUi.getDataPack().getRefs();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            List matchingRefs = refs.stream().filter(ref -> ref.getName().startsWith(reference)).collect(Collectors.toList());
            ApplicationManager.getApplication().invokeLater(() -> {
                if (matchingRefs.isEmpty()) {
                    future2.setFuture(this.myUi.jumpToHash(reference));
                } else {
                    VcsRef ref = Collections.min(matchingRefs, new VcsGoToRefComparator(this.myUi.getDataPack().getLogProviders()));
                    future2.setFuture(this.myUi.jumpToCommit(ref.getCommitHash(), ref.getRoot()));
                }
            });
        });
        SettableFuture settableFuture = future2;
        if (settableFuture == null) {
            VcsLogImpl.$$$reportNull$$$0(8);
        }
        return settableFuture;
    }

    @NotNull
    public Map<VirtualFile, VcsLogProvider> getLogProviders() {
        Map<VirtualFile, VcsLogProvider> map2 = this.myLogData.getLogProviders();
        if (map2 == null) {
            VcsLogImpl.$$$reportNull$$$0(9);
        }
        return map2;
    }

    @NotNull
    private VcsLogGraphTable getTable() {
        VcsLogGraphTable vcsLogGraphTable = this.myUi.getTable();
        if (vcsLogGraphTable == null) {
            VcsLogImpl.$$$reportNull$$$0(10);
        }
        return vcsLogGraphTable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ui";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/impl/VcsLogImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitHash";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/impl/VcsLogImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedCommits";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedShortDetails";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedDetails";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "jumpToReference";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogProviders";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "requestSelectedDetails";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getContainingBranches";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

