/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js.rhino;

import com.google.gwt.dev.js.rhino.Context;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

class UintMap
implements Serializable {
    static final long serialVersionUID = -6916326879143724506L;
    private static final int A = -1640531527;
    private static final int EMPTY = -1;
    private static final int DELETED = -2;
    private transient int[] keys;
    private transient Object[] values;
    private int power;
    private int keyCount;
    private transient int occupiedCount;
    private transient int ivaluesShift;
    private static final boolean check = false;

    public UintMap() {
        this(4);
    }

    public UintMap(int initialCapacity) {
        if (initialCapacity < 0) {
            Context.codeBug();
        }
        int minimalCapacity = initialCapacity * 4 / 3;
        int i2 = 2;
        while (1 << i2 < minimalCapacity) {
            ++i2;
        }
        this.power = i2;
    }

    public boolean isEmpty() {
        return this.keyCount == 0;
    }

    public int size() {
        return this.keyCount;
    }

    public boolean has(int key) {
        if (key < 0) {
            Context.codeBug();
        }
        return 0 <= this.findIndex(key);
    }

    public Object getObject(int key) {
        int index2;
        if (key < 0) {
            Context.codeBug();
        }
        if (this.values != null && 0 <= (index2 = this.findIndex(key))) {
            return this.values[index2];
        }
        return null;
    }

    public int getInt(int key, int defaultValue2) {
        int index2;
        if (key < 0) {
            Context.codeBug();
        }
        if (0 <= (index2 = this.findIndex(key))) {
            if (this.ivaluesShift != 0) {
                return this.keys[this.ivaluesShift + index2];
            }
            return 0;
        }
        return defaultValue2;
    }

    public int getExistingInt(int key) {
        int index2;
        if (key < 0) {
            Context.codeBug();
        }
        if (0 <= (index2 = this.findIndex(key))) {
            if (this.ivaluesShift != 0) {
                return this.keys[this.ivaluesShift + index2];
            }
            return 0;
        }
        Context.codeBug();
        return 0;
    }

    public void put(int key, Object value2) {
        if (key < 0) {
            Context.codeBug();
        }
        int index2 = this.ensureIndex(key, false);
        if (this.values == null) {
            this.values = new Object[1 << this.power];
        }
        this.values[index2] = value2;
    }

    public void put(int key, int value2) {
        if (key < 0) {
            Context.codeBug();
        }
        int index2 = this.ensureIndex(key, true);
        if (this.ivaluesShift == 0) {
            int N = 1 << this.power;
            if (this.keys.length != N * 2) {
                int[] tmp = new int[N * 2];
                System.arraycopy(this.keys, 0, tmp, 0, N);
                this.keys = tmp;
            }
            this.ivaluesShift = N;
        }
        this.keys[this.ivaluesShift + index2] = value2;
    }

    public void remove(int key) {
        int index2;
        if (key < 0) {
            Context.codeBug();
        }
        if (0 <= (index2 = this.findIndex(key))) {
            this.keys[index2] = -2;
            --this.keyCount;
            if (this.values != null) {
                this.values[index2] = null;
            }
            if (this.ivaluesShift != 0) {
                this.keys[this.ivaluesShift + index2] = 0;
            }
        }
    }

    public void clear() {
        int N = 1 << this.power;
        if (this.keys != null) {
            int i2;
            for (i2 = 0; i2 != N; ++i2) {
                this.keys[i2] = -1;
            }
            if (this.values != null) {
                for (i2 = 0; i2 != N; ++i2) {
                    this.values[i2] = null;
                }
            }
        }
        this.ivaluesShift = 0;
        this.keyCount = 0;
        this.occupiedCount = 0;
    }

    public int[] getKeys() {
        int[] keys = this.keys;
        int n = this.keyCount;
        int[] result2 = new int[n];
        int i2 = 0;
        while (n != 0) {
            int entry = keys[i2];
            if (entry != -1 && entry != -2) {
                result2[--n] = entry;
            }
            ++i2;
        }
        return result2;
    }

    private static int tableLookupStep(int fraction, int mask, int power) {
        int shift = 32 - 2 * power;
        if (shift >= 0) {
            return fraction >>> shift & mask | 1;
        }
        return fraction & mask >>> -shift | 1;
    }

    private int findIndex(int key) {
        int[] keys = this.keys;
        if (keys != null) {
            int fraction = key * -1640531527;
            int index2 = fraction >>> 32 - this.power;
            int entry = keys[index2];
            if (entry == key) {
                return index2;
            }
            if (entry != -1) {
                int mask = (1 << this.power) - 1;
                int step2 = UintMap.tableLookupStep(fraction, mask, this.power);
                boolean n = false;
                do {
                    if ((entry = keys[index2 = index2 + step2 & mask]) != key) continue;
                    return index2;
                } while (entry != -1);
            }
        }
        return -1;
    }

    private int insertNewKey(int key) {
        int[] keys = this.keys;
        int fraction = key * -1640531527;
        int index2 = fraction >>> 32 - this.power;
        if (keys[index2] != -1) {
            int mask = (1 << this.power) - 1;
            int step2 = UintMap.tableLookupStep(fraction, mask, this.power);
            int firstIndex = index2;
            while (keys[index2 = index2 + step2 & mask] != -1) {
            }
        }
        keys[index2] = key;
        ++this.occupiedCount;
        ++this.keyCount;
        return index2;
    }

    private void rehashTable(boolean ensureIntSpace) {
        if (this.keys != null && this.keyCount * 2 >= this.occupiedCount) {
            ++this.power;
        }
        int N = 1 << this.power;
        int[] old = this.keys;
        int oldShift = this.ivaluesShift;
        if (oldShift == 0 && !ensureIntSpace) {
            this.keys = new int[N];
        } else {
            this.ivaluesShift = N;
            this.keys = new int[N * 2];
        }
        for (int i2 = 0; i2 != N; ++i2) {
            this.keys[i2] = -1;
        }
        Object[] oldValues = this.values;
        if (oldValues != null) {
            this.values = new Object[N];
        }
        int oldCount = this.keyCount;
        this.occupiedCount = 0;
        if (oldCount != 0) {
            this.keyCount = 0;
            int i3 = 0;
            int remaining = oldCount;
            while (remaining != 0) {
                int key = old[i3];
                if (key != -1 && key != -2) {
                    int index2 = this.insertNewKey(key);
                    if (oldValues != null) {
                        this.values[index2] = oldValues[i3];
                    }
                    if (oldShift != 0) {
                        this.keys[this.ivaluesShift + index2] = old[oldShift + i3];
                    }
                    --remaining;
                }
                ++i3;
            }
        }
    }

    private int ensureIndex(int key, boolean intType) {
        int index2 = -1;
        int firstDeleted = -1;
        int[] keys = this.keys;
        if (keys != null) {
            int fraction = key * -1640531527;
            index2 = fraction >>> 32 - this.power;
            int entry = keys[index2];
            if (entry == key) {
                return index2;
            }
            if (entry != -1) {
                if (entry == -2) {
                    firstDeleted = index2;
                }
                int mask = (1 << this.power) - 1;
                int step2 = UintMap.tableLookupStep(fraction, mask, this.power);
                boolean n = false;
                do {
                    if ((entry = keys[index2 = index2 + step2 & mask]) == key) {
                        return index2;
                    }
                    if (entry != -2 || firstDeleted >= 0) continue;
                    firstDeleted = index2;
                } while (entry != -1);
            }
        }
        if (firstDeleted >= 0) {
            index2 = firstDeleted;
        } else {
            if (keys == null || this.occupiedCount * 4 >= (1 << this.power) * 3) {
                this.rehashTable(intType);
                return this.insertNewKey(key);
            }
            ++this.occupiedCount;
        }
        keys[index2] = key;
        ++this.keyCount;
        return index2;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        int count = this.keyCount;
        if (count != 0) {
            boolean hasIntValues = this.ivaluesShift != 0;
            boolean hasObjectValues = this.values != null;
            out.writeBoolean(hasIntValues);
            out.writeBoolean(hasObjectValues);
            int i2 = 0;
            while (count != 0) {
                int key = this.keys[i2];
                if (key != -1 && key != -2) {
                    --count;
                    out.writeInt(key);
                    if (hasIntValues) {
                        out.writeInt(this.keys[this.ivaluesShift + i2]);
                    }
                    if (hasObjectValues) {
                        out.writeObject(this.values[i2]);
                    }
                }
                ++i2;
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int writtenKeyCount = this.keyCount;
        if (writtenKeyCount != 0) {
            int i2;
            this.keyCount = 0;
            boolean hasIntValues = in.readBoolean();
            boolean hasObjectValues = in.readBoolean();
            int N = 1 << this.power;
            if (hasIntValues) {
                this.keys = new int[2 * N];
                this.ivaluesShift = N;
            } else {
                this.keys = new int[N];
            }
            for (i2 = 0; i2 != N; ++i2) {
                this.keys[i2] = -1;
            }
            if (hasObjectValues) {
                this.values = new Object[N];
            }
            for (i2 = 0; i2 != writtenKeyCount; ++i2) {
                int key = in.readInt();
                int index2 = this.insertNewKey(key);
                if (hasIntValues) {
                    int ivalue;
                    this.keys[this.ivaluesShift + index2] = ivalue = in.readInt();
                }
                if (!hasObjectValues) continue;
                this.values[index2] = in.readObject();
            }
        }
    }
}

