/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower.loops;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.ir.Symbols;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.loops.DefaultHeaderInfoBuilder;
import org.jetbrains.kotlin.backend.common.lower.loops.ForLoopHeader;
import org.jetbrains.kotlin.backend.common.lower.loops.HeaderProcessor;
import org.jetbrains.kotlin.backend.common.lower.loops.LoopReplacement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.expressions.impl.IrCompositeImpl;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrVariableSymbol;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001&B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\u0006\u0010\u0017\u001a\u00020\u0018J\u0018\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/loops/RangeLoopTransformer;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "oldLoopToNewLoop", "", "Lorg/jetbrains/kotlin/ir/expressions/IrLoop;", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;Ljava/util/Map;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "headerInfoBuilder", "Lorg/jetbrains/kotlin/backend/common/lower/loops/DefaultHeaderInfoBuilder;", "headerProcessor", "Lorg/jetbrains/kotlin/backend/common/lower/loops/HeaderProcessor;", "getOldLoopToNewLoop", "()Ljava/util/Map;", "symbols", "Lorg/jetbrains/kotlin/backend/common/ir/Symbols;", "gatherLoopVariableInfo", "Lorg/jetbrains/kotlin/backend/common/lower/loops/RangeLoopTransformer$LoopVariableInfo;", "statements", "", "Lorg/jetbrains/kotlin/ir/IrStatement;", "getScopeOwnerSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "lowerHeader", "variable", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "loopHeader", "Lorg/jetbrains/kotlin/backend/common/lower/loops/ForLoopHeader;", "lowerWhileLoop", "Lorg/jetbrains/kotlin/backend/common/lower/loops/LoopReplacement;", "loop", "Lorg/jetbrains/kotlin/ir/expressions/IrWhileLoop;", "visitBlock", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrBlock;", "LoopVariableInfo", "ir.backend.common"})
final class RangeLoopTransformer
extends IrElementTransformerVoidWithContext {
    private final Symbols<CommonBackendContext> symbols;
    private final DefaultHeaderInfoBuilder headerInfoBuilder;
    private final HeaderProcessor headerProcessor;
    @NotNull
    private final CommonBackendContext context;
    @NotNull
    private final Map<IrLoop, IrLoop> oldLoopToNewLoop;

    @NotNull
    public final IrSymbol getScopeOwnerSymbol() {
        ScopeWithIr scopeWithIr = this.getCurrentScope();
        if (scopeWithIr == null) {
            Intrinsics.throwNpe();
        }
        return scopeWithIr.getScope().getScopeOwnerSymbol();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrExpression visitBlock(@NotNull IrBlock expression2) {
        void newLoop;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        if (Intrinsics.areEqual((Object)expression2.getOrigin(), (Object)IrStatementOrigin.FOR_LOOP.INSTANCE) ^ true) {
            return super.visitBlock(expression2);
        }
        List<IrStatement> list2 = expression2.getStatements();
        boolean bl = false;
        boolean bl2 = false;
        List<IrStatement> $this$with = list2;
        boolean bl3 = false;
        boolean bl4 = $this$with.size() == 2;
        boolean bl5 = false;
        if (_Assertions.ENABLED && !bl4) {
            boolean $i$a$-assert-RangeLoopTransformer$visitBlock$1$42 = false;
            String $i$a$-assert-RangeLoopTransformer$visitBlock$1$42 = "Expected 2 statements in for-loop block, was:\n" + DumpIrTreeKt.dump$default(expression2, false, 1, null);
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-RangeLoopTransformer$visitBlock$1$42));
        }
        IrStatement irStatement = $this$with.get(0);
        if (irStatement == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrVariable");
        }
        IrVariable iteratorVariable = (IrVariable)irStatement;
        bl5 = Intrinsics.areEqual((Object)iteratorVariable.getOrigin(), (Object)IrDeclarationOrigin.FOR_LOOP_ITERATOR.INSTANCE);
        boolean $i$a$-assert-RangeLoopTransformer$visitBlock$1$42 = false;
        if (_Assertions.ENABLED && !bl5) {
            boolean $i$a$-assert-RangeLoopTransformer$visitBlock$1$52 = false;
            String $i$a$-assert-RangeLoopTransformer$visitBlock$1$52 = "Expected FOR_LOOP_ITERATOR origin for iterator variable, was:\n" + DumpIrTreeKt.dump$default(iteratorVariable, false, 1, null);
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-RangeLoopTransformer$visitBlock$1$52));
        }
        ForLoopHeader forLoopHeader = this.headerProcessor.extractHeader(iteratorVariable);
        if (forLoopHeader == null) {
            return super.visitBlock(expression2);
        }
        ForLoopHeader loopHeader = forLoopHeader;
        IrStatement loweredHeader = this.lowerHeader(iteratorVariable, loopHeader);
        IrStatement irStatement2 = $this$with.get(1);
        if (irStatement2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrWhileLoop");
        }
        IrWhileLoop oldLoop = (IrWhileLoop)irStatement2;
        boolean bl6 = Intrinsics.areEqual((Object)oldLoop.getOrigin(), (Object)IrStatementOrigin.FOR_LOOP_INNER_WHILE.INSTANCE);
        boolean bl7 = false;
        if (_Assertions.ENABLED && !bl6) {
            boolean bl8 = false;
            String string = "Expected FOR_LOOP_INNER_WHILE origin for while loop, was:\n" + DumpIrTreeKt.dump$default(oldLoop, false, 1, null);
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        LoopReplacement loopReplacement = this.lowerWhileLoop(oldLoop, loopHeader);
        if (loopReplacement == null) {
            return super.visitBlock(expression2);
        }
        LoopReplacement loopReplacement2 = loopReplacement;
        IrLoop irLoop = loopReplacement2.component1();
        IrExpression loopReplacementExpression = loopReplacement2.component2();
        this.oldLoopToNewLoop.put(oldLoop, (IrLoop)newLoop);
        $this$with.set(0, loweredHeader);
        $this$with.set(1, loopReplacementExpression);
        return super.visitBlock(expression2);
    }

    private final IrStatement lowerHeader(IrVariable variable2, ForLoopHeader loopHeader) {
        return new IrCompositeImpl(variable2.getStartOffset(), variable2.getEndOffset(), this.context.getIrBuiltIns().getUnitType(), null, loopHeader.getLoopInitStatements());
    }

    /*
     * WARNING - void declaration
     */
    private final LoopReplacement lowerWhileLoop(IrWhileLoop loop2, ForLoopHeader loopHeader) {
        IrExpression irExpression;
        void mainLoopVariableIndex;
        void loopVariableComponents;
        void mainLoopVariable;
        Object object;
        IrExpression irExpression2 = loop2.getBody();
        if (!(irExpression2 instanceof IrContainerExpression)) {
            irExpression2 = null;
        }
        if ((object = (IrContainerExpression)irExpression2) == null || (object = object.getStatements()) == null) {
            return null;
        }
        Object loopBodyStatements = object;
        LoopVariableInfo loopVariableInfo = this.gatherLoopVariableInfo((List<IrStatement>)loopBodyStatements);
        IrVariable irVariable2 = loopVariableInfo.component1();
        int n = loopVariableInfo.component2();
        Map<Integer, IrVariable> map2 = loopVariableInfo.component3();
        List<Integer> loopVariableComponentIndices = loopVariableInfo.component4();
        if (loopHeader.getConsumesLoopVariableComponents() && Intrinsics.areEqual((Object)mainLoopVariable.getOrigin(), (Object)IrDeclarationOrigin.IR_TEMPORARY_VARIABLE.INSTANCE) ^ true) {
            return null;
        }
        IrExpression irExpression3 = mainLoopVariable.getInitializer();
        if (irExpression3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrCall");
        }
        IrCall initializer2 = (IrCall)irExpression3;
        DeclarationIrBuilder declarationIrBuilder = LowerUtilsKt.createIrBuilder(this.context, this.getScopeOwnerSymbol(), initializer2.getStartOffset(), initializer2.getEndOffset());
        boolean bl = false;
        boolean bl2 = false;
        DeclarationIrBuilder $this$with = declarationIrBuilder;
        boolean bl3 = false;
        IrCompositeImpl replacement2 = new IrCompositeImpl(mainLoopVariable.getStartOffset(), mainLoopVariable.getEndOffset(), $this$with.getContext().getIrBuiltIns().getUnitType(), IrStatementOrigin.FOR_LOOP_NEXT.INSTANCE, loopHeader.initializeIteration((IrVariable)mainLoopVariable, (Map<Integer, ? extends IrVariable>)loopVariableComponents, this.symbols, $this$with));
        if (loopHeader.getConsumesLoopVariableComponents()) {
            Iterator iterator2 = CollectionsKt.asReversed(loopVariableComponentIndices).iterator();
            while (iterator2.hasNext()) {
                int index2 = ((Number)iterator2.next()).intValue();
                bl2 = index2 > mainLoopVariableIndex;
                boolean bl4 = false;
                bl3 = false;
                if (_Assertions.ENABLED && !bl2) {
                    boolean bl5 = false;
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                loopBodyStatements.remove(index2);
            }
        }
        loopBodyStatements.set((int)mainLoopVariableIndex, replacement2);
        IrExpression irExpression4 = loop2.getBody();
        if (irExpression4 != null) {
            IrExpression irExpression5 = irExpression4;
            bl2 = false;
            boolean bl6 = false;
            IrExpression it = irExpression5;
            boolean bl7 = false;
            irExpression = it instanceof IrContainerExpression && !((IrContainerExpression)it).isTransparentScope() ? (IrExpression)new IrCompositeImpl(loop2.getStartOffset(), loop2.getEndOffset(), it.getType(), ((IrContainerExpression)it).getOrigin(), ((IrContainerExpression)it).getStatements()) : it;
        } else {
            irExpression = null;
        }
        IrExpression newBody = irExpression;
        return loopHeader.buildLoop(LowerUtilsKt.createIrBuilder(this.context, this.getScopeOwnerSymbol(), loop2.getStartOffset(), loop2.getEndOffset()), loop2, newBody);
    }

    /*
     * WARNING - void declaration
     */
    private final LoopVariableInfo gatherLoopVariableInfo(List<IrStatement> statements2) {
        IrVariable mainLoopVariable = null;
        int mainLoopVariableIndex = -1;
        boolean bl = false;
        Map loopVariableComponents = new LinkedHashMap();
        boolean bl2 = false;
        List loopVariableComponentIndices = new ArrayList();
        bl2 = false;
        for (IrStatement stmt : (Iterable)statements2) {
            void i2;
            if (stmt instanceof IrVariable) {
                IrStatementOrigin origin;
                IrCall initializer2;
                IrExpression irExpression = ((IrVariable)stmt).getInitializer();
                if (!(irExpression instanceof IrCall)) {
                    irExpression = null;
                }
                IrCall irCall = initializer2 = (IrCall)irExpression;
                IrStatementOrigin irStatementOrigin = origin = irCall != null ? irCall.getOrigin() : null;
                if (Intrinsics.areEqual((Object)origin, (Object)IrStatementOrigin.FOR_LOOP_NEXT.INSTANCE)) {
                    mainLoopVariable = (IrVariable)stmt;
                    mainLoopVariableIndex = i2;
                } else if (origin instanceof IrStatementOrigin.COMPONENT_N && mainLoopVariable != null) {
                    IrExpression irExpression2 = initializer2.getDispatchReceiver();
                    if (!(irExpression2 instanceof IrGetValue)) {
                        irExpression2 = null;
                    }
                    IrGetValue irGetValue = (IrGetValue)irExpression2;
                    if (Intrinsics.areEqual((Object)(irGetValue != null ? irGetValue.getSymbol() : null), (Object)((IrVariableSymbol)mainLoopVariable.getSymbol()))) {
                        loopVariableComponents.put(((IrStatementOrigin.COMPONENT_N)origin).getIndex(), stmt);
                        loopVariableComponentIndices.add((int)i2);
                    }
                }
            }
            ++i2;
        }
        bl2 = false;
        boolean bl3 = false;
        if (mainLoopVariable == null) {
            boolean bl4 = false;
            String string = "No 'next' statement in for-loop";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        bl2 = mainLoopVariableIndex >= 0;
        bl3 = false;
        boolean bl5 = false;
        if (_Assertions.ENABLED && !bl2) {
            boolean bl6 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return new LoopVariableInfo(mainLoopVariable, mainLoopVariableIndex, loopVariableComponents, loopVariableComponentIndices);
    }

    @NotNull
    public final CommonBackendContext getContext() {
        return this.context;
    }

    @NotNull
    public final Map<IrLoop, IrLoop> getOldLoopToNewLoop() {
        return this.oldLoopToNewLoop;
    }

    public RangeLoopTransformer(@NotNull CommonBackendContext context2, @NotNull Map<IrLoop, IrLoop> oldLoopToNewLoop) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull(oldLoopToNewLoop, (String)"oldLoopToNewLoop");
        this.context = context2;
        this.oldLoopToNewLoop = oldLoopToNewLoop;
        this.symbols = this.context.getIr().getSymbols();
        this.headerInfoBuilder = new DefaultHeaderInfoBuilder(this.context, (Function0<? extends IrSymbol>)((Function0)new Function0<IrSymbol>(this){

            @NotNull
            public final IrSymbol invoke() {
                return ((RangeLoopTransformer)this.receiver).getScopeOwnerSymbol();
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(RangeLoopTransformer.class);
            }

            public final String getName() {
                return "getScopeOwnerSymbol";
            }

            public final String getSignature() {
                return "getScopeOwnerSymbol()Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;";
            }
        }));
        this.headerProcessor = new HeaderProcessor(this.context, this.headerInfoBuilder, (Function0<? extends IrSymbol>)((Function0)new Function0<IrSymbol>(this){

            @NotNull
            public final IrSymbol invoke() {
                return ((RangeLoopTransformer)this.receiver).getScopeOwnerSymbol();
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(RangeLoopTransformer.class);
            }

            public final String getName() {
                return "getScopeOwnerSymbol";
            }

            public final String getSignature() {
                return "getScopeOwnerSymbol()Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;";
            }
        }));
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00030\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\u0015\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00030\u0007H\u00c6\u0003J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\tH\u00c6\u0003JC\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00030\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/loops/RangeLoopTransformer$LoopVariableInfo;", "", "mainLoopVariable", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "mainLoopVariableIndex", "", "loopVariableComponents", "", "loopVariableComponentIndices", "", "(Lorg/jetbrains/kotlin/ir/declarations/IrVariable;ILjava/util/Map;Ljava/util/List;)V", "getLoopVariableComponentIndices", "()Ljava/util/List;", "getLoopVariableComponents", "()Ljava/util/Map;", "getMainLoopVariable", "()Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "getMainLoopVariableIndex", "()I", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "ir.backend.common"})
    private static final class LoopVariableInfo {
        @NotNull
        private final IrVariable mainLoopVariable;
        private final int mainLoopVariableIndex;
        @NotNull
        private final Map<Integer, IrVariable> loopVariableComponents;
        @NotNull
        private final List<Integer> loopVariableComponentIndices;

        @NotNull
        public final IrVariable getMainLoopVariable() {
            return this.mainLoopVariable;
        }

        public final int getMainLoopVariableIndex() {
            return this.mainLoopVariableIndex;
        }

        @NotNull
        public final Map<Integer, IrVariable> getLoopVariableComponents() {
            return this.loopVariableComponents;
        }

        @NotNull
        public final List<Integer> getLoopVariableComponentIndices() {
            return this.loopVariableComponentIndices;
        }

        public LoopVariableInfo(@NotNull IrVariable mainLoopVariable, int mainLoopVariableIndex, @NotNull Map<Integer, ? extends IrVariable> loopVariableComponents, @NotNull List<Integer> loopVariableComponentIndices) {
            Intrinsics.checkParameterIsNotNull((Object)mainLoopVariable, (String)"mainLoopVariable");
            Intrinsics.checkParameterIsNotNull(loopVariableComponents, (String)"loopVariableComponents");
            Intrinsics.checkParameterIsNotNull(loopVariableComponentIndices, (String)"loopVariableComponentIndices");
            this.mainLoopVariable = mainLoopVariable;
            this.mainLoopVariableIndex = mainLoopVariableIndex;
            this.loopVariableComponents = loopVariableComponents;
            this.loopVariableComponentIndices = loopVariableComponentIndices;
        }

        @NotNull
        public final IrVariable component1() {
            return this.mainLoopVariable;
        }

        public final int component2() {
            return this.mainLoopVariableIndex;
        }

        @NotNull
        public final Map<Integer, IrVariable> component3() {
            return this.loopVariableComponents;
        }

        @NotNull
        public final List<Integer> component4() {
            return this.loopVariableComponentIndices;
        }

        @NotNull
        public final LoopVariableInfo copy(@NotNull IrVariable mainLoopVariable, int mainLoopVariableIndex, @NotNull Map<Integer, ? extends IrVariable> loopVariableComponents, @NotNull List<Integer> loopVariableComponentIndices) {
            Intrinsics.checkParameterIsNotNull((Object)mainLoopVariable, (String)"mainLoopVariable");
            Intrinsics.checkParameterIsNotNull(loopVariableComponents, (String)"loopVariableComponents");
            Intrinsics.checkParameterIsNotNull(loopVariableComponentIndices, (String)"loopVariableComponentIndices");
            return new LoopVariableInfo(mainLoopVariable, mainLoopVariableIndex, loopVariableComponents, loopVariableComponentIndices);
        }

        public static /* synthetic */ LoopVariableInfo copy$default(LoopVariableInfo loopVariableInfo, IrVariable irVariable2, int n, Map map2, List list2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                irVariable2 = loopVariableInfo.mainLoopVariable;
            }
            if ((n2 & 2) != 0) {
                n = loopVariableInfo.mainLoopVariableIndex;
            }
            if ((n2 & 4) != 0) {
                map2 = loopVariableInfo.loopVariableComponents;
            }
            if ((n2 & 8) != 0) {
                list2 = loopVariableInfo.loopVariableComponentIndices;
            }
            return loopVariableInfo.copy(irVariable2, n, map2, list2);
        }

        @NotNull
        public String toString() {
            return "LoopVariableInfo(mainLoopVariable=" + this.mainLoopVariable + ", mainLoopVariableIndex=" + this.mainLoopVariableIndex + ", loopVariableComponents=" + this.loopVariableComponents + ", loopVariableComponentIndices=" + this.loopVariableComponentIndices + ")";
        }

        public int hashCode() {
            IrVariable irVariable2 = this.mainLoopVariable;
            Map<Integer, IrVariable> map2 = this.loopVariableComponents;
            List<Integer> list2 = this.loopVariableComponentIndices;
            return (((irVariable2 != null ? irVariable2.hashCode() : 0) * 31 + Integer.hashCode(this.mainLoopVariableIndex)) * 31 + (map2 != null ? ((Object)map2).hashCode() : 0)) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof LoopVariableInfo)) break block3;
                    LoopVariableInfo loopVariableInfo = (LoopVariableInfo)object;
                    if (!Intrinsics.areEqual((Object)this.mainLoopVariable, (Object)loopVariableInfo.mainLoopVariable) || this.mainLoopVariableIndex != loopVariableInfo.mainLoopVariableIndex || !Intrinsics.areEqual(this.loopVariableComponents, loopVariableInfo.loopVariableComponents) || !Intrinsics.areEqual(this.loopVariableComponentIndices, loopVariableInfo.loopVariableComponentIndices)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

