/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.serialization.KlibIrVersion;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\u0010\b\n\u0000\u001a\u0012\u0010\u0005\u001a\u00020\u00012\n\u0010\u0006\u001a\u00020\u0007\"\u00020\b\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\t"}, d2={"metadataVersion", "Lorg/jetbrains/kotlin/backend/common/serialization/KlibIrVersion;", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "getMetadataVersion", "(Lorg/jetbrains/kotlin/library/KotlinLibrary;)Lorg/jetbrains/kotlin/backend/common/serialization/KlibIrVersion;", "KlibIrVersion", "values", "", "", "ir.serialization.common"})
public final class KlibIrVersionKt {
    @NotNull
    public static final KlibIrVersion KlibIrVersion(int ... values) {
        Intrinsics.checkParameterIsNotNull((Object)values, (String)"values");
        if (values.length != 3) {
            String string = "Ir version should be in major.minor.patch format: " + values;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return new KlibIrVersion(values[0], values[1], values[2]);
    }

    @NotNull
    public static final KlibIrVersion getMetadataVersion(@NotNull KotlinLibrary $this$metadataVersion) {
        String versionString;
        Intrinsics.checkParameterIsNotNull((Object)$this$metadataVersion, (String)"$this$metadataVersion");
        String string = versionString = $this$metadataVersion.getManifestProperties().getProperty("ir_version");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"versionString");
        int[] nArray = BinaryVersion.Companion.parseVersionArray(string);
        if (nArray == null) {
            String string2 = "Could not parse ir version: " + versionString;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        int[] versionIntArray = nArray;
        return KlibIrVersionKt.KlibIrVersion(Arrays.copyOf(versionIntArray, versionIntArray.length));
    }
}

