/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrValueParameterBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.impl.IrFunctionImpl;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\f\u0010\u000e\u001a\u00020\u000f*\u00020\fH\u0002J\f\u0010\u0010\u001a\u00020\u000f*\u00020\fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/MainMethodGenerationLowering;", "Lorg/jetbrains/kotlin/backend/common/ClassLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "generateMainMethod", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "parameterlessMain", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "lower", "isMainMethod", "", "isParameterlessMainMethod", "backend.jvm"})
public final class MainMethodGenerationLowering
implements ClassLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    @Override
    public void lower(@NotNull IrClass irClass) {
        boolean bl;
        IrSimpleFunction parameterlessMain;
        block7: {
            Object v0;
            block6: {
                Intrinsics.checkParameterIsNotNull((Object)irClass, (String)"irClass");
                if (!CommonConfigurationKeysKt.getLanguageVersionSettings(this.context.getConfiguration()).supportsFeature(LanguageFeature.ExtendedMainConvention)) {
                    return;
                }
                if (Intrinsics.areEqual((Object)irClass.getOrigin(), (Object)IrDeclarationOrigin.FILE_CLASS.INSTANCE) ^ true) {
                    return;
                }
                Sequence<IrSimpleFunction> sequence2 = IrUtilsKt.getFunctions(irClass);
                boolean bl2 = false;
                Sequence<IrSimpleFunction> sequence3 = sequence2;
                boolean bl3 = false;
                Iterator iterator2 = sequence3.iterator();
                while (iterator2.hasNext()) {
                    Object e = iterator2.next();
                    IrSimpleFunction it = (IrSimpleFunction)e;
                    boolean bl4 = false;
                    if (!this.isParameterlessMainMethod(it)) continue;
                    v0 = e;
                    break block6;
                }
                v0 = null;
            }
            IrSimpleFunction irSimpleFunction = v0;
            if (irSimpleFunction == null) {
                return;
            }
            parameterlessMain = irSimpleFunction;
            Sequence<IrSimpleFunction> $this$any$iv = IrUtilsKt.getFunctions(irClass);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                IrSimpleFunction it = (IrSimpleFunction)element$iv;
                boolean bl5 = false;
                if (!this.isMainMethod(it)) continue;
                bl = true;
                break block7;
            }
            bl = false;
        }
        if (bl) {
            return;
        }
        this.generateMainMethod(irClass, parameterlessMain);
    }

    /*
     * WARNING - void declaration
     */
    private final void generateMainMethod(IrClass irClass, IrSimpleFunction parameterlessMain) {
        void $this$irBlockBody$iv;
        IrDeclarationContainer $this$addFunction$iv = irClass;
        boolean $i$f$addFunction = false;
        boolean $i$f$buildFun = false;
        IrFunctionBuilder irFunctionBuilder = new IrFunctionBuilder();
        boolean bl = false;
        boolean bl2 = false;
        IrFunctionBuilder $this$run$iv$iv = irFunctionBuilder;
        boolean $i$a$-run-DeclarationBuildersKt$buildFun$2$iv$iv22 = false;
        IrFunctionBuilder $this$addFunction22 = $this$run$iv$iv;
        boolean bl3 = false;
        Name name2 = Name.identifier("main");
        Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"Name.identifier(\"main\")");
        $this$addFunction22.setName(name2);
        Visibility visibility2 = Visibilities.PUBLIC;
        Intrinsics.checkExpressionValueIsNotNull((Object)visibility2, (String)"Visibilities.PUBLIC");
        $this$addFunction22.setVisibility(visibility2);
        $this$addFunction22.setReturnType(this.context.getIrBuiltIns().getUnitType());
        $this$addFunction22.setModality(Modality.FINAL);
        $this$addFunction22.setOrigin(JvmLoweredDeclarationOrigin.GENERATED_MAIN_FOR_PARAMETERLESS_MAIN_METHOD.INSTANCE);
        IrFunctionImpl irFunctionImpl = DeclarationBuildersKt.buildFun$default($this$run$iv$iv, null, 1, null);
        boolean bl4 = false;
        bl = false;
        IrFunctionImpl function$iv = irFunctionImpl;
        boolean bl5 = false;
        $this$addFunction$iv.getDeclarations().add(function$iv);
        function$iv.setParent($this$addFunction$iv);
        IrFunctionImpl irFunctionImpl2 = irFunctionImpl;
        boolean bl6 = false;
        boolean bl7 = false;
        IrFunctionImpl $this$apply = irFunctionImpl2;
        boolean bl8 = false;
        Object $this$addValueParameter$iv = $this$apply;
        boolean $i$f$addValueParameter = false;
        IrValueParameterBuilder $i$a$-run-DeclarationBuildersKt$buildFun$2$iv$iv22 = new IrValueParameterBuilder();
        boolean $this$addFunction22 = false;
        bl3 = false;
        IrValueParameterBuilder $this$run$iv = $i$a$-run-DeclarationBuildersKt$buildFun$2$iv$iv22;
        boolean bl9 = false;
        IrValueParameterBuilder $this$addValueParameter = $this$run$iv;
        boolean bl10 = false;
        Name name3 = Name.identifier("args");
        Intrinsics.checkExpressionValueIsNotNull((Object)name3, (String)"Name.identifier(\"args\")");
        $this$addValueParameter.setName(name3);
        $this$addValueParameter.setType(IrTypesKt.typeWith((IrClassifierSymbol)this.context.getIrBuiltIns().getArrayClass(), this.context.getIrBuiltIns().getStringType()));
        if ($this$run$iv.getIndex() == -1) {
            $this$run$iv.setIndex($this$addValueParameter$iv.getValueParameters().size());
        }
        IrValueParameter irValueParameter = DeclarationBuildersKt.build($this$run$iv);
        boolean bl11 = false;
        boolean bl12 = false;
        IrValueParameter valueParameter$iv = irValueParameter;
        boolean bl13 = false;
        $this$addValueParameter$iv.getValueParameters().add(valueParameter$iv);
        valueParameter$iv.setParent((IrDeclarationParent)$this$addValueParameter$iv);
        $this$addValueParameter$iv = LowerUtilsKt.createIrBuilder$default(this.context, $this$apply.getSymbol(), 0, 0, 6, null);
        IrFunctionImpl irFunctionImpl3 = $this$apply;
        int startOffset$iv = $this$irBlockBody$iv.getStartOffset();
        int endOffset$iv = $this$irBlockBody$iv.getEndOffset();
        boolean $i$f$irBlockBody = false;
        IrBlockBodyBuilder this_$iv$iv = new IrBlockBodyBuilder($this$irBlockBody$iv.getContext(), $this$irBlockBody$iv.getScope(), startOffset$iv, endOffset$iv);
        boolean $i$f$blockBody = false;
        IrBlockBodyBuilder $this$irBlockBody = this_$iv$iv;
        boolean bl14 = false;
        $this$irBlockBody.unaryPlus(ExpressionHelpersKt.irReturn($this$irBlockBody, ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$irBlockBody, parameterlessMain)));
        IrBlockBody irBlockBody2 = this_$iv$iv.doBuild();
        irFunctionImpl3.setBody(irBlockBody2);
    }

    private final boolean isParameterlessMainMethod(@NotNull IrSimpleFunction $this$isParameterlessMainMethod) {
        return $this$isParameterlessMainMethod.getTypeParameters().isEmpty() && $this$isParameterlessMainMethod.getValueParameters().isEmpty() && IrTypePredicatesKt.isUnit($this$isParameterlessMainMethod.getReturnType()) && Intrinsics.areEqual((Object)$this$isParameterlessMainMethod.getName().asString(), (Object)"main");
    }

    private final boolean isMainMethod(@NotNull IrSimpleFunction $this$isMainMethod) {
        String string = org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.getJvmNameFromAnnotation($this$isMainMethod);
        if (string == null) {
            String string2 = $this$isMainMethod.getName().asString();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"name.asString()");
        }
        if (Intrinsics.areEqual((Object)string, (Object)"main") ^ true) {
            return false;
        }
        if (!IrTypePredicatesKt.isUnit($this$isMainMethod.getReturnType())) {
            return false;
        }
        IrValueParameter irValueParameter = (IrValueParameter)CollectionsKt.singleOrNull(org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.getAllParameters($this$isMainMethod));
        if (irValueParameter == null) {
            return false;
        }
        IrValueParameter parameter = irValueParameter;
        if (!IrTypePredicatesKt.isArray(parameter.getType()) && !IrTypePredicatesKt.isNullableArray(parameter.getType())) {
            return false;
        }
        IrType irType = parameter.getType();
        if (irType == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
        }
        IrTypeArgument argType = (IrTypeArgument)CollectionsKt.first(((IrSimpleType)irType).getArguments());
        IrTypeArgument irTypeArgument = argType;
        return irTypeArgument instanceof IrTypeProjection ? ((IrTypeProjection)argType).getVariance() != Variance.IN_VARIANCE && IrTypePredicatesKt.isStringClassType(((IrTypeProjection)argType).getType()) : false;
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    public MainMethodGenerationLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        this.context = context2;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkParameterIsNotNull((Object)irFile, (String)"irFile");
        ClassLoweringPass.DefaultImpls.lower(this, irFile);
    }
}

