/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.lower.JvmStaticAnnotationLoweringKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001e\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/SingletonObjectJvmStaticLowering;", "Lorg/jetbrains/kotlin/backend/common/ClassLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "modifyBody", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "oldDispatchReceiverParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "backend.jvm"})
final class SingletonObjectJvmStaticLowering
implements ClassLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    /*
     * WARNING - void declaration
     */
    @Override
    public void lower(@NotNull IrClass irClass) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)irClass, (String)"irClass");
        if (!IrUtilsKt.isObject(irClass) || irClass.isCompanion()) {
            return;
        }
        Iterable $this$filter$iv = irClass.getDeclarations();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IrDeclaration p1 = (IrDeclaration)element$iv$iv;
            boolean bl = false;
            if (!JvmStaticAnnotationLoweringKt.access$isJvmStaticFunction(p1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrValueParameter irValueParameter;
            IrDeclaration it = (IrDeclaration)element$iv;
            boolean bl = false;
            IrDeclaration irDeclaration = it;
            if (irDeclaration == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrSimpleFunction");
            }
            IrSimpleFunction jvmStaticFunction = (IrSimpleFunction)irDeclaration;
            if (jvmStaticFunction.getDispatchReceiverParameter() == null) continue;
            boolean bl2 = false;
            boolean bl3 = false;
            IrValueParameter oldDispatchReceiverParameter = irValueParameter;
            boolean bl4 = false;
            jvmStaticFunction.setDispatchReceiverParameter(null);
            this.modifyBody(jvmStaticFunction, irClass, oldDispatchReceiverParameter);
        }
    }

    public final void modifyBody(@NotNull IrFunction irFunction, @NotNull IrClass irClass, @NotNull IrValueParameter oldDispatchReceiverParameter) {
        Intrinsics.checkParameterIsNotNull((Object)irFunction, (String)"irFunction");
        Intrinsics.checkParameterIsNotNull((Object)irClass, (String)"irClass");
        Intrinsics.checkParameterIsNotNull((Object)oldDispatchReceiverParameter, (String)"oldDispatchReceiverParameter");
        IrBody irBody = irFunction.getBody();
        irFunction.setBody(irBody != null ? org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.replaceThisByStaticReference(irBody, this.context.getDeclarationFactory(), irClass, oldDispatchReceiverParameter) : null);
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    public SingletonObjectJvmStaticLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        this.context = context2;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkParameterIsNotNull((Object)irFile, (String)"irFile");
        ClassLoweringPass.DefaultImpls.lower(this, irFile);
    }
}

