/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.caches.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.ModuleInfo;
import org.jetbrains.kotlin.analyzer.PlatformAnalysisParameters;
import org.jetbrains.kotlin.analyzer.ResolverForModuleFactory;
import org.jetbrains.kotlin.analyzer.common.CommonAnalysisParameters;
import org.jetbrains.kotlin.analyzer.common.CommonResolverForModuleFactory;
import org.jetbrains.kotlin.builtins.DefaultBuiltIns;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.caches.resolve.CommonKlibLibraryInfo;
import org.jetbrains.kotlin.caches.resolve.CommonPlatformKindResolutionKt;
import org.jetbrains.kotlin.caches.resolve.IdePlatformKindResolution;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.context.ProjectContext;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentProvider;
import org.jetbrains.kotlin.idea.caches.project.LibraryInfo;
import org.jetbrains.kotlin.idea.caches.project.SdkInfo;
import org.jetbrains.kotlin.idea.caches.resolve.BuiltInsCacheKey;
import org.jetbrains.kotlin.idea.framework.CommonLibraryKind;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.impl.CommonIdePlatformKind;
import org.jetbrains.kotlin.resolve.TargetEnvironment;
import org.jetbrains.kotlin.storage.StorageManager;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u001a\u0010\"\u001a\u00020#2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010$\u001a\u0004\u0018\u00010\u0012H\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/caches/resolve/CommonPlatformKindResolution;", "Lorg/jetbrains/kotlin/caches/resolve/IdePlatformKindResolution;", "()V", "kind", "Lorg/jetbrains/kotlin/platform/impl/CommonIdePlatformKind;", "getKind", "()Lorg/jetbrains/kotlin/platform/impl/CommonIdePlatformKind;", "libraryKind", "Lcom/intellij/openapi/roots/libraries/PersistentLibraryKind;", "getLibraryKind", "()Lcom/intellij/openapi/roots/libraries/PersistentLibraryKind;", "createBuiltIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "moduleInfo", "Lorg/jetbrains/kotlin/analyzer/ModuleInfo;", "projectContext", "Lorg/jetbrains/kotlin/context/ProjectContext;", "sdkDependency", "Lorg/jetbrains/kotlin/idea/caches/project/SdkInfo;", "createLibraryInfo", "", "Lorg/jetbrains/kotlin/idea/caches/project/LibraryInfo;", "project", "Lcom/intellij/openapi/project/Project;", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "createResolverForModuleFactory", "Lorg/jetbrains/kotlin/analyzer/ResolverForModuleFactory;", "settings", "Lorg/jetbrains/kotlin/analyzer/PlatformAnalysisParameters;", "environment", "Lorg/jetbrains/kotlin/resolve/TargetEnvironment;", "platform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getKeyForBuiltIns", "Lorg/jetbrains/kotlin/idea/caches/resolve/BuiltInsCacheKey;", "sdkInfo", "isLibraryFileForPlatform", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "idea-core"})
public final class CommonPlatformKindResolution
implements IdePlatformKindResolution {
    @Override
    public boolean isLibraryFileForPlatform(@NotNull VirtualFile virtualFile2) {
        Intrinsics.checkParameterIsNotNull((Object)virtualFile2, (String)"virtualFile");
        return Intrinsics.areEqual((Object)virtualFile2.getExtension(), (Object)"kotlin_metadata") || CommonPlatformKindResolutionKt.isMetadataKlib(virtualFile2);
    }

    @Override
    @Nullable
    public PersistentLibraryKind<?> getLibraryKind() {
        return CommonLibraryKind.INSTANCE;
    }

    @NotNull
    public CommonIdePlatformKind getKind() {
        return CommonIdePlatformKind.INSTANCE;
    }

    @Override
    @NotNull
    public BuiltInsCacheKey getKeyForBuiltIns(@NotNull ModuleInfo moduleInfo2, @Nullable SdkInfo sdkInfo) {
        Intrinsics.checkParameterIsNotNull((Object)moduleInfo2, (String)"moduleInfo");
        return BuiltInsCacheKey.DefaultBuiltInsKey.INSTANCE;
    }

    @Override
    @NotNull
    public KotlinBuiltIns createBuiltIns(@NotNull ModuleInfo moduleInfo2, @NotNull ProjectContext projectContext, @Nullable SdkInfo sdkDependency) {
        Intrinsics.checkParameterIsNotNull((Object)moduleInfo2, (String)"moduleInfo");
        Intrinsics.checkParameterIsNotNull((Object)projectContext, (String)"projectContext");
        return DefaultBuiltIns.Companion.getInstance();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<LibraryInfo> createLibraryInfo(@NotNull Project project2, @NotNull Library library2) {
        List list2;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)library2, (String)"library");
        VirtualFile[] virtualFileArray = library2.getFiles(OrderRootType.CLASSES);
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileArray, (String)"library.getFiles(OrderRootType.CLASSES)");
        Object $this$filter$iv = virtualFileArray;
        boolean $i$f$filter = false;
        VirtualFile[] virtualFileArray2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        void var9_8 = $this$filterTo$iv$iv;
        int n = ((void)var9_8).length;
        for (int j = 0; j < n; ++j) {
            void element$iv$iv;
            void it = element$iv$iv = var9_8[j];
            boolean bl = false;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            if (!CommonPlatformKindResolutionKt.isMetadataKlib((VirtualFile)v1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List klibFiles = (List)destination$iv$iv;
        $this$filter$iv = klibFiles;
        $i$f$filter = false;
        if (!$this$filter$iv.isEmpty()) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = klibFiles;
            boolean $i$f$mapNotNull = false;
            $this$filterTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                CommonKlibLibraryInfo commonKlibLibraryInfo;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                VirtualFile it = (VirtualFile)element$iv$iv;
                boolean bl2 = false;
                if (PathUtil.getLocalPath((VirtualFile)it) == null) {
                    commonKlibLibraryInfo = null;
                } else {
                    String path2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"PathUtil.getLocalPath(it\u2026?: return@mapNotNull null");
                    commonKlibLibraryInfo = new CommonKlibLibraryInfo(project2, library2, path2);
                }
                if (commonKlibLibraryInfo == null) continue;
                CommonKlibLibraryInfo commonKlibLibraryInfo2 = commonKlibLibraryInfo;
                boolean bl3 = false;
                boolean bl4 = false;
                CommonKlibLibraryInfo it$iv$iv = commonKlibLibraryInfo2;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = CollectionsKt.listOf((Object)new LibraryInfo(project2, library2));
        }
        return list2;
    }

    @Override
    @NotNull
    public ResolverForModuleFactory createResolverForModuleFactory(@NotNull PlatformAnalysisParameters settings2, @NotNull TargetEnvironment environment, @NotNull TargetPlatform platform) {
        Intrinsics.checkParameterIsNotNull((Object)settings2, (String)"settings");
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        Intrinsics.checkParameterIsNotNull((Object)platform, (String)"platform");
        return new CommonResolverForModuleFactory((CommonAnalysisParameters)settings2, environment, platform, true, null, 16, null);
    }

    @Override
    @Nullable
    public PackageFragmentProvider createPlatformSpecificPackageFragmentProvider(@NotNull ModuleInfo moduleInfo2, @NotNull StorageManager storageManager, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull ModuleDescriptor moduleDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)moduleInfo2, (String)"moduleInfo");
        Intrinsics.checkParameterIsNotNull((Object)storageManager, (String)"storageManager");
        Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkParameterIsNotNull((Object)moduleDescriptor, (String)"moduleDescriptor");
        return IdePlatformKindResolution.DefaultImpls.createPlatformSpecificPackageFragmentProvider(this, moduleInfo2, storageManager, languageVersionSettings, moduleDescriptor);
    }
}

