/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.codegen.AccessorForConstructorDescriptor;
import org.jetbrains.kotlin.codegen.AccessorForPropertyBackingField;
import org.jetbrains.kotlin.codegen.AccessorKind;
import org.jetbrains.kotlin.codegen.ArgumentGenerator;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.AssertCodegenUtilKt;
import org.jetbrains.kotlin.codegen.BaseExpressionCodegen;
import org.jetbrains.kotlin.codegen.BoxedToPrimitiveEquality;
import org.jetbrains.kotlin.codegen.BranchedValue;
import org.jetbrains.kotlin.codegen.BuiltinSpecialBridgesKt;
import org.jetbrains.kotlin.codegen.CallBasedArgumentGenerator;
import org.jetbrains.kotlin.codegen.CallGenerator;
import org.jetbrains.kotlin.codegen.CallReceiver;
import org.jetbrains.kotlin.codegen.Callable;
import org.jetbrains.kotlin.codegen.CallableMethod;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.ClosureCodegen;
import org.jetbrains.kotlin.codegen.ClosureGenerationStrategy;
import org.jetbrains.kotlin.codegen.CodegenStatementVisitor;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.codegen.CompilationException;
import org.jetbrains.kotlin.codegen.DefaultCallArgs;
import org.jetbrains.kotlin.codegen.FieldInfo;
import org.jetbrains.kotlin.codegen.FrameMap;
import org.jetbrains.kotlin.codegen.FrameMapBase;
import org.jetbrains.kotlin.codegen.FunctionGenerationStrategy;
import org.jetbrains.kotlin.codegen.FunctionReferenceGenerationStrategy;
import org.jetbrains.kotlin.codegen.Ieee754Equality;
import org.jetbrains.kotlin.codegen.Ieee754Kt;
import org.jetbrains.kotlin.codegen.ImplementationBodyCodegen;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.JvmKotlinType;
import org.jetbrains.kotlin.codegen.MemberCodegen;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.PrimitiveToBoxedEquality;
import org.jetbrains.kotlin.codegen.PrimitiveToObjectEquality;
import org.jetbrains.kotlin.codegen.PrimitiveToSafeCallEquality;
import org.jetbrains.kotlin.codegen.PropertyCodegen;
import org.jetbrains.kotlin.codegen.PropertyReferenceCodegen;
import org.jetbrains.kotlin.codegen.SafeCallToPrimitiveEquality;
import org.jetbrains.kotlin.codegen.SamCodegenUtil;
import org.jetbrains.kotlin.codegen.SamType;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.StackValueWithLeaveTask;
import org.jetbrains.kotlin.codegen.SyntheticClassDescriptorForLambda;
import org.jetbrains.kotlin.codegen.TailRecursionCodegen;
import org.jetbrains.kotlin.codegen.TypeAndNullability;
import org.jetbrains.kotlin.codegen.VariableAsmNameManglingUtils;
import org.jetbrains.kotlin.codegen.binding.CalculatedClosure;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.binding.MutableClosure;
import org.jetbrains.kotlin.codegen.context.ClassContext;
import org.jetbrains.kotlin.codegen.context.ClosureContext;
import org.jetbrains.kotlin.codegen.context.CodegenContext;
import org.jetbrains.kotlin.codegen.context.ConstructorContext;
import org.jetbrains.kotlin.codegen.context.EnclosedValueDescriptor;
import org.jetbrains.kotlin.codegen.context.FieldOwnerContext;
import org.jetbrains.kotlin.codegen.context.LocalLookup;
import org.jetbrains.kotlin.codegen.context.MethodContext;
import org.jetbrains.kotlin.codegen.context.ScriptContext;
import org.jetbrains.kotlin.codegen.context.ScriptLikeContext;
import org.jetbrains.kotlin.codegen.coroutines.CoroutineCodegenForLambda;
import org.jetbrains.kotlin.codegen.coroutines.CoroutineCodegenUtilKt;
import org.jetbrains.kotlin.codegen.coroutines.ResolvedCallWithRealDescriptor;
import org.jetbrains.kotlin.codegen.extensions.ExpressionCodegenExtension;
import org.jetbrains.kotlin.codegen.inline.FictitiousArrayConstructor;
import org.jetbrains.kotlin.codegen.inline.InlineCodegen;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenForDefaultBody;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtilsKt;
import org.jetbrains.kotlin.codegen.inline.NameGenerator;
import org.jetbrains.kotlin.codegen.inline.PsiInlineCodegen;
import org.jetbrains.kotlin.codegen.inline.PsiSourceCompilerForInline;
import org.jetbrains.kotlin.codegen.inline.ReificationArgument;
import org.jetbrains.kotlin.codegen.inline.ReifiedTypeInliner;
import org.jetbrains.kotlin.codegen.inline.ReifiedTypeParametersUsages;
import org.jetbrains.kotlin.codegen.inline.SourceCompilerForInline;
import org.jetbrains.kotlin.codegen.inline.TypeParameterMappings;
import org.jetbrains.kotlin.codegen.intrinsics.CompareTo;
import org.jetbrains.kotlin.codegen.intrinsics.IntrinsicMethod;
import org.jetbrains.kotlin.codegen.intrinsics.IntrinsicPropertyGetter;
import org.jetbrains.kotlin.codegen.intrinsics.IntrinsicWithSpecialReceiver;
import org.jetbrains.kotlin.codegen.intrinsics.JavaClassProperty;
import org.jetbrains.kotlin.codegen.intrinsics.KCallableNameProperty;
import org.jetbrains.kotlin.codegen.pseudoInsns.PseudoInsnsKt;
import org.jetbrains.kotlin.codegen.range.RangeValue;
import org.jetbrains.kotlin.codegen.range.RangeValuesKt;
import org.jetbrains.kotlin.codegen.range.forLoop.ForLoopGenerator;
import org.jetbrains.kotlin.codegen.signature.BothSignatureWriter;
import org.jetbrains.kotlin.codegen.signature.JvmSignatureWriter;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.codegen.when.SwitchCodegen;
import org.jetbrains.kotlin.codegen.when.SwitchCodegenProvider;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.JVMAssertionsMode;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SyntheticFieldDescriptor;
import org.jetbrains.kotlin.descriptors.impl.TypeAliasConstructorDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.load.java.sam.SamConstructorDescriptor;
import org.jetbrains.kotlin.load.kotlin.MethodSignatureMappingKt;
import org.jetbrains.kotlin.load.kotlin.TypeSignatureMappingKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassLiteralExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtCollectionLiteralExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEscapeStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtFinallySection;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenConditionInRange;
import org.jetbrains.kotlin.psi.KtWhenConditionIsPattern;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.KtWhileExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.CompileTimeConstantUtils;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.InlineClassDescriptorResolver;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.PropertyImportedFromObject;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.VarargValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForTypeAliasObject;
import org.jetbrains.kotlin.resolve.calls.util.UnderscoreUtilKt;
import org.jetbrains.kotlin.resolve.checkers.PrimitiveNumericComparisonInfo;
import org.jetbrains.kotlin.resolve.constants.BooleanValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.DoubleValue;
import org.jetbrains.kotlin.resolve.constants.FloatValue;
import org.jetbrains.kotlin.resolve.constants.IntegerValueConstant;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluatorKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.InlineClassManglingRulesKt;
import org.jetbrains.kotlin.resolve.jvm.JvmBindingContextSlices;
import org.jetbrains.kotlin.resolve.jvm.JvmConstantsKt;
import org.jetbrains.kotlin.resolve.jvm.RuntimeAssertionInfo;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOriginKt;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodGenericSignature;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterKind;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterSignature;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.kotlin.resolve.scopes.receivers.CastImplicitClassReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitClassReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.kotlin.synthetic.SyntheticJavaPropertyDescriptor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSystemCommonBackendContext;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.ClassicTypeSystemContextImpl;
import org.jetbrains.kotlin.types.expressions.DoubleColonLHS;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.model.TypeParameterMarker;
import org.jetbrains.kotlin.types.typesApproximation.CapturedTypeApproximationKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.commons.Method;

public class ExpressionCodegen
extends KtVisitor<StackValue, StackValue>
implements LocalLookup,
BaseExpressionCodegen {
    private final GenerationState state;
    final KotlinTypeMapper typeMapper;
    private final BindingContext bindingContext;
    public final InstructionAdapter v;
    public final FrameMap myFrameMap;
    public final MethodContext context;
    private final Type returnType;
    private final CodegenStatementVisitor statementVisitor;
    private final MemberCodegen<?> parentCodegen;
    private final TailRecursionCodegen tailRecursionCodegen;
    public final CallGenerator defaultCallGenerator;
    private final SwitchCodegenProvider switchCodegenProvider;
    private final TypeSystemCommonBackendContext typeSystem;
    private final Stack<BlockStackElement> blockStackElements;
    public final Map<KtElement, StackValue> tempVariables;
    private int myLastLineNumber;
    private boolean shouldMarkLineNumbers;
    private int finallyDepth;

    public ExpressionCodegen(@NotNull MethodVisitor mv, @NotNull FrameMap frameMap, @NotNull Type returnType2, @NotNull MethodContext context2, @NotNull GenerationState state, @NotNull MemberCodegen<?> parentCodegen) {
        if (mv == null) {
            ExpressionCodegen.$$$reportNull$$$0(0);
        }
        if (frameMap == null) {
            ExpressionCodegen.$$$reportNull$$$0(1);
        }
        if (returnType2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(2);
        }
        if (context2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(3);
        }
        if (state == null) {
            ExpressionCodegen.$$$reportNull$$$0(4);
        }
        if (parentCodegen == null) {
            ExpressionCodegen.$$$reportNull$$$0(5);
        }
        this.statementVisitor = new CodegenStatementVisitor(this);
        this.defaultCallGenerator = new CallGenerator.DefaultCallGenerator(this);
        this.blockStackElements = new Stack();
        this.tempVariables = new HashMap<KtElement, StackValue>();
        this.myLastLineNumber = -1;
        this.shouldMarkLineNumbers = true;
        this.finallyDepth = 0;
        this.state = state;
        this.typeMapper = state.getTypeMapper();
        this.bindingContext = state.getBindingContext();
        this.v = new InstructionAdapter(mv);
        this.myFrameMap = frameMap;
        this.context = context2;
        this.returnType = returnType2;
        this.parentCodegen = parentCodegen;
        this.tailRecursionCodegen = new TailRecursionCodegen(context2, this, this.v, state);
        this.switchCodegenProvider = new SwitchCodegenProvider(this);
        this.typeSystem = new ClassicTypeSystemContextImpl(state.getModule().getBuiltIns());
    }

    @Nullable
    private static FunctionDescriptor getOriginalSuspendLambdaDescriptorFromContext(MethodContext context2) {
        if (context2.getParentContext() instanceof ClosureContext && context2.getParentContext().closure != null && context2.getParentContext().closure.isSuspend()) {
            return ((ClosureContext)context2.getParentContext()).getOriginalSuspendLambdaDescriptor();
        }
        return null;
    }

    @NotNull
    public GenerationState getState() {
        GenerationState generationState = this.state;
        if (generationState == null) {
            ExpressionCodegen.$$$reportNull$$$0(6);
        }
        return generationState;
    }

    @NotNull
    public BindingContext getBindingContext() {
        BindingContext bindingContext2 = this.bindingContext;
        if (bindingContext2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(7);
        }
        return bindingContext2;
    }

    @NotNull
    public MemberCodegen<?> getParentCodegen() {
        MemberCodegen<?> memberCodegen = this.parentCodegen;
        if (memberCodegen == null) {
            ExpressionCodegen.$$$reportNull$$$0(8);
        }
        return memberCodegen;
    }

    @NotNull
    public ObjectLiteralResult generateObjectLiteral(@NotNull KtObjectLiteralExpression literal) {
        if (literal == null) {
            ExpressionCodegen.$$$reportNull$$$0(9);
        }
        KtObjectDeclaration objectDeclaration = literal.getObjectDeclaration();
        ClassDescriptor classDescriptor2 = this.bindingContext.get(BindingContext.CLASS, objectDeclaration);
        assert (classDescriptor2 != null);
        Type asmType = CodegenBinding.asmTypeForAnonymousClass(this.bindingContext, objectDeclaration);
        ClassBuilder classBuilder2 = this.state.getFactory().newVisitor(JvmDeclarationOriginKt.OtherOrigin(objectDeclaration, classDescriptor2), asmType, literal.getContainingFile());
        ClassContext objectContext = this.context.intoAnonymousClass(classDescriptor2, this, OwnerKind.IMPLEMENTATION);
        ImplementationBodyCodegen literalCodegen = new ImplementationBodyCodegen(objectDeclaration, objectContext, classBuilder2, this.state, this.getParentCodegen(), true);
        literalCodegen.generate();
        ExpressionCodegen.addReifiedParametersFromSignature(literalCodegen, classDescriptor2);
        this.propagateChildReifiedTypeParametersUsages(literalCodegen.getReifiedTypeParametersUsages());
        return new ObjectLiteralResult(literalCodegen.getReifiedTypeParametersUsages().wereUsedReifiedParameters(), classDescriptor2);
    }

    private static void addReifiedParametersFromSignature(@NotNull MemberCodegen member, @NotNull ClassDescriptor descriptor2) {
        if (member == null) {
            ExpressionCodegen.$$$reportNull$$$0(10);
        }
        if (descriptor2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(11);
        }
        for (KotlinType type2 : descriptor2.getTypeConstructor().getSupertypes()) {
            for (TypeProjection supertypeArgument : type2.getArguments()) {
                TypeParameterDescriptor parameterDescriptor = TypeUtils.getTypeParameterDescriptorOrNull(supertypeArgument.getType());
                if (parameterDescriptor == null || !parameterDescriptor.isReified()) continue;
                member.getReifiedTypeParametersUsages().addUsedReifiedParameter(parameterDescriptor.getName().asString());
            }
        }
    }

    @NotNull
    private StackValue castToRequiredTypeOfInterfaceIfNeeded(StackValue inner, @NotNull ClassDescriptor provided, @NotNull ClassDescriptor required) {
        if (provided == null) {
            ExpressionCodegen.$$$reportNull$$$0(12);
        }
        if (required == null) {
            ExpressionCodegen.$$$reportNull$$$0(13);
        }
        if (!JvmCodegenUtil.isJvmInterface(provided) && JvmCodegenUtil.isJvmInterface(required)) {
            SimpleType requiredDefaultType = required.getDefaultType();
            StackValue stackValue = StackValue.coercion(inner, this.asmType(requiredDefaultType), requiredDefaultType);
            if (stackValue == null) {
                ExpressionCodegen.$$$reportNull$$$0(14);
            }
            return stackValue;
        }
        StackValue stackValue = inner;
        if (stackValue == null) {
            ExpressionCodegen.$$$reportNull$$$0(15);
        }
        return stackValue;
    }

    public StackValue genQualified(StackValue receiver2, KtElement selector2) {
        return this.genQualified(receiver2, selector2, this);
    }

    private StackValue genQualified(StackValue receiver2, KtElement selector2, KtVisitor<StackValue, StackValue> visitor2) {
        if (this.tempVariables.containsKey(selector2)) {
            throw new IllegalStateException("Inconsistent state: expression saved to a temporary variable is a selector");
        }
        if (!(selector2 instanceof KtBlockExpression)) {
            this.markStartLineNumber(selector2);
        }
        try {
            KtExpression expression2;
            StackValue samValue;
            if (selector2 instanceof KtExpression && (samValue = this.genSamInterfaceValue((KtExpression)selector2, visitor2)) != null) {
                return samValue;
            }
            StackValue stackValue = selector2.accept(visitor2, receiver2);
            stackValue = this.suspendFunctionTypeWrapperIfNeeded(selector2, stackValue);
            RuntimeAssertionInfo runtimeAssertionInfo = null;
            if (selector2 instanceof KtExpression && (runtimeAssertionInfo = this.bindingContext.get(JvmBindingContextSlices.RUNTIME_ASSERTION_INFO, expression2 = (KtExpression)selector2)) == null && this.state.getLanguageVersionSettings().supportsFeature(LanguageFeature.StrictJavaNullabilityAssertions)) {
                runtimeAssertionInfo = this.bindingContext.get(JvmBindingContextSlices.BODY_RUNTIME_ASSERTION_INFO, expression2);
            }
            if (BuiltinSpecialBridgesKt.isValueArgumentForCallToMethodWithTypeCheckBarrier(selector2, this.bindingContext)) {
                return stackValue;
            }
            return AsmUtil.genNotNullAssertions(this.state, stackValue, runtimeAssertionInfo);
        }
        catch (ProcessCanceledException | CompilationException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CompilationException("Failed to generate expression: " + selector2.getClass().getSimpleName(), e, (PsiElement)selector2);
        }
    }

    private StackValue suspendFunctionTypeWrapperIfNeeded(KtElement selector2, StackValue stackValue) {
        Type functionTypeForWrapper;
        Type type2 = functionTypeForWrapper = selector2 instanceof KtExpression ? this.bindingContext.get(CodegenBinding.FUNCTION_TYPE_FOR_SUSPEND_WRAPPER, (KtExpression)selector2) : null;
        if (functionTypeForWrapper == null) {
            return stackValue;
        }
        final StackValue stackValueToWrap = stackValue;
        stackValue = new StackValue(stackValue.type, stackValue.kotlinType){

            @Override
            public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v) {
                if (type2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (v == null) {
                    1.$$$reportNull$$$0(1);
                }
                stackValueToWrap.put(functionTypeForWrapper, null, v);
                ExpressionCodegen.invokeCoroutineMigrationMethod(v, "toExperimentalSuspendFunction", Type.getMethodDescriptor((Type)functionTypeForWrapper, (Type[])new Type[]{functionTypeForWrapper}));
                1.coerce(functionTypeForWrapper, type2, v);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "type";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "v";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/kotlin/codegen/ExpressionCodegen$1";
                objectArray[2] = "putSelector";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        return stackValue;
    }

    public StackValue gen(KtElement expr2) {
        StackValue tempVar = this.tempVariables.get(expr2);
        return tempVar != null ? tempVar : this.genQualified(StackValue.none(), expr2);
    }

    public void gen(KtElement expr2, Type type2) {
        this.gen(expr2, type2, null);
    }

    public void gen(KtElement expr2, Type type2, KotlinType kotlinType) {
        StackValue value2 = Type.VOID_TYPE.equals((Object)type2) ? this.genStatement(expr2) : this.gen(expr2);
        this.putStackValue(expr2, type2, kotlinType, value2);
    }

    private void putStackValue(@Nullable KtElement expr2, @NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull StackValue value2) {
        FieldInfo resultFieldInfo;
        ScriptContext context2;
        if (type2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(16);
        }
        if (value2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(17);
        }
        if (value2.type != Type.VOID_TYPE && (context2 = this.getScriptContext()) != null && expr2 == context2.getLastStatement() && (resultFieldInfo = context2.getResultFieldInfo()) != null) {
            StackValue.Field resultValue = StackValue.field(resultFieldInfo, (StackValue)StackValue.LOCAL_0);
            resultValue.store(value2, this.v);
            this.state.getScriptSpecific().setResultType(resultFieldInfo.getFieldKotlinType());
            this.state.getScriptSpecific().setResultFieldName(resultFieldInfo.getFieldName());
            return;
        }
        value2.put(type2, kotlinType, this.v);
    }

    @Nullable
    private ScriptContext getScriptContext() {
        CodegenContext context2;
        for (context2 = this.getContext(); context2 != null && !(context2 instanceof ScriptContext); context2 = ((CodegenContext)context2).getParentContext()) {
        }
        return (ScriptContext)context2;
    }

    private StackValue genLazy(KtElement expr2, Type type2) {
        StackValue value2 = this.gen(expr2);
        return StackValue.coercion(value2, type2, null);
    }

    private StackValue genLazy(KtElement expr2, Type type2, KotlinType kotlinType) {
        StackValue value2 = this.gen(expr2);
        return StackValue.coercion(value2, type2, kotlinType);
    }

    private StackValue genStatement(KtElement statement2) {
        return this.genQualified(StackValue.none(), statement2, this.statementVisitor);
    }

    @Override
    public StackValue visitClass(@NotNull KtClass klass2, StackValue data2) {
        if (klass2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(18);
        }
        return this.visitClassOrObject(klass2);
    }

    @Override
    public StackValue visitTypeAlias(@NotNull KtTypeAlias typeAlias2, StackValue data2) {
        if (typeAlias2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(19);
        }
        return StackValue.none();
    }

    private StackValue visitClassOrObject(KtClassOrObject declaration2) {
        ClassDescriptor descriptor2 = this.bindingContext.get(BindingContext.CLASS, declaration2);
        assert (descriptor2 != null);
        Type asmType = CodegenBinding.asmTypeForAnonymousClass(this.bindingContext, declaration2);
        ClassBuilder classBuilder2 = this.state.getFactory().newVisitor(JvmDeclarationOriginKt.OtherOrigin(declaration2, descriptor2), asmType, declaration2.getContainingFile());
        ClassContext objectContext = this.context.intoAnonymousClass(descriptor2, this, OwnerKind.IMPLEMENTATION);
        new ImplementationBodyCodegen(declaration2, objectContext, classBuilder2, this.state, this.getParentCodegen(), true).generate();
        return StackValue.none();
    }

    @Override
    public StackValue visitObjectDeclaration(@NotNull KtObjectDeclaration declaration2, StackValue data2) {
        if (declaration2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(20);
        }
        return this.visitClassOrObject(declaration2);
    }

    @Override
    public StackValue visitExpression(@NotNull KtExpression expression2, StackValue receiver2) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(21);
        }
        throw new UnsupportedOperationException("Codegen for " + expression2 + " is not yet implemented");
    }

    @Override
    public StackValue visitSuperExpression(@NotNull KtSuperExpression expression2, StackValue data2) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(22);
        }
        return StackValue.thisOrOuter(this, ExpressionCodegen.getSuperCallLabelTarget(this.context, expression2), true, false);
    }

    @NotNull
    public static ClassDescriptor getSuperCallLabelTarget(@NotNull CodegenContext<?> context2, @NotNull KtSuperExpression expression2) {
        if (context2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(23);
        }
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(24);
        }
        KotlinType thisTypeForSuperCall = context2.getState().getBindingContext().get(BindingContext.THIS_TYPE_FOR_SUPER_EXPRESSION, expression2);
        assert (thisTypeForSuperCall != null) : "This type for superCall ''" + expression2.getText() + "'' should be not null!";
        ClassifierDescriptor descriptor2 = thisTypeForSuperCall.getConstructor().getDeclarationDescriptor();
        assert (descriptor2 instanceof ClassDescriptor) : "'This' reference target for ''" + expression2.getText() + "''should be class descriptor, but was " + descriptor2;
        ClassDescriptor classDescriptor2 = (ClassDescriptor)descriptor2;
        if (classDescriptor2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(25);
        }
        return classDescriptor2;
    }

    @NotNull
    public Type asmType(@NotNull KotlinType type2) {
        if (type2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(26);
        }
        Type type3 = this.typeMapper.mapType(type2);
        if (type3 == null) {
            ExpressionCodegen.$$$reportNull$$$0(27);
        }
        return type3;
    }

    @NotNull
    public Type mapTypeAsDeclaration(@NotNull KotlinType type2) {
        if (type2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(28);
        }
        Type type3 = this.typeMapper.mapTypeAsDeclaration(type2);
        if (type3 == null) {
            ExpressionCodegen.$$$reportNull$$$0(29);
        }
        return type3;
    }

    @NotNull
    public Type expressionType(@Nullable KtExpression expression2) {
        Type type2 = CodegenUtilKt.asmType(expression2, this.typeMapper, this.bindingContext);
        if (type2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(30);
        }
        return type2;
    }

    @Nullable
    public KotlinType kotlinType(@Nullable KtExpression expression2) {
        return CodegenUtilKt.kotlinType(expression2, this.bindingContext);
    }

    @Override
    public StackValue visitParenthesizedExpression(@NotNull KtParenthesizedExpression expression2, StackValue receiver2) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(31);
        }
        return this.genQualified(receiver2, expression2.getExpression());
    }

    @Override
    public StackValue visitAnnotatedExpression(@NotNull KtAnnotatedExpression expression2, StackValue receiver2) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(32);
        }
        return this.genQualified(receiver2, expression2.getBaseExpression());
    }

    private static boolean isEmptyExpression(@Nullable KtElement expr2) {
        KtBlockExpression blockExpression2;
        List<KtExpression> statements2;
        if (expr2 == null) {
            return true;
        }
        return expr2 instanceof KtBlockExpression && ((statements2 = (blockExpression2 = (KtBlockExpression)expr2).getStatements()).size() == 0 || statements2.size() == 1 && ExpressionCodegen.isEmptyExpression(statements2.get(0)));
    }

    @Override
    public StackValue visitIfExpression(@NotNull KtIfExpression expression2, StackValue receiver2) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(33);
        }
        return this.generateIfExpression(expression2, false);
    }

    StackValue generateIfExpression(@NotNull KtIfExpression expression2, boolean isStatement) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(34);
        }
        Type asmType = isStatement ? Type.VOID_TYPE : this.expressionType(expression2);
        KotlinType kotlinType = isStatement ? null : this.kotlinType(expression2);
        StackValue condition2 = this.gen(expression2.getCondition());
        KtExpression thenExpression2 = expression2.getThen();
        KtExpression elseExpression2 = expression2.getElse();
        if (ExpressionCodegen.isEmptyExpression(thenExpression2)) {
            if (ExpressionCodegen.isEmptyExpression(elseExpression2)) {
                return StackValue.coercion(condition2, asmType, kotlinType);
            }
            return this.generateSingleBranchIf(condition2, expression2, elseExpression2, false, isStatement);
        }
        if (ExpressionCodegen.isEmptyExpression(elseExpression2)) {
            return this.generateSingleBranchIf(condition2, expression2, thenExpression2, true, isStatement);
        }
        return StackValue.operation(asmType, kotlinType, (Function1<InstructionAdapter, Unit>)((Function1)v -> {
            Label elseLabel = new Label();
            BranchedValue.Companion.condJump(condition2, elseLabel, true, (InstructionAdapter)v);
            Label end = new Label();
            this.gen(thenExpression2, asmType, kotlinType);
            v.goTo(end);
            v.mark(elseLabel);
            this.gen(elseExpression2, asmType, kotlinType);
            this.markLineNumber((PsiElement)expression2, isStatement);
            v.mark(end);
            return Unit.INSTANCE;
        }));
    }

    @Override
    public StackValue visitWhileExpression(@NotNull KtWhileExpression expression2, StackValue receiver2) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(35);
        }
        return StackValue.operation(Type.VOID_TYPE, (Function1<InstructionAdapter, Unit>)((Function1)adapter -> {
            this.generateWhile(expression2);
            return Unit.INSTANCE;
        }));
    }

    private void generateWhile(@NotNull KtWhileExpression expression2) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(36);
        }
        Label condition2 = new Label();
        this.v.mark(condition2);
        Label end = new Label();
        this.blockStackElements.push((Object)new LoopBlockStackElement(end, condition2, ExpressionCodegen.targetLabel(expression2)));
        StackValue conditionValue = this.gen(expression2.getCondition());
        BranchedValue.Companion.loopJump(conditionValue, end, true, this.v);
        this.generateLoopBody(expression2.getBody());
        this.markStartLineNumber(expression2);
        this.v.goTo(condition2);
        this.v.mark(end);
        this.blockStackElements.pop();
    }

    @Override
    public StackValue visitDoWhileExpression(@NotNull KtDoWhileExpression expression2, StackValue receiver2) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(37);
        }
        return StackValue.operation(Type.VOID_TYPE, (Function1<InstructionAdapter, Unit>)((Function1)adapter -> {
            this.generateDoWhile(expression2);
            return Unit.INSTANCE;
        }));
    }

    private void generateDoWhile(@NotNull KtDoWhileExpression expression2) {
        StackValue conditionValue;
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(38);
        }
        Label beginLoopLabel = new Label();
        this.v.mark(beginLoopLabel);
        Label breakLabel = new Label();
        Label continueLabel = new Label();
        this.blockStackElements.push((Object)new LoopBlockStackElement(breakLabel, continueLabel, ExpressionCodegen.targetLabel(expression2)));
        PseudoInsnsKt.fakeAlwaysFalseIfeq(this.v, continueLabel);
        PseudoInsnsKt.fakeAlwaysFalseIfeq(this.v, breakLabel);
        KtExpression body2 = expression2.getBody();
        KtExpression condition2 = expression2.getCondition();
        StackValueWithLeaveTask leaveTask = null;
        if (body2 instanceof KtBlockExpression) {
            List<KtExpression> doWhileStatements = ((KtBlockExpression)body2).getStatements();
            ArrayList<KtExpression> statements2 = new ArrayList<KtExpression>(doWhileStatements.size() + 1);
            statements2.addAll(doWhileStatements);
            statements2.add(condition2);
            leaveTask = this.generateBlock(statements2, false, continueLabel, null);
            conditionValue = leaveTask.getStackValue();
        } else {
            if (body2 != null) {
                this.gen(body2, Type.VOID_TYPE);
            }
            this.v.mark(continueLabel);
            conditionValue = this.gen(condition2);
        }
        BranchedValue.Companion.loopJump(conditionValue, beginLoopLabel, false, this.v);
        if (leaveTask != null) {
            leaveTask.getLeaveTasks().invoke((Object)conditionValue);
        }
        this.v.mark(breakLabel);
        this.blockStackElements.pop();
    }

    @Override
    public StackValue visitForExpression(@NotNull KtForExpression forExpression, StackValue receiver2) {
        if (forExpression == null) {
            ExpressionCodegen.$$$reportNull$$$0(39);
        }
        return StackValue.operation(Type.VOID_TYPE, (Function1<InstructionAdapter, Unit>)((Function1)adapter -> {
            this.generateFor(forExpression);
            return Unit.INSTANCE;
        }));
    }

    private void generateFor(@NotNull KtForExpression forExpression) {
        if (forExpression == null) {
            ExpressionCodegen.$$$reportNull$$$0(40);
        }
        KtExpression range = forExpression.getLoopRange();
        assert (range != null) : "No loop range in for expression";
        RangeValue rangeValue = RangeValuesKt.createRangeValueForExpression(this, range);
        this.generateForLoop(rangeValue.createForLoopGenerator(this, forExpression));
    }

    @NotNull
    public static KotlinType getExpectedReceiverType(@NotNull ResolvedCall<? extends CallableDescriptor> resolvedCall2) {
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(41);
        }
        ReceiverParameterDescriptor extensionReceiver = resolvedCall2.getResultingDescriptor().getExtensionReceiverParameter();
        assert (extensionReceiver != null) : "Extension receiver should be non-null";
        KotlinType kotlinType = extensionReceiver.getType();
        if (kotlinType == null) {
            ExpressionCodegen.$$$reportNull$$$0(42);
        }
        return kotlinType;
    }

    @Nullable
    public static KtExpression getSingleArgumentExpression(@NotNull ResolvedCall<? extends CallableDescriptor> resolvedCall2) {
        List<ResolvedValueArgument> resolvedValueArguments;
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(43);
        }
        if ((resolvedValueArguments = resolvedCall2.getValueArgumentsByIndex()) == null) {
            return null;
        }
        if (resolvedValueArguments.size() != 1) {
            return null;
        }
        List<ValueArgument> valueArguments2 = resolvedValueArguments.get(0).getArguments();
        if (valueArguments2.size() != 1) {
            return null;
        }
        return valueArguments2.get(0).getArgumentExpression();
    }

    private OwnerKind contextKind() {
        return this.context.getContextKind();
    }

    private void generateForLoop(ForLoopGenerator generator) {
        Label loopExit = new Label();
        Label loopEntry = new Label();
        Label continueLabel = new Label();
        generator.beforeLoop();
        generator.checkEmptyLoop(loopExit);
        this.v.mark(loopEntry);
        generator.checkPreCondition(loopExit);
        PseudoInsnsKt.fakeAlwaysFalseIfeq(this.v, continueLabel);
        generator.beforeBody();
        this.blockStackElements.push((Object)new LoopBlockStackElement(loopExit, continueLabel, ExpressionCodegen.targetLabel(generator.getForExpression())));
        generator.body();
        this.blockStackElements.pop();
        this.v.mark(continueLabel);
        generator.afterBody(loopExit);
        this.v.goTo(loopEntry);
        this.v.mark(loopExit);
        generator.afterLoop();
    }

    public void generateLoopBody(@Nullable KtExpression body2) {
        if (body2 != null) {
            this.gen(body2, Type.VOID_TYPE);
        }
    }

    @Override
    public StackValue visitBreakExpression(@NotNull KtBreakExpression expression2, StackValue receiver2) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(44);
        }
        return this.generateBreakOrContinueExpression(expression2, true, new Label(), new ArrayList<TryBlockStackElement>());
    }

    @Override
    public StackValue visitContinueExpression(@NotNull KtContinueExpression expression2, StackValue receiver2) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(45);
        }
        return this.generateBreakOrContinueExpression(expression2, false, new Label(), new ArrayList<TryBlockStackElement>());
    }

    @NotNull
    private StackValue generateBreakOrContinueExpression(@NotNull KtExpressionWithLabel expression2, boolean isBreak, @NotNull Label afterBreakContinueLabel, @NotNull List<TryBlockStackElement> nestedTryBlocksWithoutFinally) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(46);
        }
        if (afterBreakContinueLabel == null) {
            ExpressionCodegen.$$$reportNull$$$0(47);
        }
        if (nestedTryBlocksWithoutFinally == null) {
            ExpressionCodegen.$$$reportNull$$$0(48);
        }
        assert (expression2 instanceof KtContinueExpression || expression2 instanceof KtBreakExpression);
        if (this.blockStackElements.isEmpty()) {
            throw new UnsupportedOperationException("Target label for break/continue not found");
        }
        BlockStackElement stackElement2 = (BlockStackElement)this.blockStackElements.peek();
        if (stackElement2 instanceof TryWithFinallyBlockStackElement) {
            TryWithFinallyBlockStackElement tryWithFinallyBlockStackElement = (TryWithFinallyBlockStackElement)stackElement2;
            this.genFinallyBlockOrGoto(tryWithFinallyBlockStackElement, null, afterBreakContinueLabel, nestedTryBlocksWithoutFinally);
            nestedTryBlocksWithoutFinally.clear();
        } else if (stackElement2 instanceof TryBlockStackElement) {
            nestedTryBlocksWithoutFinally.add((TryBlockStackElement)stackElement2);
        } else if (stackElement2 instanceof LoopBlockStackElement) {
            LoopBlockStackElement loopBlockStackElement = (LoopBlockStackElement)stackElement2;
            KtSimpleNameExpression labelElement = expression2.getTargetLabel();
            if (labelElement == null || loopBlockStackElement.targetLabel != null && labelElement.getReferencedName().equals(loopBlockStackElement.targetLabel.getReferencedName())) {
                Label label2 = isBreak ? loopBlockStackElement.breakLabel : loopBlockStackElement.continueLabel;
                StackValue stackValue = StackValue.operation(Type.VOID_TYPE, (Function1<InstructionAdapter, Unit>)((Function1)adapter -> {
                    PseudoInsnsKt.fixStackAndJump(this.v, label2);
                    this.v.mark(afterBreakContinueLabel);
                    return Unit.INSTANCE;
                }));
                if (stackValue == null) {
                    ExpressionCodegen.$$$reportNull$$$0(49);
                }
                return stackValue;
            }
        } else {
            throw new UnsupportedOperationException("Wrong BlockStackElement in processing stack");
        }
        this.blockStackElements.pop();
        StackValue result2 = this.generateBreakOrContinueExpression(expression2, isBreak, afterBreakContinueLabel, nestedTryBlocksWithoutFinally);
        this.blockStackElements.push((Object)stackElement2);
        StackValue stackValue = result2;
        if (stackValue == null) {
            ExpressionCodegen.$$$reportNull$$$0(50);
        }
        return stackValue;
    }

    private StackValue generateSingleBranchIf(StackValue condition2, KtIfExpression ifExpression2, KtExpression expression2, boolean inverse, boolean isStatement) {
        Type targetType = isStatement ? Type.VOID_TYPE : this.expressionType(ifExpression2);
        KotlinType targetKotlinType = isStatement ? null : this.kotlinType(ifExpression2);
        return StackValue.operation(targetType, (Function1<InstructionAdapter, Unit>)((Function1)v -> {
            Label elseLabel = new Label();
            BranchedValue.Companion.condJump(condition2, elseLabel, inverse, (InstructionAdapter)v);
            if (isStatement) {
                this.gen(expression2, Type.VOID_TYPE);
                v.mark(elseLabel);
            } else {
                this.gen(expression2, targetType, targetKotlinType);
                Label end = new Label();
                v.goTo(end);
                v.mark(elseLabel);
                StackValue.putUnitInstance(v);
                this.markStartLineNumber(ifExpression2);
                v.mark(end);
            }
            return null;
        }));
    }

    @Override
    public StackValue visitConstantExpression(@NotNull KtConstantExpression expression2, StackValue receiver2) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(51);
        }
        ConstantValue<?> compileTimeValue = this.getPrimitiveOrStringCompileTimeConstant(expression2);
        assert (compileTimeValue != null);
        return StackValue.constant(compileTimeValue.getValue(), this.expressionType(expression2), this.kotlinType(expression2));
    }

    @Nullable
    public ConstantValue<?> getCompileTimeConstant(@NotNull KtExpression expression2) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(52);
        }
        return ExpressionCodegen.getCompileTimeConstant(expression2, this.bindingContext, this.state.getShouldInlineConstVals());
    }

    @Nullable
    public ConstantValue<?> getPrimitiveOrStringCompileTimeConstant(@NotNull KtExpression expression2) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(53);
        }
        return ExpressionCodegen.getPrimitiveOrStringCompileTimeConstant(expression2, this.bindingContext, this.state.getShouldInlineConstVals());
    }

    @Nullable
    public static ConstantValue<?> getPrimitiveOrStringCompileTimeConstant(@NotNull KtExpression expression2, @NotNull BindingContext bindingContext2, boolean shouldInlineConstVals) {
        ConstantValue<?> constant2;
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(54);
        }
        if (bindingContext2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(55);
        }
        if ((constant2 = ExpressionCodegen.getCompileTimeConstant(expression2, bindingContext2, false, shouldInlineConstVals)) == null || ConstantExpressionEvaluatorKt.isStandaloneOnlyConstant(constant2)) {
            return null;
        }
        return constant2;
    }

    @Nullable
    public static ConstantValue<?> getCompileTimeConstant(@NotNull KtExpression expression2, @NotNull BindingContext bindingContext2, boolean shouldInlineConstVals) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(56);
        }
        if (bindingContext2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(57);
        }
        return ExpressionCodegen.getCompileTimeConstant(expression2, bindingContext2, false, shouldInlineConstVals);
    }

    @Nullable
    public static ConstantValue<?> getCompileTimeConstant(@NotNull KtExpression expression2, @NotNull BindingContext bindingContext2, boolean takeUpConstValsAsConst, boolean shouldInlineConstVals) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(58);
        }
        if (bindingContext2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(59);
        }
        return JvmConstantsKt.getCompileTimeConstant(expression2, bindingContext2, takeUpConstValsAsConst, shouldInlineConstVals);
    }

    @Override
    public StackValue visitStringTemplateExpression(@NotNull KtStringTemplateExpression expression2, StackValue receiver2) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(60);
        }
        List<StringTemplateEntry> entries2 = this.preprocessStringTemplate(expression2);
        Type type2 = this.expressionType(expression2);
        if (entries2.size() == 0) {
            return StackValue.constant("", type2);
        }
        if (entries2.size() == 1) {
            StringTemplateEntry entry = entries2.get(0);
            if (entry instanceof StringTemplateEntry.Expression) {
                KtExpression expr2 = ((StringTemplateEntry.Expression)entry).expression;
                return AsmUtil.genToString(this.gen(expr2), this.expressionType(expr2), this.kotlinType(expr2), this.typeMapper);
            }
            return StackValue.constant(((StringTemplateEntry.Constant)entry).value, type2);
        }
        return StackValue.operation(type2, (Function1<InstructionAdapter, Unit>)((Function1)v -> {
            AsmUtil.genStringBuilderConstructor(v);
            this.invokeAppendForEntries((InstructionAdapter)v, entries2);
            v.invokevirtual("java/lang/StringBuilder", "toString", "()Ljava/lang/String;", false);
            return Unit.INSTANCE;
        }));
    }

    private void invokeAppendForEntries(InstructionAdapter v, List<StringTemplateEntry> entries2) {
        for (StringTemplateEntry entry : entries2) {
            if (entry instanceof StringTemplateEntry.Expression) {
                this.invokeAppend(v, ((StringTemplateEntry.Expression)entry).expression);
                continue;
            }
            String value2 = ((StringTemplateEntry.Constant)entry).value;
            if (value2.length() == 1) {
                v.iconst((int)value2.charAt(0));
                AsmUtil.genInvokeAppendMethod(v, Type.CHAR_TYPE, null);
                continue;
            }
            v.aconst((Object)value2);
            AsmUtil.genInvokeAppendMethod(v, AsmTypes.JAVA_STRING_TYPE, null);
        }
    }

    @NotNull
    private List<StringTemplateEntry> preprocessStringTemplate(@NotNull KtStringTemplateExpression expression2) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(61);
        }
        KtStringTemplateEntry[] entries2 = expression2.getEntries();
        ArrayList<StringTemplateEntry> result2 = new ArrayList<StringTemplateEntry>(entries2.length);
        StringBuilder constantValue = new StringBuilder("");
        for (KtStringTemplateEntry entry : entries2) {
            if (entry instanceof KtLiteralStringTemplateEntry) {
                constantValue.append(entry.getText());
                continue;
            }
            if (entry instanceof KtEscapeStringTemplateEntry) {
                constantValue.append(((KtEscapeStringTemplateEntry)entry).getUnescapedValue());
                continue;
            }
            if (entry instanceof KtStringTemplateEntryWithExpression) {
                KtExpression entryExpression = entry.getExpression();
                if (entryExpression == null) {
                    throw new AssertionError((Object)("No expression in " + entry));
                }
                ConstantValue<?> compileTimeConstant = this.getPrimitiveOrStringCompileTimeConstant(entryExpression);
                if (compileTimeConstant != null && ExpressionCodegen.isConstantValueInlinableInStringTemplate(compileTimeConstant)) {
                    constantValue.append(String.valueOf(compileTimeConstant.getValue()));
                    continue;
                }
                String accumulatedConstantValue = constantValue.toString();
                if (accumulatedConstantValue.length() > 0) {
                    result2.add(new StringTemplateEntry.Constant(accumulatedConstantValue));
                }
                constantValue.setLength(0);
                result2.add(new StringTemplateEntry.Expression(entryExpression));
                continue;
            }
            throw new AssertionError((Object)("Unexpected string template entry: " + entry));
        }
        String leftoverConstantValue = constantValue.toString();
        if (leftoverConstantValue.length() > 0) {
            result2.add(new StringTemplateEntry.Constant(leftoverConstantValue));
        }
        ArrayList<StringTemplateEntry> arrayList = result2;
        if (arrayList == null) {
            ExpressionCodegen.$$$reportNull$$$0(62);
        }
        return arrayList;
    }

    private static boolean isConstantValueInlinableInStringTemplate(@NotNull ConstantValue<?> constant2) {
        if (constant2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(63);
        }
        return constant2 instanceof StringValue || constant2 instanceof BooleanValue || constant2 instanceof DoubleValue || constant2 instanceof FloatValue || constant2 instanceof IntegerValueConstant || constant2 instanceof NullValue;
    }

    @Override
    public StackValue visitBlockExpression(@NotNull KtBlockExpression expression2, StackValue receiver2) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(64);
        }
        return this.generateBlock(expression2, false);
    }

    @Override
    public StackValue visitNamedFunction(@NotNull KtNamedFunction function2, StackValue data2) {
        if (function2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(65);
        }
        return this.visitNamedFunction(function2, data2, false);
    }

    public StackValue visitNamedFunction(@NotNull KtNamedFunction function2, StackValue data2, boolean isStatement) {
        if (function2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(66);
        }
        assert (data2 == StackValue.none());
        if (KtPsiUtil.isScriptDeclaration(function2)) {
            return StackValue.none();
        }
        StackValue closure = this.genClosure(function2, null);
        if (isStatement) {
            DeclarationDescriptor descriptor2 = this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, function2);
            int index2 = this.lookupLocalIndex(descriptor2);
            closure.put(AsmTypes.OBJECT_TYPE, null, this.v);
            this.v.store(index2, AsmTypes.OBJECT_TYPE);
            return StackValue.none();
        }
        return closure;
    }

    @Override
    public StackValue visitLambdaExpression(@NotNull KtLambdaExpression expression2, StackValue receiver2) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(67);
        }
        if (Boolean.TRUE.equals(this.bindingContext.get(BindingContext.BLOCK, expression2))) {
            return this.gen(expression2.getFunctionLiteral().getBodyExpression());
        }
        return this.genClosure(expression2.getFunctionLiteral(), null);
    }

    @NotNull
    private StackValue genClosure(KtDeclarationWithBody declaration2, @Nullable SamType samType) {
        FunctionDescriptor descriptor2 = this.bindingContext.get(BindingContext.FUNCTION, declaration2);
        assert (descriptor2 != null) : "Function is not resolved to descriptor: " + declaration2.getText();
        return this.genClosure(declaration2, descriptor2, new ClosureGenerationStrategy(this.state, declaration2), samType, null, null);
    }

    @NotNull
    private StackValue genClosure(@NotNull KtElement declaration2, @NotNull FunctionDescriptor descriptor2, @NotNull FunctionGenerationStrategy strategy, @Nullable SamType samType, @Nullable FunctionDescriptor functionReferenceTarget, @Nullable StackValue functionReferenceReceiver) {
        if (declaration2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(68);
        }
        if (descriptor2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(69);
        }
        if (strategy == null) {
            ExpressionCodegen.$$$reportNull$$$0(70);
        }
        ClassBuilder cv = this.state.getFactory().newVisitor(JvmDeclarationOriginKt.OtherOrigin((PsiElement)declaration2, descriptor2), CodegenBinding.asmTypeForAnonymousClass(this.bindingContext, descriptor2), declaration2.getContainingFile());
        ClosureCodegen coroutineCodegen = CoroutineCodegenForLambda.create(this, descriptor2, declaration2, cv);
        ClosureContext closureContext = descriptor2.isSuspend() ? this.context.intoCoroutineClosure(CoroutineCodegenUtilKt.getOrCreateJvmSuspendFunctionView(descriptor2, this.state), descriptor2, this, this.state.getTypeMapper()) : this.context.intoClosure(descriptor2, this, this.typeMapper);
        ClosureCodegen closureCodegen = coroutineCodegen != null ? coroutineCodegen : new ClosureCodegen(this.state, declaration2, samType, closureContext, functionReferenceTarget, strategy, this.parentCodegen, cv);
        closureCodegen.generate();
        return this.putClosureInstanceOnStack(closureCodegen, functionReferenceReceiver);
    }

    @NotNull
    private StackValue putClosureInstanceOnStack(@NotNull ClosureCodegen closureCodegen, @Nullable StackValue functionReferenceReceiver) {
        if (closureCodegen == null) {
            ExpressionCodegen.$$$reportNull$$$0(71);
        }
        if (closureCodegen.getReifiedTypeParametersUsages().wereUsedReifiedParameters()) {
            ReifiedTypeInliner.putNeedClassReificationMarker((MethodVisitor)this.v);
            this.propagateChildReifiedTypeParametersUsages(closureCodegen.getReifiedTypeParametersUsages());
        }
        StackValue stackValue = closureCodegen.putInstanceOnStack(this, functionReferenceReceiver);
        if (stackValue == null) {
            ExpressionCodegen.$$$reportNull$$$0(72);
        }
        return stackValue;
    }

    @Override
    public StackValue visitObjectLiteralExpression(@NotNull KtObjectLiteralExpression expression2, StackValue receiver2) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(73);
        }
        ObjectLiteralResult objectLiteralResult = this.generateObjectLiteral(expression2);
        ClassDescriptor classDescriptor2 = objectLiteralResult.classDescriptor;
        Type type2 = this.typeMapper.mapType(classDescriptor2);
        return StackValue.operation(type2, (Function1<InstructionAdapter, Unit>)((Function1)v -> {
            if (objectLiteralResult.wereReifiedMarkers) {
                ReifiedTypeInliner.putNeedClassReificationMarker((MethodVisitor)v);
            }
            v.anew(type2);
            v.dup();
            this.pushClosureOnStack(classDescriptor2, true, this.defaultCallGenerator, null);
            ClassConstructorDescriptor primaryConstructor2 = classDescriptor2.getUnsubstitutedPrimaryConstructor();
            assert (primaryConstructor2 != null) : "There should be primary constructor for object literal";
            ResolvedCall<ConstructorDescriptor> superCall = BindingContextUtils.getDelegationConstructorCall(this.bindingContext, primaryConstructor2);
            if (superCall != null) {
                ConstructorDescriptor superConstructor = superCall.getResultingDescriptor();
                ConstructorDescriptor constructorToCall = SamCodegenUtil.resolveSamAdapter(superConstructor);
                List<ValueParameterDescriptor> superValueParameters = superConstructor.getValueParameters();
                int params2 = superValueParameters.size();
                List<Type> superMappedTypes = this.typeMapper.mapToCallableMethod(constructorToCall, false).getValueParameterTypes();
                assert (superMappedTypes.size() >= params2) : String.format("Incorrect number of mapped parameters vs arguments: %d < %d for %s", superMappedTypes.size(), params2, classDescriptor2);
                ArrayList<ResolvedValueArgument> valueArguments2 = new ArrayList<ResolvedValueArgument>(params2);
                ArrayList<ValueParameterDescriptor> valueParameters2 = new ArrayList<ValueParameterDescriptor>(params2);
                ArrayList<Type> mappedTypes = new ArrayList<Type>(params2);
                for (ValueParameterDescriptor parameter : superCall.getValueArguments().keySet()) {
                    ResolvedValueArgument argument2 = superCall.getValueArguments().get(parameter);
                    if (argument2 instanceof DefaultValueArgument) continue;
                    valueArguments2.add(argument2);
                    valueParameters2.add(parameter);
                    mappedTypes.add(superMappedTypes.get(parameter.getIndex()));
                }
                CallBasedArgumentGenerator argumentGenerator = new CallBasedArgumentGenerator(this, this.defaultCallGenerator, valueParameters2, mappedTypes);
                argumentGenerator.generate(valueArguments2, valueArguments2, null);
            }
            Collection<ClassConstructorDescriptor> constructors2 = classDescriptor2.getConstructors();
            assert (constructors2.size() == 1) : "Unexpected number of constructors for class: " + classDescriptor2 + " " + constructors2;
            ConstructorDescriptor constructorDescriptor = (ConstructorDescriptor)CollectionsKt.single(constructors2);
            Method constructor2 = this.typeMapper.mapAsmMethod(SamCodegenUtil.resolveSamAdapter(constructorDescriptor));
            v.invokespecial(type2.getInternalName(), "<init>", constructor2.getDescriptor(), false);
            return Unit.INSTANCE;
        }));
    }

    @Override
    public void pushClosureOnStack(@NotNull ClassDescriptor classDescriptor2, boolean putThis, @NotNull CallGenerator callGenerator, @Nullable StackValue functionReferenceReceiver) {
        KotlinType captureReceiver;
        ClassDescriptor captureThis;
        CalculatedClosure closure;
        if (classDescriptor2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(74);
        }
        if (callGenerator == null) {
            ExpressionCodegen.$$$reportNull$$$0(75);
        }
        if ((closure = (CalculatedClosure)this.bindingContext.get(CodegenBinding.CLOSURE, classDescriptor2)) == null) {
            return;
        }
        int paramIndex = 0;
        if (putThis && (captureThis = closure.getCapturedOuterClassDescriptor()) != null) {
            StackValue thisOrOuter = this.generateThisOrOuter(captureThis, false);
            assert (!AsmUtil.isPrimitive(thisOrOuter.type) || captureThis.isInline()) : "This or outer for " + captureThis + " should be non-primitive: " + thisOrOuter.type;
            callGenerator.putCapturedValueOnStack(thisOrOuter, thisOrOuter.type, paramIndex++);
        }
        if ((captureReceiver = closure.getCapturedReceiverFromOuterContext()) != null) {
            CallableDescriptor callableDescriptor;
            CallableDescriptor callableDescriptor2;
            Object capturedReceiver = functionReferenceReceiver;
            if (capturedReceiver == null && (callableDescriptor2 = ExpressionCodegen.unwrapOriginalReceiverOwnerForSuspendLambda(this.context)).getExtensionReceiverParameter() != null) {
                capturedReceiver = this.generateExtensionReceiver(callableDescriptor2);
            }
            if (capturedReceiver == null && (callableDescriptor = closure.getEnclosingCallableDescriptorWithReceiver()) != null) {
                capturedReceiver = this.generateExtensionReceiver(callableDescriptor);
            }
            assert (capturedReceiver != null) : "Captured receiver is null for closure " + closure;
            callGenerator.putCapturedValueOnStack((StackValue)capturedReceiver, ((StackValue)capturedReceiver).type, paramIndex++);
        }
        for (Map.Entry entry : closure.getCaptureVariables().entrySet()) {
            boolean asSharedVar;
            DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)entry.getKey();
            EnclosedValueDescriptor valueDescriptor2 = (EnclosedValueDescriptor)entry.getValue();
            Type sharedVarType = this.typeMapper.getSharedVarType(declarationDescriptor);
            boolean bl = asSharedVar = sharedVarType != null;
            if (sharedVarType == null) {
                sharedVarType = this.typeMapper.mapType((VariableDescriptor)declarationDescriptor);
            }
            StackValue capturedVar = this.lookupOuterValue(valueDescriptor2, asSharedVar);
            callGenerator.putCapturedValueOnStack(capturedVar, sharedVarType, paramIndex++);
        }
        ClassDescriptor superClass = DescriptorUtilsKt.getSuperClassNotAny(classDescriptor2);
        if (superClass != null) {
            this.pushClosureOnStack(superClass, putThis && closure.getCapturedOuterClassDescriptor() == null, callGenerator, null);
        }
        if (closure.isSuspend()) {
            if (closure.isSuspendLambda()) {
                boolean bl;
                boolean bl2 = bl = callGenerator instanceof InlineCodegen && Objects.requireNonNull(((InlineCodegen)((Object)callGenerator)).getActiveLambda(), (String)"no active lambda found").isCrossInline;
                if (!bl) {
                    this.v.aconst(null);
                }
            } else if (!(classDescriptor2 instanceof SyntheticClassDescriptorForLambda) || !((SyntheticClassDescriptorForLambda)classDescriptor2).isCallableReference()) {
                assert (this.context.getFunctionDescriptor().isSuspend()) : "Coroutines closure must be created only inside suspend functions";
                ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)CollectionsKt.last(this.context.getFunctionDescriptor().getValueParameters());
                StackValue continuationValue = this.findLocalOrCapturedValue(valueParameterDescriptor);
                assert (continuationValue != null) : "Couldn't find a value for continuation parameter of " + this.context.getFunctionDescriptor();
                callGenerator.putCapturedValueOnStack(continuationValue, continuationValue.type, paramIndex);
            }
        }
    }

    @NotNull
    private static CallableDescriptor unwrapOriginalReceiverOwnerForSuspendLambda(@NotNull MethodContext context2) {
        FunctionDescriptor originalForDoResume;
        if (context2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(76);
        }
        if ((originalForDoResume = context2.getFunctionDescriptor().getUserData(CoroutineCodegenUtilKt.INITIAL_SUSPEND_DESCRIPTOR_FOR_DO_RESUME)) != null) {
            FunctionDescriptor functionDescriptor2 = originalForDoResume;
            if (functionDescriptor2 == null) {
                ExpressionCodegen.$$$reportNull$$$0(77);
            }
            return functionDescriptor2;
        }
        if (context2.getFunctionDescriptor().isSuspend()) {
            FunctionDescriptor functionDescriptor3 = CoroutineCodegenUtilKt.unwrapInitialDescriptorForSuspendFunction(context2.getFunctionDescriptor());
            if (functionDescriptor3 == null) {
                ExpressionCodegen.$$$reportNull$$$0(78);
            }
            return functionDescriptor3;
        }
        FunctionDescriptor functionDescriptor4 = context2.getFunctionDescriptor();
        if (functionDescriptor4 == null) {
            ExpressionCodegen.$$$reportNull$$$0(79);
        }
        return functionDescriptor4;
    }

    StackValue generateBlock(@NotNull KtBlockExpression expression2, boolean isStatement) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(80);
        }
        if (expression2.getParent() instanceof KtNamedFunction) {
            return this.generateBlock(expression2.getStatements(), isStatement, null, this.context.getMethodEndLabel());
        }
        return this.generateBlock(expression2.getStatements(), isStatement, null, null);
    }

    @NotNull
    private StackValue lookupOuterValue(EnclosedValueDescriptor d, boolean asSharedVar) {
        DeclarationDescriptor descriptor2 = d.getDescriptor();
        for (LocalLookup.LocalLookupCase aCase : LocalLookup.LocalLookupCase.values()) {
            if (!aCase.isCase(descriptor2)) continue;
            StackValue outerValue = aCase.outerValue(d, this);
            if (asSharedVar && outerValue instanceof StackValue.FieldForSharedVar) {
                StackValue.FieldForSharedVar fieldForSharedVar = (StackValue.FieldForSharedVar)outerValue;
                StackValue stackValue = fieldForSharedVar.receiver;
                if (stackValue == null) {
                    ExpressionCodegen.$$$reportNull$$$0(81);
                }
                return stackValue;
            }
            StackValue stackValue = outerValue;
            if (stackValue == null) {
                ExpressionCodegen.$$$reportNull$$$0(82);
            }
            return stackValue;
        }
        throw new IllegalStateException("Can't get outer value in " + this + " for " + d);
    }

    private StackValueWithLeaveTask generateBlock(@NotNull List<KtExpression> statements2, boolean isStatement, @Nullable Label labelBeforeLastExpression, @Nullable Label labelBlockEnd) {
        if (statements2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(83);
        }
        Label blockEnd = labelBlockEnd != null ? labelBlockEnd : new Label();
        ArrayList leaveTasks = Lists.newArrayList();
        StackValue blockResult = null;
        Iterator<KtExpression> iterator2 = statements2.iterator();
        while (iterator2.hasNext()) {
            StackValue statementResult;
            boolean isExpression;
            KtNamedDeclaration declaration2;
            KtExpression possiblyLabeledStatement = iterator2.next();
            KtExpression statement2 = KtPsiUtil.safeDeparenthesize(possiblyLabeledStatement);
            if (statement2 instanceof KtNamedDeclaration && KtPsiUtil.isScriptDeclaration(declaration2 = (KtNamedDeclaration)statement2)) continue;
            this.putDescriptorIntoFrameMap(statement2);
            boolean bl = isExpression = !iterator2.hasNext() && !isStatement;
            if (isExpression && labelBeforeLastExpression != null) {
                this.v.mark(labelBeforeLastExpression);
            }
            StackValue stackValue = statementResult = isExpression ? this.gen(possiblyLabeledStatement) : this.genStatement(possiblyLabeledStatement);
            if (!iterator2.hasNext()) {
                blockResult = statementResult;
            } else {
                statementResult.put(Type.VOID_TYPE, null, this.v);
            }
            this.addLeaveTaskToRemoveDescriptorFromFrameMap(statement2, blockEnd, leaveTasks);
        }
        if (statements2.isEmpty()) {
            blockResult = StackValue.none();
        }
        assert (blockResult != null) : "Block result should be initialized in the loop or the condition above";
        return new StackValueWithLeaveTask(blockResult, (Function1<? super StackValue, Unit>)((Function1)value2 -> {
            if (labelBlockEnd == null) {
                this.v.mark(blockEnd);
            }
            for (Function task2 : Lists.reverse((List)leaveTasks)) {
                task2.fun(value2);
            }
            return Unit.INSTANCE;
        }));
    }

    @Nullable
    private StackValue getCoroutineInstanceValueForSuspensionPoint(@NotNull ResolvedCall<?> resolvedCall2) {
        FunctionDescriptor enclosingSuspendLambdaForSuspensionPoint;
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(84);
        }
        if ((enclosingSuspendLambdaForSuspensionPoint = this.bindingContext.get(BindingContext.ENCLOSING_SUSPEND_FUNCTION_FOR_SUSPEND_FUNCTION_CALL, resolvedCall2.getCall())) == null) {
            return null;
        }
        return this.genCoroutineInstanceForSuspendLambda(enclosingSuspendLambdaForSuspensionPoint);
    }

    @Nullable
    public StackValue genCoroutineInstanceForSuspendLambda(@NotNull FunctionDescriptor suspendFunction) {
        if (suspendFunction == null) {
            ExpressionCodegen.$$$reportNull$$$0(85);
        }
        if (!CoroutineCodegenUtilKt.isSuspendLambdaOrLocalFunction(suspendFunction)) {
            return null;
        }
        ClassDescriptor suspendLambdaClassDescriptor = this.bindingContext.get(CodegenBinding.CLASS_FOR_CALLABLE, suspendFunction);
        assert (suspendLambdaClassDescriptor != null) : "Coroutine class descriptor should not be null";
        return StackValue.thisOrOuter(this, suspendLambdaClassDescriptor, false, false);
    }

    @NotNull
    private Type getVariableType(@NotNull VariableDescriptor variableDescriptor) {
        Type sharedVarType;
        if (variableDescriptor == null) {
            ExpressionCodegen.$$$reportNull$$$0(86);
        }
        return (sharedVarType = this.typeMapper.getSharedVarType(variableDescriptor)) != null ? sharedVarType : this.getVariableTypeNoSharing(variableDescriptor);
    }

    @NotNull
    private Type getVariableTypeNoSharing(@NotNull VariableDescriptor variableDescriptor) {
        KotlinType varType;
        if (variableDescriptor == null) {
            ExpressionCodegen.$$$reportNull$$$0(87);
        }
        KotlinType kotlinType = varType = JvmCodegenUtil.isDelegatedLocalVariable(variableDescriptor) ? JvmCodegenUtil.getPropertyDelegateType((VariableDescriptorWithAccessors)variableDescriptor, this.bindingContext) : variableDescriptor.getType();
        if (variableDescriptor instanceof ValueParameterDescriptor && MethodSignatureMappingKt.forceSingleValueParameterBoxing((CallableDescriptor)variableDescriptor.getContainingDeclaration())) {
            Type type2 = this.asmType(TypeUtils.makeNullable(varType));
            if (type2 == null) {
                ExpressionCodegen.$$$reportNull$$$0(88);
            }
            return type2;
        }
        Type type3 = this.asmType(varType);
        if (type3 == null) {
            ExpressionCodegen.$$$reportNull$$$0(89);
        }
        return type3;
    }

    private void putDescriptorIntoFrameMap(@NotNull KtElement statement2) {
        if (statement2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(90);
        }
        if (statement2 instanceof KtDestructuringDeclaration) {
            KtDestructuringDeclaration multiDeclaration = (KtDestructuringDeclaration)statement2;
            for (KtDestructuringDeclarationEntry entry : multiDeclaration.getEntries()) {
                this.putLocalVariableIntoFrameMap(entry);
            }
        }
        if (statement2 instanceof KtVariableDeclaration) {
            this.putLocalVariableIntoFrameMap((KtVariableDeclaration)statement2);
        }
        if (statement2 instanceof KtNamedFunction) {
            DeclarationDescriptor descriptor2 = this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, statement2);
            assert (descriptor2 instanceof FunctionDescriptor) : "Couldn't find function declaration in binding context " + statement2.getText();
            Type type2 = CodegenBinding.asmTypeForAnonymousClass(this.bindingContext, (FunctionDescriptor)descriptor2);
            this.myFrameMap.enter(descriptor2, type2);
        }
    }

    private void putLocalVariableIntoFrameMap(@NotNull KtVariableDeclaration statement2) {
        VariableDescriptor variableDescriptor;
        if (statement2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(91);
        }
        if ((variableDescriptor = this.getVariableDescriptorNotNull(statement2)).getName().isSpecial()) {
            return;
        }
        Type type2 = this.getVariableType(variableDescriptor);
        int index2 = this.myFrameMap.enter(variableDescriptor, type2);
        if (JvmCodegenUtil.isDelegatedLocalVariable(variableDescriptor)) {
            this.myFrameMap.enter(CodegenBinding.getDelegatedLocalVariableMetadata(variableDescriptor, this.bindingContext), AsmTypes.K_PROPERTY0_TYPE);
        }
        if (AsmTypes.isSharedVarType(type2)) {
            this.markLineNumber(statement2, false);
            this.v.anew(type2);
            this.v.dup();
            this.v.invokespecial(type2.getInternalName(), "<init>", "()V", false);
            this.v.store(index2, AsmTypes.OBJECT_TYPE);
        }
    }

    private void addLeaveTaskToRemoveDescriptorFromFrameMap(@NotNull KtElement statement2, @NotNull Label blockEnd, @NotNull List<Function<StackValue, Void>> leaveTasks) {
        if (statement2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(92);
        }
        if (blockEnd == null) {
            ExpressionCodegen.$$$reportNull$$$0(93);
        }
        if (leaveTasks == null) {
            ExpressionCodegen.$$$reportNull$$$0(94);
        }
        if (statement2 instanceof KtDestructuringDeclaration) {
            KtDestructuringDeclaration multiDeclaration = (KtDestructuringDeclaration)statement2;
            for (KtDestructuringDeclarationEntry entry : multiDeclaration.getEntries()) {
                this.addLeaveTaskToRemoveLocalVariableFromFrameMap(entry, blockEnd, leaveTasks);
            }
        }
        if (statement2 instanceof KtVariableDeclaration) {
            this.addLeaveTaskToRemoveLocalVariableFromFrameMap((KtVariableDeclaration)statement2, blockEnd, leaveTasks);
        }
        if (statement2 instanceof KtNamedFunction) {
            this.addLeaveTaskToRemoveNamedFunctionFromFrameMap((KtNamedFunction)statement2, blockEnd, leaveTasks);
        }
    }

    private void addLeaveTaskToRemoveLocalVariableFromFrameMap(@NotNull KtVariableDeclaration statement2, Label blockEnd, @NotNull List<Function<StackValue, Void>> leaveTasks) {
        VariableDescriptor variableDescriptor;
        if (statement2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(95);
        }
        if (leaveTasks == null) {
            ExpressionCodegen.$$$reportNull$$$0(96);
        }
        if ((variableDescriptor = this.getVariableDescriptorNotNull(statement2)).getName().isSpecial()) {
            return;
        }
        Type type2 = this.getVariableType(variableDescriptor);
        Label scopeStart = new Label();
        this.v.mark(scopeStart);
        leaveTasks.add((Function<StackValue, Void>)((Function)answer -> {
            if (JvmCodegenUtil.isDelegatedLocalVariable(variableDescriptor)) {
                this.myFrameMap.leave(CodegenBinding.getDelegatedLocalVariableMetadata(variableDescriptor, this.bindingContext));
            }
            int index2 = this.myFrameMap.leave(variableDescriptor);
            this.v.visitLocalVariable(variableDescriptor.getName().asString(), type2.getDescriptor(), null, scopeStart, blockEnd, index2);
            return null;
        }));
    }

    private void addLeaveTaskToRemoveNamedFunctionFromFrameMap(@NotNull KtNamedFunction localFunction, Label blockEnd, @NotNull List<Function<StackValue, Void>> leaveTasks) {
        if (localFunction == null) {
            ExpressionCodegen.$$$reportNull$$$0(97);
        }
        if (leaveTasks == null) {
            ExpressionCodegen.$$$reportNull$$$0(98);
        }
        FunctionDescriptor functionDescriptor2 = (FunctionDescriptor)this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, localFunction);
        assert (functionDescriptor2 != null);
        Type type2 = CodegenBinding.asmTypeForAnonymousClass(this.bindingContext, functionDescriptor2);
        Label scopeStart = new Label();
        this.v.mark(scopeStart);
        leaveTasks.add((Function<StackValue, Void>)((Function)answer -> {
            int index2 = this.myFrameMap.leave(functionDescriptor2);
            String functionIndex = StringsKt.substringAfterLast((String)type2.getInternalName(), (char)'$', (String)"");
            assert (!functionIndex.isEmpty());
            String localVariableName = "$fun$" + VariableAsmNameManglingUtils.mangleNameIfNeeded(functionDescriptor2.getName().asString()) + "$" + functionIndex;
            this.v.visitLocalVariable(localVariableName, type2.getDescriptor(), null, scopeStart, blockEnd, index2);
            return null;
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runWithShouldMarkLineNumbers(boolean enable, Supplier<T> operation2) {
        boolean originalStatus = this.shouldMarkLineNumbers;
        this.shouldMarkLineNumbers = enable;
        try {
            T t = operation2.get();
            return t;
        }
        finally {
            this.shouldMarkLineNumbers = originalStatus;
        }
    }

    public void markStartLineNumber(@NotNull KtElement element3) {
        if (element3 == null) {
            ExpressionCodegen.$$$reportNull$$$0(99);
        }
        this.markLineNumber((PsiElement)element3, false);
    }

    public void markLineNumber(@NotNull PsiElement statement2, boolean markEndOffset) {
        if (statement2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(100);
        }
        if (!this.shouldMarkLineNumbers) {
            return;
        }
        Integer lineNumber2 = CodegenUtil.getLineNumberForElement(statement2, markEndOffset);
        if (lineNumber2 == null || lineNumber2 == this.myLastLineNumber) {
            return;
        }
        this.myLastLineNumber = lineNumber2;
        Label label2 = new Label();
        this.v.visitLabel(label2);
        this.v.visitLineNumber(lineNumber2.intValue(), label2);
    }

    @Override
    public void markLineNumberAfterInlineIfNeeded() {
        if (!this.shouldMarkLineNumbers) {
            if (this.myLastLineNumber > -1) {
                Label label2 = new Label();
                this.v.visitLabel(label2);
                this.v.visitLineNumber(this.myLastLineNumber, label2);
            }
        } else {
            this.myLastLineNumber = -1;
        }
    }

    @Override
    public int getLastLineNumber() {
        return this.myLastLineNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doFinallyOnReturn(@NotNull Label afterReturnLabel, @NotNull List<TryBlockStackElement> nestedTryBlocksWithoutFinally) {
        if (afterReturnLabel == null) {
            ExpressionCodegen.$$$reportNull$$$0(101);
        }
        if (nestedTryBlocksWithoutFinally == null) {
            ExpressionCodegen.$$$reportNull$$$0(102);
        }
        if (!this.blockStackElements.isEmpty()) {
            BlockStackElement stackElement2 = (BlockStackElement)this.blockStackElements.peek();
            if (stackElement2 instanceof TryWithFinallyBlockStackElement) {
                TryWithFinallyBlockStackElement tryWithFinallyBlockStackElement = (TryWithFinallyBlockStackElement)stackElement2;
                this.genFinallyBlockOrGoto(tryWithFinallyBlockStackElement, null, afterReturnLabel, nestedTryBlocksWithoutFinally);
                nestedTryBlocksWithoutFinally.clear();
            } else if (stackElement2 instanceof TryBlockStackElement) {
                nestedTryBlocksWithoutFinally.add((TryBlockStackElement)stackElement2);
            } else if (!(stackElement2 instanceof LoopBlockStackElement)) {
                throw new UnsupportedOperationException("Wrong BlockStackElement in processing stack");
            }
            this.blockStackElements.pop();
            try {
                boolean bl = this.doFinallyOnReturn(afterReturnLabel, nestedTryBlocksWithoutFinally);
                return bl;
            }
            finally {
                this.blockStackElements.push((Object)stackElement2);
            }
        }
        return false;
    }

    public boolean hasFinallyBlocks() {
        for (BlockStackElement element3 : this.blockStackElements) {
            if (!(element3 instanceof TryWithFinallyBlockStackElement)) continue;
            return true;
        }
        return false;
    }

    private void genFinallyBlockOrGoto(@Nullable TryWithFinallyBlockStackElement tryWithFinallyBlockStackElement, @Nullable Label tryCatchBlockEnd, @Nullable Label afterJumpLabel, @NotNull List<TryBlockStackElement> nestedTryBlocksWithoutFinally) {
        if (nestedTryBlocksWithoutFinally == null) {
            ExpressionCodegen.$$$reportNull$$$0(103);
        }
        if (tryWithFinallyBlockStackElement != null) {
            ++this.finallyDepth;
            assert (tryWithFinallyBlockStackElement.gaps.size() % 2 == 0) : "Finally block gaps are inconsistent";
            BlockStackElement topOfStack = (BlockStackElement)this.blockStackElements.pop();
            assert (topOfStack == tryWithFinallyBlockStackElement) : "Top element of stack doesn't equals processing finally block";
            KtTryExpression jetTryExpression = tryWithFinallyBlockStackElement.expression;
            Label finallyStart = CodegenUtilKt.linkedLabel();
            this.v.mark(finallyStart);
            tryWithFinallyBlockStackElement.addGapLabel(finallyStart);
            ExpressionCodegen.addGapLabelsForNestedTryCatchWithoutFinally(this.state, nestedTryBlocksWithoutFinally, finallyStart);
            if (InlineCodegenUtilsKt.isFinallyMarkerRequired(this.context)) {
                InlineCodegenUtilsKt.generateFinallyMarker(this.v, this.finallyDepth, true);
            }
            this.gen(jetTryExpression.getFinallyBlock().getFinalExpression(), Type.VOID_TYPE);
            if (InlineCodegenUtilsKt.isFinallyMarkerRequired(this.context)) {
                InlineCodegenUtilsKt.generateFinallyMarker(this.v, this.finallyDepth, false);
            }
        }
        if (tryCatchBlockEnd != null) {
            if (tryWithFinallyBlockStackElement != null) {
                this.markLineNumber((PsiElement)tryWithFinallyBlockStackElement.expression, true);
            }
            this.v.goTo(tryCatchBlockEnd);
        }
        if (tryWithFinallyBlockStackElement != null) {
            Label finallyEnd;
            --this.finallyDepth;
            Label label2 = finallyEnd = afterJumpLabel != null ? afterJumpLabel : new Label();
            if (afterJumpLabel == null) {
                this.v.mark(finallyEnd);
            }
            tryWithFinallyBlockStackElement.addGapLabel(finallyEnd);
            ExpressionCodegen.addGapLabelsForNestedTryCatchWithoutFinally(this.state, nestedTryBlocksWithoutFinally, finallyEnd);
            this.blockStackElements.push((Object)tryWithFinallyBlockStackElement);
        }
    }

    private static void addGapLabelsForNestedTryCatchWithoutFinally(@NotNull GenerationState state, @NotNull List<TryBlockStackElement> nestedTryBlocksWithoutFinally, @NotNull Label label2) {
        if (state == null) {
            ExpressionCodegen.$$$reportNull$$$0(104);
        }
        if (nestedTryBlocksWithoutFinally == null) {
            ExpressionCodegen.$$$reportNull$$$0(105);
        }
        if (label2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(106);
        }
        if (state.getLanguageVersionSettings().supportsFeature(LanguageFeature.ProperFinally)) {
            for (TryBlockStackElement tryBlock2 : nestedTryBlocksWithoutFinally) {
                tryBlock2.addGapLabel(label2);
            }
        }
    }

    @Override
    public StackValue visitReturnExpression(@NotNull KtReturnExpression expression2, StackValue receiver2) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(107);
        }
        return StackValue.operation(Type.VOID_TYPE, (Function1<InstructionAdapter, Unit>)((Function1)adapter -> {
            KotlinType returnKotlinType;
            Type returnType2;
            boolean isNonLocalReturn;
            KtExpression returnedExpression = expression2.getReturnedExpression();
            CallableMemberDescriptor descriptor2 = (CallableMemberDescriptor)this.getContext().getContextDescriptor();
            NonLocalReturnInfo nonLocalReturn = this.getNonLocalReturnInfo(descriptor2, expression2);
            boolean bl = isNonLocalReturn = nonLocalReturn != null;
            if (isNonLocalReturn && this.state.isInlineDisabled()) {
                this.state.getDiagnostics().report(Errors.NON_LOCAL_RETURN_IN_DISABLED_INLINE.on((PsiElement)expression2));
                AsmUtil.genThrow(this.v, "java/lang/UnsupportedOperationException", "Non-local returns are not allowed with inlining disabled");
                return Unit.INSTANCE;
            }
            if (isNonLocalReturn) {
                returnType2 = nonLocalReturn.returnType.getType();
                returnKotlinType = nonLocalReturn.returnType.getKotlinType();
            } else {
                returnType2 = this.returnType;
                returnKotlinType = this.context.getFunctionDescriptor().getReturnType();
            }
            StackValue valueToReturn = returnedExpression != null ? this.gen(returnedExpression) : StackValue.none();
            this.putStackValue(returnedExpression, returnType2, returnKotlinType, valueToReturn);
            Label afterReturnLabel = new Label();
            this.generateFinallyBlocksIfNeeded(returnType2, returnKotlinType, afterReturnLabel);
            if (isNonLocalReturn) {
                InlineCodegenUtilsKt.generateGlobalReturnFlag(this.v, nonLocalReturn.labelName);
                this.v.visitInsn(returnType2.getOpcode(172));
            } else {
                this.v.areturn(this.returnType);
            }
            this.v.mark(afterReturnLabel);
            return Unit.INSTANCE;
        }));
    }

    public void generateFinallyBlocksIfNeeded(@NotNull Type returnType2, @Nullable KotlinType returnKotlinType, @NotNull Label afterReturnLabel) {
        if (returnType2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(108);
        }
        if (afterReturnLabel == null) {
            ExpressionCodegen.$$$reportNull$$$0(109);
        }
        if (this.hasFinallyBlocks()) {
            if (!Type.VOID_TYPE.equals((Object)returnType2)) {
                int returnValIndex = this.myFrameMap.enterTemp(returnType2);
                StackValue.Local localForReturnValue = StackValue.local(returnValIndex, returnType2, returnKotlinType);
                localForReturnValue.store(StackValue.onStack(returnType2, returnKotlinType), this.v);
                this.doFinallyOnReturn(afterReturnLabel, new ArrayList<TryBlockStackElement>());
                localForReturnValue.put(returnType2, null, this.v);
                this.myFrameMap.leaveTemp(returnType2);
            } else {
                this.doFinallyOnReturn(afterReturnLabel, new ArrayList<TryBlockStackElement>());
            }
        }
    }

    @Nullable
    private NonLocalReturnInfo getNonLocalReturnInfo(@NotNull CallableMemberDescriptor descriptor2, @NotNull KtReturnExpression expression2) {
        if (descriptor2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(110);
        }
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(111);
        }
        if (ExpressionTypingUtils.isFunctionLiteral(descriptor2) || ExpressionTypingUtils.isFunctionExpression(descriptor2)) {
            if (expression2.getLabelName() == null) {
                if (ExpressionTypingUtils.isFunctionLiteral(descriptor2)) {
                    FunctionDescriptor containingFunction = (FunctionDescriptor)BindingContextUtils.getContainingFunctionSkipFunctionLiterals(descriptor2, true).getFirst();
                    return new NonLocalReturnInfo(new JvmKotlinType(this.typeMapper.mapReturnType(containingFunction), containingFunction.getReturnType()), "$$$$$ROOT$$$$$");
                }
                return null;
            }
            PsiElement element3 = this.bindingContext.get(BindingContext.LABEL_TARGET, expression2.getTargetLabel());
            if (element3 != DescriptorToSourceUtils.getSourceFromDescriptor(this.context.getContextDescriptor())) {
                DeclarationDescriptor elementDescriptor = this.typeMapper.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, element3);
                assert (element3 != null) : "Expression should be not null " + expression2.getText();
                assert (elementDescriptor != null) : "Descriptor should be not null: " + element3.getText();
                CallableDescriptor function2 = (CallableDescriptor)elementDescriptor;
                return new NonLocalReturnInfo(new JvmKotlinType(this.typeMapper.mapReturnType(function2), function2.getReturnType()), expression2.getLabelName());
            }
        }
        return null;
    }

    public void returnExpression(@NotNull KtExpression expr2) {
        if (expr2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(112);
        }
        boolean isBlockedNamedFunction = expr2 instanceof KtBlockExpression && expr2.getParent() instanceof KtNamedFunction;
        FunctionDescriptor originalSuspendLambdaDescriptor = ExpressionCodegen.getOriginalSuspendLambdaDescriptorFromContext(this.context);
        boolean isVoidCoroutineLambda = originalSuspendLambdaDescriptor != null && TypeSignatureMappingKt.hasVoidReturnType(originalSuspendLambdaDescriptor);
        Type typeForExpression = isBlockedNamedFunction || isVoidCoroutineLambda ? Type.VOID_TYPE : this.returnType;
        KotlinType kotlinTypeForExpression = isBlockedNamedFunction || isVoidCoroutineLambda ? null : this.context.getFunctionDescriptor().getReturnType();
        this.gen(expr2, typeForExpression, kotlinTypeForExpression);
        if (!ExpressionCodegen.endsWithReturn(expr2)) {
            if (ExpressionCodegen.isLambdaVoidBody(expr2, typeForExpression)) {
                this.markLineNumber((KtFunctionLiteral)expr2.getParent(), true);
            } else {
                this.markLineNumber((PsiElement)expr2, true);
            }
            if (typeForExpression.getSort() == 0) {
                StackValue.none().put(this.returnType, null, this.v);
            }
            this.v.areturn(this.returnType);
        }
    }

    private static boolean endsWithReturn(@NotNull KtElement bodyExpression) {
        if (bodyExpression == null) {
            ExpressionCodegen.$$$reportNull$$$0(113);
        }
        if (bodyExpression instanceof KtBlockExpression) {
            List<KtExpression> statements2 = ((KtBlockExpression)bodyExpression).getStatements();
            return statements2.size() > 0 && statements2.get(statements2.size() - 1) instanceof KtReturnExpression;
        }
        return bodyExpression instanceof KtReturnExpression;
    }

    private static boolean isLambdaVoidBody(@NotNull KtElement bodyExpression, @NotNull Type returnType2) {
        PsiElement parent2;
        if (bodyExpression == null) {
            ExpressionCodegen.$$$reportNull$$$0(114);
        }
        if (returnType2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(115);
        }
        if (bodyExpression instanceof KtBlockExpression && (parent2 = bodyExpression.getParent()) instanceof KtFunctionLiteral) {
            return Type.VOID_TYPE.equals((Object)returnType2);
        }
        return false;
    }

    @Override
    public StackValue visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression2, @NotNull StackValue receiver2) {
        StackValue intrinsicResult;
        DeclarationDescriptor descriptor2;
        ResolvedCall<? extends CallableDescriptor> resolvedCall2;
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(116);
        }
        if (receiver2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(117);
        }
        if ((resolvedCall2 = CallUtilKt.getResolvedCall(expression2, this.bindingContext)) == null) {
            descriptor2 = this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression2);
        } else {
            StackValue intrinsicResult2;
            if (resolvedCall2 instanceof VariableAsFunctionResolvedCall) {
                VariableAsFunctionResolvedCall call2 = (VariableAsFunctionResolvedCall)((Object)resolvedCall2);
                resolvedCall2 = call2.getVariableCall();
            }
            if ((intrinsicResult2 = this.applyIntrinsic(descriptor2 = resolvedCall2.getResultingDescriptor(), KCallableNameProperty.class, resolvedCall2, receiver2)) != null) {
                return intrinsicResult2;
            }
            receiver2 = StackValue.receiver(resolvedCall2, receiver2, this, null);
            if (descriptor2 instanceof FakeCallableDescriptorForObject) {
                descriptor2 = ((FakeCallableDescriptorForObject)descriptor2).getReferencedDescriptor();
            }
        }
        assert (descriptor2 != null) : "Couldn't find descriptor for '" + expression2.getText() + "'";
        boolean isSyntheticField = (descriptor2 = descriptor2.getOriginal()) instanceof SyntheticFieldDescriptor;
        if (isSyntheticField) {
            descriptor2 = ((SyntheticFieldDescriptor)descriptor2).getPropertyDescriptor();
        }
        if ((intrinsicResult = this.applyIntrinsic(descriptor2, IntrinsicPropertyGetter.class, resolvedCall2, receiver2)) != null) {
            return intrinsicResult;
        }
        return this.generateNonIntrinsicSimpleNameExpression(expression2, receiver2, descriptor2, resolvedCall2, isSyntheticField);
    }

    public StackValue generateNonIntrinsicSimpleNameExpression(@NotNull KtSimpleNameExpression expression2, @NotNull StackValue receiver2, @NotNull DeclarationDescriptor descriptor2, @Nullable ResolvedCall<?> resolvedCall2, boolean isSyntheticField) {
        ClassDescriptor classDescriptor2;
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(118);
        }
        if (receiver2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(119);
        }
        if (descriptor2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(120);
        }
        if (descriptor2 instanceof PropertyDescriptor) {
            ClassDescriptor superCallTarget;
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)descriptor2;
            if (InlineClassesUtilsKt.isUnderlyingPropertyOfInlineClass(propertyDescriptor)) {
                KotlinType propertyType = propertyDescriptor.getType();
                return StackValue.underlyingValueOfInlineClass(this.typeMapper.mapType(propertyType), propertyType, receiver2);
            }
            List codegenExtensions = ExpressionCodegenExtension.Companion.getInstances(this.state.getProject());
            if (!codegenExtensions.isEmpty() && resolvedCall2 != null) {
                ExpressionCodegenExtension.Context context2 = new ExpressionCodegenExtension.Context(this, this.typeMapper, this.v);
                KotlinType returnType2 = propertyDescriptor.getReturnType();
                for (ExpressionCodegenExtension extension2 : codegenExtensions) {
                    StackValue value2;
                    if (returnType2 == null || (value2 = extension2.applyProperty(receiver2, resolvedCall2, context2)) == null) continue;
                    return value2;
                }
            }
            boolean directToField = isSyntheticField && this.contextKind() != OwnerKind.DEFAULT_IMPLS;
            ClassDescriptor classDescriptor3 = superCallTarget = resolvedCall2 == null ? null : this.getSuperCallTarget(resolvedCall2.getCall());
            if (directToField) {
                receiver2 = StackValue.receiverWithoutReceiverArgument(receiver2);
            }
            return this.intermediateValueForProperty(propertyDescriptor, directToField, directToField, superCallTarget, false, receiver2, resolvedCall2, false);
        }
        if (descriptor2 instanceof FakeCallableDescriptorForTypeAliasObject) {
            descriptor2 = ((FakeCallableDescriptorForTypeAliasObject)descriptor2).getTypeAliasDescriptor();
        }
        if (descriptor2 instanceof TypeAliasDescriptor) {
            classDescriptor2 = ((TypeAliasDescriptor)descriptor2).getClassDescriptor();
            if (classDescriptor2 == null) {
                throw new IllegalStateException("Type alias " + descriptor2 + " static member reference should be rejected by type checker, since there is no class corresponding to this type alias.");
            }
            descriptor2 = classDescriptor2;
        }
        if (descriptor2 instanceof ClassDescriptor) {
            classDescriptor2 = (ClassDescriptor)descriptor2;
            if (this.shouldGenerateSingletonAsThisOrOuterFromContext(classDescriptor2)) {
                return this.generateThisOrOuterFromContext(classDescriptor2, false, false);
            }
            if (DescriptorUtils.isCompanionObject(classDescriptor2) && !JvmCodegenUtil.couldUseDirectAccessToCompanionObject(classDescriptor2, this.context)) {
                return this.generateAccessorCallForCompanionObject(classDescriptor2);
            }
            if (DescriptorUtils.isObject(classDescriptor2)) {
                return StackValue.singleton(classDescriptor2, this.typeMapper);
            }
            if (DescriptorUtils.isEnumEntry(classDescriptor2)) {
                return StackValue.enumEntry(classDescriptor2, this.typeMapper);
            }
            ClassDescriptor companionObjectDescriptor2 = classDescriptor2.getCompanionObjectDescriptor();
            if (companionObjectDescriptor2 != null) {
                return StackValue.singleton(companionObjectDescriptor2, this.typeMapper);
            }
            return StackValue.none();
        }
        StackValue localOrCaptured = this.findLocalOrCapturedValue(descriptor2);
        if (localOrCaptured != null) {
            return localOrCaptured;
        }
        throw new UnsupportedOperationException("don't know how to generate reference " + descriptor2);
    }

    private boolean shouldGenerateSingletonAsThisOrOuterFromContext(ClassDescriptor classDescriptor2) {
        if (!CodegenUtilKt.isPossiblyUninitializedSingleton(classDescriptor2)) {
            return false;
        }
        if (!this.isInsideSingleton(classDescriptor2)) {
            return false;
        }
        for (CodegenContext context2 = this.context; context2 != null; context2 = ((CodegenContext)context2).getParentContext()) {
            ClassDescriptor contextClass;
            if (context2 instanceof ConstructorContext) {
                ConstructorContext constructorContext = (ConstructorContext)context2;
                ClassDescriptor constructedClass = constructorContext.getConstructorDescriptor().getConstructedClass();
                if (constructedClass != classDescriptor2) continue;
                return constructorContext.isThisInitialized();
            }
            if (!(context2 instanceof ClassContext) || !ExpressionCodegen.isInInnerClassesChainFor(contextClass = (ClassDescriptor)((ClassContext)context2).getContextDescriptor(), classDescriptor2)) continue;
            return true;
        }
        return false;
    }

    private static boolean isInInnerClassesChainFor(ClassDescriptor innerClass, ClassDescriptor outerClass) {
        if (innerClass == outerClass) {
            return true;
        }
        if (!innerClass.isInner()) {
            return false;
        }
        DeclarationDescriptor containingDeclaration2 = innerClass.getContainingDeclaration();
        if (!(containingDeclaration2 instanceof ClassDescriptor)) {
            return false;
        }
        return ExpressionCodegen.isInInnerClassesChainFor((ClassDescriptor)containingDeclaration2, outerClass);
    }

    @Nullable
    private StackValue applyIntrinsic(DeclarationDescriptor descriptor2, Class<? extends IntrinsicPropertyGetter> intrinsicType, ResolvedCall<?> resolvedCall2, @NotNull StackValue receiver2) {
        if (receiver2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(121);
        }
        if (descriptor2 instanceof CallableMemberDescriptor) {
            CallableMemberDescriptor memberDescriptor = DescriptorUtils.unwrapFakeOverride((CallableMemberDescriptor)descriptor2);
            IntrinsicMethod intrinsic = this.state.getIntrinsics().getIntrinsic(memberDescriptor);
            if (intrinsicType.isInstance(intrinsic)) {
                Type returnType2 = this.typeMapper.mapType(memberDescriptor);
                return ((IntrinsicPropertyGetter)intrinsic).generate(resolvedCall2, this, returnType2, receiver2);
            }
        }
        return null;
    }

    @Nullable
    public ClassDescriptor getSuperCallTarget(@NotNull Call call2) {
        KtSuperExpression superExpression;
        if (call2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(122);
        }
        return (superExpression = CallResolverUtilKt.getSuperCallExpression(call2)) == null ? null : ExpressionCodegen.getSuperCallLabelTarget(this.context, superExpression);
    }

    @Nullable
    public StackValue findLocalOrCapturedValue(@NotNull DeclarationDescriptor descriptor2) {
        int index2;
        if (descriptor2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(123);
        }
        if ((index2 = this.lookupLocalIndex(descriptor2)) >= 0) {
            return this.stackValueForLocal(descriptor2, index2);
        }
        return this.findCapturedValue(descriptor2);
    }

    @Nullable
    public StackValue findCapturedValue(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(124);
        }
        if (this.context instanceof ConstructorContext) {
            return this.lookupCapturedValueInConstructorParameters(descriptor2);
        }
        StackValue value2 = this.context.lookupInContext(descriptor2, StackValue.LOCAL_0, this.state, false);
        if (JvmCodegenUtil.isDelegatedLocalVariable(descriptor2) && value2 != null) {
            VariableDescriptor metadata = CodegenBinding.getDelegatedLocalVariableMetadata((VariableDescriptor)descriptor2, this.bindingContext);
            StackValue metadataValue = this.context.lookupInContext(metadata, StackValue.LOCAL_0, this.state, false);
            assert (metadataValue != null) : "Metadata stack value should be non-null for local delegated property: " + descriptor2;
            return this.delegatedVariableValue(value2, metadataValue, (VariableDescriptorWithAccessors)descriptor2, this.typeMapper);
        }
        return value2;
    }

    @Nullable
    private StackValue lookupCapturedValueInConstructorParameters(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(125);
        }
        StackValue parentResult = this.context.lookupInContext(descriptor2, StackValue.LOCAL_0, this.state, false);
        if (this.context.closure == null || parentResult == null) {
            return parentResult;
        }
        int parameterOffsetInConstructor = this.context.closure.getCapturedParameterOffsetInConstructor(descriptor2);
        if (parameterOffsetInConstructor == -1) {
            return this.adjustVariableValue(parentResult, descriptor2);
        }
        assert (parentResult instanceof StackValue.Field || parentResult instanceof StackValue.FieldForSharedVar) : "Part of closure should be either Field or FieldForSharedVar";
        if (parentResult instanceof StackValue.FieldForSharedVar) {
            return StackValue.shared(parameterOffsetInConstructor, parentResult.type);
        }
        return this.adjustVariableValue(StackValue.local(parameterOffsetInConstructor, parentResult.type, parentResult.kotlinType), descriptor2);
    }

    private StackValue stackValueForLocal(DeclarationDescriptor descriptor2, int index2) {
        if (descriptor2 instanceof VariableDescriptor) {
            KotlinType delegateKotlinType;
            VariableDescriptor variableDescriptor = (VariableDescriptor)descriptor2;
            Type sharedVarType = this.typeMapper.getSharedVarType(descriptor2);
            Type varType = this.getVariableTypeNoSharing(variableDescriptor);
            KotlinType kotlinType = delegateKotlinType = JvmCodegenUtil.isDelegatedLocalVariable(descriptor2) ? JvmCodegenUtil.getPropertyDelegateType((VariableDescriptorWithAccessors)descriptor2, this.bindingContext) : null;
            if (sharedVarType != null) {
                return StackValue.shared(index2, varType, variableDescriptor, delegateKotlinType);
            }
            return this.adjustVariableValue(StackValue.local(index2, varType, variableDescriptor, delegateKotlinType), variableDescriptor);
        }
        return StackValue.local(index2, AsmTypes.OBJECT_TYPE);
    }

    @Override
    public boolean isLocal(DeclarationDescriptor descriptor2) {
        LocalLookup outerLookup;
        if (this.lookupLocalIndex(descriptor2) != -1) {
            return true;
        }
        if (this.context.isContextWithUninitializedThis() && (outerLookup = this.context.getParentContext().getEnclosingLocalLookup()) != null) {
            return outerLookup.isLocal(descriptor2);
        }
        return false;
    }

    public int lookupLocalIndex(DeclarationDescriptor descriptor2) {
        int index2 = this.myFrameMap.getIndex(descriptor2);
        if (index2 != -1) {
            return index2;
        }
        if (!(descriptor2 instanceof ValueParameterDescriptor)) {
            return -1;
        }
        DeclarationDescriptor synonym = this.bindingContext.get(CodegenBinding.PARAMETER_SYNONYM, (ValueParameterDescriptor)descriptor2);
        if (synonym == null) {
            return -1;
        }
        return this.myFrameMap.getIndex(synonym);
    }

    @NotNull
    public StackValue.Property intermediateValueForProperty(@NotNull PropertyDescriptor propertyDescriptor, boolean forceField, @Nullable ClassDescriptor superCallTarget, @NotNull StackValue receiver2) {
        if (propertyDescriptor == null) {
            ExpressionCodegen.$$$reportNull$$$0(126);
        }
        if (receiver2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(127);
        }
        StackValue.Property property2 = this.intermediateValueForProperty(propertyDescriptor, forceField, false, superCallTarget, false, receiver2, null, false);
        if (property2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(128);
        }
        return property2;
    }

    private CodegenContext getBackingFieldContext(@NotNull AccessorKind accessorKind, @NotNull DeclarationDescriptor containingDeclaration2) {
        if (accessorKind == null) {
            ExpressionCodegen.$$$reportNull$$$0(129);
        }
        if (containingDeclaration2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(130);
        }
        switch (accessorKind) {
            case NORMAL: {
                CodegenContext parentWithDescriptor;
                if (containingDeclaration2 instanceof ClassDescriptor && (parentWithDescriptor = this.context.findParentContextWithDescriptor(containingDeclaration2)) != null) {
                    return parentWithDescriptor;
                }
                return this.context.getParentContext();
            }
            case IN_CLASS_COMPANION: {
                return this.context.findParentContextWithDescriptor(containingDeclaration2.getContainingDeclaration());
            }
            case FIELD_FROM_LOCAL: {
                return this.context.findParentContextWithDescriptor(containingDeclaration2);
            }
            case LATEINIT_INTRINSIC: {
                return this.context.findParentContextWithDescriptor(containingDeclaration2);
            }
        }
        throw new IllegalStateException("Unknown field accessor kind: " + (Object)((Object)accessorKind));
    }

    private static boolean isDefaultAccessor(@Nullable PropertyAccessorDescriptor accessor) {
        return accessor == null || accessor.isDefault();
    }

    public StackValue.Property intermediateValueForProperty(@NotNull PropertyDescriptor propertyDescriptor, boolean forceField, boolean syntheticBackingField, @Nullable ClassDescriptor superCallTarget, boolean skipAccessorsForPrivateFieldInOuterClass, @NotNull StackValue receiver2, @Nullable ResolvedCall resolvedCall2, boolean skipLateinitAssertion) {
        String fieldName;
        DeclarationDescriptor ownerDescriptor;
        boolean skipPropertyAccessors;
        if (propertyDescriptor == null) {
            ExpressionCodegen.$$$reportNull$$$0(131);
        }
        if (receiver2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(132);
        }
        if (propertyDescriptor instanceof SyntheticJavaPropertyDescriptor) {
            return this.intermediateValueForSyntheticExtensionProperty((SyntheticJavaPropertyDescriptor)propertyDescriptor, receiver2);
        }
        if (propertyDescriptor instanceof PropertyImportedFromObject) {
            propertyDescriptor = (PropertyDescriptor)((PropertyImportedFromObject)propertyDescriptor).getCallableFromObject();
        }
        DeclarationDescriptor containingDeclaration2 = propertyDescriptor.getContainingDeclaration();
        boolean isBackingFieldMovedFromCompanion = JvmAbi.isPropertyWithBackingFieldInOuterClass(propertyDescriptor);
        AccessorKind fieldAccessorKind = skipLateinitAssertion ? AccessorKind.LATEINIT_INTRINSIC : (isBackingFieldMovedFromCompanion && (forceField || Visibilities.isPrivate(propertyDescriptor.getVisibility()) && ExpressionCodegen.isDefaultAccessor(propertyDescriptor.getGetter()) && ExpressionCodegen.isDefaultAccessor(propertyDescriptor.getSetter())) ? (JvmCodegenUtil.isDebuggerContext(this.context) ? AccessorKind.NORMAL : AccessorKind.IN_CLASS_COMPANION) : (syntheticBackingField && this.context.getFirstCrossInlineOrNonInlineContext().getParentContext().getContextDescriptor() != containingDeclaration2 ? AccessorKind.FIELD_FROM_LOCAL : AccessorKind.NORMAL));
        boolean isStaticBackingField = DescriptorUtils.isStaticDeclaration(propertyDescriptor) || AsmUtil.isInstancePropertyWithStaticBackingField(propertyDescriptor);
        boolean isSuper = superCallTarget != null;
        boolean isExtensionProperty = propertyDescriptor.getExtensionReceiverParameter() != null;
        KotlinType delegateType = JvmCodegenUtil.getPropertyDelegateType(propertyDescriptor, this.bindingContext);
        boolean isDelegatedProperty = delegateType != null;
        CallableMethod callableGetter = null;
        CallableMethod callableSetter = null;
        CodegenContext backingFieldContext = this.getBackingFieldContext(fieldAccessorKind, containingDeclaration2);
        boolean isPrivateProperty = fieldAccessorKind != AccessorKind.NORMAL && (AsmUtil.getVisibilityForBackingField(propertyDescriptor, isDelegatedProperty) & 2) != 0;
        PropertyDescriptor originalPropertyDescriptor = DescriptorUtils.unwrapFakeOverride(propertyDescriptor);
        boolean directAccessToGetter = JvmCodegenUtil.couldUseDirectAccessToProperty(propertyDescriptor, true, isDelegatedProperty, this.context, this.state.getShouldInlineConstVals());
        boolean directAccessToSetter = JvmCodegenUtil.couldUseDirectAccessToProperty(propertyDescriptor, false, isDelegatedProperty, this.context, this.state.getShouldInlineConstVals());
        if (fieldAccessorKind == AccessorKind.LATEINIT_INTRINSIC) {
            boolean bl = skipPropertyAccessors = (!isPrivateProperty || this.context.getClassOrPackageParentContext() == backingFieldContext) && !isBackingFieldMovedFromCompanion;
            if (!skipPropertyAccessors) {
                propertyDescriptor = isBackingFieldMovedFromCompanion && this.context.getContextDescriptor() instanceof AccessorForPropertyBackingField ? backingFieldContext.getParentContext().getAccessor(propertyDescriptor, AccessorKind.IN_CLASS_COMPANION, delegateType, superCallTarget) : backingFieldContext.getAccessor(propertyDescriptor, fieldAccessorKind, delegateType, superCallTarget);
            }
            ownerDescriptor = propertyDescriptor;
        } else if (fieldAccessorKind == AccessorKind.IN_CLASS_COMPANION || fieldAccessorKind == AccessorKind.FIELD_FROM_LOCAL) {
            boolean bl = skipPropertyAccessors = skipAccessorsForPrivateFieldInOuterClass || directAccessToGetter && (!propertyDescriptor.isVar() || directAccessToSetter);
            if (!skipPropertyAccessors) {
                propertyDescriptor = backingFieldContext.getAccessor(propertyDescriptor, fieldAccessorKind, delegateType, superCallTarget);
                assert (propertyDescriptor instanceof AccessorForPropertyBackingField) : "Unexpected accessor descriptor: " + propertyDescriptor;
                ownerDescriptor = propertyDescriptor;
            } else {
                ownerDescriptor = containingDeclaration2;
            }
        } else {
            skipPropertyAccessors = forceField;
            if (JvmCodegenUtil.isDebuggerContext(this.context) && Visibilities.isPrivate(propertyDescriptor.getVisibility()) && this.bindingContext.get(BindingContext.BACKING_FIELD_REQUIRED, propertyDescriptor) == Boolean.TRUE) {
                skipPropertyAccessors = true;
            }
            DeclarationDescriptor declarationDescriptor = ownerDescriptor = isBackingFieldMovedFromCompanion ? containingDeclaration2 : propertyDescriptor;
        }
        if (!(skipPropertyAccessors || directAccessToGetter && directAccessToSetter)) {
            propertyDescriptor = this.context.getAccessorForSuperCallIfNeeded(propertyDescriptor, superCallTarget, this.state);
            if (!JvmCodegenUtil.isConstOrHasJvmFieldAnnotation(propertyDescriptor = this.context.accessibleDescriptor(propertyDescriptor, superCallTarget))) {
                PropertySetterDescriptor setter2;
                PropertyGetterDescriptor getter2;
                if (!directAccessToGetter && (getter2 = propertyDescriptor.getGetter()) != null) {
                    callableGetter = this.typeMapper.mapToCallableMethod(getter2, isSuper);
                }
                if (propertyDescriptor.isVar() && !directAccessToSetter && (setter2 = propertyDescriptor.getSetter()) != null) {
                    callableSetter = this.typeMapper.mapToCallableMethod(setter2, isSuper);
                }
            }
        }
        if (!isStaticBackingField) {
            propertyDescriptor = DescriptorUtils.unwrapFakeOverride(propertyDescriptor);
        }
        Type backingFieldOwner = this.typeMapper.mapOwner(ownerDescriptor);
        if (isExtensionProperty && !isDelegatedProperty) {
            fieldName = null;
        } else if (originalPropertyDescriptor.getContainingDeclaration() == backingFieldContext.getContextDescriptor()) {
            assert (backingFieldContext instanceof FieldOwnerContext) : "Actual context is " + backingFieldContext + " but should be instance of FieldOwnerContext";
            fieldName = ((FieldOwnerContext)backingFieldContext).getFieldName(propertyDescriptor, isDelegatedProperty);
        } else {
            fieldName = KotlinTypeMapper.mapDefaultFieldName(propertyDescriptor, isDelegatedProperty);
        }
        return StackValue.property(propertyDescriptor, backingFieldOwner, this.typeMapper.mapType(isDelegatedProperty && forceField ? delegateType : propertyDescriptor.getOriginal().getType()), isStaticBackingField, fieldName, callableGetter, callableSetter, receiver2, this, resolvedCall2, skipLateinitAssertion, isDelegatedProperty && forceField ? delegateType : null);
    }

    @NotNull
    private StackValue.Property intermediateValueForSyntheticExtensionProperty(@NotNull SyntheticJavaPropertyDescriptor propertyDescriptor, @NotNull StackValue receiver2) {
        if (propertyDescriptor == null) {
            ExpressionCodegen.$$$reportNull$$$0(133);
        }
        if (receiver2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(134);
        }
        Type type2 = this.typeMapper.mapType(propertyDescriptor.getOriginal().getType());
        CallableMethod callableGetter = this.typeMapper.mapToCallableMethod(this.context.accessibleDescriptor(propertyDescriptor.getGetMethod(), null), false);
        FunctionDescriptor setMethod = propertyDescriptor.getSetMethod();
        CallableMethod callableSetter = setMethod != null ? this.typeMapper.mapToCallableMethod(this.context.accessibleDescriptor(setMethod, null), false) : null;
        StackValue.Property property2 = StackValue.property(propertyDescriptor, null, type2, false, null, callableGetter, callableSetter, receiver2, this, null, false, null);
        if (property2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(135);
        }
        return property2;
    }

    @Override
    public StackValue visitCallExpression(@NotNull KtCallExpression expression2, StackValue receiver2) {
        ResolvedCall<? extends CallableDescriptor> resolvedCall2;
        FunctionDescriptor descriptor2;
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(136);
        }
        if ((descriptor2 = this.accessibleFunctionDescriptor(resolvedCall2 = CallUtilKt.getResolvedCallWithAssert(expression2, this.bindingContext))) instanceof ConstructorDescriptor) {
            return this.generateNewCall(expression2, resolvedCall2);
        }
        if (descriptor2.getOriginal() instanceof SamConstructorDescriptor) {
            KtExpression argumentExpression2 = this.bindingContext.get(CodegenBinding.SAM_CONSTRUCTOR_TO_ARGUMENT, expression2);
            assert (argumentExpression2 != null) : "Argument expression is not saved for a SAM constructor: " + descriptor2;
            return this.genSamInterfaceValue(argumentExpression2, this);
        }
        return this.invokeFunction(resolvedCall2, receiver2);
    }

    @Override
    public StackValue visitCollectionLiteralExpression(@NotNull KtCollectionLiteralExpression expression2, StackValue data2) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(137);
        }
        ResolvedCall<FunctionDescriptor> resolvedCall2 = this.bindingContext.get(BindingContext.COLLECTION_LITERAL_CALL, expression2);
        assert (resolvedCall2 != null) : "No resolved call for " + PsiUtilsKt.getTextWithLocation((PsiElement)expression2);
        return this.invokeFunction(resolvedCall2, data2);
    }

    @Nullable
    private StackValue genSamInterfaceValue(@NotNull KtExpression probablyParenthesizedExpression, @NotNull KtVisitor<StackValue, StackValue> visitor2) {
        if (probablyParenthesizedExpression == null) {
            ExpressionCodegen.$$$reportNull$$$0(138);
        }
        if (visitor2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(139);
        }
        KtExpression expression2 = KtPsiUtil.deparenthesize(probablyParenthesizedExpression);
        SamType samType = this.bindingContext.get(CodegenBinding.SAM_VALUE, probablyParenthesizedExpression);
        if (samType == null || expression2 == null) {
            return null;
        }
        if (expression2 instanceof KtLambdaExpression) {
            return this.genClosure(((KtLambdaExpression)expression2).getFunctionLiteral(), samType);
        }
        if (expression2 instanceof KtNamedFunction) {
            return this.genClosure((KtNamedFunction)expression2, samType);
        }
        Type asmType = this.state.getSamWrapperClasses().getSamWrapperClass(samType, expression2.getContainingKtFile(), this, (CallableMemberDescriptor)this.context.getContextDescriptor());
        return StackValue.operation(asmType, (Function1<InstructionAdapter, Unit>)((Function1)v -> {
            Label afterAll = new Label();
            Type functionType2 = this.typeMapper.mapType(samType.getKotlinFunctionType());
            ((StackValue)expression2.accept(visitor2, StackValue.none())).put(functionType2, null, (InstructionAdapter)v);
            v.dup();
            v.ifnull(afterAll);
            int tmp = this.myFrameMap.enterTemp(functionType2);
            v.store(tmp, functionType2);
            v.anew(asmType);
            v.dup();
            v.load(tmp, functionType2);
            v.invokespecial(asmType.getInternalName(), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{functionType2}), false);
            this.myFrameMap.leaveTemp(functionType2);
            v.mark(afterAll);
            return null;
        }));
    }

    @NotNull
    protected FunctionDescriptor accessibleFunctionDescriptor(@NotNull ResolvedCall<?> resolvedCall2) {
        FunctionDescriptor originalIfSamAdapter;
        FunctionDescriptor descriptor2;
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(140);
        }
        if ((descriptor2 = (FunctionDescriptor)resolvedCall2.getResultingDescriptor()) instanceof TypeAliasConstructorDescriptor) {
            descriptor2 = ((TypeAliasConstructorDescriptor)descriptor2).getUnderlyingConstructorDescriptor();
        }
        if ((originalIfSamAdapter = SamCodegenUtil.getOriginalIfSamAdapter(descriptor2)) != null) {
            descriptor2 = originalIfSamAdapter;
        }
        descriptor2 = CoroutineCodegenUtilKt.unwrapInitialDescriptorForSuspendFunction(descriptor2);
        if (CallUtilKt.usesDefaultArguments(resolvedCall2)) {
            FunctionDescriptor functionDescriptor2 = descriptor2;
            if (functionDescriptor2 == null) {
                ExpressionCodegen.$$$reportNull$$$0(141);
            }
            return functionDescriptor2;
        }
        if (InlineClassManglingRulesKt.shouldHideConstructorDueToInlineClassTypeValueParameters(descriptor2.getOriginal())) {
            return new AccessorForConstructorDescriptor((ClassConstructorDescriptor)descriptor2.getOriginal(), descriptor2.getContainingDeclaration(), this.getSuperCallTarget(resolvedCall2.getCall()), AccessorKind.NORMAL);
        }
        FunctionDescriptor functionDescriptor3 = this.context.accessibleDescriptor(descriptor2, this.getSuperCallTarget(resolvedCall2.getCall()));
        if (functionDescriptor3 == null) {
            ExpressionCodegen.$$$reportNull$$$0(142);
        }
        return functionDescriptor3;
    }

    @NotNull
    public StackValue invokeFunction(@NotNull ResolvedCall<?> resolvedCall2, @NotNull StackValue receiver2) {
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(143);
        }
        if (receiver2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(144);
        }
        StackValue stackValue = this.invokeFunction(resolvedCall2.getCall(), resolvedCall2, receiver2);
        if (stackValue == null) {
            ExpressionCodegen.$$$reportNull$$$0(145);
        }
        return stackValue;
    }

    @NotNull
    public StackValue invokeFunction(@NotNull Call call2, @NotNull ResolvedCall<?> resolvedCall2, @NotNull StackValue receiver2) {
        ResolvedCallWithRealDescriptor callWithRealDescriptor;
        if (call2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(146);
        }
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(147);
        }
        if (receiver2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(148);
        }
        if ((callWithRealDescriptor = CoroutineCodegenUtilKt.replaceSuspensionFunctionWithRealDescriptor(resolvedCall2, this.state)) != null) {
            this.prepareCoroutineArgumentForSuspendCall(resolvedCall2, callWithRealDescriptor.getFakeContinuationExpression());
            StackValue stackValue = this.invokeFunction(callWithRealDescriptor.getResolvedCall(), receiver2);
            if (stackValue == null) {
                ExpressionCodegen.$$$reportNull$$$0(149);
            }
            return stackValue;
        }
        FunctionDescriptor fd = this.accessibleFunctionDescriptor(resolvedCall2);
        ClassDescriptor superCallTarget = this.getSuperCallTarget(call2);
        fd = this.context.getAccessorForSuperCallIfNeeded(fd, superCallTarget, this.state);
        List codegenExtensions = ExpressionCodegenExtension.Companion.getInstances(this.state.getProject());
        if (!codegenExtensions.isEmpty()) {
            ExpressionCodegenExtension.Context context2 = new ExpressionCodegenExtension.Context(this, this.typeMapper, this.v);
            for (ExpressionCodegenExtension extension2 : codegenExtensions) {
                StackValue stackValue = extension2.applyFunction(receiver2, resolvedCall2, context2);
                if (stackValue == null) continue;
                StackValue stackValue2 = stackValue;
                if (stackValue2 == null) {
                    ExpressionCodegen.$$$reportNull$$$0(150);
                }
                return stackValue2;
            }
        }
        Callable callable2 = this.resolveToCallable(fd, superCallTarget != null, resolvedCall2);
        StackValue stackValue = callable2.invokeMethodWithArguments(resolvedCall2, receiver2, this);
        if (stackValue == null) {
            ExpressionCodegen.$$$reportNull$$$0(151);
        }
        return stackValue;
    }

    private void prepareCoroutineArgumentForSuspendCall(@NotNull ResolvedCall<?> resolvedCall2, @NotNull KtExpression continuationExpression) {
        StackValue coroutineInstanceValueForSuspensionPoint;
        StackValue coroutineInstanceValue;
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(152);
        }
        if (continuationExpression == null) {
            ExpressionCodegen.$$$reportNull$$$0(153);
        }
        StackValue stackValue = coroutineInstanceValue = (coroutineInstanceValueForSuspensionPoint = this.getCoroutineInstanceValueForSuspensionPoint(resolvedCall2)) != null ? coroutineInstanceValueForSuspensionPoint : this.getContinuationParameterFromEnclosingSuspendFunction(resolvedCall2);
        if (coroutineInstanceValue != null && CodegenUtilKt.needsExperimentalCoroutinesWrapper(resolvedCall2.getCandidateDescriptor())) {
            final StackValue releaseContinuation = coroutineInstanceValue;
            coroutineInstanceValue = new StackValue(CoroutineCodegenUtilKt.EXPERIMENTAL_CONTINUATION_ASM_TYPE){

                @Override
                public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v) {
                    if (type2 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (v == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    releaseContinuation.put(CoroutineCodegenUtilKt.RELEASE_CONTINUATION_ASM_TYPE, v);
                    ExpressionCodegen.invokeCoroutineMigrationMethod(v, "toExperimentalContinuation", Type.getMethodDescriptor((Type)CoroutineCodegenUtilKt.EXPERIMENTAL_CONTINUATION_ASM_TYPE, (Type[])new Type[]{CoroutineCodegenUtilKt.RELEASE_CONTINUATION_ASM_TYPE}));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "type";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "v";
                            break;
                        }
                    }
                    objectArray[1] = "org/jetbrains/kotlin/codegen/ExpressionCodegen$2";
                    objectArray[2] = "putSelector";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        }
        this.tempVariables.put(continuationExpression, coroutineInstanceValue);
    }

    private static void invokeCoroutineMigrationMethod(@NotNull InstructionAdapter v, String methodName2, String descriptor2) {
        if (v == null) {
            ExpressionCodegen.$$$reportNull$$$0(154);
        }
        v.invokestatic("kotlin/coroutines/experimental/migration/CoroutinesMigrationKt", methodName2, descriptor2, false);
    }

    private StackValue getContinuationParameterFromEnclosingSuspendFunction(@NotNull ResolvedCall<?> resolvedCall2) {
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(155);
        }
        FunctionDescriptor enclosingSuspendFunction = this.bindingContext.get(BindingContext.ENCLOSING_SUSPEND_FUNCTION_FOR_SUSPEND_FUNCTION_CALL, resolvedCall2.getCall());
        assert (enclosingSuspendFunction != null) : "Suspend functions may be called either as suspension points or from another suspend function";
        FunctionDescriptor enclosingSuspendFunctionJvmView = this.bindingContext.get(CodegenBinding.SUSPEND_FUNCTION_TO_JVM_VIEW, enclosingSuspendFunction);
        assert (enclosingSuspendFunctionJvmView != null) : "No JVM view function found for " + enclosingSuspendFunction;
        return this.getContinuationParameterFromEnclosingSuspendFunctionDescriptor(enclosingSuspendFunctionJvmView);
    }

    @Nullable
    public StackValue getContinuationParameterFromEnclosingSuspendFunctionDescriptor(@NotNull FunctionDescriptor enclosingSuspendFunctionJvmView) {
        if (enclosingSuspendFunctionJvmView == null) {
            ExpressionCodegen.$$$reportNull$$$0(156);
        }
        ValueParameterDescriptor continuationParameter = enclosingSuspendFunctionJvmView.getValueParameters().get(enclosingSuspendFunctionJvmView.getValueParameters().size() - 1);
        return this.findLocalOrCapturedValue(continuationParameter);
    }

    @Nullable
    public static CodegenContext getParentContextSubclassOf(ClassDescriptor descriptor2, CodegenContext context2) {
        for (CodegenContext c = context2; c != null; c = c.getParentContext()) {
            if (!(c instanceof ClassContext) || !DescriptorUtils.isSubclass(c.getThisDescriptor(), descriptor2)) continue;
            return c;
        }
        return null;
    }

    @NotNull
    Callable resolveToCallable(@NotNull FunctionDescriptor fd, boolean superCall, @NotNull ResolvedCall resolvedCall2) {
        IntrinsicMethod intrinsic;
        if (fd == null) {
            ExpressionCodegen.$$$reportNull$$$0(157);
        }
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(158);
        }
        if ((intrinsic = this.state.getIntrinsics().getIntrinsic(fd)) != null) {
            Callable callable2 = intrinsic.toCallable(fd, superCall, resolvedCall2, this);
            if (callable2 == null) {
                ExpressionCodegen.$$$reportNull$$$0(159);
            }
            return callable2;
        }
        CallableMethod callableMethod = this.typeMapper.mapToCallableMethod(SamCodegenUtil.resolveSamAdapter(fd), superCall, null, resolvedCall2);
        if (callableMethod == null) {
            ExpressionCodegen.$$$reportNull$$$0(160);
        }
        return callableMethod;
    }

    public void invokeMethodWithArguments(@NotNull Callable callableMethod, @NotNull ResolvedCall<?> resolvedCall2, @NotNull StackValue receiver2) {
        if (callableMethod == null) {
            ExpressionCodegen.$$$reportNull$$$0(161);
        }
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(162);
        }
        if (receiver2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(163);
        }
        CallGenerator callGenerator = this.getOrCreateCallGenerator(resolvedCall2);
        Object descriptor2 = resolvedCall2.getResultingDescriptor();
        assert (callGenerator == this.defaultCallGenerator || !this.tailRecursionCodegen.isTailRecursion(resolvedCall2)) : "Tail recursive method can't be inlined: " + descriptor2;
        CallBasedArgumentGenerator argumentGenerator = new CallBasedArgumentGenerator(this, callGenerator, descriptor2.getValueParameters(), callableMethod.getValueParameterTypes());
        this.invokeMethodWithArguments(callableMethod, resolvedCall2, receiver2, callGenerator, argumentGenerator);
    }

    public void invokeMethodWithArguments(@NotNull Callable callableMethod, @NotNull ResolvedCall<?> resolvedCall2, @NotNull StackValue receiver2, @NotNull CallGenerator callGenerator, @NotNull ArgumentGenerator argumentGenerator) {
        KotlinType returnType2;
        if (callableMethod == null) {
            ExpressionCodegen.$$$reportNull$$$0(164);
        }
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(165);
        }
        if (receiver2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(166);
        }
        if (callGenerator == null) {
            ExpressionCodegen.$$$reportNull$$$0(167);
        }
        if (argumentGenerator == null) {
            ExpressionCodegen.$$$reportNull$$$0(168);
        }
        if (AssertCodegenUtilKt.isAssertCall(resolvedCall2) && !this.state.getAssertionsMode().equals((Object)JVMAssertionsMode.LEGACY)) {
            AssertCodegenUtilKt.generateAssert(this.state.getAssertionsMode(), resolvedCall2, this, this.parentCodegen);
            return;
        }
        boolean isSuspendNoInlineCall = CoroutineCodegenUtilKt.isSuspendNoInlineCall(resolvedCall2, this, this.state.getLanguageVersionSettings());
        boolean isConstructor2 = resolvedCall2.getResultingDescriptor() instanceof ConstructorDescriptor;
        if (!(callableMethod instanceof IntrinsicWithSpecialReceiver)) {
            this.putReceiverAndInlineMarkerIfNeeded(callableMethod, resolvedCall2, receiver2, isSuspendNoInlineCall, isConstructor2);
        }
        callGenerator.processAndPutHiddenParameters(false);
        List<ResolvedValueArgument> valueArguments2 = resolvedCall2.getValueArgumentsByIndex();
        assert (valueArguments2 != null) : "Failed to arrange value arguments by index: " + resolvedCall2.getResultingDescriptor();
        DefaultCallArgs defaultArgs = argumentGenerator.generate((List<? extends ResolvedValueArgument>)valueArguments2, (List<? extends ResolvedValueArgument>)new ArrayList<ResolvedValueArgument>(resolvedCall2.getValueArguments().values()), (CallableDescriptor)resolvedCall2.getResultingDescriptor());
        if (this.tailRecursionCodegen.isTailRecursion(resolvedCall2)) {
            this.tailRecursionCodegen.generateTailRecursion(resolvedCall2);
            return;
        }
        boolean defaultMaskWasGenerated = defaultArgs.generateOnStackIfNeeded(callGenerator, isConstructor2);
        if (callableMethod instanceof CallableMethod) {
            List<JvmMethodParameterSignature> callableParameters = ((CallableMethod)callableMethod).getValueParameters();
            for (JvmMethodParameterSignature parameter : callableParameters) {
                if (parameter.getKind() != JvmMethodParameterKind.CONSTRUCTOR_MARKER) continue;
                callGenerator.putValueIfNeeded(new JvmKotlinType(parameter.getAsmType(), null), StackValue.constant(null, parameter.getAsmType()));
            }
        }
        if (isSuspendNoInlineCall) {
            InlineCodegenUtilsKt.addSuspendMarker(this.v, true);
        }
        callGenerator.genCall(callableMethod, resolvedCall2, defaultMaskWasGenerated, this);
        if (isSuspendNoInlineCall) {
            InlineCodegenUtilsKt.addReturnsUnitMarkerIfNecessary(this.v, resolvedCall2);
            InlineCodegenUtilsKt.addSuspendMarker(this.v, false);
            InlineCodegenUtilsKt.addInlineMarker(this.v, false);
        }
        if ((returnType2 = resolvedCall2.getResultingDescriptor().getReturnType()) != null && KotlinBuiltIns.isNothing(returnType2)) {
            this.v.aconst(null);
            this.v.athrow();
        }
    }

    private void putReceiverAndInlineMarkerIfNeeded(@NotNull Callable callableMethod, @NotNull ResolvedCall<?> resolvedCall2, @NotNull StackValue receiver2, boolean isSuspendCall, boolean isConstructor2) {
        boolean isSafeCallOrOnStack;
        if (callableMethod == null) {
            ExpressionCodegen.$$$reportNull$$$0(169);
        }
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(170);
        }
        if (receiver2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(171);
        }
        boolean bl = isSafeCallOrOnStack = receiver2 instanceof StackValue.SafeCall || receiver2 instanceof StackValue.OnStack;
        if (isSuspendCall && !isSafeCallOrOnStack && !this.tailRecursionCodegen.isTailRecursion(resolvedCall2)) {
            InlineCodegenUtilsKt.addInlineMarker(this.v, true);
        }
        if (!isConstructor2) {
            receiver2 = StackValue.receiver(resolvedCall2, receiver2, this, callableMethod);
            receiver2.put(receiver2.type, receiver2.kotlinType, this.v);
            if (isSuspendCall && isSafeCallOrOnStack) {
                boolean bothReceivers = receiver2 instanceof CallReceiver && ((CallReceiver)receiver2).getDispatchReceiver().type.getSort() != 0 && ((CallReceiver)receiver2).getExtensionReceiver().type.getSort() != 0;
                Type firstReceiverType = bothReceivers ? ((CallReceiver)receiver2).getDispatchReceiver().type : receiver2.type;
                Type secondReceiverType = bothReceivers ? receiver2.type : null;
                int tmpVarForFirstReceiver = this.myFrameMap.enterTemp(firstReceiverType);
                int tmpVarForSecondReceiver = -1;
                if (secondReceiverType != null) {
                    tmpVarForSecondReceiver = this.myFrameMap.enterTemp(secondReceiverType);
                    this.v.store(tmpVarForSecondReceiver, secondReceiverType);
                }
                this.v.store(tmpVarForFirstReceiver, firstReceiverType);
                InlineCodegenUtilsKt.addInlineMarker(this.v, true);
                this.v.load(tmpVarForFirstReceiver, firstReceiverType);
                if (secondReceiverType != null) {
                    this.v.load(tmpVarForSecondReceiver, secondReceiverType);
                    this.myFrameMap.leaveTemp(secondReceiverType);
                }
                this.myFrameMap.leaveTemp(firstReceiverType);
            }
            callableMethod.afterReceiverGeneration(this.v, this.myFrameMap);
        }
    }

    @NotNull
    private CallGenerator getOrCreateCallGenerator(@NotNull CallableDescriptor descriptor2, @Nullable KtElement callElement2, @Nullable TypeParameterMappings<KotlinType> typeParameterMappings, boolean isDefaultCompilation) {
        boolean shouldInline;
        if (descriptor2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(172);
        }
        if (callElement2 == null) {
            CallGenerator callGenerator = this.defaultCallGenerator;
            if (callGenerator == null) {
                ExpressionCodegen.$$$reportNull$$$0(173);
            }
            return callGenerator;
        }
        boolean isIntrinsic = descriptor2 instanceof CallableMemberDescriptor && this.state.getIntrinsics().getIntrinsic((CallableMemberDescriptor)descriptor2) != null;
        boolean isInline = InlineUtil.isInline(descriptor2) && !isIntrinsic || InlineUtil.isArrayConstructorWithLambda(descriptor2);
        boolean bl = shouldInline = isInline && (!this.state.isInlineDisabled() || InlineUtil.containsReifiedTypeParameters(descriptor2));
        if (!shouldInline) {
            CallGenerator callGenerator = this.defaultCallGenerator;
            if (callGenerator == null) {
                ExpressionCodegen.$$$reportNull$$$0(174);
            }
            return callGenerator;
        }
        FunctionDescriptor original = CoroutineCodegenUtilKt.getOriginalSuspendFunctionView(CodegenUtilKt.unwrapInitialSignatureDescriptor(DescriptorUtils.unwrapFakeOverride((FunctionDescriptor)descriptor2.getOriginal())), this.bindingContext, this.state);
        PsiSourceCompilerForInline sourceCompiler = new PsiSourceCompilerForInline(this, callElement2);
        FunctionDescriptor functionDescriptor2 = InlineUtil.isArrayConstructorWithLambda(original) ? FictitiousArrayConstructor.create((ConstructorDescriptor)original) : original.getOriginal();
        sourceCompiler.initializeInlineFunctionContext(functionDescriptor2);
        JvmMethodGenericSignature signature = this.typeMapper.mapSignatureWithGeneric(functionDescriptor2, sourceCompiler.getContextKind());
        Type methodOwner = this.typeMapper.mapImplementationOwner(functionDescriptor2);
        if (isDefaultCompilation) {
            return new InlineCodegenForDefaultBody(functionDescriptor2, this, this.state, methodOwner, signature, sourceCompiler);
        }
        return new PsiInlineCodegen(this, this.state, functionDescriptor2, methodOwner, (JvmMethodSignature)signature, typeParameterMappings, (SourceCompilerForInline)sourceCompiler, this.typeMapper.mapOwner(descriptor2));
    }

    @NotNull
    protected CallGenerator getOrCreateCallGeneratorForDefaultImplBody(@NotNull FunctionDescriptor descriptor2, @Nullable KtNamedFunction function2) {
        if (descriptor2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(175);
        }
        return this.getOrCreateCallGenerator(descriptor2, function2, null, true);
    }

    CallGenerator getOrCreateCallGenerator(@NotNull ResolvedCall<?> resolvedCall2) {
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(176);
        }
        return this.getOrCreateCallGenerator(resolvedCall2, (CallableDescriptor)resolvedCall2.getResultingDescriptor());
    }

    @NotNull
    CallGenerator getOrCreateCallGenerator(@NotNull ResolvedCall<?> resolvedCall2, @NotNull CallableDescriptor descriptor2) {
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(177);
        }
        if (descriptor2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(178);
        }
        Map<TypeParameterDescriptor, KotlinType> typeArguments2 = ExpressionCodegen.getTypeArgumentsForResolvedCall(resolvedCall2, descriptor2);
        TypeParameterMappings<KotlinType> mappings = new TypeParameterMappings<KotlinType>();
        for (Map.Entry<TypeParameterDescriptor, KotlinType> entry : typeArguments2.entrySet()) {
            TypeParameterDescriptor key = entry.getKey();
            KotlinType type2 = entry.getValue();
            boolean isReified = key.isReified() || InlineUtil.isArrayConstructorWithLambda(resolvedCall2.getResultingDescriptor());
            Pair<TypeParameterMarker, ReificationArgument> typeParameterAndReificationArgument = CodegenUtilKt.extractReificationArgument(this.typeSystem, type2);
            if (typeParameterAndReificationArgument == null) {
                KotlinType approximatedType = CapturedTypeApproximationKt.approximateCapturedTypes(entry.getValue()).getUpper();
                BothSignatureWriter signatureWriter = new BothSignatureWriter(BothSignatureWriter.Mode.TYPE);
                Type asmType = this.typeMapper.mapTypeParameter(approximatedType, signatureWriter);
                mappings.addParameterMappingToType(key.getName().getIdentifier(), approximatedType, asmType, ((JvmSignatureWriter)signatureWriter).toString(), isReified);
                continue;
            }
            mappings.addParameterMappingForFurtherReification(key.getName().getIdentifier(), type2, (ReificationArgument)typeParameterAndReificationArgument.getSecond(), isReified);
        }
        return this.getOrCreateCallGenerator(descriptor2, resolvedCall2.getCall().getCallElement(), mappings, false);
    }

    @NotNull
    private static Map<TypeParameterDescriptor, KotlinType> getTypeArgumentsForResolvedCall(@NotNull ResolvedCall<?> resolvedCall2, @NotNull CallableDescriptor descriptor2) {
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(179);
        }
        if (descriptor2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(180);
        }
        if (!(descriptor2 instanceof TypeAliasConstructorDescriptor)) {
            Map<TypeParameterDescriptor, KotlinType> map2 = resolvedCall2.getTypeArguments();
            if (map2 == null) {
                ExpressionCodegen.$$$reportNull$$$0(181);
            }
            return map2;
        }
        TypeAliasConstructorDescriptor typeAliasConstructorDescriptor = (TypeAliasConstructorDescriptor)descriptor2;
        ClassConstructorDescriptor underlyingConstructorDescriptor = typeAliasConstructorDescriptor.getUnderlyingConstructorDescriptor();
        KotlinType resultingType = typeAliasConstructorDescriptor.getReturnType();
        List<TypeProjection> typeArgumentsForReturnType = resultingType.getArguments();
        List<TypeParameterDescriptor> typeParameters2 = underlyingConstructorDescriptor.getTypeParameters();
        assert (typeParameters2.size() == typeArgumentsForReturnType.size()) : "Type parameters of the underlying constructor " + underlyingConstructorDescriptor + "should correspond to type arguments for the resulting type " + resultingType;
        HashMap typeArgumentsMap = Maps.newHashMapWithExpectedSize((int)typeParameters2.size());
        for (TypeParameterDescriptor typeParameter : typeParameters2) {
            KotlinType typeArgument = typeArgumentsForReturnType.get(typeParameter.getIndex()).getType();
            typeArgumentsMap.put(typeParameter, typeArgument);
        }
        HashMap hashMap = typeArgumentsMap;
        if (hashMap == null) {
            ExpressionCodegen.$$$reportNull$$$0(182);
        }
        return hashMap;
    }

    @NotNull
    public StackValue generateReceiverValue(@Nullable ReceiverValue receiverValue, boolean isSuper) {
        if (receiverValue instanceof ImplicitClassReceiver) {
            ClassDescriptor receiverDescriptor = ((ImplicitClassReceiver)receiverValue).getDeclarationDescriptor();
            StackValue stackValue = this.generateInstanceReceiver(receiverDescriptor, isSuper, receiverValue instanceof CastImplicitClassReceiver || DescriptorUtils.isEnumEntry(receiverDescriptor));
            if (stackValue == null) {
                ExpressionCodegen.$$$reportNull$$$0(183);
            }
            return stackValue;
        }
        if (receiverValue instanceof ExtensionReceiver) {
            StackValue stackValue = this.generateExtensionReceiver(((ExtensionReceiver)receiverValue).getDeclarationDescriptor());
            if (stackValue == null) {
                ExpressionCodegen.$$$reportNull$$$0(184);
            }
            return stackValue;
        }
        if (receiverValue instanceof ExpressionReceiver) {
            ExpressionReceiver expressionReceiver = (ExpressionReceiver)receiverValue;
            StackValue stackValue = this.gen(expressionReceiver.getExpression());
            if (!this.state.isReceiverAssertionsDisabled()) {
                RuntimeAssertionInfo runtimeAssertionInfo = this.bindingContext.get(JvmBindingContextSlices.RECEIVER_RUNTIME_ASSERTION_INFO, expressionReceiver);
                stackValue = AsmUtil.genNotNullAssertions(this.state, stackValue, runtimeAssertionInfo);
            }
            StackValue stackValue2 = stackValue;
            if (stackValue2 == null) {
                ExpressionCodegen.$$$reportNull$$$0(185);
            }
            return stackValue2;
        }
        throw new UnsupportedOperationException("Unsupported receiver value: " + receiverValue);
    }

    private StackValue generateInstanceReceiver(@NotNull ClassDescriptor receiverDescriptor, boolean isSuper, boolean castReceiver) {
        if (receiverDescriptor == null) {
            ExpressionCodegen.$$$reportNull$$$0(186);
        }
        if (DescriptorUtils.isCompanionObject(receiverDescriptor)) {
            CallableMemberDescriptor contextDescriptor = (CallableMemberDescriptor)this.context.getContextDescriptor();
            if (contextDescriptor instanceof FunctionDescriptor && receiverDescriptor == contextDescriptor.getContainingDeclaration()) {
                return StackValue.LOCAL_0;
            }
            if (CodegenUtilKt.isPossiblyUninitializedSingleton(receiverDescriptor) && this.isInsideSingleton(receiverDescriptor)) {
                return this.generateThisOrOuterFromContext(receiverDescriptor, false, false);
            }
            if (JvmCodegenUtil.couldUseDirectAccessToCompanionObject(receiverDescriptor, this.context)) {
                return StackValue.singleton(receiverDescriptor, this.typeMapper);
            }
            return this.generateAccessorCallForCompanionObject(receiverDescriptor);
        }
        if (receiverDescriptor instanceof ScriptDescriptor) {
            return this.generateScriptReceiver((ScriptDescriptor)receiverDescriptor);
        }
        return StackValue.thisOrOuter(this, receiverDescriptor, isSuper, castReceiver);
    }

    @NotNull
    private StackValue generateAccessorCallForCompanionObject(@NotNull ClassDescriptor companionObjectDescriptor2) {
        if (companionObjectDescriptor2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(187);
        }
        DeclarationDescriptor hostClassDescriptor = companionObjectDescriptor2.getContainingDeclaration();
        assert (hostClassDescriptor instanceof ClassDescriptor) : "Containing declaration of the companion object " + companionObjectDescriptor2 + ": expected a class, actual: " + hostClassDescriptor;
        CodegenContext hostClassContext = this.context.findParentContextWithDescriptor(hostClassDescriptor);
        assert (hostClassContext != null) : "Host class context for " + hostClassDescriptor + " not found in context hierarchy for " + this.context;
        hostClassContext.markCompanionObjectDescriptorWithAccessorRequired(companionObjectDescriptor2);
        Type hostClassType = this.typeMapper.mapClass((ClassifierDescriptor)hostClassDescriptor);
        Type companionObjectType = this.typeMapper.mapClass(companionObjectDescriptor2);
        StackValue stackValue = StackValue.operation(companionObjectType, companionObjectDescriptor2.getDefaultType(), (Function1<InstructionAdapter, Unit>)((Function1)v -> {
            v.invokestatic(hostClassType.getInternalName(), JvmCodegenUtil.getCompanionObjectAccessorName(companionObjectDescriptor2), Type.getMethodDescriptor((Type)companionObjectType, (Type[])new Type[0]), false);
            return null;
        }));
        if (stackValue == null) {
            ExpressionCodegen.$$$reportNull$$$0(188);
        }
        return stackValue;
    }

    @NotNull
    public StackValue generateExtensionReceiver(@NotNull CallableDescriptor descriptor2) {
        ReceiverParameterDescriptor parameter;
        if (descriptor2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(189);
        }
        if (this.myFrameMap.getIndex(parameter = descriptor2.getExtensionReceiverParameter()) != -1) {
            KotlinType type2 = parameter.getReturnType();
            StackValue.Local local = StackValue.local(this.myFrameMap.getIndex(parameter), this.typeMapper.mapType(type2), type2);
            if (local == null) {
                ExpressionCodegen.$$$reportNull$$$0(190);
            }
            return local;
        }
        StackValue result2 = this.context.generateReceiver(descriptor2, this.state, false);
        if (result2 == null) {
            throw new NullPointerException("Extension receiver was null for callable " + descriptor2);
        }
        StackValue stackValue = result2;
        if (stackValue == null) {
            ExpressionCodegen.$$$reportNull$$$0(191);
        }
        return stackValue;
    }

    @NotNull
    private StackValue generateScriptReceiver(@NotNull ScriptDescriptor receiver2) {
        CodegenContext cur;
        if (receiver2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(192);
        }
        StackValue result2 = StackValue.LOCAL_0;
        boolean inStartConstructorContext = cur instanceof ConstructorContext;
        for (cur = this.context; cur != null; cur = cur.getParentContext()) {
            if (!inStartConstructorContext) {
                cur = ExpressionCodegen.getNotNullParentContextForMethod(cur);
            }
            if (cur instanceof ScriptContext) {
                ScriptContext scriptContext = (ScriptContext)cur;
                if (scriptContext.getScriptDescriptor() == receiver2) {
                    StackValue stackValue = result2;
                    if (stackValue == null) {
                        ExpressionCodegen.$$$reportNull$$$0(193);
                    }
                    return stackValue;
                }
                Type currentScriptType = this.typeMapper.mapType(scriptContext.getScriptDescriptor());
                SimpleType receiverKotlinType = receiver2.getDefaultType();
                Type classType = this.typeMapper.mapType(receiverKotlinType);
                String fieldName = scriptContext.getScriptFieldName(receiver2);
                StackValue.Field field2 = StackValue.field(classType, receiverKotlinType, currentScriptType, fieldName, false, result2, receiver2);
                if (field2 == null) {
                    ExpressionCodegen.$$$reportNull$$$0(194);
                }
                return field2;
            }
            result2 = cur.getOuterExpression(result2, false);
            if (!inStartConstructorContext) continue;
            cur = ExpressionCodegen.getNotNullParentContextForMethod(cur);
            inStartConstructorContext = false;
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    public StackValue generateThisOrOuter(@NotNull ClassDescriptor calleeContainingClass, boolean isSuper) {
        if (calleeContainingClass == null) {
            ExpressionCodegen.$$$reportNull$$$0(195);
        }
        StackValue stackValue = this.generateThisOrOuter(calleeContainingClass, isSuper, false);
        if (stackValue == null) {
            ExpressionCodegen.$$$reportNull$$$0(196);
        }
        return stackValue;
    }

    private boolean isInsideSingleton(@NotNull ClassDescriptor singletonClassDescriptor) {
        if (singletonClassDescriptor == null) {
            ExpressionCodegen.$$$reportNull$$$0(197);
        }
        assert (singletonClassDescriptor.getKind().isSingleton()) : "Singleton expected: " + singletonClassDescriptor;
        for (Object descriptor2 = this.context.getContextDescriptor(); descriptor2 != null; descriptor2 = descriptor2.getContainingDeclaration()) {
            if (descriptor2 == singletonClassDescriptor) {
                return true;
            }
            if (!(descriptor2 instanceof ClassDescriptor) || ((ClassDescriptor)descriptor2).isInner() || DescriptorUtils.isAnonymousObject(descriptor2)) continue;
            return false;
        }
        return false;
    }

    @NotNull
    public StackValue generateThisOrOuter(@NotNull ClassDescriptor thisOrOuterClass, boolean isSuper, boolean forceOuter) {
        if (thisOrOuterClass == null) {
            ExpressionCodegen.$$$reportNull$$$0(198);
        }
        if (!thisOrOuterClass.getKind().isSingleton()) {
            StackValue stackValue = this.generateThisOrOuterFromContext(thisOrOuterClass, isSuper, forceOuter);
            if (stackValue == null) {
                ExpressionCodegen.$$$reportNull$$$0(199);
            }
            return stackValue;
        }
        if (thisOrOuterClass.equals(this.context.getThisDescriptor()) && !CodegenUtilKt.isJvmStaticInObjectOrClassOrInterface(this.context.getFunctionDescriptor())) {
            StackValue.Local local = StackValue.local(0, this.typeMapper.mapType(thisOrOuterClass));
            if (local == null) {
                ExpressionCodegen.$$$reportNull$$$0(200);
            }
            return local;
        }
        if (this.shouldGenerateSingletonAsThisOrOuterFromContext(thisOrOuterClass)) {
            StackValue stackValue = this.generateThisOrOuterFromContext(thisOrOuterClass, isSuper, forceOuter);
            if (stackValue == null) {
                ExpressionCodegen.$$$reportNull$$$0(201);
            }
            return stackValue;
        }
        if (DescriptorUtils.isEnumEntry(thisOrOuterClass)) {
            StackValue.Field field2 = StackValue.enumEntry(thisOrOuterClass, this.typeMapper);
            if (field2 == null) {
                ExpressionCodegen.$$$reportNull$$$0(202);
            }
            return field2;
        }
        StackValue.Field field3 = StackValue.singleton(thisOrOuterClass, this.typeMapper);
        if (field3 == null) {
            ExpressionCodegen.$$$reportNull$$$0(203);
        }
        return field3;
    }

    private StackValue generateThisOrOuterFromContext(@NotNull ClassDescriptor thisOrOuterClass, boolean isSuper, boolean forceOuter) {
        if (thisOrOuterClass == null) {
            ExpressionCodegen.$$$reportNull$$$0(204);
        }
        CodegenContext cur = this.context;
        SimpleType contextType = cur.getThisDescriptor().getDefaultType();
        StackValue result2 = StackValue.local(0, this.asmType(contextType), contextType);
        boolean inStartConstructorContext = cur instanceof ConstructorContext;
        while (cur != null) {
            CodegenContext enclosingContext;
            ClassDescriptor thisDescriptor = cur.getThisDescriptor();
            if (!isSuper && thisDescriptor.getTypeConstructor().equals(thisOrOuterClass.getTypeConstructor())) {
                return result2;
            }
            if (!forceOuter && isSuper && DescriptorUtils.isSubclass(thisDescriptor, thisOrOuterClass)) {
                return this.castToRequiredTypeOfInterfaceIfNeeded(result2, thisDescriptor, thisOrOuterClass);
            }
            forceOuter = false;
            if (inStartConstructorContext) {
                result2 = cur.getOuterExpression(result2, false);
                cur = ExpressionCodegen.getNotNullParentContextForMethod(cur);
                enclosingContext = cur.getEnclosingClassContext();
                inStartConstructorContext = false;
            } else {
                cur = ExpressionCodegen.getNotNullParentContextForMethod(cur);
                enclosingContext = cur.getEnclosingClassContext();
                if (!(thisOrOuterClass instanceof ScriptDescriptor)) {
                    StackValue captured2;
                    MutableClosure closure;
                    if (cur instanceof ScriptLikeContext) {
                        return ((ScriptLikeContext)cur).getOuterReceiverExpression(result2, thisOrOuterClass);
                    }
                    if (enclosingContext instanceof ScriptLikeContext && (closure = cur.closure) != null && (captured2 = ((ScriptLikeContext)enclosingContext).captureVariable(closure, thisOrOuterClass)) != null) {
                        return captured2;
                    }
                }
                result2 = cur.getOuterExpression(result2, false);
            }
            cur = enclosingContext;
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    private static CodegenContext getNotNullParentContextForMethod(CodegenContext cur) {
        if (cur instanceof MethodContext) {
            cur = cur.getParentContext();
        }
        assert (cur != null);
        CodegenContext codegenContext = cur;
        if (codegenContext == null) {
            ExpressionCodegen.$$$reportNull$$$0(205);
        }
        return codegenContext;
    }

    private boolean canSkipArrayCopyForSpreadArgument(KtExpression spreadArgument) {
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(spreadArgument, this.bindingContext);
        if (resolvedCall2 == null) {
            return false;
        }
        CallableDescriptor calleeDescriptor = resolvedCall2.getResultingDescriptor();
        return calleeDescriptor instanceof ConstructorDescriptor || CompileTimeConstantUtils.isArrayFunctionCall(resolvedCall2) || DescriptorUtils.getFqName(calleeDescriptor).asString().equals("kotlin.arrayOfNulls");
    }

    @NotNull
    public StackValue genVarargs(@NotNull VarargValueArgument valueArgument, @NotNull KotlinType outType) {
        if (valueArgument == null) {
            ExpressionCodegen.$$$reportNull$$$0(206);
        }
        if (outType == null) {
            ExpressionCodegen.$$$reportNull$$$0(207);
        }
        Type type2 = this.asmType(outType);
        assert (type2.getSort() == 9);
        Type elementType = AsmUtil.correctElementType(type2);
        List<ValueArgument> arguments2 = valueArgument.getArguments();
        int size = arguments2.size();
        boolean hasSpread = false;
        for (int i2 = 0; i2 != size; ++i2) {
            if (arguments2.get(i2).getSpreadElement() == null) continue;
            hasSpread = true;
            break;
        }
        if (hasSpread) {
            String toArrayDescriptor;
            String addDescriptor;
            String owner;
            boolean arrayOfReferences = KotlinBuiltIns.isArray(outType);
            if (size == 1) {
                Type arrayType = AsmUtil.getArrayType(arrayOfReferences ? AsmTypes.OBJECT_TYPE : elementType);
                StackValue stackValue = StackValue.operation(type2, outType, (Function1<InstructionAdapter, Unit>)((Function1)adapter -> {
                    KtExpression spreadArgument = ((ValueArgument)arguments2.get(0)).getArgumentExpression();
                    this.gen(spreadArgument, type2, outType);
                    if (!this.canSkipArrayCopyForSpreadArgument(spreadArgument)) {
                        this.v.dup();
                        this.v.arraylength();
                        this.v.invokestatic("java/util/Arrays", "copyOf", Type.getMethodDescriptor((Type)arrayType, (Type[])new Type[]{arrayType, Type.INT_TYPE}), false);
                    }
                    if (arrayOfReferences) {
                        this.v.checkcast(type2);
                    }
                    return Unit.INSTANCE;
                }));
                if (stackValue == null) {
                    ExpressionCodegen.$$$reportNull$$$0(208);
                }
                return stackValue;
            }
            if (arrayOfReferences) {
                owner = "kotlin/jvm/internal/SpreadBuilder";
                addDescriptor = "(Ljava/lang/Object;)V";
                toArrayDescriptor = "([Ljava/lang/Object;)[Ljava/lang/Object;";
            } else {
                String spreadBuilderClassName = AsmUtil.asmPrimitiveTypeToLangPrimitiveType(elementType).getTypeName().getIdentifier() + "SpreadBuilder";
                owner = "kotlin/jvm/internal/" + spreadBuilderClassName;
                addDescriptor = "(" + elementType.getDescriptor() + ")V";
                toArrayDescriptor = "()" + type2.getDescriptor();
            }
            StackValue stackValue = StackValue.operation(type2, (Function1<InstructionAdapter, Unit>)((Function1)adapter -> {
                this.v.anew(Type.getObjectType((String)owner));
                this.v.dup();
                this.v.iconst(size);
                this.v.invokespecial(owner, "<init>", "(I)V", false);
                for (int i2 = 0; i2 != size; ++i2) {
                    this.v.dup();
                    ValueArgument argument2 = (ValueArgument)arguments2.get(i2);
                    KtExpression argumentExpression2 = argument2.getArgumentExpression();
                    KotlinType argumentKotlinType = this.kotlinType(argumentExpression2);
                    if (argument2.getSpreadElement() != null) {
                        this.gen(argumentExpression2, AsmTypes.OBJECT_TYPE, argumentKotlinType);
                        if (argumentKotlinType != null && InlineClassesUtilsKt.isInlineClassType(argumentKotlinType)) {
                            StackValue.coerce(AsmTypes.OBJECT_TYPE, argumentKotlinType, this.asmType(argumentKotlinType), argumentKotlinType, this.v);
                        }
                        this.v.invokevirtual(owner, "addSpread", "(Ljava/lang/Object;)V", false);
                        continue;
                    }
                    this.gen(argumentExpression2, elementType, argumentKotlinType);
                    this.v.invokevirtual(owner, "add", addDescriptor, false);
                }
                if (arrayOfReferences) {
                    this.v.dup();
                    this.v.invokevirtual(owner, "size", "()I", false);
                    this.newArrayInstruction(outType);
                    this.v.invokevirtual(owner, "toArray", toArrayDescriptor, false);
                    this.v.checkcast(type2);
                } else {
                    this.v.invokevirtual(owner, "toArray", toArrayDescriptor, false);
                }
                return Unit.INSTANCE;
            }));
            if (stackValue == null) {
                ExpressionCodegen.$$$reportNull$$$0(209);
            }
            return stackValue;
        }
        StackValue stackValue = StackValue.operation(type2, outType, (Function1<InstructionAdapter, Unit>)((Function1)adapter -> {
            this.v.iconst(arguments2.size());
            this.newArrayInstruction(outType);
            KotlinType elementKotlinType = outType.getConstructor().getBuiltIns().getArrayElementType(outType);
            for (int i2 = 0; i2 != size; ++i2) {
                this.v.dup();
                StackValue rightSide = this.gen(((ValueArgument)arguments2.get(i2)).getArgumentExpression());
                StackValue.arrayElement(elementType, elementKotlinType, StackValue.onStack(type2, outType), StackValue.constant(i2)).store(rightSide, this.v);
            }
            return Unit.INSTANCE;
        }));
        if (stackValue == null) {
            ExpressionCodegen.$$$reportNull$$$0(210);
        }
        return stackValue;
    }

    public int indexOfLocalNotDelegated(KtReferenceExpression lhs) {
        DeclarationDescriptor declarationDescriptor = this.bindingContext.get(BindingContext.REFERENCE_TARGET, lhs);
        if (BindingContextUtils.isBoxedLocalCapturedInClosure(this.bindingContext, declarationDescriptor)) {
            return -1;
        }
        if (declarationDescriptor instanceof LocalVariableDescriptor && ((LocalVariableDescriptor)declarationDescriptor).isDelegated()) {
            return -1;
        }
        return this.lookupLocalIndex(declarationDescriptor);
    }

    @Override
    public StackValue visitClassLiteralExpression(@NotNull KtClassLiteralExpression expression2, StackValue data2) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(211);
        }
        KtExpression receiverExpression = expression2.getReceiverExpression();
        assert (receiverExpression != null) : "Class literal expression should have a left-hand side";
        DoubleColonLHS lhs = this.bindingContext.get(BindingContext.DOUBLE_COLON_LHS, receiverExpression);
        assert (lhs != null) : "Class literal expression should have LHS resolved";
        return this.generateClassLiteralReference(lhs, receiverExpression, true);
    }

    @Override
    public StackValue visitCallableReferenceExpression(@NotNull KtCallableReferenceExpression expression2, StackValue data2) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(212);
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCallWithAssert(expression2.getCallableReference(), this.bindingContext);
        StackValue receiver2 = this.generateCallableReferenceReceiver(resolvedCall2);
        FunctionDescriptor functionDescriptor2 = this.bindingContext.get(BindingContext.FUNCTION, expression2);
        if (functionDescriptor2 != null) {
            FunctionReferenceGenerationStrategy strategy = new FunctionReferenceGenerationStrategy(this.state, functionDescriptor2, resolvedCall2, receiver2 != null ? new JvmKotlinType(receiver2.type, receiver2.kotlinType) : null, null, false);
            return this.genClosure(expression2, functionDescriptor2, strategy, null, (FunctionDescriptor)resolvedCall2.getResultingDescriptor(), receiver2);
        }
        return this.generatePropertyReference(expression2, this.getVariableDescriptorNotNull(expression2), (VariableDescriptor)resolvedCall2.getResultingDescriptor(), receiver2);
    }

    @Nullable
    public StackValue generateCallableReferenceReceiver(@NotNull ResolvedCall<?> resolvedCall2) {
        ReceiverValue receiver2;
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(213);
        }
        if ((receiver2 = JvmCodegenUtil.getBoundCallableReferenceReceiver(resolvedCall2)) == null) {
            return null;
        }
        KotlinType receiverType2 = receiver2.getType();
        return StackValue.coercion(this.generateReceiverValue(receiver2, false), this.asmType(receiverType2), receiverType2);
    }

    @NotNull
    private StackValue generatePropertyReference(@NotNull KtElement element3, @NotNull VariableDescriptor variableDescriptor, @NotNull VariableDescriptor target, @Nullable StackValue receiverValue) {
        ClassDescriptor classDescriptor2;
        if (element3 == null) {
            ExpressionCodegen.$$$reportNull$$$0(214);
        }
        if (variableDescriptor == null) {
            ExpressionCodegen.$$$reportNull$$$0(215);
        }
        if (target == null) {
            ExpressionCodegen.$$$reportNull$$$0(216);
        }
        if ((classDescriptor2 = this.bindingContext.get(CodegenBinding.CLASS_FOR_CALLABLE, variableDescriptor)) == null) {
            throw new IllegalStateException("Property reference class was not found: " + variableDescriptor + "\nTried to generate: " + element3.getText());
        }
        ClassBuilder classBuilder2 = this.state.getFactory().newVisitor(JvmDeclarationOriginKt.OtherOrigin((PsiElement)element3), this.typeMapper.mapClass(classDescriptor2), element3.getContainingFile());
        PropertyReferenceCodegen codegen2 = new PropertyReferenceCodegen(this.state, this.parentCodegen, this.context.intoAnonymousClass(classDescriptor2, this, OwnerKind.IMPLEMENTATION), element3, classBuilder2, variableDescriptor, target, receiverValue != null ? new JvmKotlinType(receiverValue.type, receiverValue.kotlinType) : null);
        codegen2.generate();
        StackValue stackValue = codegen2.putInstanceOnStack(receiverValue);
        if (stackValue == null) {
            ExpressionCodegen.$$$reportNull$$$0(217);
        }
        return stackValue;
    }

    @NotNull
    public StackValue generateClassLiteralReference(@NotNull DoubleColonLHS lhs, @Nullable KtExpression receiverExpression, boolean wrapIntoKClass) {
        if (lhs == null) {
            ExpressionCodegen.$$$reportNull$$$0(218);
        }
        StackValue stackValue = StackValue.operation(wrapIntoKClass ? AsmTypes.K_CLASS_TYPE : AsmTypes.JAVA_CLASS_TYPE, (Function1<InstructionAdapter, Unit>)((Function1)v -> {
            KotlinType type2 = lhs.getType();
            if (lhs instanceof DoubleColonLHS.Expression && !((DoubleColonLHS.Expression)lhs).isObjectQualifier()) {
                JavaClassProperty.INSTANCE.generateImpl((InstructionAdapter)v, this.gen(receiverExpression));
            } else {
                if (TypeUtils.isTypeParameter(type2)) {
                    assert (TypeUtils.isReifiedTypeParameter(type2)) : "Non-reified type parameter under ::class should be rejected by type checker: " + type2;
                    this.putReifiedOperationMarkerIfTypeIsReifiedParameter(type2, ReifiedTypeInliner.OperationKind.JAVA_CLASS);
                }
                AsmUtil.putJavaLangClassInstance(v, this.typeMapper.mapType(type2), type2, this.typeMapper);
            }
            if (wrapIntoKClass) {
                AsmUtil.wrapJavaClassIntoKClass(v);
            }
            return Unit.INSTANCE;
        }));
        if (stackValue == null) {
            ExpressionCodegen.$$$reportNull$$$0(219);
        }
        return stackValue;
    }

    @Override
    public StackValue visitDotQualifiedExpression(@NotNull KtDotQualifiedExpression expression2, StackValue receiver2) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(220);
        }
        StackValue receiverValue = StackValue.none();
        return this.genQualified(receiverValue, expression2.getSelectorExpression());
    }

    private StackValue generateExpressionWithNullFallback(@NotNull KtExpression expression2, @NotNull Label ifnull) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(221);
        }
        if (ifnull == null) {
            ExpressionCodegen.$$$reportNull$$$0(222);
        }
        KtExpression deparenthesized = KtPsiUtil.deparenthesize(expression2);
        assert (deparenthesized != null) : "Unexpected empty expression";
        expression2 = deparenthesized;
        Type type2 = this.expressionType(expression2);
        KotlinType kotlinType = this.kotlinType(expression2);
        if (expression2 instanceof KtSafeQualifiedExpression && !AsmUtil.isPrimitive(type2)) {
            return StackValue.coercion(this.generateSafeQualifiedExpression((KtSafeQualifiedExpression)expression2, ifnull), type2, kotlinType);
        }
        return this.genLazy(expression2, type2, kotlinType);
    }

    private StackValue generateSafeQualifiedExpression(@NotNull KtSafeQualifiedExpression expression2, @NotNull Label ifNull) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(223);
        }
        if (ifNull == null) {
            ExpressionCodegen.$$$reportNull$$$0(224);
        }
        KtExpression receiver2 = expression2.getReceiverExpression();
        KtExpression selector2 = expression2.getSelectorExpression();
        Type receiverType2 = this.expressionType(receiver2);
        KotlinType receiverKotlinType = this.kotlinType(receiver2);
        StackValue receiverValue = this.generateExpressionWithNullFallback(receiver2, ifNull);
        StackValue.SafeCall newReceiver = new StackValue.SafeCall(receiverType2, receiverKotlinType, receiverValue, AsmUtil.isPrimitive(receiverType2) ? null : ifNull);
        return this.genQualified(newReceiver, selector2);
    }

    @Override
    public StackValue visitSafeQualifiedExpression(@NotNull KtSafeQualifiedExpression expression2, StackValue unused2) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(225);
        }
        Label ifnull = new Label();
        Type type2 = AsmUtil.boxType(this.expressionType(expression2));
        KotlinType kotlinType = this.kotlinType(expression2);
        StackValue value2 = this.generateSafeQualifiedExpression(expression2, ifnull);
        StackValue newReceiver = StackValue.coercion(value2, type2, kotlinType);
        StackValue result2 = !AsmUtil.isPrimitive(this.expressionType(expression2.getReceiverExpression())) ? new StackValue.SafeFallback(type2, ifnull, newReceiver) : newReceiver;
        return result2;
    }

    @Override
    public StackValue visitBinaryExpression(@NotNull KtBinaryExpression expression2, @NotNull StackValue receiver2) {
        KtOperationReferenceExpression reference2;
        IElementType opToken;
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(226);
        }
        if (receiver2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(227);
        }
        if ((opToken = (reference2 = expression2.getOperationReference()).getReferencedNameElementType()) == KtTokens.EQ) {
            return this.generateAssignmentExpression(expression2);
        }
        if (KtTokens.AUGMENTED_ASSIGNMENTS.contains(opToken)) {
            return this.generateAugmentedAssignment(expression2);
        }
        if (opToken == KtTokens.ANDAND) {
            return this.generateBooleanAnd(expression2);
        }
        if (opToken == KtTokens.OROR) {
            return this.generateBooleanOr(expression2);
        }
        if (opToken == KtTokens.EQEQ || opToken == KtTokens.EXCLEQ || opToken == KtTokens.EQEQEQ || opToken == KtTokens.EXCLEQEQEQ) {
            return this.generateEquals(expression2.getLeft(), expression2.getRight(), opToken, null, null, this.bindingContext.get(BindingContext.PRIMITIVE_NUMERIC_COMPARISON_INFO, expression2));
        }
        if (opToken == KtTokens.LT || opToken == KtTokens.LTEQ || opToken == KtTokens.GT || opToken == KtTokens.GTEQ) {
            return this.generateComparison(expression2, receiver2);
        }
        if (opToken == KtTokens.ELVIS) {
            return this.generateElvis(expression2);
        }
        if (opToken == KtTokens.IN_KEYWORD || opToken == KtTokens.NOT_IN) {
            return this.generateIn(StackValue.expression(this.expressionType(expression2.getLeft()), expression2.getLeft(), this), expression2.getRight(), reference2);
        }
        ConstantValue<?> compileTimeConstant = this.getPrimitiveOrStringCompileTimeConstant(expression2);
        if (compileTimeConstant != null) {
            return StackValue.constant(compileTimeConstant.getValue(), this.expressionType(expression2));
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCallWithAssert(expression2, this.bindingContext);
        FunctionDescriptor descriptor2 = (FunctionDescriptor)resolvedCall2.getResultingDescriptor();
        if (descriptor2 instanceof ConstructorDescriptor) {
            return this.generateConstructorCall(resolvedCall2, this.expressionType(expression2));
        }
        return this.invokeFunction(resolvedCall2, receiver2);
    }

    private StackValue generateIn(StackValue leftValue, KtExpression rangeExpression, KtSimpleNameExpression operationReference) {
        KtExpression deparenthesized = KtPsiUtil.deparenthesize(rangeExpression);
        assert (deparenthesized != null) : "For with empty range expression";
        RangeValue rangeValue = RangeValuesKt.createRangeValueForExpression(this, deparenthesized);
        return rangeValue.createInExpressionGenerator(this, operationReference).generate(leftValue);
    }

    private StackValue generateBooleanAnd(KtBinaryExpression expression2) {
        return StackValue.and(this.gen(expression2.getLeft()), this.gen(expression2.getRight()));
    }

    private StackValue generateBooleanOr(KtBinaryExpression expression2) {
        return StackValue.or(this.gen(expression2.getLeft()), this.gen(expression2.getRight()));
    }

    private StackValue genLazyUnlessProvided(@Nullable StackValue pregenerated, @NotNull KtExpression expr2, @NotNull Type type2) {
        if (expr2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(228);
        }
        if (type2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(229);
        }
        return this.genLazyUnlessProvided(pregenerated, expr2, type2, null);
    }

    private StackValue genLazyUnlessProvided(@Nullable StackValue pregenerated, @NotNull KtExpression expr2, @NotNull Type type2, @Nullable KotlinType kotlinType) {
        if (expr2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(230);
        }
        if (type2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(231);
        }
        return pregenerated != null ? StackValue.coercion(pregenerated, type2, kotlinType) : this.genLazy(expr2, type2, kotlinType);
    }

    private StackValue genUnlessProvided(@Nullable StackValue pregenerated, @NotNull KtExpression expr2, @NotNull Type type2) {
        if (expr2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(232);
        }
        if (type2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(233);
        }
        if (pregenerated != null) {
            pregenerated.put(type2, null, this.v);
        } else {
            this.gen(expr2, type2);
        }
        return StackValue.onStack(type2);
    }

    private StackValue generateEquals(@Nullable KtExpression left, @Nullable KtExpression right2, @NotNull IElementType opToken, @Nullable StackValue pregeneratedSubject, @Nullable KotlinType subjectKotlinType, @Nullable PrimitiveNumericComparisonInfo primitiveNumericComparisonInfo) {
        boolean rightHasPrimitiveEquality;
        if (opToken == null) {
            ExpressionCodegen.$$$reportNull$$$0(234);
        }
        if (left == null || right2 == null) {
            return StackValue.operation(Type.VOID_TYPE, (Function1<InstructionAdapter, Unit>)((Function1)v -> {
                v.aconst(null);
                v.athrow();
                return Unit.INSTANCE;
            }));
        }
        KotlinType leftKotlinType = subjectKotlinType != null ? subjectKotlinType : this.kotlinType(left);
        KotlinType rightKotlinType = this.kotlinType(right2);
        boolean leftIsInlineClass = leftKotlinType != null && InlineClassesUtilsKt.isInlineClassType(leftKotlinType);
        boolean rightIsInlineClass = rightKotlinType != null && InlineClassesUtilsKt.isInlineClassType(rightKotlinType);
        Type leftType = pregeneratedSubject != null ? pregeneratedSubject.type : this.expressionType(left);
        Type rightType2 = this.expressionType(right2);
        boolean leftHasPrimitiveEquality = AsmUtil.isPrimitive(leftType) && (!leftIsInlineClass || CodegenUtilKt.isInlineClassTypeWithPrimitiveEquality(leftKotlinType));
        boolean bl = rightHasPrimitiveEquality = AsmUtil.isPrimitive(rightType2) && (!rightIsInlineClass || CodegenUtilKt.isInlineClassTypeWithPrimitiveEquality(rightKotlinType));
        if (KtPsiUtil.isNullConstant(left)) {
            return this.genCmpWithNull(right2, opToken, null);
        }
        if (KtPsiUtil.isNullConstant(right2)) {
            return this.genCmpWithNull(left, opToken, pregeneratedSubject);
        }
        if (leftIsInlineClass || rightIsInlineClass) {
            boolean rightIsUnboxed;
            boolean leftIsUnboxed = leftIsInlineClass && StackValue.isUnboxedInlineClass(leftKotlinType, leftType);
            boolean bl2 = rightIsUnboxed = rightIsInlineClass && StackValue.isUnboxedInlineClass(rightKotlinType, rightType2);
            if (!(leftIsUnboxed && rightIsUnboxed && leftHasPrimitiveEquality && rightHasPrimitiveEquality)) {
                return this.genEqualsForInlineClasses(left, right2, opToken, pregeneratedSubject, leftKotlinType, rightKotlinType, leftType, rightType2, leftIsInlineClass, leftIsUnboxed, rightIsUnboxed);
            }
        }
        if (this.isIntZero(left, leftType) && rightHasPrimitiveEquality && AsmUtil.isIntPrimitive(rightType2)) {
            return this.genCmpWithZero(right2, opToken, null);
        }
        if (this.isIntZero(right2, rightType2) && leftHasPrimitiveEquality && AsmUtil.isIntPrimitive(leftType)) {
            return this.genCmpWithZero(left, opToken, pregeneratedSubject);
        }
        if (pregeneratedSubject == null && left instanceof KtSafeQualifiedExpression && this.isSelectorPureNonNullType((KtSafeQualifiedExpression)left) && AsmUtil.isPrimitive(rightType2) && rightHasPrimitiveEquality) {
            return this.genCmpSafeCallToPrimitive((KtSafeQualifiedExpression)left, right2, rightType2, opToken);
        }
        if (AsmUtil.isPrimitive(leftType) && leftHasPrimitiveEquality && right2 instanceof KtSafeQualifiedExpression && this.isSelectorPureNonNullType((KtSafeQualifiedExpression)right2)) {
            return this.genCmpPrimitiveToSafeCall(left, leftType, (KtSafeQualifiedExpression)right2, opToken, pregeneratedSubject);
        }
        if (BoxedToPrimitiveEquality.isApplicable(opToken, leftType, rightType2)) {
            return BoxedToPrimitiveEquality.create(opToken, this.genLazyUnlessProvided(pregeneratedSubject, left, leftType), leftType, this.genLazy(right2, rightType2), rightType2, this.myFrameMap);
        }
        if (PrimitiveToBoxedEquality.isApplicable(opToken, leftType, rightType2)) {
            return PrimitiveToBoxedEquality.create(opToken, this.genLazyUnlessProvided(pregeneratedSubject, left, leftType), leftType, this.genLazy(right2, rightType2), rightType2);
        }
        if (PrimitiveToObjectEquality.isApplicable(opToken, leftType, rightType2)) {
            return PrimitiveToObjectEquality.create(opToken, this.genLazyUnlessProvided(pregeneratedSubject, left, leftType), leftType, this.genLazy(right2, rightType2), rightType2);
        }
        if (AsmUtil.isPrimitive(leftType) != AsmUtil.isPrimitive(rightType2)) {
            leftType = AsmUtil.boxType(leftType);
            rightType2 = AsmUtil.boxType(rightType2);
        }
        if (opToken == KtTokens.EQEQEQ || opToken == KtTokens.EXCLEQEQEQ) {
            Type operandType = AsmUtil.isPrimitive(leftType) ? leftType : AsmTypes.OBJECT_TYPE;
            return StackValue.cmp(opToken, operandType, this.genLazyUnlessProvided(pregeneratedSubject, left, leftType), this.genLazy(right2, rightType2));
        }
        if ((opToken == KtTokens.EQEQ || opToken == KtTokens.EXCLEQ) && (this.isEnumExpression(left) || this.isEnumExpression(right2))) {
            return StackValue.cmp(opToken == KtTokens.EQEQ ? KtTokens.EQEQEQ : KtTokens.EXCLEQEQEQ, AsmTypes.OBJECT_TYPE, this.genLazyUnlessProvided(pregeneratedSubject, left, leftType), this.genLazy(right2, rightType2));
        }
        return this.genEqualsForExpressionsPreferIeee754Arithmetic(left, right2, opToken, leftType, rightType2, pregeneratedSubject, primitiveNumericComparisonInfo);
    }

    @NotNull
    private StackValue genEqualsForInlineClasses(@NotNull KtExpression left, @NotNull KtExpression right2, @NotNull IElementType opToken, @Nullable StackValue pregeneratedSubject, @NotNull KotlinType leftKotlinType, @NotNull KotlinType rightKotlinType, @NotNull Type leftType, @NotNull Type rightType2, boolean leftIsInlineClass, boolean leftIsUnboxed, boolean rightIsUnboxed) {
        if (left == null) {
            ExpressionCodegen.$$$reportNull$$$0(235);
        }
        if (right2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(236);
        }
        if (opToken == null) {
            ExpressionCodegen.$$$reportNull$$$0(237);
        }
        if (leftKotlinType == null) {
            ExpressionCodegen.$$$reportNull$$$0(238);
        }
        if (rightKotlinType == null) {
            ExpressionCodegen.$$$reportNull$$$0(239);
        }
        if (leftType == null) {
            ExpressionCodegen.$$$reportNull$$$0(240);
        }
        if (rightType2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(241);
        }
        StackValue leftValue = this.genLazyUnlessProvided(pregeneratedSubject, left, leftType, leftKotlinType);
        StackValue rightValue = this.genLazy(right2, rightType2, rightKotlinType);
        StackValue stackValue = StackValue.operation(Type.BOOLEAN_TYPE, (Function1<InstructionAdapter, Unit>)((Function1)v -> {
            SimpleType nullableAnyType = this.state.getModule().getBuiltIns().getNullableAnyType();
            Label endLabel = new Label();
            boolean flipComparison = opToken == KtTokens.EXCLEQ || opToken == KtTokens.EXCLEQEQEQ;
            boolean useUnboxedEquals = (leftIsUnboxed || leftIsInlineClass && rightIsUnboxed) && JvmCodegenUtil.typeHasSpecializedInlineClassEquality(leftKotlinType, this.state);
            leftValue.put(leftType, leftKotlinType, (InstructionAdapter)v);
            Type afterTopType = leftType;
            if (!useUnboxedEquals) {
                StackValue.coerce(leftType, leftKotlinType, AsmTypes.OBJECT_TYPE, nullableAnyType, v);
                afterTopType = AsmTypes.OBJECT_TYPE;
            }
            rightValue.put(rightType2, rightKotlinType, (InstructionAdapter)v);
            Type topType = rightType2;
            if (!useUnboxedEquals || !rightIsUnboxed) {
                StackValue.coerce(rightType2, rightKotlinType, AsmTypes.OBJECT_TYPE, nullableAnyType, v);
                topType = AsmTypes.OBJECT_TYPE;
            }
            if (useUnboxedEquals) {
                String descriptor2;
                Label nonNullLabel;
                String className2 = this.typeMapper.mapTypeAsDeclaration(leftKotlinType).getInternalName();
                if (TypeUtils.isNullableType(leftKotlinType)) {
                    AsmUtil.dupSecond(v, topType, afterTopType);
                    nonNullLabel = new Label();
                    v.ifnonnull(nonNullLabel);
                    if (TypeUtils.isNullableType(rightKotlinType)) {
                        Label branchJumpLabel = new Label();
                        v.ifnonnull(branchJumpLabel);
                        AsmUtil.pop((MethodVisitor)v, afterTopType);
                        v.iconst(flipComparison ? 0 : 1);
                        v.goTo(endLabel);
                        v.visitLabel(branchJumpLabel);
                        AsmUtil.pop((MethodVisitor)v, afterTopType);
                    } else {
                        AsmUtil.pop2((MethodVisitor)v, topType, afterTopType);
                    }
                    v.iconst(flipComparison ? 1 : 0);
                    v.goTo(endLabel);
                    v.visitLabel(nonNullLabel);
                }
                if (rightIsUnboxed) {
                    if (TypeUtils.isNullableType(rightKotlinType)) {
                        AsmUtil.dup(v, topType);
                        nonNullLabel = new Label();
                        v.ifnonnull(nonNullLabel);
                        AsmUtil.pop2((MethodVisitor)v, topType, afterTopType);
                        v.iconst(flipComparison ? 1 : 0);
                        v.goTo(endLabel);
                        v.visitLabel(nonNullLabel);
                    }
                    if (!leftIsUnboxed) {
                        AsmUtil.swap(v, topType, afterTopType);
                        KotlinType nonNullableLeftKotlinType = TypeUtils.makeNotNullable(leftKotlinType);
                        Type nonNullableLeftType = this.typeMapper.mapType(nonNullableLeftKotlinType);
                        StackValue.coerce(leftType, leftKotlinType, nonNullableLeftType, nonNullableLeftKotlinType, v);
                        afterTopType = nonNullableLeftType;
                        AsmUtil.swap(v, afterTopType, topType);
                    }
                    descriptor2 = Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{afterTopType, afterTopType});
                    v.invokestatic(className2, InlineClassDescriptorResolver.SPECIALIZED_EQUALS_NAME.asString(), descriptor2, false);
                } else {
                    descriptor2 = Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{afterTopType, AsmTypes.OBJECT_TYPE});
                    v.invokestatic(className2, "equals-impl", descriptor2, false);
                }
            } else {
                AsmUtil.genAreEqualCall(v);
            }
            if (flipComparison) {
                AsmUtil.genInvertBoolean(v);
            }
            v.visitLabel(endLabel);
            return Unit.INSTANCE;
        }));
        if (stackValue == null) {
            ExpressionCodegen.$$$reportNull$$$0(242);
        }
        return stackValue;
    }

    private boolean isEnumExpression(@Nullable KtExpression expression2) {
        KotlinType expressionType = this.bindingContext.getType(expression2);
        if (expressionType == null) {
            return false;
        }
        return DescriptorUtils.isEnumClass(expressionType.getConstructor().getDeclarationDescriptor());
    }

    private boolean isSelectorPureNonNullType(@NotNull KtSafeQualifiedExpression safeExpression) {
        KtExpression expression2;
        if (safeExpression == null) {
            ExpressionCodegen.$$$reportNull$$$0(243);
        }
        if ((expression2 = safeExpression.getSelectorExpression()) == null) {
            return false;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(expression2, this.bindingContext);
        if (resolvedCall2 == null) {
            return false;
        }
        KotlinType returnType2 = resolvedCall2.getResultingDescriptor().getReturnType();
        return returnType2 != null && !TypeUtils.isNullableType(returnType2);
    }

    private StackValue genCmpPrimitiveToSafeCall(@NotNull KtExpression left, @NotNull Type leftType, @NotNull KtSafeQualifiedExpression right2, @NotNull IElementType opToken, @Nullable StackValue pregeneratedLeft) {
        if (left == null) {
            ExpressionCodegen.$$$reportNull$$$0(244);
        }
        if (leftType == null) {
            ExpressionCodegen.$$$reportNull$$$0(245);
        }
        if (right2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(246);
        }
        if (opToken == null) {
            ExpressionCodegen.$$$reportNull$$$0(247);
        }
        Label rightIsNull = new Label();
        return new PrimitiveToSafeCallEquality(opToken, leftType, this.genLazyUnlessProvided(pregeneratedLeft, left, leftType), this.generateSafeQualifiedExpression(right2, rightIsNull), this.expressionType(right2.getReceiverExpression()), rightIsNull);
    }

    private StackValue genCmpSafeCallToPrimitive(@NotNull KtSafeQualifiedExpression left, @NotNull KtExpression right2, @NotNull Type rightType2, @NotNull IElementType opToken) {
        if (left == null) {
            ExpressionCodegen.$$$reportNull$$$0(248);
        }
        if (right2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(249);
        }
        if (rightType2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(250);
        }
        if (opToken == null) {
            ExpressionCodegen.$$$reportNull$$$0(251);
        }
        Label leftIsNull = new Label();
        return new SafeCallToPrimitiveEquality(opToken, rightType2, this.generateSafeQualifiedExpression(left, leftIsNull), this.genLazy(right2, rightType2), this.expressionType(left.getReceiverExpression()), leftIsNull);
    }

    @Nullable
    private static KotlinType getLeftOperandType(@Nullable PrimitiveNumericComparisonInfo numericComparisonInfo) {
        if (numericComparisonInfo == null) {
            return null;
        }
        return numericComparisonInfo.getLeftType();
    }

    @Nullable
    private static KotlinType getRightOperandType(@Nullable PrimitiveNumericComparisonInfo numericComparisonInfo) {
        if (numericComparisonInfo == null) {
            return null;
        }
        return numericComparisonInfo.getRightType();
    }

    private StackValue genEqualsForExpressionsPreferIeee754Arithmetic(@NotNull KtExpression left, @NotNull KtExpression right2, @NotNull IElementType opToken, @NotNull Type leftType, @NotNull Type rightType2, @Nullable StackValue pregeneratedLeft, @Nullable PrimitiveNumericComparisonInfo primitiveNumericComparisonInfo) {
        Type comparisonType;
        if (left == null) {
            ExpressionCodegen.$$$reportNull$$$0(252);
        }
        if (right2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(253);
        }
        if (opToken == null) {
            ExpressionCodegen.$$$reportNull$$$0(254);
        }
        if (leftType == null) {
            ExpressionCodegen.$$$reportNull$$$0(255);
        }
        if (rightType2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(256);
        }
        assert (opToken == KtTokens.EQEQ || opToken == KtTokens.EXCLEQ) : "Optoken should be '==' or '!=', but: " + opToken;
        TypeAndNullability left754Type = this.calcTypeForIeee754ArithmeticIfNeeded(left, ExpressionCodegen.getLeftOperandType(primitiveNumericComparisonInfo));
        TypeAndNullability right754Type = this.calcTypeForIeee754ArithmeticIfNeeded(right2, ExpressionCodegen.getRightOperandType(primitiveNumericComparisonInfo));
        if (left754Type != null && right754Type != null && ((comparisonType = AsmUtil.comparisonOperandType(left754Type.type, right754Type.type)) == Type.FLOAT_TYPE || comparisonType == Type.DOUBLE_TYPE)) {
            if (left754Type.type.equals((Object)right754Type.type)) {
                if (left754Type.isNullable || right754Type.isNullable) {
                    if (this.state.getLanguageVersionSettings().getApiVersion().compareTo(ApiVersion.KOTLIN_1_1) >= 0) {
                        return StackValue.operation(Type.BOOLEAN_TYPE, (Function1<InstructionAdapter, Unit>)((Function1)v -> {
                            this.generate754EqualsForNullableTypesViaIntrinsic((InstructionAdapter)v, opToken, pregeneratedLeft, left, left754Type, right2, right754Type);
                            return Unit.INSTANCE;
                        }));
                    }
                    return StackValue.operation(Type.BOOLEAN_TYPE, (Function1<InstructionAdapter, Unit>)((Function1)v -> {
                        this.generate754EqualsForNullableTypes((InstructionAdapter)v, opToken, pregeneratedLeft, left, left754Type, right2, right754Type);
                        return Unit.INSTANCE;
                    }));
                }
                leftType = left754Type.type;
                rightType2 = right754Type.type;
            } else if (this.shouldUseProperIeee754Comparisons()) {
                return Ieee754Equality.create(this.myFrameMap, this.genLazy(left, ExpressionCodegen.boxIfNullable(left754Type)), this.genLazy(right2, ExpressionCodegen.boxIfNullable(right754Type)), comparisonType, opToken);
            }
        }
        return AsmUtil.genEqualsForExpressionsOnStack(opToken, this.genLazyUnlessProvided(pregeneratedLeft, left, leftType, this.kotlinType(left)), this.genLazy(right2, rightType2, this.kotlinType(right2)));
    }

    @NotNull
    private static Type boxIfNullable(@NotNull TypeAndNullability ieee754Type) {
        if (ieee754Type == null) {
            ExpressionCodegen.$$$reportNull$$$0(257);
        }
        if (ieee754Type.isNullable) {
            Type type2 = AsmUtil.boxType(ieee754Type.type);
            if (type2 == null) {
                ExpressionCodegen.$$$reportNull$$$0(258);
            }
            return type2;
        }
        Type type3 = ieee754Type.type;
        if (type3 == null) {
            ExpressionCodegen.$$$reportNull$$$0(259);
        }
        return type3;
    }

    private void generate754EqualsForNullableTypesViaIntrinsic(@NotNull InstructionAdapter v, @NotNull IElementType opToken, @Nullable StackValue pregeneratedLeft, @Nullable KtExpression left, @NotNull TypeAndNullability left754Type, @Nullable KtExpression right2, @NotNull TypeAndNullability right754Type) {
        if (v == null) {
            ExpressionCodegen.$$$reportNull$$$0(260);
        }
        if (opToken == null) {
            ExpressionCodegen.$$$reportNull$$$0(261);
        }
        if (left754Type == null) {
            ExpressionCodegen.$$$reportNull$$$0(262);
        }
        if (right754Type == null) {
            ExpressionCodegen.$$$reportNull$$$0(263);
        }
        Type leftType = left754Type.isNullable ? AsmUtil.boxType(left754Type.type) : left754Type.type;
        this.genUnlessProvided(pregeneratedLeft, left, leftType);
        Type rightType2 = right754Type.isNullable ? AsmUtil.boxType(right754Type.type) : right754Type.type;
        this.gen(right2, rightType2);
        AsmUtil.genIEEE754EqualForNullableTypesCall(v, leftType, rightType2);
        if (opToken == KtTokens.EXCLEQ) {
            AsmUtil.genInvertBoolean(v);
        }
    }

    private void generate754EqualsForNullableTypes(@NotNull InstructionAdapter v, @NotNull IElementType opToken, @Nullable StackValue pregeneratedLeft, @Nullable KtExpression left, @NotNull TypeAndNullability left754Type, @Nullable KtExpression right2, @NotNull TypeAndNullability right754Type) {
        if (v == null) {
            ExpressionCodegen.$$$reportNull$$$0(264);
        }
        if (opToken == null) {
            ExpressionCodegen.$$$reportNull$$$0(265);
        }
        if (left754Type == null) {
            ExpressionCodegen.$$$reportNull$$$0(266);
        }
        if (right754Type == null) {
            ExpressionCodegen.$$$reportNull$$$0(267);
        }
        int equals = opToken == KtTokens.EQEQ ? 1 : 0;
        int notEquals = opToken != KtTokens.EQEQ ? 1 : 0;
        Label end = new Label();
        StackValue leftValue = pregeneratedLeft != null ? pregeneratedLeft : this.gen(left);
        leftValue.put(leftValue.type, leftValue.kotlinType, v);
        leftValue = StackValue.onStack(leftValue.type);
        Type leftType = left754Type.type;
        Type rightType2 = right754Type.type;
        if (left754Type.isNullable) {
            leftValue.dup(v, false);
            Label leftIsNull = new Label();
            v.ifnull(leftIsNull);
            StackValue.coercion(leftValue, leftType, null).put(leftType, null, v);
            StackValue nonNullLeftValue = StackValue.onStack(leftType);
            StackValue rightValue = this.gen(right2);
            rightValue.put(rightValue.type, rightValue.kotlinType, v);
            rightValue = StackValue.onStack(rightValue.type);
            if (right754Type.isNullable) {
                rightValue.dup(v, false);
                Label rightIsNotNull = new Label();
                v.ifnonnull(rightIsNotNull);
                AsmUtil.pop((MethodVisitor)v, rightValue.type);
                AsmUtil.pop((MethodVisitor)v, nonNullLeftValue.type);
                v.iconst(notEquals);
                v.goTo(end);
                v.mark(rightIsNotNull);
            }
            StackValue.coercion(rightValue, rightType2, null).put(rightType2, null, v);
            StackValue nonNullRightValue = StackValue.onStack(rightType2);
            StackValue.cmp(opToken, leftType, nonNullLeftValue, nonNullRightValue).put(Type.BOOLEAN_TYPE, null, v);
            v.goTo(end);
            v.mark(leftIsNull);
            AsmUtil.pop((MethodVisitor)v, leftValue.type);
            rightValue = this.gen(right2);
            rightValue.put(rightValue.type, rightValue.kotlinType, v);
            rightValue = StackValue.onStack(rightValue.type);
            if (right754Type.isNullable) {
                Label rightIsNotNull = new Label();
                v.ifnonnull(rightIsNotNull);
                v.iconst(equals);
                v.goTo(end);
                v.mark(rightIsNotNull);
                v.iconst(notEquals);
            } else {
                AsmUtil.pop((MethodVisitor)v, rightValue.type);
                v.iconst(notEquals);
            }
            v.mark(end);
            return;
        }
        StackValue.coercion(leftValue, leftType, null).put(leftType, null, v);
        leftValue = StackValue.onStack(leftType);
        StackValue rightValue = this.gen(right2);
        rightValue.put(rightValue.type, rightValue.kotlinType, v);
        rightValue = StackValue.onStack(rightValue.type);
        rightValue.dup(v, false);
        Label rightIsNotNull = new Label();
        v.ifnonnull(rightIsNotNull);
        AsmUtil.pop((MethodVisitor)v, rightValue.type);
        AsmUtil.pop((MethodVisitor)v, leftValue.type);
        v.iconst(notEquals);
        v.goTo(end);
        v.mark(rightIsNotNull);
        StackValue.coercion(rightValue, rightType2, null).put(rightType2, null, v);
        StackValue nonNullRightValue = StackValue.onStack(rightType2);
        StackValue.cmp(opToken, leftType, leftValue, nonNullRightValue).put(Type.BOOLEAN_TYPE, null, v);
        v.mark(end);
    }

    private boolean isIntZero(KtExpression expr2, Type exprType) {
        ConstantValue<?> exprValue = this.getPrimitiveOrStringCompileTimeConstant(expr2);
        return AsmUtil.isIntPrimitive(exprType) && exprValue != null && Integer.valueOf(0).equals(exprValue.getValue());
    }

    private StackValue genCmpWithZero(KtExpression exp, IElementType opToken, @Nullable StackValue pregeneratedExpr) {
        StackValue argument2;
        if (pregeneratedExpr == null) {
            KotlinType kotlinType = this.kotlinType(exp);
            assert (kotlinType != null) : "No KotlinType for expression " + exp.getText();
            argument2 = this.genLazy(exp, this.asmType(kotlinType), kotlinType);
        } else {
            argument2 = pregeneratedExpr;
        }
        return StackValue.compareIntWithZero(argument2, KtTokens.EQEQ == opToken || KtTokens.EQEQEQ == opToken ? 154 : 153);
    }

    private StackValue genCmpWithNull(KtExpression exp, IElementType opToken, @Nullable StackValue pregeneratedExpr) {
        StackValue argument2;
        KotlinType kotlinType = this.kotlinType(exp);
        Type type2 = this.expressionType(exp);
        StackValue stackValue = argument2 = pregeneratedExpr != null ? pregeneratedExpr : this.gen(exp);
        if (kotlinType == null || TypeUtils.isNullableType(kotlinType) || !InlineClassesUtilsKt.isInlineClassType(kotlinType)) {
            return StackValue.compareWithNull(argument2, KtTokens.EQEQ == opToken || KtTokens.EQEQEQ == opToken ? 199 : 198);
        }
        return StackValue.operation(Type.BOOLEAN_TYPE, (Function1<InstructionAdapter, Unit>)((Function1)v -> {
            argument2.put(type2, kotlinType, (InstructionAdapter)v);
            AsmUtil.pop((MethodVisitor)v, type2);
            v.iconst(opToken == KtTokens.EXCLEQ || opToken == KtTokens.EXCLEQEQEQ ? 1 : 0);
            return Unit.INSTANCE;
        }));
    }

    private StackValue generateElvis(@NotNull KtBinaryExpression expression2) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(268);
        }
        KtExpression left = expression2.getLeft();
        Type exprType = this.expressionType(expression2);
        KotlinType exprKotlinType = this.kotlinType(expression2);
        Type leftType = this.expressionType(left);
        KotlinType leftKotlinType = this.kotlinType(left);
        Label ifNull = new Label();
        assert (left != null) : "left expression in elvis should be not null: " + expression2.getText();
        StackValue value2 = this.generateExpressionWithNullFallback(left, ifNull);
        if (AsmUtil.isPrimitive(leftType)) {
            return value2;
        }
        return StackValue.operation(exprType, exprKotlinType, (Function1<InstructionAdapter, Unit>)((Function1)v -> {
            value2.put(value2.type, value2.kotlinType, (InstructionAdapter)v);
            v.dup();
            v.ifnull(ifNull);
            StackValue.onStack(leftType, leftKotlinType).put(exprType, exprKotlinType, (InstructionAdapter)v);
            Label end = new Label();
            v.goTo(end);
            v.mark(ifNull);
            Integer leftLineNumber = CodegenUtil.getLineNumberForElement((PsiElement)left, false);
            Integer rightLineNumber = CodegenUtil.getLineNumberForElement((PsiElement)expression2.getRight(), false);
            if (rightLineNumber != null && rightLineNumber.equals(leftLineNumber)) {
                v.visitLineNumber(rightLineNumber.intValue(), ifNull);
            }
            v.pop();
            this.gen(expression2.getRight(), exprType, exprKotlinType);
            v.mark(end);
            return null;
        }));
    }

    private StackValue generateComparison(KtBinaryExpression expression2, StackValue receiver2) {
        StackValue rightValue;
        StackValue leftValue;
        Type type2;
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCallWithAssert(expression2, this.bindingContext);
        PrimitiveNumericComparisonInfo primitiveNumericComparisonInfo = this.bindingContext.get(BindingContext.PRIMITIVE_NUMERIC_COMPARISON_INFO, expression2);
        KtExpression left = expression2.getLeft();
        KtExpression right2 = expression2.getRight();
        Type leftType = this.expressionType(left);
        Type rightType2 = this.expressionType(right2);
        TypeAndNullability left754Type = this.calcTypeForIeee754ArithmeticIfNeeded(left, ExpressionCodegen.getLeftOperandType(primitiveNumericComparisonInfo));
        TypeAndNullability right754Type = this.calcTypeForIeee754ArithmeticIfNeeded(right2, ExpressionCodegen.getRightOperandType(primitiveNumericComparisonInfo));
        boolean isSame754ArithmeticTypes = left754Type != null && right754Type != null && left754Type.type.equals((Object)right754Type.type);
        boolean properIeee754Comparisons = this.shouldUseProperIeee754Comparisons();
        if (properIeee754Comparisons && left754Type != null && right754Type != null) {
            type2 = AsmUtil.comparisonOperandType(leftType, rightType2);
            leftValue = this.gen(left);
            rightValue = this.gen(right2);
        } else if (!properIeee754Comparisons && this.state.getIntrinsics().getIntrinsic((FunctionDescriptor)resolvedCall2.getResultingDescriptor()) instanceof CompareTo && (AsmUtil.isPrimitive(leftType) && AsmUtil.isPrimitive(rightType2) || isSame754ArithmeticTypes)) {
            type2 = isSame754ArithmeticTypes ? left754Type.type : AsmUtil.comparisonOperandType(leftType, rightType2);
            leftValue = this.gen(left);
            rightValue = this.gen(right2);
        } else {
            type2 = Type.INT_TYPE;
            leftValue = this.invokeFunction(resolvedCall2, receiver2);
            rightValue = StackValue.constant(0, type2);
        }
        return StackValue.cmp(expression2.getOperationToken(), type2, leftValue, rightValue);
    }

    @Nullable
    private TypeAndNullability calcTypeForIeee754ArithmeticIfNeeded(@Nullable KtExpression expression2, @Nullable KotlinType inferredPrimitiveType) {
        if (expression2 == null) {
            return null;
        }
        if (this.shouldUseProperIeee754Comparisons()) {
            return Ieee754Kt.calcProperTypeForIeee754ArithmeticIfNeeded(expression2, this.bindingContext, inferredPrimitiveType, this.typeMapper);
        }
        return Ieee754Kt.legacyCalcTypeForIeee754ArithmeticIfNeeded(expression2, this.bindingContext, this.context.getFunctionDescriptor(), this.state.getLanguageVersionSettings());
    }

    private boolean shouldUseProperIeee754Comparisons() {
        return this.state.getLanguageVersionSettings().supportsFeature(LanguageFeature.ProperIeee754Comparisons);
    }

    private StackValue generateAssignmentExpression(KtBinaryExpression expression2) {
        return StackValue.operation(Type.VOID_TYPE, (Function1<InstructionAdapter, Unit>)((Function1)adapter -> {
            StackValue stackValue = this.gen(expression2.getLeft());
            KtExpression right2 = expression2.getRight();
            assert (right2 != null) : expression2.getText();
            stackValue.store(this.gen(right2), this.v);
            return Unit.INSTANCE;
        }));
    }

    private StackValue generateAugmentedAssignment(KtBinaryExpression expression2) {
        return StackValue.operation(Type.VOID_TYPE, (Function1<InstructionAdapter, Unit>)((Function1)adapter -> {
            ResolvedCall<CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCallWithAssert(expression2, this.bindingContext);
            ResolvedCallWithRealDescriptor callWithRealDescriptor = CoroutineCodegenUtilKt.replaceSuspensionFunctionWithRealDescriptor(resolvedCall2, this.state);
            if (callWithRealDescriptor != null) {
                this.prepareCoroutineArgumentForSuspendCall(resolvedCall2, callWithRealDescriptor.getFakeContinuationExpression());
                resolvedCall2 = callWithRealDescriptor.getResolvedCall();
            }
            FunctionDescriptor descriptor2 = this.accessibleFunctionDescriptor(resolvedCall2);
            Callable callable2 = this.resolveToCallable(descriptor2, false, resolvedCall2);
            KtExpression lhs = expression2.getLeft();
            JvmKotlinType jvmKotlinType = new JvmKotlinType(this.expressionType(lhs), this.kotlinType(lhs));
            boolean keepReturnValue = Boolean.TRUE.equals(this.bindingContext.get(BindingContext.VARIABLE_REASSIGNMENT, expression2)) || !KotlinBuiltIns.isUnit(descriptor2.getReturnType());
            this.putCallAugAssignMethod(expression2, resolvedCall2, callable2, descriptor2.getReturnType(), jvmKotlinType, keepReturnValue);
            return Unit.INSTANCE;
        }));
    }

    private void putCallAugAssignMethod(@NotNull KtBinaryExpression expression2, @NotNull ResolvedCall<?> resolvedCall2, @NotNull Callable callable2, @Nullable KotlinType returnKotlinType, @NotNull JvmKotlinType jvmKotlinType, boolean keepReturnValue) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(269);
        }
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(270);
        }
        if (callable2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(271);
        }
        if (jvmKotlinType == null) {
            ExpressionCodegen.$$$reportNull$$$0(272);
        }
        StackValue value2 = this.gen(expression2.getLeft());
        if (keepReturnValue) {
            value2 = StackValue.complexWriteReadReceiver(value2);
        }
        value2.put(jvmKotlinType.getType(), jvmKotlinType.getKotlinType(), this.v);
        StackValue receiver2 = StackValue.onStack(jvmKotlinType.getType(), jvmKotlinType.getKotlinType());
        callable2.invokeMethodWithArguments(resolvedCall2, receiver2, this).put(callable2.getReturnType(), null, this.v);
        if (keepReturnValue) {
            value2.store(StackValue.onStack(callable2.getReturnType(), returnKotlinType), this.v, true);
        }
    }

    public void invokeAppend(InstructionAdapter v, KtExpression expr2) {
        ConstantValue<?> compileTimeConstant = this.getPrimitiveOrStringCompileTimeConstant(expr2 = KtPsiUtil.safeDeparenthesize(expr2));
        if (compileTimeConstant == null) {
            if (expr2 instanceof KtBinaryExpression) {
                KtBinaryExpression binaryExpression = (KtBinaryExpression)expr2;
                if (binaryExpression.getOperationToken() == KtTokens.PLUS) {
                    KtExpression left = binaryExpression.getLeft();
                    KtExpression right2 = binaryExpression.getRight();
                    Type leftType = this.expressionType(left);
                    if (leftType.equals((Object)AsmTypes.JAVA_STRING_TYPE)) {
                        this.invokeAppend(v, left);
                        this.invokeAppend(v, right2);
                        return;
                    }
                }
            } else if (expr2 instanceof KtStringTemplateExpression) {
                List<StringTemplateEntry> entries2 = this.preprocessStringTemplate((KtStringTemplateExpression)expr2);
                this.invokeAppendForEntries(v, entries2);
                return;
            }
        }
        Type exprType = this.expressionType(expr2);
        KotlinType exprKotlinType = this.kotlinType(expr2);
        if (compileTimeConstant != null) {
            StackValue.constant(compileTimeConstant.getValue(), exprType, exprKotlinType).put(exprType, exprKotlinType, v);
        } else {
            this.gen(expr2, exprType, exprKotlinType);
        }
        AsmUtil.genInvokeAppendMethod(v, exprType, exprKotlinType, this.typeMapper);
    }

    @Nullable
    private static KtSimpleNameExpression targetLabel(KtExpression expression2) {
        if (expression2.getParent() instanceof KtLabeledExpression) {
            return ((KtLabeledExpression)expression2.getParent()).getTargetLabel();
        }
        return null;
    }

    @Override
    public StackValue visitLabeledExpression(@NotNull KtLabeledExpression expression2, StackValue receiver2) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(273);
        }
        return this.genQualified(receiver2, expression2.getBaseExpression());
    }

    @Override
    public StackValue visitPrefixExpression(@NotNull KtPrefixExpression expression2, @NotNull StackValue receiver2) {
        String operationName;
        ConstantValue<?> compileTimeConstant;
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(274);
        }
        if (receiver2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(275);
        }
        if ((compileTimeConstant = this.getPrimitiveOrStringCompileTimeConstant(expression2)) != null) {
            return StackValue.constant(compileTimeConstant.getValue(), this.expressionType(expression2));
        }
        DeclarationDescriptor originalOperation = this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression2.getOperationReference());
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCallWithAssert(expression2, this.bindingContext);
        CallableDescriptor op = resolvedCall2.getResultingDescriptor();
        assert (op instanceof FunctionDescriptor || originalOperation == null) : String.valueOf(op);
        String string = operationName = originalOperation == null ? "" : originalOperation.getName().asString();
        if (!operationName.equals("inc") && !operationName.equals("dec")) {
            return this.invokeFunction(resolvedCall2, receiver2);
        }
        int increment = operationName.equals("inc") ? 1 : -1;
        Type type2 = this.expressionType(expression2.getBaseExpression());
        StackValue value2 = this.gen(expression2.getBaseExpression());
        return StackValue.preIncrement(type2, value2, increment, resolvedCall2, this);
    }

    @Override
    public StackValue visitPostfixExpression(@NotNull KtPostfixExpression expression2, StackValue receiver2) {
        int index2;
        KtExpression operand2;
        int increment;
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(276);
        }
        if (expression2.getOperationReference().getReferencedNameElementType() == KtTokens.EXCLEXCL) {
            StackValue base = this.genQualified(receiver2, expression2.getBaseExpression());
            if (AsmUtil.isPrimitive(base.type)) {
                return base;
            }
            return StackValue.operation(base.type, base.kotlinType, (Function1<InstructionAdapter, Unit>)((Function1)v -> {
                base.put(base.type, base.kotlinType, (InstructionAdapter)v);
                v.dup();
                if (this.state.getLanguageVersionSettings().getApiVersion().compareTo(ApiVersion.KOTLIN_1_4) >= 0) {
                    v.invokestatic("kotlin/jvm/internal/Intrinsics", "checkNotNull", "(Ljava/lang/Object;)V", false);
                } else {
                    Label ok = new Label();
                    v.ifnonnull(ok);
                    v.invokestatic("kotlin/jvm/internal/Intrinsics", "throwNpe", "()V", false);
                    v.mark(ok);
                }
                return null;
            }));
        }
        DeclarationDescriptor originalOperation = this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression2.getOperationReference());
        String originalOperationName = originalOperation != null ? originalOperation.getName().asString() : null;
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCallWithAssert(expression2, this.bindingContext);
        CallableDescriptor op = resolvedCall2.getResultingDescriptor();
        if (!(op instanceof FunctionDescriptor) || originalOperation == null) {
            throw new UnsupportedOperationException("Don't know how to generate this postfix expression: " + originalOperationName + " " + op);
        }
        Type asmResultType = this.expressionType(expression2);
        Type asmBaseType = this.expressionType(expression2.getBaseExpression());
        KotlinType kotlinBaseType = this.kotlinType(expression2.getBaseExpression());
        DeclarationDescriptor cls = op.getContainingDeclaration();
        if (originalOperationName.equals("inc")) {
            increment = 1;
        } else if (originalOperationName.equals("dec")) {
            increment = -1;
        } else {
            throw new UnsupportedOperationException("Unsupported postfix operation: " + originalOperationName + " " + op);
        }
        boolean isPrimitiveNumberClassDescriptor = AsmUtil.isPrimitiveNumberClassDescriptor(cls);
        if (isPrimitiveNumberClassDescriptor && AsmUtil.isPrimitive(asmBaseType) && (operand2 = expression2.getBaseExpression()) instanceof KtReferenceExpression && asmResultType == Type.INT_TYPE && this.bindingContext.get(BindingContext.SMARTCAST, operand2) == null && (index2 = this.indexOfLocalNotDelegated((KtReferenceExpression)operand2)) >= 0) {
            return StackValue.postIncrement(index2, increment);
        }
        return StackValue.operation(asmBaseType, kotlinBaseType, (Function1<InstructionAdapter, Unit>)((Function1)v -> {
            KotlinType storeKotlinType;
            Type storeType;
            StackValue value2 = StackValue.complexWriteReadReceiver(this.gen(expression2.getBaseExpression()));
            value2.put(asmBaseType, kotlinBaseType, (InstructionAdapter)v);
            AsmUtil.dup(v, asmBaseType);
            StackValue.Local previousValue = StackValue.local(this.myFrameMap.enterTemp(asmBaseType), asmBaseType, kotlinBaseType);
            previousValue.store(StackValue.onStack(asmBaseType, kotlinBaseType), (InstructionAdapter)v);
            if (isPrimitiveNumberClassDescriptor && AsmUtil.isPrimitive(asmBaseType)) {
                AsmUtil.genIncrement(asmBaseType, increment, v);
                storeType = asmBaseType;
                storeKotlinType = kotlinBaseType;
            } else {
                StackValue result2 = this.invokeFunction(resolvedCall2, StackValue.onStack(asmBaseType, kotlinBaseType));
                result2.put(result2.type, result2.kotlinType, (InstructionAdapter)v);
                storeType = result2.type;
                storeKotlinType = result2.kotlinType;
            }
            value2.store(StackValue.onStack(storeType, storeKotlinType), (InstructionAdapter)v, true);
            previousValue.put(asmBaseType, kotlinBaseType, (InstructionAdapter)v);
            this.myFrameMap.leaveTemp(asmBaseType);
            return Unit.INSTANCE;
        }));
    }

    @Override
    public StackValue visitProperty(@NotNull KtProperty property2, StackValue receiver2) {
        if (property2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(277);
        }
        KtExpression initializer2 = property2.getInitializer();
        KtExpression delegateExpression2 = property2.getDelegateExpression();
        if (initializer2 != null) {
            assert (delegateExpression2 == null) : PsiUtilsKt.getElementTextWithContext(property2);
            this.initializeLocalVariable(property2, this.gen(initializer2));
        } else if (delegateExpression2 != null) {
            this.initializeLocalVariable(property2, this.gen(delegateExpression2));
        } else if (property2.hasModifier(KtTokens.LATEINIT_KEYWORD)) {
            this.initializeLocalVariable(property2, null);
        } else {
            this.initializeLocalVariableWithFakeDefaultValue(property2);
        }
        return StackValue.none();
    }

    @Override
    public StackValue visitDestructuringDeclaration(@NotNull KtDestructuringDeclaration multiDeclaration, StackValue receiver2) {
        if (multiDeclaration == null) {
            ExpressionCodegen.$$$reportNull$$$0(278);
        }
        return this.initializeDestructuringDeclaration(multiDeclaration, false);
    }

    public StackValue initializeDestructuringDeclaration(@NotNull KtDestructuringDeclaration multiDeclaration, boolean asProperty) {
        KtExpression initializer2;
        if (multiDeclaration == null) {
            ExpressionCodegen.$$$reportNull$$$0(279);
        }
        if ((initializer2 = multiDeclaration.getInitializer()) == null) {
            return StackValue.none();
        }
        KotlinType initializerType = this.bindingContext.getType(initializer2);
        assert (initializerType != null);
        Type initializerAsmType = this.asmType(initializerType);
        TransientReceiver initializerAsReceiver = new TransientReceiver(initializerType);
        int tempVarIndex = this.myFrameMap.enterTemp(initializerAsmType);
        this.gen(initializer2, initializerAsmType, initializerType);
        this.v.store(tempVarIndex, initializerAsmType);
        StackValue.Local local = StackValue.local(tempVarIndex, initializerAsmType, initializerType);
        this.initializeDestructuringDeclarationVariables(multiDeclaration, initializerAsReceiver, local, asProperty);
        this.myFrameMap.leaveTemp(initializerAsmType);
        return StackValue.none();
    }

    public void initializeDestructuringDeclarationVariables(@NotNull KtDestructuringDeclaration destructuringDeclaration, @NotNull ReceiverValue receiver2, @NotNull StackValue receiverStackValue) {
        if (destructuringDeclaration == null) {
            ExpressionCodegen.$$$reportNull$$$0(280);
        }
        if (receiver2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(281);
        }
        if (receiverStackValue == null) {
            ExpressionCodegen.$$$reportNull$$$0(282);
        }
        this.initializeDestructuringDeclarationVariables(destructuringDeclaration, receiver2, receiverStackValue, false);
    }

    private void initializeDestructuringDeclarationVariables(@NotNull KtDestructuringDeclaration destructuringDeclaration, @NotNull ReceiverValue receiver2, @NotNull StackValue receiverStackValue, boolean asProperty) {
        if (destructuringDeclaration == null) {
            ExpressionCodegen.$$$reportNull$$$0(283);
        }
        if (receiver2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(284);
        }
        if (receiverStackValue == null) {
            ExpressionCodegen.$$$reportNull$$$0(285);
        }
        for (KtDestructuringDeclarationEntry variableDeclaration : destructuringDeclaration.getEntries()) {
            ResolvedCall<FunctionDescriptor> resolvedCall2 = this.bindingContext.get(BindingContext.COMPONENT_RESOLVED_CALL, variableDeclaration);
            assert (resolvedCall2 != null) : "Resolved call is null for " + variableDeclaration.getText();
            Call call2 = this.makeFakeCall(receiver2);
            VariableDescriptor variableDescriptor = this.getVariableDescriptorNotNull(variableDeclaration);
            if (UnderscoreUtilKt.isSingleUnderscore(variableDeclaration)) continue;
            if (asProperty && variableDescriptor instanceof PropertyDescriptor) {
                StackValue.Property propertyValue = this.intermediateValueForProperty((PropertyDescriptor)variableDescriptor, true, false, null, true, StackValue.LOCAL_0, null, false);
                propertyValue.store(this.invokeFunction(call2, resolvedCall2, receiverStackValue), this.v);
                continue;
            }
            this.initializeLocalVariable(variableDeclaration, this.invokeFunction(call2, resolvedCall2, receiverStackValue));
        }
    }

    @NotNull
    private StackValue getVariableMetadataValue(@NotNull VariableDescriptorWithAccessors variableDescriptor) {
        if (variableDescriptor == null) {
            ExpressionCodegen.$$$reportNull$$$0(286);
        }
        StackValue value2 = this.findLocalOrCapturedValue(CodegenBinding.getDelegatedLocalVariableMetadata(variableDescriptor, this.bindingContext));
        assert (value2 != null) : "Can't find stack value for local delegated variable metadata: " + variableDescriptor;
        StackValue stackValue = value2;
        if (stackValue == null) {
            ExpressionCodegen.$$$reportNull$$$0(287);
        }
        return stackValue;
    }

    @NotNull
    private StackValue adjustVariableValue(@NotNull StackValue varValue, DeclarationDescriptor descriptor2) {
        if (varValue == null) {
            ExpressionCodegen.$$$reportNull$$$0(288);
        }
        if (!JvmCodegenUtil.isDelegatedLocalVariable(descriptor2)) {
            StackValue stackValue = varValue;
            if (stackValue == null) {
                ExpressionCodegen.$$$reportNull$$$0(289);
            }
            return stackValue;
        }
        VariableDescriptorWithAccessors variableDescriptor = (VariableDescriptorWithAccessors)descriptor2;
        StackValue metadataValue = this.getVariableMetadataValue(variableDescriptor);
        return this.delegatedVariableValue(varValue, metadataValue, variableDescriptor, this.typeMapper);
    }

    private void initializeLocalVariable(@NotNull KtVariableDeclaration variableDeclaration, @Nullable StackValue initializer2) {
        if (variableDeclaration == null) {
            ExpressionCodegen.$$$reportNull$$$0(290);
        }
        LocalVariableDescriptor variableDescriptor = (LocalVariableDescriptor)this.getVariableDescriptorNotNull(variableDeclaration);
        if (KtPsiUtil.isScriptDeclaration(variableDeclaration)) {
            return;
        }
        int index2 = this.lookupLocalIndex(variableDescriptor);
        if (index2 < 0) {
            throw new IllegalStateException("Local variable not found for " + variableDescriptor);
        }
        Type sharedVarType = this.typeMapper.getSharedVarType(variableDescriptor);
        Type varType = this.getVariableTypeNoSharing(variableDescriptor);
        KotlinType delegateKotlinType = JvmCodegenUtil.getPropertyDelegateType(variableDescriptor, this.bindingContext);
        StackValue storeTo = sharedVarType == null ? StackValue.local(index2, varType, variableDescriptor, delegateKotlinType) : StackValue.shared(index2, varType, variableDescriptor, delegateKotlinType);
        storeTo.putReceiver(this.v, false);
        if (variableDescriptor.isLateInit()) {
            assert (initializer2 == null) : "Initializer should be null for lateinit var " + variableDescriptor + ": " + initializer2;
            this.v.aconst(null);
            storeTo.storeSelector(storeTo.type, storeTo.kotlinType, this.v);
            return;
        }
        assert (initializer2 != null) : "Initializer should be not null for " + variableDescriptor;
        initializer2.put(initializer2.type, initializer2.kotlinType, this.v);
        this.markLineNumber(variableDeclaration, false);
        Type resultType = initializer2.type;
        KotlinType resultKotlinType = initializer2.kotlinType;
        if (JvmCodegenUtil.isDelegatedLocalVariable(variableDescriptor)) {
            StackValue metadataValue = this.getVariableMetadataValue(variableDescriptor);
            this.initializePropertyMetadata((KtProperty)variableDeclaration, variableDescriptor, metadataValue);
            ResolvedCall<FunctionDescriptor> provideDelegateCall = this.bindingContext.get(BindingContext.PROVIDE_DELEGATE_RESOLVED_CALL, variableDescriptor);
            if (provideDelegateCall != null) {
                StackValue provideDelegateValue = this.generateProvideDelegateCallForLocalVariable(initializer2, metadataValue, provideDelegateCall);
                resultType = provideDelegateValue.type;
                resultKotlinType = provideDelegateValue.kotlinType;
            }
        }
        storeTo.storeSelector(resultType, resultKotlinType, this.v);
    }

    private void initializeLocalVariableWithFakeDefaultValue(@NotNull KtProperty variableDeclaration) {
        LocalVariableDescriptor variableDescriptor;
        if (variableDeclaration == null) {
            ExpressionCodegen.$$$reportNull$$$0(291);
        }
        if (BindingContextUtils.isBoxedLocalCapturedInClosure(this.bindingContext, variableDescriptor = (LocalVariableDescriptor)this.getVariableDescriptorNotNull(variableDeclaration))) {
            return;
        }
        assert (!variableDeclaration.hasDelegateExpressionOrInitializer() && !variableDescriptor.isLateInit()) : variableDeclaration.getText() + " in not variable declaration without initializer";
        KotlinType kotlinType = variableDescriptor.getType();
        Type type2 = this.typeMapper.mapType(kotlinType);
        if (type2 == Type.VOID_TYPE) {
            return;
        }
        int index2 = this.lookupLocalIndex(variableDescriptor);
        assert (index2 >= 0) : variableDescriptor + " is not in frame map";
        switch (type2.getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.v.iconst(0);
                break;
            }
            case 6: {
                this.v.fconst(0.0f);
                break;
            }
            case 7: {
                this.v.lconst(0L);
                break;
            }
            case 8: {
                this.v.dconst(0.0);
                break;
            }
            default: {
                this.v.aconst(null);
            }
        }
        this.v.store(index2, type2);
    }

    @NotNull
    private StackValue generateProvideDelegateCallForLocalVariable(@NotNull StackValue initializer2, final StackValue metadataValue, ResolvedCall<FunctionDescriptor> provideDelegateResolvedCall) {
        if (initializer2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(292);
        }
        StackValue provideDelegateReceiver = StackValue.onStack(initializer2.type, initializer2.kotlinType);
        List<? extends ValueArgument> arguments2 = provideDelegateResolvedCall.getCall().getValueArguments();
        assert (arguments2.size() == 2) : "Resolved call for '" + OperatorNameConventions.PROVIDE_DELEGATE.asString() + "' should have exactly 2 value parameters";
        this.tempVariables.put(arguments2.get(0).asElement(), StackValue.constant(null, AsmTypes.OBJECT_TYPE));
        this.tempVariables.put(arguments2.get(1).asElement(), new StackValue(AsmTypes.K_PROPERTY_TYPE){

            @Override
            public void putSelector(@NotNull Type type2, @Nullable KotlinType kotlinType, @NotNull InstructionAdapter v) {
                if (type2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (v == null) {
                    3.$$$reportNull$$$0(1);
                }
                metadataValue.put(type2, kotlinType, v);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "type";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "v";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/kotlin/codegen/ExpressionCodegen$3";
                objectArray[2] = "putSelector";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        StackValue result2 = this.invokeFunction(provideDelegateResolvedCall, provideDelegateReceiver);
        result2.put(result2.type, result2.kotlinType, this.v);
        this.tempVariables.remove(arguments2.get(0).asElement());
        this.tempVariables.remove(arguments2.get(1).asElement());
        StackValue stackValue = result2;
        if (stackValue == null) {
            ExpressionCodegen.$$$reportNull$$$0(293);
        }
        return stackValue;
    }

    @NotNull
    public VariableDescriptor getVariableDescriptorNotNull(@NotNull KtElement declaration2) {
        if (declaration2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(294);
        }
        VariableDescriptor descriptor2 = this.bindingContext.get(BindingContext.VARIABLE, declaration2);
        assert (descriptor2 != null) : "Couldn't find variable declaration in binding context " + declaration2.getText();
        VariableDescriptor variableDescriptor = descriptor2;
        if (variableDescriptor == null) {
            ExpressionCodegen.$$$reportNull$$$0(295);
        }
        return variableDescriptor;
    }

    private void initializePropertyMetadata(@NotNull KtProperty variable2, @NotNull LocalVariableDescriptor variableDescriptor, @NotNull StackValue metadataVar) {
        if (variable2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(296);
        }
        if (variableDescriptor == null) {
            ExpressionCodegen.$$$reportNull$$$0(297);
        }
        if (metadataVar == null) {
            ExpressionCodegen.$$$reportNull$$$0(298);
        }
        StackValue value2 = PropertyCodegen.isDelegatedPropertyWithOptimizedMetadata(variableDescriptor, this.bindingContext) ? PropertyCodegen.getOptimizedDelegatedPropertyMetadataValue() : (this.context.getFunctionDescriptor().isInline() ? this.generatePropertyReference(variable2.getDelegate(), variableDescriptor, variableDescriptor, null) : PropertyCodegen.getDelegatedPropertyMetadata(variableDescriptor, this.bindingContext));
        value2.put(AsmTypes.K_PROPERTY_TYPE, null, this.v);
        metadataVar.storeSelector(AsmTypes.K_PROPERTY_TYPE, null, this.v);
    }

    @NotNull
    private StackValue generateNewCall(@NotNull KtCallExpression expression2, @NotNull ResolvedCall<?> resolvedCall2) {
        Type type2;
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(299);
        }
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(300);
        }
        if ((type2 = this.expressionType(expression2)).getSort() == 9) {
            KotlinType kotlinType = this.kotlinType(expression2);
            assert (kotlinType != null) : "No kotlinType for expression of type " + type2 + ": " + expression2.getText();
            if (KotlinBuiltIns.isArrayOrPrimitiveArray(kotlinType)) {
                StackValue stackValue = this.generateNewArray(expression2, this.bindingContext.getType(expression2), resolvedCall2);
                if (stackValue == null) {
                    ExpressionCodegen.$$$reportNull$$$0(301);
                }
                return stackValue;
            }
        }
        StackValue stackValue = this.generateConstructorCall(resolvedCall2, type2);
        if (stackValue == null) {
            ExpressionCodegen.$$$reportNull$$$0(302);
        }
        return stackValue;
    }

    @NotNull
    public ClassConstructorDescriptor getConstructorDescriptor(@NotNull ResolvedCall<?> resolvedCall2) {
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(303);
        }
        FunctionDescriptor accessibleDescriptor = this.accessibleFunctionDescriptor(resolvedCall2);
        assert (accessibleDescriptor instanceof ClassConstructorDescriptor) : "getConstructorDescriptor must be called only for constructors: " + accessibleDescriptor;
        ClassConstructorDescriptor classConstructorDescriptor = (ClassConstructorDescriptor)accessibleDescriptor;
        if (classConstructorDescriptor == null) {
            ExpressionCodegen.$$$reportNull$$$0(304);
        }
        return classConstructorDescriptor;
    }

    @Nullable
    private static ReceiverValue getConstructorReceiver(@NotNull ResolvedCall<?> resolvedCall2) {
        Object constructor2;
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(305);
        }
        if ((constructor2 = resolvedCall2.getResultingDescriptor()).getExtensionReceiverParameter() != null) {
            assert (constructor2 instanceof TypeAliasConstructorDescriptor) : "Only type alias constructor can have an extension receiver: " + constructor2;
            return resolvedCall2.getExtensionReceiver();
        }
        if (constructor2.getDispatchReceiverParameter() != null) {
            return resolvedCall2.getDispatchReceiver();
        }
        return null;
    }

    @NotNull
    public StackValue generateConstructorCall(@NotNull ResolvedCall<?> resolvedCall2, @NotNull Type objectType) {
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(306);
        }
        if (objectType == null) {
            ExpressionCodegen.$$$reportNull$$$0(307);
        }
        StackValue stackValue = StackValue.functionCall(objectType, resolvedCall2.getResultingDescriptor().getReturnType(), (Function1<InstructionAdapter, Unit>)((Function1)v -> {
            ClassConstructorDescriptor constructor2 = this.getConstructorDescriptor(resolvedCall2);
            ReceiverParameterDescriptor dispatchReceiver = constructor2.getDispatchReceiverParameter();
            ClassDescriptor containingDeclaration2 = constructor2.getContainingDeclaration();
            if (!containingDeclaration2.isInline()) {
                v.anew(objectType);
                v.dup();
            }
            if (dispatchReceiver != null) {
                KotlinType kotlinType = dispatchReceiver.getType();
                Type receiverType2 = this.typeMapper.mapType(kotlinType);
                ReceiverValue receiver2 = ExpressionCodegen.getConstructorReceiver(resolvedCall2);
                boolean callSuper = containingDeclaration2.isInner() && receiver2 instanceof ImplicitClassReceiver;
                this.generateReceiverValue(receiver2, callSuper).put(receiverType2, kotlinType, (InstructionAdapter)v);
            }
            this.pushClosureOnStack(containingDeclaration2, dispatchReceiver == null, this.defaultCallGenerator, null);
            constructor2 = SamCodegenUtil.resolveSamAdapter(constructor2);
            OwnerKind inlineClassKindOrNull = InlineClassesUtilsKt.isInlineClass(constructor2.getContainingDeclaration()) ? OwnerKind.ERASED_INLINE_CLASS : null;
            CallableMethod method = this.typeMapper.mapToCallableMethod(constructor2, false, inlineClassKindOrNull);
            this.invokeMethodWithArguments(method, resolvedCall2, StackValue.none());
            return Unit.INSTANCE;
        }));
        if (stackValue == null) {
            ExpressionCodegen.$$$reportNull$$$0(308);
        }
        return stackValue;
    }

    public StackValue generateNewArray(@NotNull KtCallExpression expression2, @NotNull KotlinType arrayType, @NotNull ResolvedCall<?> resolvedCall2) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(309);
        }
        if (arrayType == null) {
            ExpressionCodegen.$$$reportNull$$$0(310);
        }
        if (resolvedCall2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(311);
        }
        List<KtValueArgument> args = expression2.getValueArguments();
        assert (args.size() == 1 || args.size() == 2) : "Unknown constructor called: " + args.size() + " arguments";
        if (args.size() == 1) {
            KtExpression sizeExpression = args.get(0).getArgumentExpression();
            return StackValue.operation(this.typeMapper.mapType(arrayType), (Function1<InstructionAdapter, Unit>)((Function1)v -> {
                this.gen(sizeExpression, Type.INT_TYPE);
                this.newArrayInstruction(arrayType);
                return Unit.INSTANCE;
            }));
        }
        return this.invokeFunction(resolvedCall2, StackValue.none());
    }

    public void newArrayInstruction(@NotNull KotlinType arrayType) {
        if (arrayType == null) {
            ExpressionCodegen.$$$reportNull$$$0(312);
        }
        if (KotlinBuiltIns.isArray(arrayType)) {
            KotlinType elementJetType = arrayType.getArguments().get(0).getType();
            this.putReifiedOperationMarkerIfTypeIsReifiedParameter(elementJetType, ReifiedTypeInliner.OperationKind.NEW_ARRAY);
            this.v.newarray(AsmUtil.boxType(this.typeMapper.mapTypeAsDeclaration(elementJetType)));
        } else {
            Type type2 = this.typeMapper.mapType(arrayType);
            this.v.newarray(AsmUtil.correctElementType(type2));
        }
    }

    @Override
    public StackValue visitArrayAccessExpression(@NotNull KtArrayAccessExpression expression2, StackValue receiver2) {
        ResolvedCall<FunctionDescriptor> resolvedCall2;
        boolean isInlineClassType;
        KtExpression array2;
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(313);
        }
        KotlinType arrayKotlinType = (array2 = expression2.getArrayExpression()) != null ? this.bindingContext.getType(array2) : null;
        Type arrayType = this.expressionType(array2);
        List<KtExpression> indices2 = expression2.getIndexExpressions();
        FunctionDescriptor operationDescriptor = (FunctionDescriptor)this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression2);
        assert (operationDescriptor != null);
        boolean bl = isInlineClassType = arrayKotlinType != null && InlineClassesUtilsKt.isInlineClassType(arrayKotlinType);
        if (arrayType.getSort() == 9 && indices2.size() == 1 && KotlinBuiltIns.isInt(operationDescriptor.getValueParameters().get(0).getType()) && !isInlineClassType) {
            assert (arrayKotlinType != null);
            KotlinType elementKotlinType = this.state.getModule().getBuiltIns().getArrayElementType(arrayKotlinType);
            Type elementType = KotlinBuiltIns.isArray(arrayKotlinType) ? AsmUtil.boxType(this.asmType(elementKotlinType), elementKotlinType, this.typeMapper) : AsmUtil.correctElementType(arrayType);
            StackValue arrayValue = this.genLazy(array2, arrayType);
            StackValue index2 = this.genLazy(indices2.get(0), Type.INT_TYPE);
            return StackValue.arrayElement(elementType, elementKotlinType, arrayValue, index2);
        }
        ResolvedCall<FunctionDescriptor> resolvedSetCall = this.bindingContext.get(BindingContext.INDEXED_LVALUE_SET, expression2);
        ResolvedCall<FunctionDescriptor> resolvedGetCall = this.bindingContext.get(BindingContext.INDEXED_LVALUE_GET, expression2);
        boolean isGetter = OperatorNameConventions.GET.equals(operationDescriptor.getName());
        ResolvedCall<FunctionDescriptor> resolvedCall3 = resolvedCall2 = isGetter ? resolvedGetCall : resolvedSetCall;
        assert (resolvedCall2 != null) : "No resolved call for " + operationDescriptor;
        Callable callable2 = this.resolveToCallable(this.accessibleFunctionDescriptor(resolvedCall2), false, resolvedCall2);
        CallableMethod callableMethod = this.typeMapper.mapToCallableMethod(SamCodegenUtil.resolveSamAdapter(operationDescriptor), false);
        Object[] argumentTypes2 = callableMethod.getParameterTypes();
        StackValue.CollectionElementReceiver collectionElementReceiver = this.createCollectionElementReceiver(expression2, receiver2, operationDescriptor, isGetter, resolvedGetCall, resolvedSetCall, callable2);
        Type elementType = isGetter ? callableMethod.getReturnType() : (Type)ArrayUtil.getLastElement((Object[])argumentTypes2);
        KotlinType elementKotlinType = isGetter ? operationDescriptor.getOriginal().getReturnType() : ((ValueParameterDescriptor)CollectionsKt.last(operationDescriptor.getOriginal().getValueParameters())).getType();
        return StackValue.collectionElement(collectionElementReceiver, elementType, elementKotlinType, resolvedGetCall, resolvedSetCall, this);
    }

    @NotNull
    private StackValue.CollectionElementReceiver createCollectionElementReceiver(@NotNull KtArrayAccessExpression expression2, @NotNull StackValue receiver2, @NotNull FunctionDescriptor operationDescriptor, boolean isGetter, ResolvedCall<FunctionDescriptor> resolvedGetCall, ResolvedCall<FunctionDescriptor> resolvedSetCall, @NotNull Callable callable2) {
        ResolvedCall<FunctionDescriptor> resolvedCall2;
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(314);
        }
        if (receiver2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(315);
        }
        if (operationDescriptor == null) {
            ExpressionCodegen.$$$reportNull$$$0(316);
        }
        if (callable2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(317);
        }
        ResolvedCall<FunctionDescriptor> resolvedCall3 = resolvedCall2 = isGetter ? resolvedGetCall : resolvedSetCall;
        assert (resolvedCall2 != null) : "couldn't find resolved call: " + expression2.getText();
        List<ResolvedValueArgument> valueArguments2 = resolvedCall2.getValueArgumentsByIndex();
        assert (valueArguments2 != null) : "Failed to arrange value arguments by index: " + operationDescriptor;
        if (!isGetter) {
            assert (valueArguments2.size() >= 2) : "Setter call should have at least 2 arguments: " + operationDescriptor;
            valueArguments2.remove(valueArguments2.size() - 1);
        }
        return new StackValue.CollectionElementReceiver(callable2, receiver2, resolvedGetCall, resolvedSetCall, isGetter, this, valueArguments2);
    }

    @Override
    public StackValue visitThrowExpression(@NotNull KtThrowExpression expression2, StackValue receiver2) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(318);
        }
        return StackValue.operation(Type.VOID_TYPE, (Function1<InstructionAdapter, Unit>)((Function1)adapter -> {
            this.gen(expression2.getThrownExpression(), AsmTypes.JAVA_THROWABLE_TYPE);
            this.v.athrow();
            return Unit.INSTANCE;
        }));
    }

    @Override
    public StackValue visitThisExpression(@NotNull KtThisExpression expression2, StackValue receiver2) {
        DeclarationDescriptor descriptor2;
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(319);
        }
        if ((descriptor2 = this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression2.getInstanceReference())) instanceof ClassDescriptor) {
            return this.generateInstanceReceiver((ClassDescriptor)descriptor2, false, true);
        }
        if (descriptor2 instanceof CallableDescriptor) {
            return this.generateExtensionReceiver((CallableDescriptor)descriptor2);
        }
        throw new UnsupportedOperationException("Neither this nor receiver: " + descriptor2 + expression2.getParent().getContainingFile().getText());
    }

    @Override
    public StackValue visitTryExpression(@NotNull KtTryExpression expression2, StackValue receiver2) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(320);
        }
        return this.generateTryExpression(expression2, false);
    }

    public StackValue generateTryExpression(KtTryExpression expression2, boolean isStatement) {
        Type expectedAsmType = isStatement ? Type.VOID_TYPE : this.expressionType(expression2);
        KotlinType expectedKotlinType = isStatement ? null : this.kotlinType(expression2);
        return StackValue.operation(expectedAsmType, expectedKotlinType, (Function1<InstructionAdapter, Unit>)((Function1)v -> {
            TryBlockStackElement element3;
            KtFinallySection finallyBlock = expression2.getFinallyBlock();
            TryWithFinallyBlockStackElement tryWithFinallyBlockStackElement = null;
            if (finallyBlock != null) {
                tryWithFinallyBlockStackElement = new TryWithFinallyBlockStackElement(expression2);
                element3 = tryWithFinallyBlockStackElement;
                this.blockStackElements.push((Object)tryWithFinallyBlockStackElement);
            } else {
                element3 = new TryBlockStackElement();
                this.blockStackElements.push((Object)element3);
            }
            Label tryStart = new Label();
            v.mark(tryStart);
            v.nop();
            this.gen(expression2.getTryBlock(), expectedAsmType, expectedKotlinType);
            int savedValue = -1;
            if (!isStatement) {
                savedValue = this.myFrameMap.enterTemp(expectedAsmType);
                v.store(savedValue, expectedAsmType);
            }
            Label tryEnd = new Label();
            v.mark(tryEnd);
            List<Label> tryBlockRegions = ExpressionCodegen.getCurrentCatchIntervals(element3, tryStart, tryEnd);
            Label end = new Label();
            this.genFinallyBlockOrGoto(tryWithFinallyBlockStackElement, end, null, new ArrayList<TryBlockStackElement>());
            List<KtCatchClause> clauses = expression2.getCatchClauses();
            int size = clauses.size();
            for (int i2 = 0; i2 < size; ++i2) {
                KtCatchClause clause = clauses.get(i2);
                Label clauseStart = new Label();
                v.mark(clauseStart);
                KtExpression catchBody = clause.getCatchBody();
                if (catchBody != null) {
                    this.markLineNumber((PsiElement)catchBody, false);
                }
                VariableDescriptor descriptor2 = this.bindingContext.get(BindingContext.VALUE_PARAMETER, clause.getCatchParameter());
                assert (descriptor2 != null);
                Type descriptorType = this.asmType(descriptor2.getType());
                this.myFrameMap.enter(descriptor2, descriptorType);
                int index2 = this.lookupLocalIndex(descriptor2);
                v.store(index2, descriptorType);
                Label catchVariableStart = new Label();
                v.mark(catchVariableStart);
                this.gen(catchBody, expectedAsmType, expectedKotlinType);
                if (!isStatement) {
                    v.store(savedValue, expectedAsmType);
                }
                this.myFrameMap.leave(descriptor2);
                Label clauseEnd = new Label();
                v.mark(clauseEnd);
                v.visitLocalVariable(descriptor2.getName().asString(), descriptorType.getDescriptor(), null, catchVariableStart, clauseEnd, index2);
                this.genFinallyBlockOrGoto(tryWithFinallyBlockStackElement, (Label)(i2 != size - 1 || finallyBlock != null ? end : null), null, new ArrayList<TryBlockStackElement>());
                this.generateExceptionTable(clauseStart, tryBlockRegions, descriptorType.getInternalName());
            }
            if (finallyBlock != null) {
                Label defaultCatchStart = new Label();
                v.mark(defaultCatchStart);
                int savedException = this.myFrameMap.enterTemp(AsmTypes.JAVA_THROWABLE_TYPE);
                v.store(savedException, AsmTypes.JAVA_THROWABLE_TYPE);
                Label defaultCatchEnd = new Label();
                v.mark(defaultCatchEnd);
                List<Label> defaultCatchRegions = ExpressionCodegen.getCurrentCatchIntervals(tryWithFinallyBlockStackElement, tryStart, defaultCatchEnd);
                this.genFinallyBlockOrGoto(tryWithFinallyBlockStackElement, null, null, new ArrayList<TryBlockStackElement>());
                v.load(savedException, AsmTypes.JAVA_THROWABLE_TYPE);
                this.myFrameMap.leaveTemp(AsmTypes.JAVA_THROWABLE_TYPE);
                v.athrow();
                this.generateExceptionTable(defaultCatchStart, defaultCatchRegions, null);
            }
            this.markLineNumber((PsiElement)expression2, isStatement);
            v.mark(end);
            if (!isStatement) {
                v.load(savedValue, expectedAsmType);
                this.myFrameMap.leaveTemp(expectedAsmType);
            }
            this.blockStackElements.pop();
            return Unit.INSTANCE;
        }));
    }

    private void generateExceptionTable(@NotNull Label catchStart, @NotNull List<Label> catchedRegions, @Nullable String exception) {
        if (catchStart == null) {
            ExpressionCodegen.$$$reportNull$$$0(321);
        }
        if (catchedRegions == null) {
            ExpressionCodegen.$$$reportNull$$$0(322);
        }
        for (int i2 = 0; i2 < catchedRegions.size(); i2 += 2) {
            Label startRegion = catchedRegions.get(i2);
            Label endRegion = catchedRegions.get(i2 + 1);
            if (startRegion.info == null || endRegion.info == null || catchStart.info == null) {
                throw new IllegalStateException("All labels should have nodes added to instruction list");
            }
            this.v.visitTryCatchBlock(startRegion, endRegion, catchStart, exception);
        }
    }

    @NotNull
    private static List<Label> getCurrentCatchIntervals(@Nullable TryBlockStackElement finallyBlockStackElement, @NotNull Label blockStart, @NotNull Label blockEnd) {
        ArrayList<Label> gapsInBlock;
        if (blockStart == null) {
            ExpressionCodegen.$$$reportNull$$$0(323);
        }
        if (blockEnd == null) {
            ExpressionCodegen.$$$reportNull$$$0(324);
        }
        ArrayList<Label> arrayList = gapsInBlock = finallyBlockStackElement != null ? new ArrayList<Label>(finallyBlockStackElement.gaps) : Collections.emptyList();
        assert (gapsInBlock.size() % 2 == 0);
        ArrayList<Label> blockRegions = new ArrayList<Label>(gapsInBlock.size() + 2);
        blockRegions.add(blockStart);
        blockRegions.addAll(gapsInBlock);
        blockRegions.add(blockEnd);
        ArrayList<Label> arrayList2 = blockRegions;
        if (arrayList2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(325);
        }
        return arrayList2;
    }

    @Override
    public StackValue visitBinaryWithTypeRHSExpression(@NotNull KtBinaryExpressionWithTypeRHS expression2, StackValue receiver2) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(326);
        }
        KtExpression left = expression2.getLeft();
        IElementType opToken = expression2.getOperationReference().getReferencedNameElementType();
        KotlinType rightKotlinType = this.bindingContext.get(BindingContext.TYPE, expression2.getRight());
        assert (rightKotlinType != null);
        StackValue value2 = this.genQualified(receiver2, left);
        KotlinType leftKotlinType = value2.kotlinType;
        Type boxedLeftType = leftKotlinType != null && InlineClassesUtilsKt.isInlineClassType(leftKotlinType) ? this.typeMapper.mapTypeAsDeclaration(leftKotlinType) : AsmUtil.boxType(value2.type);
        Type boxedRightType = AsmUtil.boxType(this.typeMapper.mapTypeAsDeclaration(rightKotlinType));
        return StackValue.operation(boxedRightType, rightKotlinType, (Function1<InstructionAdapter, Unit>)((Function1)v -> {
            boolean safeAs;
            value2.put(boxedLeftType, value2.kotlinType, (InstructionAdapter)v);
            if (value2.type == Type.VOID_TYPE) {
                StackValue.putUnitInstance(v);
            }
            boolean bl = safeAs = opToken == KtTokens.AS_SAFE;
            if (TypeUtils.isReifiedTypeParameter(rightKotlinType)) {
                this.putReifiedOperationMarkerIfTypeIsReifiedParameter(rightKotlinType, safeAs ? ReifiedTypeInliner.OperationKind.SAFE_AS : ReifiedTypeInliner.OperationKind.AS);
                v.checkcast(boxedRightType);
                return Unit.INSTANCE;
            }
            CodegenUtilKt.generateAsCast(v, rightKotlinType, boxedRightType, safeAs, this.state.getLanguageVersionSettings());
            return Unit.INSTANCE;
        }));
    }

    @Override
    public StackValue visitIsExpression(@NotNull KtIsExpression expression2, StackValue receiver2) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(327);
        }
        StackValue match2 = StackValue.expression(AsmTypes.OBJECT_TYPE, expression2.getLeftHandSide(), this);
        return this.generateIsCheck(match2, expression2.getTypeReference(), expression2.isNegated());
    }

    private StackValue generateExpressionMatch(StackValue expressionToMatch, KtExpression subjectExpression, KotlinType subjectKotlinType, KtExpression patternExpression) {
        if (expressionToMatch != null) {
            return this.generateEquals(subjectExpression, patternExpression, KtTokens.EQEQ, expressionToMatch, subjectKotlinType, this.bindingContext.get(BindingContext.PRIMITIVE_NUMERIC_COMPARISON_INFO, patternExpression));
        }
        return this.gen(patternExpression);
    }

    private StackValue generateIsCheck(StackValue expressionToMatch, KtTypeReference typeReference2, boolean negated) {
        KotlinType kotlinType = this.bindingContext.get(BindingContext.TYPE, typeReference2);
        this.markStartLineNumber(typeReference2);
        StackValue value2 = this.generateIsCheck(expressionToMatch, kotlinType, false);
        return negated ? StackValue.not(value2) : value2;
    }

    private StackValue generateIsCheck(StackValue expressionToGen, KotlinType rhsKotlinType, boolean leaveExpressionOnStack) {
        KotlinType lhsKotlinType = expressionToGen.kotlinType;
        Type lhsBoxedType = lhsKotlinType != null && InlineClassesUtilsKt.isInlineClassType(lhsKotlinType) ? this.typeMapper.mapTypeAsDeclaration(lhsKotlinType) : AsmTypes.OBJECT_TYPE;
        return StackValue.operation(Type.BOOLEAN_TYPE, (Function1<InstructionAdapter, Unit>)((Function1)v -> {
            expressionToGen.put(lhsBoxedType, expressionToGen.kotlinType, (InstructionAdapter)v);
            if (leaveExpressionOnStack) {
                v.dup();
            }
            Type type2 = AsmUtil.boxType(this.typeMapper.mapTypeAsDeclaration(rhsKotlinType));
            if (TypeUtils.isReifiedTypeParameter(rhsKotlinType)) {
                this.putReifiedOperationMarkerIfTypeIsReifiedParameter(rhsKotlinType, ReifiedTypeInliner.OperationKind.IS);
                v.instanceOf(type2);
                return null;
            }
            CodegenUtilKt.generateIsCheck(v, rhsKotlinType, type2, this.state.getLanguageVersionSettings().supportsFeature(LanguageFeature.ReleaseCoroutines));
            return null;
        }));
    }

    @Override
    public void propagateChildReifiedTypeParametersUsages(@NotNull ReifiedTypeParametersUsages usages2) {
        if (usages2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(328);
        }
        this.parentCodegen.getReifiedTypeParametersUsages().propagateChildUsagesWithinContext(usages2, (Function0<? extends Set<String>>)((Function0)() -> ((CallableMemberDescriptor)this.context.getContextDescriptor()).getTypeParameters().stream().filter(TypeParameterDescriptor::isReified).map(it -> it.getName().asString()).collect(Collectors.toSet())));
    }

    @Override
    public StackValue visitWhenExpression(@NotNull KtWhenExpression expression2, StackValue receiver2) {
        if (expression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(329);
        }
        return this.generateWhenExpression(expression2, false);
    }

    public StackValue generateWhenExpression(KtWhenExpression expression2, boolean isStatement) {
        Type resultType = isStatement ? Type.VOID_TYPE : this.expressionType(expression2);
        KotlinType resultKotlinType = isStatement ? null : this.kotlinType(expression2);
        return StackValue.operation(resultType, resultKotlinType, (Function1<InstructionAdapter, Unit>)((Function1)v -> {
            int subjectLocal;
            Type subjectType;
            KotlinType subjectKotlinType;
            SwitchCodegen switchCodegen;
            KtProperty subjectVariable = expression2.getSubjectVariable();
            KtExpression subjectExpression = expression2.getSubjectExpression();
            if (subjectVariable == null && subjectExpression == null) {
                v.nop();
            }
            if ((switchCodegen = this.switchCodegenProvider.buildAppropriateSwitchCodegenIfPossible(expression2, isStatement, CodegenUtil.isExhaustive(this.bindingContext, expression2, isStatement))) != null) {
                switchCodegen.generate();
                return null;
            }
            VariableDescriptor subjectVariableDescriptor = null;
            if (subjectVariable != null) {
                subjectVariableDescriptor = this.bindingContext.get(BindingContext.VARIABLE, subjectVariable);
                assert (subjectVariableDescriptor != null) : "Unresolved subject variable: " + subjectVariable.getName();
                subjectKotlinType = subjectVariableDescriptor.getType();
                subjectType = this.asmType(subjectVariableDescriptor.getType());
                subjectLocal = this.myFrameMap.enter(subjectVariableDescriptor, subjectType);
                this.visitProperty(subjectVariable, null);
                this.tempVariables.put(subjectExpression, StackValue.local(subjectLocal, subjectType, subjectKotlinType));
            } else if (subjectExpression != null) {
                subjectKotlinType = this.kotlinType(subjectExpression);
                subjectType = this.expressionType(subjectExpression);
                subjectLocal = this.myFrameMap.enterTemp(subjectType);
                this.gen(subjectExpression, subjectType, subjectKotlinType);
                this.tempVariables.put(subjectExpression, StackValue.local(subjectLocal, subjectType, subjectKotlinType));
                v.store(subjectLocal, subjectType);
            } else {
                subjectLocal = -1;
                subjectType = Type.VOID_TYPE;
                subjectKotlinType = null;
            }
            Label begin = new Label();
            v.mark(begin);
            Label end = new Label();
            boolean hasElse = KtPsiUtil.checkWhenExpressionHasSingleElse(expression2);
            Label nextCondition = null;
            for (KtWhenEntry whenEntry : expression2.getEntries()) {
                if (nextCondition != null) {
                    v.mark(nextCondition);
                }
                nextCondition = new Label();
                FrameMapBase.Mark mark = this.myFrameMap.mark();
                Label thisEntry = new Label();
                if (!whenEntry.isElse()) {
                    KtWhenCondition[] conditions2 = whenEntry.getConditions();
                    for (int i2 = 0; i2 < conditions2.length; ++i2) {
                        StackValue conditionValue = this.generateWhenCondition(subjectExpression, subjectType, subjectKotlinType, subjectLocal, conditions2[i2]);
                        BranchedValue.Companion.condJump(conditionValue, nextCondition, true, (InstructionAdapter)v);
                        if (i2 >= conditions2.length - 1) continue;
                        v.goTo(thisEntry);
                        v.mark(nextCondition);
                        nextCondition = new Label();
                    }
                }
                v.visitLabel(thisEntry);
                this.gen(whenEntry.getExpression(), resultType, resultKotlinType);
                mark.dropTo();
                if (whenEntry.isElse()) continue;
                v.goTo(end);
            }
            if (!hasElse && nextCondition != null) {
                v.mark(nextCondition);
                this.putUnitInstanceOntoStackForNonExhaustiveWhen(expression2, isStatement);
            }
            this.markLineNumber((PsiElement)expression2, isStatement);
            v.mark(end);
            if (subjectVariableDescriptor != null) {
                this.myFrameMap.leave(subjectVariableDescriptor);
                v.visitLocalVariable(subjectVariableDescriptor.getName().asString(), subjectType.getDescriptor(), null, begin, end, subjectLocal);
            } else {
                this.myFrameMap.leaveTemp(subjectType);
            }
            this.tempVariables.remove(subjectExpression);
            return null;
        }));
    }

    public void putUnitInstanceOntoStackForNonExhaustiveWhen(@NotNull KtWhenExpression whenExpression2, boolean isStatement) {
        if (whenExpression2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(330);
        }
        if (CodegenUtil.isExhaustive(this.bindingContext, whenExpression2, isStatement)) {
            AsmUtil.genThrow(this.v, "kotlin/NoWhenBranchMatchedException", null);
        } else if (!isStatement) {
            StackValue.putUnitInstance(this.v);
        }
    }

    private StackValue generateWhenCondition(KtExpression subjectExpression, Type subjectType, KotlinType subjectKotlinType, int subjectLocal, KtWhenCondition condition2) {
        StackValue.Local match2;
        if (condition2 instanceof KtWhenConditionInRange) {
            KtWhenConditionInRange conditionInRange = (KtWhenConditionInRange)condition2;
            return this.generateIn(StackValue.local(subjectLocal, subjectType, subjectKotlinType), conditionInRange.getRangeExpression(), conditionInRange.getOperationReference());
        }
        StackValue.Local local = match2 = subjectLocal == -1 ? null : StackValue.local(subjectLocal, subjectType, subjectKotlinType);
        if (condition2 instanceof KtWhenConditionIsPattern) {
            KtWhenConditionIsPattern patternCondition = (KtWhenConditionIsPattern)condition2;
            return this.generateIsCheck((StackValue)match2, patternCondition.getTypeReference(), patternCondition.isNegated());
        }
        if (condition2 instanceof KtWhenConditionWithExpression) {
            KtExpression patternExpression = ((KtWhenConditionWithExpression)condition2).getExpression();
            return this.generateExpressionMatch(match2, subjectExpression, subjectKotlinType, patternExpression);
        }
        throw new UnsupportedOperationException("unsupported kind of when condition");
    }

    public Call makeFakeCall(ReceiverValue initializerAsReceiver) {
        KtSimpleNameExpression fake = KtPsiFactoryKt.KtPsiFactory(this.state.getProject(), false).createSimpleName("fake");
        return CallMaker.makeCall(fake, initializerAsReceiver);
    }

    public String toString() {
        return ((CallableMemberDescriptor)this.context.getContextDescriptor()).toString();
    }

    @NotNull
    public FrameMap getFrameMap() {
        FrameMap frameMap = this.myFrameMap;
        if (frameMap == null) {
            ExpressionCodegen.$$$reportNull$$$0(331);
        }
        return frameMap;
    }

    @NotNull
    public MethodContext getContext() {
        MethodContext methodContext2 = this.context;
        if (methodContext2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(332);
        }
        return methodContext2;
    }

    @Override
    @NotNull
    public NameGenerator getInlineNameGenerator() {
        NameGenerator nameGenerator2 = this.getParentCodegen().getInlineNameGenerator();
        Name name2 = ((CallableMemberDescriptor)this.context.getContextDescriptor()).getName();
        String inlinedName = name2.isSpecial() ? "$special" : name2.asString();
        NameGenerator nameGenerator3 = nameGenerator2.subGenerator(inlinedName + "$$inlined");
        if (nameGenerator3 == null) {
            ExpressionCodegen.$$$reportNull$$$0(333);
        }
        return nameGenerator3;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public Stack<BlockStackElement> getBlockStackElements() {
        return new Stack(this.blockStackElements);
    }

    public void addBlockStackElementsForNonLocalReturns(@NotNull Stack<BlockStackElement> elements2, int finallyDepth) {
        if (elements2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(334);
        }
        this.blockStackElements.addAll(elements2);
        this.finallyDepth = finallyDepth;
    }

    @NotNull
    private StackValue.Delegate delegatedVariableValue(@NotNull StackValue delegateValue, @NotNull StackValue metadataValue, @NotNull VariableDescriptorWithAccessors variableDescriptor, @NotNull KotlinTypeMapper typeMapper2) {
        if (delegateValue == null) {
            ExpressionCodegen.$$$reportNull$$$0(335);
        }
        if (metadataValue == null) {
            ExpressionCodegen.$$$reportNull$$$0(336);
        }
        if (variableDescriptor == null) {
            ExpressionCodegen.$$$reportNull$$$0(337);
        }
        if (typeMapper2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(338);
        }
        StackValue.Delegate delegate2 = StackValue.localDelegate(typeMapper2.mapType(variableDescriptor.getType()), delegateValue, metadataValue, variableDescriptor, this);
        if (delegate2 == null) {
            ExpressionCodegen.$$$reportNull$$$0(339);
        }
        return delegate2;
    }

    @Override
    @NotNull
    public InstructionAdapter getVisitor() {
        InstructionAdapter instructionAdapter = this.v;
        if (instructionAdapter == null) {
            ExpressionCodegen.$$$reportNull$$$0(340);
        }
        return instructionAdapter;
    }

    @Override
    @NotNull
    public TypeSystemCommonBackendContext getTypeSystem() {
        TypeSystemCommonBackendContext typeSystemCommonBackendContext = this.typeSystem;
        if (typeSystemCommonBackendContext == null) {
            ExpressionCodegen.$$$reportNull$$$0(341);
        }
        return typeSystemCommonBackendContext;
    }

    @Override
    public void consumeReifiedOperationMarker(@NotNull TypeParameterMarker typeParameter) {
        if (typeParameter == null) {
            ExpressionCodegen.$$$reportNull$$$0(342);
        }
        assert (typeParameter instanceof TypeParameterDescriptor) : "Type parameter should be a descriptor: " + typeParameter;
        TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)typeParameter;
        if (typeParameterDescriptor.getContainingDeclaration() != this.context.getContextDescriptor()) {
            this.parentCodegen.getReifiedTypeParametersUsages().addUsedReifiedParameter(typeParameterDescriptor.getName().asString());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 14: 
            case 15: 
            case 25: 
            case 27: 
            case 29: 
            case 30: 
            case 42: 
            case 49: 
            case 50: 
            case 62: 
            case 72: 
            case 77: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 88: 
            case 89: 
            case 128: 
            case 135: 
            case 141: 
            case 142: 
            case 145: 
            case 149: 
            case 150: 
            case 151: 
            case 159: 
            case 160: 
            case 173: 
            case 174: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 188: 
            case 190: 
            case 191: 
            case 193: 
            case 194: 
            case 196: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 205: 
            case 208: 
            case 209: 
            case 210: 
            case 217: 
            case 219: 
            case 242: 
            case 258: 
            case 259: 
            case 287: 
            case 289: 
            case 293: 
            case 295: 
            case 301: 
            case 302: 
            case 304: 
            case 308: 
            case 325: 
            case 331: 
            case 332: 
            case 333: 
            case 339: 
            case 340: 
            case 341: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 14: 
            case 15: 
            case 25: 
            case 27: 
            case 29: 
            case 30: 
            case 42: 
            case 49: 
            case 50: 
            case 62: 
            case 72: 
            case 77: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 88: 
            case 89: 
            case 128: 
            case 135: 
            case 141: 
            case 142: 
            case 145: 
            case 149: 
            case 150: 
            case 151: 
            case 159: 
            case 160: 
            case 173: 
            case 174: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 188: 
            case 190: 
            case 191: 
            case 193: 
            case 194: 
            case 196: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 205: 
            case 208: 
            case 209: 
            case 210: 
            case 217: 
            case 219: 
            case 242: 
            case 258: 
            case 259: 
            case 287: 
            case 289: 
            case 293: 
            case 295: 
            case 301: 
            case 302: 
            case 304: 
            case 308: 
            case 325: 
            case 331: 
            case 332: 
            case 333: 
            case 339: 
            case 340: 
            case 341: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mv";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameMap";
                break;
            }
            case 2: 
            case 108: 
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
            case 3: 
            case 23: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentCodegen";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 14: 
            case 15: 
            case 25: 
            case 27: 
            case 29: 
            case 30: 
            case 42: 
            case 49: 
            case 50: 
            case 62: 
            case 72: 
            case 77: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 88: 
            case 89: 
            case 128: 
            case 135: 
            case 141: 
            case 142: 
            case 145: 
            case 149: 
            case 150: 
            case 151: 
            case 159: 
            case 160: 
            case 173: 
            case 174: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 188: 
            case 190: 
            case 191: 
            case 193: 
            case 194: 
            case 196: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 205: 
            case 208: 
            case 209: 
            case 210: 
            case 217: 
            case 219: 
            case 242: 
            case 258: 
            case 259: 
            case 287: 
            case 289: 
            case 293: 
            case 295: 
            case 301: 
            case 302: 
            case 304: 
            case 308: 
            case 325: 
            case 331: 
            case 332: 
            case 333: 
            case 339: 
            case 340: 
            case 341: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/ExpressionCodegen";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 11: 
            case 69: 
            case 110: 
            case 120: 
            case 123: 
            case 124: 
            case 125: 
            case 172: 
            case 175: 
            case 178: 
            case 180: 
            case 189: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provided";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "required";
                break;
            }
            case 16: 
            case 26: 
            case 28: 
            case 229: 
            case 231: 
            case 233: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeAlias";
                break;
            }
            case 20: 
            case 68: 
            case 294: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 21: 
            case 22: 
            case 24: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 44: 
            case 45: 
            case 46: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 56: 
            case 58: 
            case 60: 
            case 61: 
            case 64: 
            case 67: 
            case 73: 
            case 80: 
            case 107: 
            case 111: 
            case 116: 
            case 118: 
            case 136: 
            case 137: 
            case 211: 
            case 212: 
            case 220: 
            case 221: 
            case 223: 
            case 225: 
            case 226: 
            case 268: 
            case 269: 
            case 273: 
            case 274: 
            case 276: 
            case 299: 
            case 309: 
            case 313: 
            case 314: 
            case 318: 
            case 319: 
            case 320: 
            case 326: 
            case 327: 
            case 329: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forExpression";
                break;
            }
            case 41: 
            case 43: 
            case 84: 
            case 140: 
            case 143: 
            case 147: 
            case 152: 
            case 155: 
            case 158: 
            case 162: 
            case 165: 
            case 170: 
            case 176: 
            case 177: 
            case 179: 
            case 213: 
            case 270: 
            case 300: 
            case 303: 
            case 305: 
            case 306: 
            case 311: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedCall";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterBreakContinueLabel";
                break;
            }
            case 48: 
            case 102: 
            case 103: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nestedTryBlocksWithoutFinally";
                break;
            }
            case 55: 
            case 57: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindingContext";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constant";
                break;
            }
            case 65: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closureCodegen";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classDescriptor";
                break;
            }
            case 75: 
            case 167: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callGenerator";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statements";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suspendFunction";
                break;
            }
            case 86: 
            case 87: 
            case 215: 
            case 286: 
            case 297: 
            case 337: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableDescriptor";
                break;
            }
            case 90: 
            case 91: 
            case 92: 
            case 95: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 93: 
            case 324: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockEnd";
                break;
            }
            case 94: 
            case 96: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leaveTasks";
                break;
            }
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localFunction";
                break;
            }
            case 99: 
            case 214: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 101: 
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterReturnLabel";
                break;
            }
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 112: 
            case 228: 
            case 230: 
            case 232: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 113: 
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bodyExpression";
                break;
            }
            case 117: 
            case 119: 
            case 121: 
            case 127: 
            case 132: 
            case 134: 
            case 144: 
            case 148: 
            case 163: 
            case 166: 
            case 171: 
            case 192: 
            case 227: 
            case 275: 
            case 281: 
            case 284: 
            case 315: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiver";
                break;
            }
            case 122: 
            case 146: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 126: 
            case 131: 
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyDescriptor";
                break;
            }
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessorKind";
                break;
            }
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingDeclaration";
                break;
            }
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = "probablyParenthesizedExpression";
                break;
            }
            case 139: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 153: {
                objectArray2 = objectArray3;
                objectArray3[0] = "continuationExpression";
                break;
            }
            case 154: 
            case 260: 
            case 264: {
                objectArray2 = objectArray3;
                objectArray3[0] = "v";
                break;
            }
            case 156: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enclosingSuspendFunctionJvmView";
                break;
            }
            case 157: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fd";
                break;
            }
            case 161: 
            case 164: 
            case 169: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callableMethod";
                break;
            }
            case 168: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentGenerator";
                break;
            }
            case 186: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiverDescriptor";
                break;
            }
            case 187: {
                objectArray2 = objectArray3;
                objectArray3[0] = "companionObjectDescriptor";
                break;
            }
            case 195: {
                objectArray2 = objectArray3;
                objectArray3[0] = "calleeContainingClass";
                break;
            }
            case 197: {
                objectArray2 = objectArray3;
                objectArray3[0] = "singletonClassDescriptor";
                break;
            }
            case 198: 
            case 204: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisOrOuterClass";
                break;
            }
            case 206: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueArgument";
                break;
            }
            case 207: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outType";
                break;
            }
            case 216: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 218: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lhs";
                break;
            }
            case 222: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifnull";
                break;
            }
            case 224: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifNull";
                break;
            }
            case 234: 
            case 237: 
            case 247: 
            case 251: 
            case 254: 
            case 261: 
            case 265: {
                objectArray2 = objectArray3;
                objectArray3[0] = "opToken";
                break;
            }
            case 235: 
            case 244: 
            case 248: 
            case 252: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 236: 
            case 246: 
            case 249: 
            case 253: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 238: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftKotlinType";
                break;
            }
            case 239: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightKotlinType";
                break;
            }
            case 240: 
            case 245: 
            case 255: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftType";
                break;
            }
            case 241: 
            case 250: 
            case 256: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightType";
                break;
            }
            case 243: {
                objectArray2 = objectArray3;
                objectArray3[0] = "safeExpression";
                break;
            }
            case 257: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ieee754Type";
                break;
            }
            case 262: 
            case 266: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left754Type";
                break;
            }
            case 263: 
            case 267: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right754Type";
                break;
            }
            case 271: 
            case 317: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callable";
                break;
            }
            case 272: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jvmKotlinType";
                break;
            }
            case 277: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 278: 
            case 279: {
                objectArray2 = objectArray3;
                objectArray3[0] = "multiDeclaration";
                break;
            }
            case 280: 
            case 283: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destructuringDeclaration";
                break;
            }
            case 282: 
            case 285: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiverStackValue";
                break;
            }
            case 288: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varValue";
                break;
            }
            case 290: 
            case 291: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableDeclaration";
                break;
            }
            case 292: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 296: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 298: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metadataVar";
                break;
            }
            case 307: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectType";
                break;
            }
            case 310: 
            case 312: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayType";
                break;
            }
            case 316: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operationDescriptor";
                break;
            }
            case 321: {
                objectArray2 = objectArray3;
                objectArray3[0] = "catchStart";
                break;
            }
            case 322: {
                objectArray2 = objectArray3;
                objectArray3[0] = "catchedRegions";
                break;
            }
            case 323: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockStart";
                break;
            }
            case 328: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 330: {
                objectArray2 = objectArray3;
                objectArray3[0] = "whenExpression";
                break;
            }
            case 334: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 335: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegateValue";
                break;
            }
            case 336: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metadataValue";
                break;
            }
            case 338: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMapper";
                break;
            }
            case 342: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/ExpressionCodegen";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getBindingContext";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentCodegen";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "castToRequiredTypeOfInterfaceIfNeeded";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperCallLabelTarget";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "asmType";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "mapTypeAsDeclaration";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "expressionType";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedReceiverType";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "generateBreakOrContinueExpression";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "preprocessStringTemplate";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "putClosureInstanceOnStack";
                break;
            }
            case 77: 
            case 78: 
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrapOriginalReceiverOwnerForSuspendLambda";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "lookupOuterValue";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableTypeNoSharing";
                break;
            }
            case 128: {
                objectArray = objectArray2;
                objectArray2[1] = "intermediateValueForProperty";
                break;
            }
            case 135: {
                objectArray = objectArray2;
                objectArray2[1] = "intermediateValueForSyntheticExtensionProperty";
                break;
            }
            case 141: 
            case 142: {
                objectArray = objectArray2;
                objectArray2[1] = "accessibleFunctionDescriptor";
                break;
            }
            case 145: 
            case 149: 
            case 150: 
            case 151: {
                objectArray = objectArray2;
                objectArray2[1] = "invokeFunction";
                break;
            }
            case 159: 
            case 160: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveToCallable";
                break;
            }
            case 173: 
            case 174: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateCallGenerator";
                break;
            }
            case 181: 
            case 182: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeArgumentsForResolvedCall";
                break;
            }
            case 183: 
            case 184: 
            case 185: {
                objectArray = objectArray2;
                objectArray2[1] = "generateReceiverValue";
                break;
            }
            case 188: {
                objectArray = objectArray2;
                objectArray2[1] = "generateAccessorCallForCompanionObject";
                break;
            }
            case 190: 
            case 191: {
                objectArray = objectArray2;
                objectArray2[1] = "generateExtensionReceiver";
                break;
            }
            case 193: 
            case 194: {
                objectArray = objectArray2;
                objectArray2[1] = "generateScriptReceiver";
                break;
            }
            case 196: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: {
                objectArray = objectArray2;
                objectArray2[1] = "generateThisOrOuter";
                break;
            }
            case 205: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotNullParentContextForMethod";
                break;
            }
            case 208: 
            case 209: 
            case 210: {
                objectArray = objectArray2;
                objectArray2[1] = "genVarargs";
                break;
            }
            case 217: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePropertyReference";
                break;
            }
            case 219: {
                objectArray = objectArray2;
                objectArray2[1] = "generateClassLiteralReference";
                break;
            }
            case 242: {
                objectArray = objectArray2;
                objectArray2[1] = "genEqualsForInlineClasses";
                break;
            }
            case 258: 
            case 259: {
                objectArray = objectArray2;
                objectArray2[1] = "boxIfNullable";
                break;
            }
            case 287: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableMetadataValue";
                break;
            }
            case 289: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustVariableValue";
                break;
            }
            case 293: {
                objectArray = objectArray2;
                objectArray2[1] = "generateProvideDelegateCallForLocalVariable";
                break;
            }
            case 295: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableDescriptorNotNull";
                break;
            }
            case 301: 
            case 302: {
                objectArray = objectArray2;
                objectArray2[1] = "generateNewCall";
                break;
            }
            case 304: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructorDescriptor";
                break;
            }
            case 308: {
                objectArray = objectArray2;
                objectArray2[1] = "generateConstructorCall";
                break;
            }
            case 325: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentCatchIntervals";
                break;
            }
            case 331: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrameMap";
                break;
            }
            case 332: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 333: {
                objectArray = objectArray2;
                objectArray2[1] = "getInlineNameGenerator";
                break;
            }
            case 339: {
                objectArray = objectArray2;
                objectArray2[1] = "delegatedVariableValue";
                break;
            }
            case 340: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisitor";
                break;
            }
            case 341: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSystem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 14: 
            case 15: 
            case 25: 
            case 27: 
            case 29: 
            case 30: 
            case 42: 
            case 49: 
            case 50: 
            case 62: 
            case 72: 
            case 77: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 88: 
            case 89: 
            case 128: 
            case 135: 
            case 141: 
            case 142: 
            case 145: 
            case 149: 
            case 150: 
            case 151: 
            case 159: 
            case 160: 
            case 173: 
            case 174: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 188: 
            case 190: 
            case 191: 
            case 193: 
            case 194: 
            case 196: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 205: 
            case 208: 
            case 209: 
            case 210: 
            case 217: 
            case 219: 
            case 242: 
            case 258: 
            case 259: 
            case 287: 
            case 289: 
            case 293: 
            case 295: 
            case 301: 
            case 302: 
            case 304: 
            case 308: 
            case 325: 
            case 331: 
            case 332: 
            case 333: 
            case 339: 
            case 340: 
            case 341: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "generateObjectLiteral";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addReifiedParametersFromSignature";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "castToRequiredTypeOfInterfaceIfNeeded";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "putStackValue";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "visitClass";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeAlias";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "visitObjectDeclaration";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "visitExpression";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "visitSuperExpression";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getSuperCallLabelTarget";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "asmType";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "mapTypeAsDeclaration";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "visitParenthesizedExpression";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "visitAnnotatedExpression";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "visitIfExpression";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "generateIfExpression";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "visitWhileExpression";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "generateWhile";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "visitDoWhileExpression";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "generateDoWhile";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "visitForExpression";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "generateFor";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedReceiverType";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getSingleArgumentExpression";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "visitBreakExpression";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "visitContinueExpression";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "generateBreakOrContinueExpression";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "visitConstantExpression";
                break;
            }
            case 52: 
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getCompileTimeConstant";
                break;
            }
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getPrimitiveOrStringCompileTimeConstant";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "visitStringTemplateExpression";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "preprocessStringTemplate";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "isConstantValueInlinableInStringTemplate";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "visitBlockExpression";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "visitNamedFunction";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "visitLambdaExpression";
                break;
            }
            case 68: 
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "genClosure";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "putClosureInstanceOnStack";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "visitObjectLiteralExpression";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "pushClosureOnStack";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "unwrapOriginalReceiverOwnerForSuspendLambda";
                break;
            }
            case 80: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "generateBlock";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "getCoroutineInstanceValueForSuspensionPoint";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "genCoroutineInstanceForSuspendLambda";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "getVariableType";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "getVariableTypeNoSharing";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "putDescriptorIntoFrameMap";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "putLocalVariableIntoFrameMap";
                break;
            }
            case 92: 
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "addLeaveTaskToRemoveDescriptorFromFrameMap";
                break;
            }
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "addLeaveTaskToRemoveLocalVariableFromFrameMap";
                break;
            }
            case 97: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "addLeaveTaskToRemoveNamedFunctionFromFrameMap";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "markStartLineNumber";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "markLineNumber";
                break;
            }
            case 101: 
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "doFinallyOnReturn";
                break;
            }
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "genFinallyBlockOrGoto";
                break;
            }
            case 104: 
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "addGapLabelsForNestedTryCatchWithoutFinally";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "visitReturnExpression";
                break;
            }
            case 108: 
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "generateFinallyBlocksIfNeeded";
                break;
            }
            case 110: 
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "getNonLocalReturnInfo";
                break;
            }
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "returnExpression";
                break;
            }
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "endsWithReturn";
                break;
            }
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "isLambdaVoidBody";
                break;
            }
            case 116: 
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "visitSimpleNameExpression";
                break;
            }
            case 118: 
            case 119: 
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "generateNonIntrinsicSimpleNameExpression";
                break;
            }
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "applyIntrinsic";
                break;
            }
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "getSuperCallTarget";
                break;
            }
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "findLocalOrCapturedValue";
                break;
            }
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "findCapturedValue";
                break;
            }
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "lookupCapturedValueInConstructorParameters";
                break;
            }
            case 126: 
            case 127: 
            case 131: 
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "intermediateValueForProperty";
                break;
            }
            case 129: 
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "getBackingFieldContext";
                break;
            }
            case 133: 
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "intermediateValueForSyntheticExtensionProperty";
                break;
            }
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "visitCallExpression";
                break;
            }
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "visitCollectionLiteralExpression";
                break;
            }
            case 138: 
            case 139: {
                objectArray = objectArray;
                objectArray[2] = "genSamInterfaceValue";
                break;
            }
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "accessibleFunctionDescriptor";
                break;
            }
            case 143: 
            case 144: 
            case 146: 
            case 147: 
            case 148: {
                objectArray = objectArray;
                objectArray[2] = "invokeFunction";
                break;
            }
            case 152: 
            case 153: {
                objectArray = objectArray;
                objectArray[2] = "prepareCoroutineArgumentForSuspendCall";
                break;
            }
            case 154: {
                objectArray = objectArray;
                objectArray[2] = "invokeCoroutineMigrationMethod";
                break;
            }
            case 155: {
                objectArray = objectArray;
                objectArray[2] = "getContinuationParameterFromEnclosingSuspendFunction";
                break;
            }
            case 156: {
                objectArray = objectArray;
                objectArray[2] = "getContinuationParameterFromEnclosingSuspendFunctionDescriptor";
                break;
            }
            case 157: 
            case 158: {
                objectArray = objectArray;
                objectArray[2] = "resolveToCallable";
                break;
            }
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: {
                objectArray = objectArray;
                objectArray[2] = "invokeMethodWithArguments";
                break;
            }
            case 169: 
            case 170: 
            case 171: {
                objectArray = objectArray;
                objectArray[2] = "putReceiverAndInlineMarkerIfNeeded";
                break;
            }
            case 172: 
            case 176: 
            case 177: 
            case 178: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateCallGenerator";
                break;
            }
            case 175: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateCallGeneratorForDefaultImplBody";
                break;
            }
            case 179: 
            case 180: {
                objectArray = objectArray;
                objectArray[2] = "getTypeArgumentsForResolvedCall";
                break;
            }
            case 186: {
                objectArray = objectArray;
                objectArray[2] = "generateInstanceReceiver";
                break;
            }
            case 187: {
                objectArray = objectArray;
                objectArray[2] = "generateAccessorCallForCompanionObject";
                break;
            }
            case 189: {
                objectArray = objectArray;
                objectArray[2] = "generateExtensionReceiver";
                break;
            }
            case 192: {
                objectArray = objectArray;
                objectArray[2] = "generateScriptReceiver";
                break;
            }
            case 195: 
            case 198: {
                objectArray = objectArray;
                objectArray[2] = "generateThisOrOuter";
                break;
            }
            case 197: {
                objectArray = objectArray;
                objectArray[2] = "isInsideSingleton";
                break;
            }
            case 204: {
                objectArray = objectArray;
                objectArray[2] = "generateThisOrOuterFromContext";
                break;
            }
            case 206: 
            case 207: {
                objectArray = objectArray;
                objectArray[2] = "genVarargs";
                break;
            }
            case 211: {
                objectArray = objectArray;
                objectArray[2] = "visitClassLiteralExpression";
                break;
            }
            case 212: {
                objectArray = objectArray;
                objectArray[2] = "visitCallableReferenceExpression";
                break;
            }
            case 213: {
                objectArray = objectArray;
                objectArray[2] = "generateCallableReferenceReceiver";
                break;
            }
            case 214: 
            case 215: 
            case 216: {
                objectArray = objectArray;
                objectArray[2] = "generatePropertyReference";
                break;
            }
            case 218: {
                objectArray = objectArray;
                objectArray[2] = "generateClassLiteralReference";
                break;
            }
            case 220: {
                objectArray = objectArray;
                objectArray[2] = "visitDotQualifiedExpression";
                break;
            }
            case 221: 
            case 222: {
                objectArray = objectArray;
                objectArray[2] = "generateExpressionWithNullFallback";
                break;
            }
            case 223: 
            case 224: {
                objectArray = objectArray;
                objectArray[2] = "generateSafeQualifiedExpression";
                break;
            }
            case 225: {
                objectArray = objectArray;
                objectArray[2] = "visitSafeQualifiedExpression";
                break;
            }
            case 226: 
            case 227: {
                objectArray = objectArray;
                objectArray[2] = "visitBinaryExpression";
                break;
            }
            case 228: 
            case 229: 
            case 230: 
            case 231: {
                objectArray = objectArray;
                objectArray[2] = "genLazyUnlessProvided";
                break;
            }
            case 232: 
            case 233: {
                objectArray = objectArray;
                objectArray[2] = "genUnlessProvided";
                break;
            }
            case 234: {
                objectArray = objectArray;
                objectArray[2] = "generateEquals";
                break;
            }
            case 235: 
            case 236: 
            case 237: 
            case 238: 
            case 239: 
            case 240: 
            case 241: {
                objectArray = objectArray;
                objectArray[2] = "genEqualsForInlineClasses";
                break;
            }
            case 243: {
                objectArray = objectArray;
                objectArray[2] = "isSelectorPureNonNullType";
                break;
            }
            case 244: 
            case 245: 
            case 246: 
            case 247: {
                objectArray = objectArray;
                objectArray[2] = "genCmpPrimitiveToSafeCall";
                break;
            }
            case 248: 
            case 249: 
            case 250: 
            case 251: {
                objectArray = objectArray;
                objectArray[2] = "genCmpSafeCallToPrimitive";
                break;
            }
            case 252: 
            case 253: 
            case 254: 
            case 255: 
            case 256: {
                objectArray = objectArray;
                objectArray[2] = "genEqualsForExpressionsPreferIeee754Arithmetic";
                break;
            }
            case 257: {
                objectArray = objectArray;
                objectArray[2] = "boxIfNullable";
                break;
            }
            case 260: 
            case 261: 
            case 262: 
            case 263: {
                objectArray = objectArray;
                objectArray[2] = "generate754EqualsForNullableTypesViaIntrinsic";
                break;
            }
            case 264: 
            case 265: 
            case 266: 
            case 267: {
                objectArray = objectArray;
                objectArray[2] = "generate754EqualsForNullableTypes";
                break;
            }
            case 268: {
                objectArray = objectArray;
                objectArray[2] = "generateElvis";
                break;
            }
            case 269: 
            case 270: 
            case 271: 
            case 272: {
                objectArray = objectArray;
                objectArray[2] = "putCallAugAssignMethod";
                break;
            }
            case 273: {
                objectArray = objectArray;
                objectArray[2] = "visitLabeledExpression";
                break;
            }
            case 274: 
            case 275: {
                objectArray = objectArray;
                objectArray[2] = "visitPrefixExpression";
                break;
            }
            case 276: {
                objectArray = objectArray;
                objectArray[2] = "visitPostfixExpression";
                break;
            }
            case 277: {
                objectArray = objectArray;
                objectArray[2] = "visitProperty";
                break;
            }
            case 278: {
                objectArray = objectArray;
                objectArray[2] = "visitDestructuringDeclaration";
                break;
            }
            case 279: {
                objectArray = objectArray;
                objectArray[2] = "initializeDestructuringDeclaration";
                break;
            }
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 284: 
            case 285: {
                objectArray = objectArray;
                objectArray[2] = "initializeDestructuringDeclarationVariables";
                break;
            }
            case 286: {
                objectArray = objectArray;
                objectArray[2] = "getVariableMetadataValue";
                break;
            }
            case 288: {
                objectArray = objectArray;
                objectArray[2] = "adjustVariableValue";
                break;
            }
            case 290: {
                objectArray = objectArray;
                objectArray[2] = "initializeLocalVariable";
                break;
            }
            case 291: {
                objectArray = objectArray;
                objectArray[2] = "initializeLocalVariableWithFakeDefaultValue";
                break;
            }
            case 292: {
                objectArray = objectArray;
                objectArray[2] = "generateProvideDelegateCallForLocalVariable";
                break;
            }
            case 294: {
                objectArray = objectArray;
                objectArray[2] = "getVariableDescriptorNotNull";
                break;
            }
            case 296: 
            case 297: 
            case 298: {
                objectArray = objectArray;
                objectArray[2] = "initializePropertyMetadata";
                break;
            }
            case 299: 
            case 300: {
                objectArray = objectArray;
                objectArray[2] = "generateNewCall";
                break;
            }
            case 303: {
                objectArray = objectArray;
                objectArray[2] = "getConstructorDescriptor";
                break;
            }
            case 305: {
                objectArray = objectArray;
                objectArray[2] = "getConstructorReceiver";
                break;
            }
            case 306: 
            case 307: {
                objectArray = objectArray;
                objectArray[2] = "generateConstructorCall";
                break;
            }
            case 309: 
            case 310: 
            case 311: {
                objectArray = objectArray;
                objectArray[2] = "generateNewArray";
                break;
            }
            case 312: {
                objectArray = objectArray;
                objectArray[2] = "newArrayInstruction";
                break;
            }
            case 313: {
                objectArray = objectArray;
                objectArray[2] = "visitArrayAccessExpression";
                break;
            }
            case 314: 
            case 315: 
            case 316: 
            case 317: {
                objectArray = objectArray;
                objectArray[2] = "createCollectionElementReceiver";
                break;
            }
            case 318: {
                objectArray = objectArray;
                objectArray[2] = "visitThrowExpression";
                break;
            }
            case 319: {
                objectArray = objectArray;
                objectArray[2] = "visitThisExpression";
                break;
            }
            case 320: {
                objectArray = objectArray;
                objectArray[2] = "visitTryExpression";
                break;
            }
            case 321: 
            case 322: {
                objectArray = objectArray;
                objectArray[2] = "generateExceptionTable";
                break;
            }
            case 323: 
            case 324: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentCatchIntervals";
                break;
            }
            case 326: {
                objectArray = objectArray;
                objectArray[2] = "visitBinaryWithTypeRHSExpression";
                break;
            }
            case 327: {
                objectArray = objectArray;
                objectArray[2] = "visitIsExpression";
                break;
            }
            case 328: {
                objectArray = objectArray;
                objectArray[2] = "propagateChildReifiedTypeParametersUsages";
                break;
            }
            case 329: {
                objectArray = objectArray;
                objectArray[2] = "visitWhenExpression";
                break;
            }
            case 330: {
                objectArray = objectArray;
                objectArray[2] = "putUnitInstanceOntoStackForNonExhaustiveWhen";
                break;
            }
            case 334: {
                objectArray = objectArray;
                objectArray[2] = "addBlockStackElementsForNonLocalReturns";
                break;
            }
            case 335: 
            case 336: 
            case 337: 
            case 338: {
                objectArray = objectArray;
                objectArray[2] = "delegatedVariableValue";
                break;
            }
            case 342: {
                objectArray = objectArray;
                objectArray[2] = "consumeReifiedOperationMarker";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 14: 
            case 15: 
            case 25: 
            case 27: 
            case 29: 
            case 30: 
            case 42: 
            case 49: 
            case 50: 
            case 62: 
            case 72: 
            case 77: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 88: 
            case 89: 
            case 128: 
            case 135: 
            case 141: 
            case 142: 
            case 145: 
            case 149: 
            case 150: 
            case 151: 
            case 159: 
            case 160: 
            case 173: 
            case 174: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 188: 
            case 190: 
            case 191: 
            case 193: 
            case 194: 
            case 196: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 205: 
            case 208: 
            case 209: 
            case 210: 
            case 217: 
            case 219: 
            case 242: 
            case 258: 
            case 259: 
            case 287: 
            case 289: 
            case 293: 
            case 295: 
            case 301: 
            case 302: 
            case 304: 
            case 308: 
            case 325: 
            case 331: 
            case 332: 
            case 333: 
            case 339: 
            case 340: 
            case 341: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NonLocalReturnInfo {
        private final JvmKotlinType returnType;
        private final String labelName;

        private NonLocalReturnInfo(@NotNull JvmKotlinType type2, @NotNull String name2) {
            if (type2 == null) {
                NonLocalReturnInfo.$$$reportNull$$$0(0);
            }
            if (name2 == null) {
                NonLocalReturnInfo.$$$reportNull$$$0(1);
            }
            this.returnType = type2;
            this.labelName = name2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/codegen/ExpressionCodegen$NonLocalReturnInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class StringTemplateEntry {
        private StringTemplateEntry() {
        }

        static class Expression
        extends StringTemplateEntry {
            final KtExpression expression;

            Expression(KtExpression expression2) {
                this.expression = expression2;
            }
        }

        static class Constant
        extends StringTemplateEntry {
            final String value;

            Constant(String value2) {
                this.value = value2;
            }
        }
    }

    private static class ObjectLiteralResult {
        private final boolean wereReifiedMarkers;
        private final ClassDescriptor classDescriptor;

        public ObjectLiteralResult(boolean wereReifiedMarkers, @NotNull ClassDescriptor classDescriptor2) {
            if (classDescriptor2 == null) {
                ObjectLiteralResult.$$$reportNull$$$0(0);
            }
            this.wereReifiedMarkers = wereReifiedMarkers;
            this.classDescriptor = classDescriptor2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/codegen/ExpressionCodegen$ObjectLiteralResult", "<init>"));
        }
    }

    static class TryWithFinallyBlockStackElement
    extends TryBlockStackElement {
        final KtTryExpression expression;

        TryWithFinallyBlockStackElement(KtTryExpression expression2) {
            this.expression = expression2;
        }
    }

    static class TryBlockStackElement
    extends BlockStackElement {
        List<Label> gaps = new ArrayList<Label>();

        TryBlockStackElement() {
        }

        void addGapLabel(Label label2) {
            this.gaps.add(label2);
        }
    }

    static class LoopBlockStackElement
    extends BlockStackElement {
        final Label continueLabel;
        final Label breakLabel;
        public final KtSimpleNameExpression targetLabel;

        LoopBlockStackElement(Label breakLabel, Label continueLabel, KtSimpleNameExpression targetLabel) {
            this.breakLabel = breakLabel;
            this.continueLabel = continueLabel;
            this.targetLabel = targetLabel;
        }
    }

    static class BlockStackElement {
        BlockStackElement() {
        }
    }
}

