/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.optimization.ConstantConditionEliminationMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.transformer.MethodTransformer;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.MavenComparableVersion;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.InsnNode;
import org.jetbrains.org.objectweb.asm.tree.IntInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LdcInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u000fH\u0002\u00a2\u0006\u0002\u0010\u0010J\f\u0010\u0011\u001a\u00020\u0012*\u00020\u000fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/ApiVersionCallsPreprocessingMethodTransformer;", "Lorg/jetbrains/kotlin/codegen/optimization/transformer/MethodTransformer;", "targetApiVersion", "Lorg/jetbrains/kotlin/config/ApiVersion;", "(Lorg/jetbrains/kotlin/config/ApiVersion;)V", "constantConditionElimination", "Lorg/jetbrains/kotlin/codegen/optimization/ConstantConditionEliminationMethodTransformer;", "transform", "", "internalClassName", "", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "getIntConstValue", "", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "(Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;)Ljava/lang/Integer;", "isApiVersionIsAtLeastCall", "", "backend"})
public final class ApiVersionCallsPreprocessingMethodTransformer
extends MethodTransformer {
    private final ConstantConditionEliminationMethodTransformer constantConditionElimination;
    private final ApiVersion targetApiVersion;

    @Override
    public void transform(@NotNull String internalClassName, @NotNull MethodNode methodNode) {
        Intrinsics.checkParameterIsNotNull((Object)internalClassName, (String)"internalClassName");
        Intrinsics.checkParameterIsNotNull((Object)methodNode, (String)"methodNode");
        boolean hasFoldedCalls = false;
        AbstractInsnNode[] abstractInsnNodeArray = methodNode.instructions.toArray();
        int n = abstractInsnNodeArray.length;
        for (int j = 0; j < n; ++j) {
            AbstractInsnNode prev1;
            AbstractInsnNode prev2;
            AbstractInsnNode prev3;
            AbstractInsnNode insn;
            AbstractInsnNode abstractInsnNode = insn = abstractInsnNodeArray[j];
            Intrinsics.checkExpressionValueIsNotNull((Object)abstractInsnNode, (String)"insn");
            if (!this.isApiVersionIsAtLeastCall(abstractInsnNode)) continue;
            if (insn.getPrevious() == null) {
                continue;
            }
            Integer n2 = this.getIntConstValue(prev3);
            if (n2 == null) {
                continue;
            }
            int minor = n2;
            if (prev3.getPrevious() == null) {
                continue;
            }
            Integer n3 = this.getIntConstValue(prev2);
            if (n3 == null) {
                continue;
            }
            int major = n3;
            if (prev2.getPrevious() == null) {
                continue;
            }
            Integer n4 = this.getIntConstValue(prev1);
            if (n4 == null) {
                continue;
            }
            int epic = n4;
            hasFoldedCalls = true;
            MavenComparableVersion atLeastVersion = new MavenComparableVersion("" + epic + '.' + major + '.' + minor);
            InsnNode replacementInsn = this.targetApiVersion.getVersion().compareTo(atLeastVersion) >= 0 ? new InsnNode(4) : new InsnNode(3);
            InsnList insnList = methodNode.instructions;
            boolean bl = false;
            boolean bl2 = false;
            InsnList $this$run = insnList;
            boolean bl3 = false;
            $this$run.remove(prev1);
            $this$run.remove(prev2);
            $this$run.remove(prev3);
            $this$run.set(insn, (AbstractInsnNode)replacementInsn);
        }
        if (hasFoldedCalls) {
            this.constantConditionElimination.transform(internalClassName, methodNode);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isApiVersionIsAtLeastCall(@NotNull AbstractInsnNode $this$isApiVersionIsAtLeastCall) {
        void $this$isMethodInsnWith$iv;
        AbstractInsnNode abstractInsnNode = $this$isApiVersionIsAtLeastCall;
        int opcode$iv = 184;
        boolean $i$f$isMethodInsnWith = false;
        if ($this$isMethodInsnWith$iv.getOpcode() != opcode$iv) return false;
        if (!($this$isMethodInsnWith$iv instanceof MethodInsnNode)) return false;
        MethodInsnNode $this$isMethodInsnWith = (MethodInsnNode)$this$isMethodInsnWith$iv;
        boolean bl = false;
        String string = $this$isMethodInsnWith.owner;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"owner");
        if (!StringsKt.startsWith$default((String)string, (String)"kotlin/internal", (boolean)false, (int)2, null)) return false;
        if (!Intrinsics.areEqual((Object)$this$isMethodInsnWith.name, (Object)"apiVersionIsAtLeast")) return false;
        if (!Intrinsics.areEqual((Object)$this$isMethodInsnWith.desc, (Object)"(III)Z")) return false;
        return true;
    }

    private final Integer getIntConstValue(@NotNull AbstractInsnNode $this$getIntConstValue) {
        Integer n;
        AbstractInsnNode abstractInsnNode = $this$getIntConstValue;
        if (abstractInsnNode instanceof InsnNode) {
            int n2 = ((InsnNode)$this$getIntConstValue).getOpcode();
            n = 2 <= n2 && 8 >= n2 ? Integer.valueOf(((InsnNode)$this$getIntConstValue).getOpcode() - 3) : null;
        } else if (abstractInsnNode instanceof IntInsnNode) {
            switch (((IntInsnNode)$this$getIntConstValue).getOpcode()) {
                case 16: {
                    n = ((IntInsnNode)$this$getIntConstValue).operand;
                    break;
                }
                case 17: {
                    n = ((IntInsnNode)$this$getIntConstValue).operand;
                    break;
                }
                default: {
                    n = null;
                    break;
                }
            }
        } else if (abstractInsnNode instanceof LdcInsnNode) {
            Object object = ((LdcInsnNode)$this$getIntConstValue).cst;
            if (!(object instanceof Integer)) {
                object = null;
            }
            n = (Integer)object;
        } else {
            n = null;
        }
        return n;
    }

    public ApiVersionCallsPreprocessingMethodTransformer(@NotNull ApiVersion targetApiVersion) {
        Intrinsics.checkParameterIsNotNull((Object)targetApiVersion, (String)"targetApiVersion");
        this.targetApiVersion = targetApiVersion;
        this.constantConditionElimination = new ConstantConditionEliminationMethodTransformer();
    }
}

