/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon.common;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.daemon.common.PerfCounters;
import org.jetbrains.kotlin.daemon.common.Profiler;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0010 \n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0086\b\u001a\u001f\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\b\u001a%\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\"\u0004\b\u0000\u0010\b2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0086\b\u001a)\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0086\b\u001a\u000f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0086\b\u001a'\u0010\f\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0086\b\u001a\u001f\u0010\f\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0086\b\u001a1\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0086\b\u001a-\u0010\u000f\u001a\u00020\r\"\u0004\b\u0000\u0010\b2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0086\b\u001a\u001f\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0086\b\u001a\u0011\u0010\u0011\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0086\b\u001a\r\u0010\u0012\u001a\u00020\u0002*\u00020\u0006H\u0086\b\u001a\r\u0010\u0013\u001a\u00020\u0002*\u00020\u0006H\u0086\b\u001a0\u0010\u0014\u001a\u0002H\b\"\u0004\b\u0000\u0010\b*\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\b0\u0019H\u0086\b\u00a2\u0006\u0002\u0010\u001a\u00a8\u0006\u001b"}, d2={"beginMeasureWallAndThreadTimes", "", "", "perfCounters", "Lorg/jetbrains/kotlin/daemon/common/PerfCounters;", "threadMXBean", "Ljava/lang/management/ThreadMXBean;", "beginMeasureWallAndThreadTimesAndMemory", "R", "withGC", "", "beginMeasureWallTime", "endMeasureWallAndThreadTimes", "", "startState", "endMeasureWallAndThreadTimesAndMemory", "endMeasureWallTime", "usedMemory", "threadCpuTime", "threadUserTime", "withMeasure", "Lorg/jetbrains/kotlin/daemon/common/Profiler;", "obj", "", "body", "Lkotlin/Function0;", "(Lorg/jetbrains/kotlin/daemon/common/Profiler;Ljava/lang/Object;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "daemon-common"})
public final class PerfUtilsKt {
    public static final <R> R withMeasure(@NotNull Profiler $this$withMeasure, @Nullable Object obj, @NotNull Function0<? extends R> body2) {
        int $i$f$withMeasure = 0;
        Intrinsics.checkParameterIsNotNull((Object)$this$withMeasure, (String)"$this$withMeasure");
        Intrinsics.checkParameterIsNotNull(body2, (String)"body");
        List<Long> startState = $this$withMeasure.beginMeasure(obj);
        Object res2 = body2.invoke();
        $this$withMeasure.endMeasure(obj, startState);
        return (R)res2;
    }

    public static final long threadCpuTime(@NotNull ThreadMXBean $this$threadCpuTime) {
        int $i$f$threadCpuTime = 0;
        Intrinsics.checkParameterIsNotNull((Object)$this$threadCpuTime, (String)"$this$threadCpuTime");
        return $this$threadCpuTime.isCurrentThreadCpuTimeSupported() ? $this$threadCpuTime.getCurrentThreadCpuTime() : 0L;
    }

    public static final long threadUserTime(@NotNull ThreadMXBean $this$threadUserTime) {
        int $i$f$threadUserTime = 0;
        Intrinsics.checkParameterIsNotNull((Object)$this$threadUserTime, (String)"$this$threadUserTime");
        return $this$threadUserTime.isCurrentThreadCpuTimeSupported() ? $this$threadUserTime.getCurrentThreadUserTime() : 0L;
    }

    public static final long usedMemory(boolean withGC) {
        int $i$f$usedMemory = 0;
        if (withGC) {
            System.gc();
        }
        Runtime rt = Runtime.getRuntime();
        return rt.totalMemory() - rt.freeMemory();
    }

    @NotNull
    public static final List<Long> beginMeasureWallTime() {
        int $i$f$beginMeasureWallTime = 0;
        return CollectionsKt.listOf((Object)System.nanoTime());
    }

    public static final void endMeasureWallTime(@NotNull PerfCounters perfCounters, @NotNull List<Long> startState) {
        List<Long> list2;
        int $i$f$endMeasureWallTime = 0;
        Intrinsics.checkParameterIsNotNull((Object)perfCounters, (String)"perfCounters");
        Intrinsics.checkParameterIsNotNull(startState, (String)"startState");
        List<Long> list3 = list2 = startState;
        boolean bl = false;
        long startTime = ((Number)list3.get(0)).longValue();
        PerfCounters.DefaultImpls.addMeasurement$default(perfCounters, System.nanoTime() - startTime, 0L, 0L, 0L, 14, null);
    }

    @NotNull
    public static final List<Long> beginMeasureWallAndThreadTimes(@NotNull PerfCounters perfCounters, @NotNull ThreadMXBean threadMXBean) {
        int $i$f$beginMeasureWallAndThreadTimes = 0;
        Intrinsics.checkParameterIsNotNull((Object)perfCounters, (String)"perfCounters");
        Intrinsics.checkParameterIsNotNull((Object)threadMXBean, (String)"threadMXBean");
        long startTime = System.nanoTime();
        ThreadMXBean $this$threadCpuTime$iv = threadMXBean;
        boolean $i$f$threadCpuTime = false;
        long startThreadTime = $this$threadCpuTime$iv.isCurrentThreadCpuTimeSupported() ? $this$threadCpuTime$iv.getCurrentThreadCpuTime() : 0L;
        ThreadMXBean $this$threadUserTime$iv = threadMXBean;
        boolean $i$f$threadUserTime = false;
        long startThreadUserTime = $this$threadUserTime$iv.isCurrentThreadCpuTimeSupported() ? $this$threadUserTime$iv.getCurrentThreadUserTime() : 0L;
        return CollectionsKt.listOf((Object[])new Long[]{startTime, startThreadTime, startThreadUserTime});
    }

    /*
     * WARNING - void declaration
     */
    public static final void endMeasureWallAndThreadTimes(@NotNull PerfCounters perfCounters, @NotNull ThreadMXBean threadMXBean, @NotNull List<Long> startState) {
        void startThreadTime;
        void $this$threadUserTime$iv;
        ThreadMXBean $this$threadCpuTime$iv;
        void startTime;
        int $i$f$endMeasureWallAndThreadTimes = 0;
        Intrinsics.checkParameterIsNotNull((Object)perfCounters, (String)"perfCounters");
        Intrinsics.checkParameterIsNotNull((Object)threadMXBean, (String)"threadMXBean");
        Intrinsics.checkParameterIsNotNull(startState, (String)"startState");
        Object object = startState;
        List<Long> list2 = object;
        boolean bl = false;
        long l = ((Number)list2.get(0)).longValue();
        list2 = object;
        bl = false;
        long l2 = ((Number)list2.get(1)).longValue();
        list2 = object;
        bl = false;
        long startThreadUserTime = ((Number)list2.get(2)).longValue();
        object = threadMXBean;
        long l3 = System.nanoTime() - startTime;
        PerfCounters perfCounters2 = perfCounters;
        boolean $i$f$threadCpuTime = false;
        long l4 = $this$threadCpuTime$iv.isCurrentThreadCpuTimeSupported() ? $this$threadCpuTime$iv.getCurrentThreadCpuTime() : 0L;
        $this$threadCpuTime$iv = threadMXBean;
        boolean $i$f$threadUserTime = false;
        long l5 = $this$threadUserTime$iv.isCurrentThreadCpuTimeSupported() ? $this$threadUserTime$iv.getCurrentThreadUserTime() : 0L;
        PerfCounters.DefaultImpls.addMeasurement$default(perfCounters2, l3, l4 -= startThreadTime, l5 - startThreadUserTime, 0L, 8, null);
    }

    @NotNull
    public static final List<Long> beginMeasureWallAndThreadTimes(@NotNull PerfCounters perfCounters) {
        int $i$f$beginMeasureWallAndThreadTimes = 0;
        Intrinsics.checkParameterIsNotNull((Object)perfCounters, (String)"perfCounters");
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        Intrinsics.checkExpressionValueIsNotNull((Object)threadMXBean, (String)"ManagementFactory.getThreadMXBean()");
        ThreadMXBean threadMXBean$iv = threadMXBean;
        boolean $i$f$beginMeasureWallAndThreadTimes2 = false;
        long startTime$iv = System.nanoTime();
        ThreadMXBean $this$threadCpuTime$iv$iv = threadMXBean$iv;
        boolean $i$f$threadCpuTime = false;
        long startThreadTime$iv = $this$threadCpuTime$iv$iv.isCurrentThreadCpuTimeSupported() ? $this$threadCpuTime$iv$iv.getCurrentThreadCpuTime() : 0L;
        ThreadMXBean $this$threadUserTime$iv$iv = threadMXBean$iv;
        boolean $i$f$threadUserTime = false;
        long startThreadUserTime$iv = $this$threadUserTime$iv$iv.isCurrentThreadCpuTimeSupported() ? $this$threadUserTime$iv$iv.getCurrentThreadUserTime() : 0L;
        return CollectionsKt.listOf((Object[])new Long[]{startTime$iv, startThreadTime$iv, startThreadUserTime$iv});
    }

    /*
     * WARNING - void declaration
     */
    public static final void endMeasureWallAndThreadTimes(@NotNull PerfCounters perfCounters, @NotNull List<Long> startState) {
        void startThreadTime$iv;
        void $this$threadUserTime$iv$iv;
        ThreadMXBean $this$threadCpuTime$iv$iv;
        void startTime$iv;
        int $i$f$endMeasureWallAndThreadTimes = 0;
        Intrinsics.checkParameterIsNotNull((Object)perfCounters, (String)"perfCounters");
        Intrinsics.checkParameterIsNotNull(startState, (String)"startState");
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        Intrinsics.checkExpressionValueIsNotNull((Object)threadMXBean, (String)"ManagementFactory.getThreadMXBean()");
        ThreadMXBean threadMXBean$iv = threadMXBean;
        boolean $i$f$endMeasureWallAndThreadTimes2 = false;
        Object object = startState;
        List<Long> list2 = object;
        boolean bl = false;
        long l = ((Number)list2.get(0)).longValue();
        list2 = object;
        bl = false;
        long l2 = ((Number)list2.get(1)).longValue();
        list2 = object;
        bl = false;
        long startThreadUserTime$iv = ((Number)list2.get(2)).longValue();
        object = threadMXBean$iv;
        long l3 = System.nanoTime() - startTime$iv;
        PerfCounters perfCounters2 = perfCounters;
        boolean $i$f$threadCpuTime = false;
        long l4 = $this$threadCpuTime$iv$iv.isCurrentThreadCpuTimeSupported() ? $this$threadCpuTime$iv$iv.getCurrentThreadCpuTime() : 0L;
        $this$threadCpuTime$iv$iv = threadMXBean$iv;
        boolean $i$f$threadUserTime = false;
        long l5 = $this$threadUserTime$iv$iv.isCurrentThreadCpuTimeSupported() ? $this$threadUserTime$iv$iv.getCurrentThreadUserTime() : 0L;
        PerfCounters.DefaultImpls.addMeasurement$default(perfCounters2, l3, l4 -= startThreadTime$iv, l5 - startThreadUserTime$iv, 0L, 8, null);
    }

    @NotNull
    public static final List<Long> beginMeasureWallAndThreadTimesAndMemory(@NotNull PerfCounters perfCounters, boolean withGC, @NotNull ThreadMXBean threadMXBean) {
        int $i$f$beginMeasureWallAndThreadTimesAndMemory = 0;
        Intrinsics.checkParameterIsNotNull((Object)perfCounters, (String)"perfCounters");
        Intrinsics.checkParameterIsNotNull((Object)threadMXBean, (String)"threadMXBean");
        boolean $i$f$usedMemory = false;
        if (withGC) {
            System.gc();
        }
        Runtime rt$iv = Runtime.getRuntime();
        long startMem = rt$iv.totalMemory() - rt$iv.freeMemory();
        long startTime = System.nanoTime();
        ThreadMXBean $this$threadCpuTime$iv = threadMXBean;
        boolean $i$f$threadCpuTime = false;
        long startThreadTime = $this$threadCpuTime$iv.isCurrentThreadCpuTimeSupported() ? $this$threadCpuTime$iv.getCurrentThreadCpuTime() : 0L;
        ThreadMXBean $this$threadUserTime$iv = threadMXBean;
        boolean $i$f$threadUserTime = false;
        long startThreadUserTime = $this$threadUserTime$iv.isCurrentThreadCpuTimeSupported() ? $this$threadUserTime$iv.getCurrentThreadUserTime() : 0L;
        return CollectionsKt.listOf((Object[])new Long[]{startMem, startTime, startThreadTime, startThreadUserTime});
    }

    public static /* synthetic */ List beginMeasureWallAndThreadTimesAndMemory$default(PerfCounters perfCounters, boolean withGC, ThreadMXBean threadMXBean, int n, Object object) {
        if ((n & 2) != 0) {
            withGC = false;
        }
        boolean $i$f$beginMeasureWallAndThreadTimesAndMemory = false;
        Intrinsics.checkParameterIsNotNull((Object)perfCounters, (String)"perfCounters");
        Intrinsics.checkParameterIsNotNull((Object)threadMXBean, (String)"threadMXBean");
        boolean $i$f$usedMemory = false;
        if (withGC) {
            System.gc();
        }
        Runtime rt$iv = Runtime.getRuntime();
        long startMem = rt$iv.totalMemory() - rt$iv.freeMemory();
        long startTime = System.nanoTime();
        ThreadMXBean $this$threadCpuTime$iv = threadMXBean;
        boolean $i$f$threadCpuTime = false;
        long startThreadTime = $this$threadCpuTime$iv.isCurrentThreadCpuTimeSupported() ? $this$threadCpuTime$iv.getCurrentThreadCpuTime() : 0L;
        ThreadMXBean $this$threadUserTime$iv = threadMXBean;
        boolean $i$f$threadUserTime = false;
        long startThreadUserTime = $this$threadUserTime$iv.isCurrentThreadCpuTimeSupported() ? $this$threadUserTime$iv.getCurrentThreadUserTime() : 0L;
        return CollectionsKt.listOf((Object[])new Long[]{startMem, startTime, startThreadTime, startThreadUserTime});
    }

    /*
     * WARNING - void declaration
     */
    public static final void endMeasureWallAndThreadTimesAndMemory(@NotNull PerfCounters perfCounters, boolean withGC, @NotNull ThreadMXBean threadMXBean, @NotNull List<Long> startState) {
        void startMem;
        void $this$threadUserTime$iv;
        void startThreadTime;
        ThreadMXBean $this$threadCpuTime$iv;
        void startTime;
        int $i$f$endMeasureWallAndThreadTimesAndMemory = 0;
        Intrinsics.checkParameterIsNotNull((Object)perfCounters, (String)"perfCounters");
        Intrinsics.checkParameterIsNotNull((Object)threadMXBean, (String)"threadMXBean");
        Intrinsics.checkParameterIsNotNull(startState, (String)"startState");
        Object object = startState;
        List<Long> list2 = object;
        boolean bl = false;
        long l = ((Number)list2.get(0)).longValue();
        list2 = object;
        bl = false;
        long l2 = ((Number)list2.get(1)).longValue();
        list2 = object;
        bl = false;
        long l3 = ((Number)list2.get(2)).longValue();
        list2 = object;
        bl = false;
        long startThreadUserTime = ((Number)list2.get(3)).longValue();
        object = threadMXBean;
        long l4 = System.nanoTime() - startTime;
        PerfCounters perfCounters2 = perfCounters;
        boolean $i$f$threadCpuTime = false;
        long l5 = $this$threadCpuTime$iv.isCurrentThreadCpuTimeSupported() ? $this$threadCpuTime$iv.getCurrentThreadCpuTime() : 0L;
        $this$threadCpuTime$iv = threadMXBean;
        l5 -= startThreadTime;
        boolean $i$f$threadUserTime = false;
        long l6 = $this$threadUserTime$iv.isCurrentThreadCpuTimeSupported() ? $this$threadUserTime$iv.getCurrentThreadUserTime() : 0L;
        l6 -= startThreadUserTime;
        boolean $i$f$usedMemory = false;
        if (withGC) {
            System.gc();
        }
        Runtime rt$iv = Runtime.getRuntime();
        long l7 = rt$iv.totalMemory() - rt$iv.freeMemory();
        perfCounters2.addMeasurement(l4, l5, l6, l7 - startMem);
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ void endMeasureWallAndThreadTimesAndMemory$default(PerfCounters perfCounters, boolean withGC, ThreadMXBean threadMXBean, List startState, int n, Object object) {
        void startMem;
        void $this$threadUserTime$iv;
        void startThreadTime;
        ThreadMXBean $this$threadCpuTime$iv;
        void startTime;
        if ((n & 2) != 0) {
            withGC = false;
        }
        boolean $i$f$endMeasureWallAndThreadTimesAndMemory = false;
        Intrinsics.checkParameterIsNotNull((Object)perfCounters, (String)"perfCounters");
        Intrinsics.checkParameterIsNotNull((Object)threadMXBean, (String)"threadMXBean");
        Intrinsics.checkParameterIsNotNull((Object)startState, (String)"startState");
        Object object2 = startState;
        List list2 = object2;
        boolean bl = false;
        long l = ((Number)list2.get(0)).longValue();
        list2 = object2;
        bl = false;
        long l2 = ((Number)list2.get(1)).longValue();
        list2 = object2;
        bl = false;
        long l3 = ((Number)list2.get(2)).longValue();
        list2 = object2;
        bl = false;
        long startThreadUserTime = ((Number)list2.get(3)).longValue();
        object2 = threadMXBean;
        long l4 = System.nanoTime() - startTime;
        PerfCounters perfCounters2 = perfCounters;
        boolean $i$f$threadCpuTime = false;
        long l5 = $this$threadCpuTime$iv.isCurrentThreadCpuTimeSupported() ? $this$threadCpuTime$iv.getCurrentThreadCpuTime() : 0L;
        $this$threadCpuTime$iv = threadMXBean;
        l5 -= startThreadTime;
        boolean $i$f$threadUserTime = false;
        long l6 = $this$threadUserTime$iv.isCurrentThreadCpuTimeSupported() ? $this$threadUserTime$iv.getCurrentThreadUserTime() : 0L;
        l6 -= startThreadUserTime;
        boolean $i$f$usedMemory = false;
        if (withGC) {
            System.gc();
        }
        Runtime rt$iv = Runtime.getRuntime();
        long l7 = rt$iv.totalMemory() - rt$iv.freeMemory();
        perfCounters2.addMeasurement(l4, l5, l6, l7 - startMem);
    }

    @NotNull
    public static final <R> List<Long> beginMeasureWallAndThreadTimesAndMemory(@NotNull PerfCounters perfCounters, boolean withGC) {
        int $i$f$beginMeasureWallAndThreadTimesAndMemory = 0;
        Intrinsics.checkParameterIsNotNull((Object)perfCounters, (String)"perfCounters");
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        Intrinsics.checkExpressionValueIsNotNull((Object)threadMXBean, (String)"ManagementFactory.getThreadMXBean()");
        ThreadMXBean threadMXBean$iv = threadMXBean;
        boolean $i$f$beginMeasureWallAndThreadTimesAndMemory2 = false;
        boolean $i$f$usedMemory = false;
        if (withGC) {
            System.gc();
        }
        Runtime rt$iv$iv = Runtime.getRuntime();
        long startMem$iv = rt$iv$iv.totalMemory() - rt$iv$iv.freeMemory();
        long startTime$iv = System.nanoTime();
        ThreadMXBean $this$threadCpuTime$iv$iv = threadMXBean$iv;
        boolean $i$f$threadCpuTime = false;
        long startThreadTime$iv = $this$threadCpuTime$iv$iv.isCurrentThreadCpuTimeSupported() ? $this$threadCpuTime$iv$iv.getCurrentThreadCpuTime() : 0L;
        ThreadMXBean $this$threadUserTime$iv$iv = threadMXBean$iv;
        boolean $i$f$threadUserTime = false;
        long startThreadUserTime$iv = $this$threadUserTime$iv$iv.isCurrentThreadCpuTimeSupported() ? $this$threadUserTime$iv$iv.getCurrentThreadUserTime() : 0L;
        return CollectionsKt.listOf((Object[])new Long[]{startMem$iv, startTime$iv, startThreadTime$iv, startThreadUserTime$iv});
    }

    /*
     * WARNING - void declaration
     */
    public static final <R> void endMeasureWallAndThreadTimesAndMemory(@NotNull PerfCounters perfCounters, boolean withGC, @NotNull List<Long> startState) {
        void startMem$iv;
        void $this$threadUserTime$iv$iv;
        void startThreadTime$iv;
        ThreadMXBean $this$threadCpuTime$iv$iv;
        void startTime$iv;
        int $i$f$endMeasureWallAndThreadTimesAndMemory = 0;
        Intrinsics.checkParameterIsNotNull((Object)perfCounters, (String)"perfCounters");
        Intrinsics.checkParameterIsNotNull(startState, (String)"startState");
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        Intrinsics.checkExpressionValueIsNotNull((Object)threadMXBean, (String)"ManagementFactory.getThreadMXBean()");
        ThreadMXBean threadMXBean$iv = threadMXBean;
        boolean $i$f$endMeasureWallAndThreadTimesAndMemory2 = false;
        Object object = startState;
        List<Long> list2 = object;
        boolean bl = false;
        long l = ((Number)list2.get(0)).longValue();
        list2 = object;
        bl = false;
        long l2 = ((Number)list2.get(1)).longValue();
        list2 = object;
        bl = false;
        long l3 = ((Number)list2.get(2)).longValue();
        list2 = object;
        bl = false;
        long startThreadUserTime$iv = ((Number)list2.get(3)).longValue();
        object = threadMXBean$iv;
        long l4 = System.nanoTime() - startTime$iv;
        PerfCounters perfCounters2 = perfCounters;
        boolean $i$f$threadCpuTime = false;
        long l5 = $this$threadCpuTime$iv$iv.isCurrentThreadCpuTimeSupported() ? $this$threadCpuTime$iv$iv.getCurrentThreadCpuTime() : 0L;
        $this$threadCpuTime$iv$iv = threadMXBean$iv;
        l5 -= startThreadTime$iv;
        boolean $i$f$threadUserTime = false;
        long l6 = $this$threadUserTime$iv$iv.isCurrentThreadCpuTimeSupported() ? $this$threadUserTime$iv$iv.getCurrentThreadUserTime() : 0L;
        l6 -= startThreadUserTime$iv;
        boolean $i$f$usedMemory = false;
        if (withGC) {
            System.gc();
        }
        Runtime rt$iv$iv = Runtime.getRuntime();
        long l7 = rt$iv$iv.totalMemory() - rt$iv$iv.freeMemory();
        perfCounters2.addMeasurement(l4, l5, l6, l7 - startMem$iv);
    }
}

