/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.searches.IndexPatternSearch;
import com.intellij.util.QueryExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.KotlinPluginCompatibilityVerifier;
import org.jetbrains.kotlin.idea.KotlinPluginUpdater;
import org.jetbrains.kotlin.idea.StartupCompatKt;
import org.jetbrains.kotlin.idea.TestResourceBundleKt;
import org.jetbrains.kotlin.idea.reporter.KotlinReportSubmitter;
import org.jetbrains.kotlin.idea.search.ideaExtensions.KotlinTodoSearcher;
import org.jetbrains.kotlin.utils.PathUtil;

public class PluginStartupActivity
implements StartupActivity.DumbAware {
    private static final Logger LOG = Logger.getInstance(PluginStartupActivity.class);
    private static final String KOTLIN_BUNDLED = "KOTLIN_BUNDLED";

    public void runActivity(@NotNull Project project2) {
        if (project2 == null) {
            PluginStartupActivity.$$$reportNull$$$3(0);
        }
        if (project2 == null) {
            PluginStartupActivity.$$$reportNull$$$2(0);
        }
        if (project2 == null) {
            PluginStartupActivity.$$$reportNull$$$1(0);
        }
        if (project2 == null) {
            PluginStartupActivity.$$$reportNull$$$0(0);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            TestResourceBundleKt.registerAdditionalResourceBundleInTests();
        }
        StartupCompatKt.runActivity(project2);
        PluginStartupActivity.registerPathVariable();
        try {
            UpdateChecker.INSTANCE.getExcludedFromUpdateCheckPlugins().add("org.jetbrains.kotlin");
        }
        catch (Throwable throwable) {
            LOG.debug("Excluding Kotlin plugin updates using old API", throwable);
            UpdateChecker.getDisabledToUpdatePlugins().add("org.jetbrains.kotlin");
        }
        EditorEventMulticaster eventMulticaster = EditorFactory.getInstance().getEventMulticaster();
        DocumentListener documentListener = new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                VirtualFile virtualFile2;
                if (e == null) {
                    1.$$$reportNull$$$3(0);
                }
                if (e == null) {
                    1.$$$reportNull$$$2(0);
                }
                if (e == null) {
                    1.$$$reportNull$$$1(0);
                }
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((virtualFile2 = FileDocumentManager.getInstance().getFile(e.getDocument())) != null && virtualFile2.getFileType() == KotlinFileType.INSTANCE) {
                    KotlinPluginUpdater.Companion.getInstance().kotlinFileEdited(virtualFile2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/idea/PluginStartupActivity$1", "documentChanged"));
            }

            private static /* synthetic */ void $$$reportNull$$$1(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/idea/PluginStartupActivity$1", "documentChanged"));
            }

            private static /* synthetic */ void $$$reportNull$$$2(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/idea/PluginStartupActivity$1", "documentChanged"));
            }

            private static /* synthetic */ void $$$reportNull$$$3(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/idea/PluginStartupActivity$1", "documentChanged"));
            }
        };
        eventMulticaster.addDocumentListener(documentListener, (Disposable)project2);
        IndexPatternSearch indexPatternSearch = (IndexPatternSearch)ServiceManager.getService(IndexPatternSearch.class);
        KotlinTodoSearcher kotlinTodoSearcher = new KotlinTodoSearcher();
        indexPatternSearch.registerExecutor((QueryExecutor)kotlinTodoSearcher);
        KotlinPluginCompatibilityVerifier.checkCompatibility();
        KotlinReportSubmitter.Companion.setupReportingFromRelease();
        Disposer.register((Disposable)project2, () -> {
            eventMulticaster.removeDocumentListener(documentListener);
            indexPatternSearch.unregisterExecutor((QueryExecutor)kotlinTodoSearcher);
        });
    }

    private static void registerPathVariable() {
        PathMacros macros = PathMacros.getInstance();
        macros.setMacro(KOTLIN_BUNDLED, PathUtil.getKotlinPathsForIdeaPlugin().getHomePath().getPath());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/PluginStartupActivity", "runActivity"));
    }

    private static /* synthetic */ void $$$reportNull$$$1(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/PluginStartupActivity", "runActivity"));
    }

    private static /* synthetic */ void $$$reportNull$$$2(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/PluginStartupActivity", "runActivity"));
    }

    private static /* synthetic */ void $$$reportNull$$$3(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/PluginStartupActivity", "runActivity"));
    }
}

