/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea;

import com.intellij.openapi.application.ApplicationManager;
import java.io.File;
import java.io.IOException;

public class PluginStartupService {
    private String aliveFlagPath;

    public static PluginStartupService getInstance() {
        return (PluginStartupService)ApplicationManager.getApplication().getService(PluginStartupService.class);
    }

    public synchronized String getAliveFlagPath() {
        if (this.aliveFlagPath == null) {
            try {
                File flagFile = File.createTempFile("kotlin-idea-", "-is-running");
                flagFile.deleteOnExit();
                this.aliveFlagPath = flagFile.getAbsolutePath();
            }
            catch (IOException e) {
                this.aliveFlagPath = "";
            }
        }
        return this.aliveFlagPath;
    }

    public synchronized void resetAliveFlag() {
        File flagFile;
        if (this.aliveFlagPath != null && (flagFile = new File(this.aliveFlagPath)).exists() && flagFile.delete()) {
            this.aliveFlagPath = null;
        }
    }
}

