/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.project;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.ModuleInfo;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.idea.KotlinIdeaAnalysisBundle;
import org.jetbrains.kotlin.idea.caches.project.BinaryModuleInfo;
import org.jetbrains.kotlin.idea.caches.project.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.caches.project.IdeaModuleInfosKt;
import org.jetbrains.kotlin.idea.caches.project.LibrarySourceScope;
import org.jetbrains.kotlin.idea.caches.project.ModuleOrigin;
import org.jetbrains.kotlin.idea.caches.project.SourceForBinaryModuleInfo;
import org.jetbrains.kotlin.idea.stubindex.KotlinSourceFilterScope;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.resolve.PlatformDependentAnalyzerServices;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u001c\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\bH\u00c6\u0003J'\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u00d6\u0003J\t\u0010$\u001a\u00020%H\u00d6\u0001J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'H\u0016J\b\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020,H\u0016R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/idea/caches/project/LibrarySourceInfo;", "Lorg/jetbrains/kotlin/idea/caches/project/IdeaModuleInfo;", "Lorg/jetbrains/kotlin/idea/caches/project/SourceForBinaryModuleInfo;", "project", "Lcom/intellij/openapi/project/Project;", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "binariesModuleInfo", "Lorg/jetbrains/kotlin/idea/caches/project/BinaryModuleInfo;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/roots/libraries/Library;Lorg/jetbrains/kotlin/idea/caches/project/BinaryModuleInfo;)V", "analyzerServices", "Lorg/jetbrains/kotlin/resolve/PlatformDependentAnalyzerServices;", "getAnalyzerServices", "()Lorg/jetbrains/kotlin/resolve/PlatformDependentAnalyzerServices;", "getBinariesModuleInfo", "()Lorg/jetbrains/kotlin/idea/caches/project/BinaryModuleInfo;", "getLibrary", "()Lcom/intellij/openapi/roots/libraries/Library;", "name", "Lorg/jetbrains/kotlin/name/Name;", "getName", "()Lorg/jetbrains/kotlin/name/Name;", "platform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getPlatform", "()Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getProject", "()Lcom/intellij/openapi/project/Project;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "modulesWhoseInternalsAreVisible", "", "Lorg/jetbrains/kotlin/analyzer/ModuleInfo;", "sourceScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "toString", "", "idea-core"})
public final class LibrarySourceInfo
implements IdeaModuleInfo,
SourceForBinaryModuleInfo {
    @NotNull
    private final Name name;
    @NotNull
    private final Project project;
    @NotNull
    private final Library library;
    @NotNull
    private final BinaryModuleInfo binariesModuleInfo;

    @Override
    @NotNull
    public Name getName() {
        return this.name;
    }

    @Override
    @NotNull
    public GlobalSearchScope sourceScope() {
        return KotlinSourceFilterScope.Companion.librarySources((GlobalSearchScope)new LibrarySourceScope(this.project, this.library), this.project);
    }

    @Override
    @NotNull
    public Collection<ModuleInfo> modulesWhoseInternalsAreVisible() {
        return IdeaModuleInfosKt.createLibraryInfo(this.project, this.library);
    }

    @Override
    @NotNull
    public TargetPlatform getPlatform() {
        return this.getBinariesModuleInfo().getPlatform();
    }

    @Override
    @NotNull
    public PlatformDependentAnalyzerServices getAnalyzerServices() {
        return this.getBinariesModuleInfo().getAnalyzerServices();
    }

    @NotNull
    public String toString() {
        return "LibrarySourceInfo(libraryName=" + this.library.getName() + ')';
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Library getLibrary() {
        return this.library;
    }

    @Override
    @NotNull
    public BinaryModuleInfo getBinariesModuleInfo() {
        return this.binariesModuleInfo;
    }

    public LibrarySourceInfo(@NotNull Project project2, @NotNull Library library2, @NotNull BinaryModuleInfo binariesModuleInfo) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)library2, (String)"library");
        Intrinsics.checkParameterIsNotNull((Object)binariesModuleInfo, (String)"binariesModuleInfo");
        this.project = project2;
        this.library = library2;
        this.binariesModuleInfo = binariesModuleInfo;
        Name name2 = Name.special(KotlinIdeaAnalysisBundle.message("sources.for.library.0", String.valueOf(this.library.getName())));
        Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"Name.special(KotlinIdeaA\u2026library.name.toString()))");
        this.name = name2;
    }

    @Override
    @NotNull
    public GlobalSearchScope contentScope() {
        return SourceForBinaryModuleInfo.DefaultImpls.contentScope(this);
    }

    @Override
    @NotNull
    public ModuleOrigin getModuleOrigin() {
        return SourceForBinaryModuleInfo.DefaultImpls.getModuleOrigin(this);
    }

    @Override
    @NotNull
    public Map<ModuleDescriptor.Capability<?>, Object> getCapabilities() {
        return IdeaModuleInfo.DefaultImpls.getCapabilities(this);
    }

    @Override
    @NotNull
    public List<IdeaModuleInfo> dependencies() {
        return SourceForBinaryModuleInfo.DefaultImpls.dependencies(this);
    }

    @Override
    @NotNull
    public String getDisplayedName() {
        return IdeaModuleInfo.DefaultImpls.getDisplayedName(this);
    }

    @Override
    @NotNull
    public List<ModuleInfo> getExpectedBy() {
        return IdeaModuleInfo.DefaultImpls.getExpectedBy(this);
    }

    @Override
    @Nullable
    public Name getStableName() {
        return IdeaModuleInfo.DefaultImpls.getStableName(this);
    }

    @Override
    @NotNull
    public ModuleInfo.DependencyOnBuiltIns dependencyOnBuiltIns() {
        return IdeaModuleInfo.DefaultImpls.dependencyOnBuiltIns(this);
    }

    @NotNull
    public final Project component1() {
        return this.project;
    }

    @NotNull
    public final Library component2() {
        return this.library;
    }

    @NotNull
    public final BinaryModuleInfo component3() {
        return this.getBinariesModuleInfo();
    }

    @NotNull
    public final LibrarySourceInfo copy(@NotNull Project project2, @NotNull Library library2, @NotNull BinaryModuleInfo binariesModuleInfo) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)library2, (String)"library");
        Intrinsics.checkParameterIsNotNull((Object)binariesModuleInfo, (String)"binariesModuleInfo");
        return new LibrarySourceInfo(project2, library2, binariesModuleInfo);
    }

    public static /* synthetic */ LibrarySourceInfo copy$default(LibrarySourceInfo librarySourceInfo, Project project2, Library library2, BinaryModuleInfo binaryModuleInfo, int n, Object object) {
        if ((n & 1) != 0) {
            project2 = librarySourceInfo.project;
        }
        if ((n & 2) != 0) {
            library2 = librarySourceInfo.library;
        }
        if ((n & 4) != 0) {
            binaryModuleInfo = librarySourceInfo.getBinariesModuleInfo();
        }
        return librarySourceInfo.copy(project2, library2, binaryModuleInfo);
    }

    public int hashCode() {
        Project project2 = this.project;
        Library library2 = this.library;
        BinaryModuleInfo binaryModuleInfo = this.getBinariesModuleInfo();
        return ((project2 != null ? project2.hashCode() : 0) * 31 + (library2 != null ? library2.hashCode() : 0)) * 31 + (binaryModuleInfo != null ? binaryModuleInfo.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof LibrarySourceInfo)) break block3;
                LibrarySourceInfo librarySourceInfo = (LibrarySourceInfo)object;
                if (!Intrinsics.areEqual((Object)this.project, (Object)librarySourceInfo.project) || !Intrinsics.areEqual((Object)this.library, (Object)librarySourceInfo.library) || !Intrinsics.areEqual((Object)this.getBinariesModuleInfo(), (Object)librarySourceInfo.getBinariesModuleInfo())) break block3;
            }
            return true;
        }
        return false;
    }
}

