/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.resolve;

import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.container.ComponentProvider;
import org.jetbrains.kotlin.container.DslKt;
import org.jetbrains.kotlin.context.GlobalContext;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.idea.caches.resolve.CodeFragmentAnalyzer;
import org.jetbrains.kotlin.idea.caches.resolve.KotlinCacheServiceImplKt;
import org.jetbrains.kotlin.idea.caches.resolve.KotlinResolveDataProvider;
import org.jetbrains.kotlin.idea.caches.resolve.StackedCompositeBindingContextTrace;
import org.jetbrains.kotlin.idea.caches.trackers.KotlinCodeBlockModificationListenerKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BodyResolveCache;
import org.jetbrains.kotlin.resolve.lazy.ResolveSession;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001a2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\u000e\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001aJ\n\u0010\u001f\u001a\u0004\u0018\u00010\fH\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010\f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J \u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\f2\u0006\u0010#\u001a\u00020\f2\u0006\u0010$\u001a\u00020%H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/idea/caches/resolve/PerFileAnalysisCache;", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "componentProvider", "Lorg/jetbrains/kotlin/container/ComponentProvider;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lorg/jetbrains/kotlin/container/ComponentProvider;)V", "bodyResolveCache", "Lorg/jetbrains/kotlin/resolve/BodyResolveCache;", "cache", "Ljava/util/HashMap;", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/analyzer/AnalysisResult;", "codeFragmentAnalyzer", "Lorg/jetbrains/kotlin/idea/caches/resolve/CodeFragmentAnalyzer;", "getFile", "()Lorg/jetbrains/kotlin/psi/KtFile;", "fileResult", "globalContext", "Lorg/jetbrains/kotlin/context/GlobalContext;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "resolveSession", "Lorg/jetbrains/kotlin/resolve/lazy/ResolveSession;", "analyze", "analyzableElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "bindingTrace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "getAnalysisResults", "element", "getIncrementalAnalysisResult", "lookUp", "wrapResult", "oldResult", "newResult", "elementBindingTrace", "Lorg/jetbrains/kotlin/idea/caches/resolve/StackedCompositeBindingContextTrace;", "idea-core"})
public final class PerFileAnalysisCache {
    private final GlobalContext globalContext;
    private final ModuleDescriptor moduleDescriptor;
    private final ResolveSession resolveSession;
    private final CodeFragmentAnalyzer codeFragmentAnalyzer;
    private final BodyResolveCache bodyResolveCache;
    private final HashMap<PsiElement, AnalysisResult> cache;
    private AnalysisResult fileResult;
    @NotNull
    private final KtFile file;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final AnalysisResult getAnalysisResults(@NotNull KtElement element3) {
        AnalysisResult analysisResult;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        boolean bl = Intrinsics.areEqual((Object)element3.getContainingKtFile(), (Object)this.file);
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Wrong file. Expected " + this.file + ", but was " + element3.getContainingKtFile();
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        KtElement analyzableParent = KotlinResolveDataProvider.INSTANCE.findAnalyzableParent(element3);
        PerFileAnalysisCache perFileAnalysisCache = this;
        boolean bl4 = false;
        boolean bl5 = false;
        synchronized (perFileAnalysisCache) {
            AnalysisResult analysisResult2;
            block7: {
                boolean bl6 = false;
                ProgressIndicatorProvider.checkCanceled();
                AnalysisResult analysisResult3 = this.getIncrementalAnalysisResult();
                if (analysisResult3 == null) break block7;
                AnalysisResult analysisResult4 = analysisResult3;
                boolean bl7 = false;
                boolean bl8 = false;
                AnalysisResult it = analysisResult4;
                boolean bl9 = false;
                AnalysisResult analysisResult5 = it;
                return analysisResult5;
            }
            AnalysisResult analysisResult6 = this.lookUp(analyzableParent);
            if (analysisResult6 != null) {
                AnalysisResult analysisResult7 = analysisResult6;
                boolean bl10 = false;
                boolean bl11 = false;
                AnalysisResult it = analysisResult7;
                boolean bl12 = false;
                analysisResult2 = it;
            } else {
                AnalysisResult result2 = PerFileAnalysisCache.analyze$default(this, analyzableParent, null, 2, null);
                ((Map)this.cache).put(analyzableParent, result2);
                analysisResult2 = result2;
            }
            analysisResult = analysisResult2;
        }
        return analysisResult;
    }

    private final AnalysisResult getIncrementalAnalysisResult() {
        if (this.fileResult == null && this.cache.containsKey(this.file)) {
            this.fileResult = this.cache.get(this.file);
            this.cache.clear();
        }
        Collection<KtElement> inBlockModifications = KotlinCodeBlockModificationListenerKt.getInBlockModifications(this.file);
        Object object = inBlockModifications;
        boolean bl = false;
        if (!object.isEmpty()) {
            try {
                Object object2;
                PerFileAnalysisCache perFileAnalysisCache = this;
                AnalysisResult analysisResult = this.fileResult;
                if (analysisResult != null) {
                    Object object3;
                    PerFileAnalysisCache perFileAnalysisCache2;
                    block12: {
                        object = analysisResult;
                        perFileAnalysisCache2 = perFileAnalysisCache;
                        bl = false;
                        boolean bl2 = false;
                        Object result2 = object;
                        boolean bl3 = false;
                        Object analysisResult2 = result2;
                        for (KtElement inBlockModification : inBlockModifications) {
                            StackedCompositeBindingContextTrace stackedCompositeBindingContextTrace;
                            StackedCompositeBindingContextTrace.StackedCompositeBindingContext stackedCtx;
                            BindingContext resultCtx = ((AnalysisResult)analysisResult2).getBindingContext();
                            StackedCompositeBindingContextTrace.StackedCompositeBindingContext stackedCompositeBindingContext = stackedCtx = resultCtx instanceof StackedCompositeBindingContextTrace.StackedCompositeBindingContext ? (StackedCompositeBindingContextTrace.StackedCompositeBindingContext)resultCtx : null;
                            if (stackedCompositeBindingContext != null) {
                                if (!stackedCompositeBindingContext.isIncrementalAnalysisApplicable()) {
                                    object3 = null;
                                    break block12;
                                }
                            }
                            if (stackedCtx != null && Intrinsics.areEqual((Object)stackedCtx.element(), (Object)inBlockModification)) {
                                StackedCompositeBindingContextTrace trace = stackedCtx.bindingTrace();
                                trace.clear();
                                stackedCompositeBindingContextTrace = trace;
                            } else {
                                StackedCompositeBindingContextTrace.StackedCompositeBindingContext stackedCompositeBindingContext2 = stackedCtx;
                                int depth2 = (stackedCompositeBindingContext2 != null ? stackedCompositeBindingContext2.depth() : 0) + 1;
                                BindingContext bindingContext2 = this.resolveSession.getBindingContext();
                                Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"resolveSession.bindingContext");
                                stackedCompositeBindingContextTrace = new StackedCompositeBindingContextTrace(depth2, inBlockModification, bindingContext2, resultCtx);
                            }
                            StackedCompositeBindingContextTrace trace = stackedCompositeBindingContextTrace;
                            AnalysisResult newResult2 = this.analyze(inBlockModification, trace);
                            analysisResult2 = this.wrapResult((AnalysisResult)result2, newResult2, trace);
                        }
                        KotlinCodeBlockModificationListenerKt.clearInBlockModifications(this.file);
                        object3 = analysisResult2;
                    }
                    Object object4 = object3;
                    perFileAnalysisCache = perFileAnalysisCache2;
                    object2 = object4;
                } else {
                    object2 = null;
                }
                perFileAnalysisCache.fileResult = object2;
            }
            catch (Throwable e) {
                if (!(e instanceof ControlFlowException)) {
                    KotlinCodeBlockModificationListenerKt.clearInBlockModifications(this.file);
                    this.fileResult = null;
                }
                throw e;
            }
        }
        return this.fileResult;
    }

    private final AnalysisResult lookUp(KtElement analyzableElement) {
        boolean bl = false;
        ArrayList<PsiElement> descendantsOfCurrent = new ArrayList<PsiElement>();
        boolean bl2 = false;
        HashSet toRemove = new HashSet();
        AnalysisResult result2 = null;
        for (PsiElement current : PsiUtilsKt.getParentsWithSelf((PsiElement)analyzableElement)) {
            AnalysisResult cached2 = this.cache.get(current);
            if (cached2 != null) {
                result2 = cached2;
                toRemove.addAll(descendantsOfCurrent);
                descendantsOfCurrent.clear();
            }
            descendantsOfCurrent.add(current);
        }
        this.cache.keySet().removeAll(toRemove);
        return result2;
    }

    private final AnalysisResult wrapResult(AnalysisResult oldResult, AnalysisResult newResult2, StackedCompositeBindingContextTrace elementBindingTrace) {
        StackedCompositeBindingContextTrace.StackedCompositeBindingContext newBindingCtx = elementBindingTrace.getStackedContext();
        return oldResult.isError() ? AnalysisResult.Companion.internalError(newBindingCtx, oldResult.getError()) : (newResult2.isError() ? AnalysisResult.Companion.internalError(newBindingCtx, newResult2.getError()) : AnalysisResult.Companion.success(newBindingCtx, oldResult.getModuleDescriptor(), oldResult.getShouldGenerateCode()));
    }

    private final AnalysisResult analyze(KtElement analyzableElement, BindingTrace bindingTrace) {
        ProgressIndicatorProvider.checkCanceled();
        Project project2 = analyzableElement.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"analyzableElement.project");
        Project project3 = project2;
        if (DumbService.isDumb((Project)project3)) {
            return AnalysisResult.Companion.getEMPTY();
        }
        try {
            return KotlinResolveDataProvider.INSTANCE.analyze(project3, this.globalContext, this.moduleDescriptor, this.resolveSession, this.codeFragmentAnalyzer, this.bodyResolveCache, analyzableElement, bindingTrace);
        }
        catch (ProcessCanceledException e) {
            throw (Throwable)e;
        }
        catch (IndexNotReadyException e) {
            throw (Throwable)e;
        }
        catch (Throwable e) {
            DiagnosticUtils.throwIfRunningOnServer(e);
            KotlinCacheServiceImplKt.getLOG().error(e);
            BindingContext bindingContext2 = BindingContext.EMPTY;
            Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"BindingContext.EMPTY");
            return AnalysisResult.Companion.internalError(bindingContext2, e);
        }
    }

    static /* synthetic */ AnalysisResult analyze$default(PerFileAnalysisCache perFileAnalysisCache, KtElement ktElement, BindingTrace bindingTrace, int n, Object object) {
        if ((n & 2) != 0) {
            bindingTrace = null;
        }
        return perFileAnalysisCache.analyze(ktElement, bindingTrace);
    }

    @NotNull
    public final KtFile getFile() {
        return this.file;
    }

    public PerFileAnalysisCache(@NotNull KtFile file2, @NotNull ComponentProvider componentProvider) {
        ComponentProvider $this$get$iv;
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)componentProvider, (String)"componentProvider");
        this.file = file2;
        ComponentProvider componentProvider2 = componentProvider;
        PerFileAnalysisCache perFileAnalysisCache = this;
        boolean $i$f$get = false;
        Object object = DslKt.getService($this$get$iv, GlobalContext.class);
        perFileAnalysisCache.globalContext = object;
        $this$get$iv = componentProvider;
        perFileAnalysisCache = this;
        $i$f$get = false;
        object = DslKt.getService($this$get$iv, ModuleDescriptor.class);
        perFileAnalysisCache.moduleDescriptor = (ModuleDescriptor)object;
        $this$get$iv = componentProvider;
        perFileAnalysisCache = this;
        $i$f$get = false;
        object = DslKt.getService($this$get$iv, ResolveSession.class);
        perFileAnalysisCache.resolveSession = (ResolveSession)object;
        $this$get$iv = componentProvider;
        perFileAnalysisCache = this;
        $i$f$get = false;
        object = DslKt.getService($this$get$iv, CodeFragmentAnalyzer.class);
        perFileAnalysisCache.codeFragmentAnalyzer = (CodeFragmentAnalyzer)object;
        $this$get$iv = componentProvider;
        perFileAnalysisCache = this;
        $i$f$get = false;
        object = DslKt.getService($this$get$iv, BodyResolveCache.class);
        perFileAnalysisCache.bodyResolveCache = (BodyResolveCache)object;
        this.cache = new HashMap();
    }
}

