/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.idea.configuration.GradleBuildScriptManipulator;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtilKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u000e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b\u001a\u0012\u0010\t\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\n\u0010\n\u001a\u00020\u000b*\u00020\f\u001a\u0012\u0010\r\u001a\u00020\u000e*\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u000e\u001a\u001e\u0010\u0010\u001a\u00020\u0011*\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0001\u001a\u000e\u0010\u0015\u001a\u00020\u0011*\u0006\u0012\u0002\b\u00030\u0012\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0019\u0010\u0003\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0016"}, d2={"MIN_GRADLE_VERSION_FOR_API_AND_IMPLEMENTATION", "Lorg/gradle/util/GradleVersion;", "kotlin.jvm.PlatformType", "MIN_GRADLE_VERSION_FOR_NEW_PLUGIN_SYNTAX", "getMIN_GRADLE_VERSION_FOR_NEW_PLUGIN_SYNTAX", "()Lorg/gradle/util/GradleVersion;", "fetchGradleVersion", "psiFile", "Lcom/intellij/psi/PsiFile;", "gradleVersionFromFile", "assertApplicableInMultiplatform", "", "Lorg/jetbrains/kotlin/config/LanguageFeature$State;", "scope", "", "directive", "useNewSyntax", "", "Lorg/jetbrains/kotlin/idea/configuration/GradleBuildScriptManipulator;", "kotlinPluginName", "gradleVersion", "usesNewMultiplatform", "idea-gradle"})
public final class GradleBuildScriptManipulatorKt {
    private static final GradleVersion MIN_GRADLE_VERSION_FOR_NEW_PLUGIN_SYNTAX = GradleVersion.version((String)"4.4");
    private static final GradleVersion MIN_GRADLE_VERSION_FOR_API_AND_IMPLEMENTATION = GradleVersion.version((String)"3.4");

    @NotNull
    public static final GradleVersion fetchGradleVersion(@NotNull PsiFile psiFile2) {
        Intrinsics.checkParameterIsNotNull((Object)psiFile2, (String)"psiFile");
        GradleVersion gradleVersion = GradleBuildScriptManipulatorKt.gradleVersionFromFile(psiFile2);
        if (gradleVersion == null) {
            GradleVersion gradleVersion2 = GradleVersion.current();
            gradleVersion = gradleVersion2;
            Intrinsics.checkExpressionValueIsNotNull((Object)gradleVersion2, (String)"GradleVersion.current()");
        }
        return gradleVersion;
    }

    private static final GradleVersion gradleVersionFromFile(PsiFile psiFile2) {
        Module module = ProjectRootsUtilKt.getModule((PsiElement)psiFile2);
        if (module == null) {
            return null;
        }
        Module module2 = module;
        String string = ExternalSystemApiUtil.getExternalProjectPath((Module)module2);
        if (string == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ExternalSystemApiUtil.ge\u2026th(module) ?: return null");
        String path2 = string;
        GradleProjectSettings gradleProjectSettings = (GradleProjectSettings)GradleSettings.getInstance((Project)module2.getProject()).getLinkedProjectSettings(path2);
        return gradleProjectSettings != null ? gradleProjectSettings.resolveGradleVersion() : null;
    }

    public static final GradleVersion getMIN_GRADLE_VERSION_FOR_NEW_PLUGIN_SYNTAX() {
        return MIN_GRADLE_VERSION_FOR_NEW_PLUGIN_SYNTAX;
    }

    public static final boolean useNewSyntax(@NotNull GradleBuildScriptManipulator<?> $this$useNewSyntax, @NotNull String kotlinPluginName, @NotNull GradleVersion gradleVersion) {
        String fileText2;
        Intrinsics.checkParameterIsNotNull($this$useNewSyntax, (String)"$this$useNewSyntax");
        Intrinsics.checkParameterIsNotNull((Object)kotlinPluginName, (String)"kotlinPluginName");
        Intrinsics.checkParameterIsNotNull((Object)gradleVersion, (String)"gradleVersion");
        if (!$this$useNewSyntax.getPreferNewSyntax()) {
            return false;
        }
        if (gradleVersion.compareTo(MIN_GRADLE_VERSION_FOR_NEW_PLUGIN_SYNTAX) < 0) {
            return false;
        }
        if ($this$useNewSyntax.isConfiguredWithOldSyntax(kotlinPluginName)) {
            return false;
        }
        String string = fileText2 = (String)ApplicationUtilsKt.runReadAction((Function0)new Function0<String>($this$useNewSyntax){
            final /* synthetic */ GradleBuildScriptManipulator $this_useNewSyntax;

            public final String invoke() {
                return this.$this_useNewSyntax.getScriptFile().getText();
            }
            {
                this.$this_useNewSyntax = gradleBuildScriptManipulator;
                super(0);
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fileText");
        boolean hasOldApply = StringsKt.contains$default((CharSequence)string, (CharSequence)"apply plugin:", (boolean)false, (int)2, null);
        return !hasOldApply;
    }

    public static final boolean usesNewMultiplatform(@NotNull GradleBuildScriptManipulator<?> $this$usesNewMultiplatform) {
        String fileText2;
        Intrinsics.checkParameterIsNotNull($this$usesNewMultiplatform, (String)"$this$usesNewMultiplatform");
        String string = fileText2 = (String)ApplicationUtilsKt.runReadAction((Function0)new Function0<String>($this$usesNewMultiplatform){
            final /* synthetic */ GradleBuildScriptManipulator $this_usesNewMultiplatform;

            public final String invoke() {
                return this.$this_usesNewMultiplatform.getScriptFile().getText();
            }
            {
                this.$this_usesNewMultiplatform = gradleBuildScriptManipulator;
                super(0);
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fileText");
        return StringsKt.contains$default((CharSequence)string, (CharSequence)"multiplatform", (boolean)false, (int)2, null);
    }

    public static final void assertApplicableInMultiplatform(@NotNull LanguageFeature.State $this$assertApplicableInMultiplatform) {
        Intrinsics.checkParameterIsNotNull((Object)$this$assertApplicableInMultiplatform, (String)"$this$assertApplicableInMultiplatform");
        if ($this$assertApplicableInMultiplatform == LanguageFeature.State.ENABLED_WITH_ERROR || $this$assertApplicableInMultiplatform == LanguageFeature.State.DISABLED) {
            throw (Throwable)new UnsupportedOperationException("Disabling the language feature is unsupported for multiplatform");
        }
    }

    @NotNull
    public static final String scope(@NotNull GradleVersion $this$scope, @NotNull String directive) {
        Intrinsics.checkParameterIsNotNull((Object)$this$scope, (String)"$this$scope");
        Intrinsics.checkParameterIsNotNull((Object)directive, (String)"directive");
        if ($this$scope.compareTo(MIN_GRADLE_VERSION_FOR_API_AND_IMPLEMENTATION) < 0) {
            String string;
            switch (directive) {
                case "implementation": {
                    string = "compile";
                    break;
                }
                case "testImplementation": {
                    string = "testCompile";
                    break;
                }
                default: {
                    throw (Throwable)new IllegalArgumentException("Unknown directive `" + directive + '`');
                }
            }
            return string;
        }
        return directive;
    }
}

