/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.SystemProperties;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.project.AbstractProjectResolverExtension;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0002J.\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0011H\u0016J\u0016\u0010\u0012\u001a\u00020\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0011H\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinGradleCoroutineDebugProjectResolver;", "Lorg/jetbrains/plugins/gradle/service/project/AbstractProjectResolverExtension;", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "coroutineDebuggerEnabled", "", "enhanceTaskProcessing", "", "taskNames", "", "", "jvmParametersSetup", "initScriptConsumer", "Lcom/intellij/util/Consumer;", "setupCoroutineAgentForJvmForkedTestTasks", "idea-gradle"})
public final class KotlinGradleCoroutineDebugProjectResolver
extends AbstractProjectResolverExtension {
    @NotNull
    private final Logger log;

    @NotNull
    public final Logger getLog() {
        return this.log;
    }

    public void enhanceTaskProcessing(@NotNull List<String> taskNames, @Nullable String jvmParametersSetup, @NotNull Consumer<String> initScriptConsumer) {
        Intrinsics.checkParameterIsNotNull(taskNames, (String)"taskNames");
        Intrinsics.checkParameterIsNotNull(initScriptConsumer, (String)"initScriptConsumer");
        try {
            if (this.coroutineDebuggerEnabled()) {
                this.setupCoroutineAgentForJvmForkedTestTasks(initScriptConsumer);
            }
        }
        catch (Exception e) {
            this.log.error("Gradle: not possible to attach coroutine debugger agent. Coroutine debugger disabled.", (Throwable)e);
        }
    }

    private final void setupCoroutineAgentForJvmForkedTestTasks(Consumer<String> initScriptConsumer) {
        String[] lines = new String[]{"gradle.taskGraph.beforeTask { Task task ->", "  if (task instanceof Test) {", "    def kotlinxCoroutinesDebugJar = task.classpath.find { it.name.startsWith(\"kotlinx-coroutines-debug\") }", "    if (kotlinxCoroutinesDebugJar)", "        task.jvmArgs (\"-javaagent:${kotlinxCoroutinesDebugJar?.absolutePath}\", \"-ea\")", "  }", "}"};
        String string = StringUtil.join((String[])lines, (String)SystemProperties.getLineSeparator());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringUtil.join(lines, S\u2026rties.getLineSeparator())");
        String script = string;
        initScriptConsumer.consume((Object)script);
    }

    private final boolean coroutineDebuggerEnabled() {
        return Registry.is((String)"kotlin.debugger.coroutines");
    }

    public KotlinGradleCoroutineDebugProjectResolver() {
        Logger logger = Logger.getInstance(((Object)((Object)this)).getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(this::class.java)");
        this.log = logger;
    }
}

