/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProviderImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.config.KotlinFacetSettings;
import org.jetbrains.kotlin.idea.compiler.configuration.Kotlin2JvmCompilerArgumentsHolder;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.KotlinJavaModuleConfigurator;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;
import org.jetbrains.kotlin.idea.configuration.KotlinWithLibraryConfigurator;
import org.jetbrains.kotlin.idea.configuration.NotificationMessageCollector;
import org.jetbrains.kotlin.idea.facet.FacetUtilsKt;
import org.jetbrains.kotlin.idea.facet.KotlinFacet;
import org.jetbrains.kotlin.idea.facet.KotlinFacetConfiguration;
import org.jetbrains.kotlin.idea.framework.JavaRuntimeLibraryDescription;
import org.jetbrains.kotlin.idea.framework.JsLibraryStdDetectionUtil;
import org.jetbrains.kotlin.idea.util.projectStructure.ProjectStructureUtilKt;
import org.jetbrains.kotlin.idea.versions.LibraryJarDescriptor;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatforms;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 22\u00020\u0001:\u00012B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0014J:\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020\rH\u0016J\u0018\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\u001f2\b\u0010,\u001a\u0004\u0018\u00010-H\u0016J\b\u0010\u001a\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020\r2\u0006\u0010\"\u001a\u00020 H\u0002J\u0010\u00100\u001a\u00020\r2\u0006\u0010\"\u001a\u00020 H\u0014J\u0010\u00101\u001a\u00020\r2\u0006\u0010\"\u001a\u00020 H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R&\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\nX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0006R\u0014\u0010\u0012\u001a\u00020\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0006R\u0014\u0010\u0014\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0006R\u0014\u0010\u0016\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0006R\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinJavaModuleConfigurator;", "Lorg/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator;", "()V", "dialogTitle", "", "getDialogTitle", "()Ljava/lang/String;", "libraryCaption", "getLibraryCaption", "libraryMatcher", "Lkotlin/Function2;", "Lcom/intellij/openapi/roots/libraries/Library;", "Lcom/intellij/openapi/project/Project;", "", "getLibraryMatcher", "()Lkotlin/jvm/functions/Function2;", "libraryName", "getLibraryName", "messageForOverrideDialog", "getMessageForOverrideDialog", "name", "getName", "presentableText", "getPresentableText", "targetPlatform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getTargetPlatform", "()Lorg/jetbrains/kotlin/platform/TargetPlatform;", "configureKotlinSettings", "", "modules", "", "Lcom/intellij/openapi/module/Module;", "configureModule", "module", "classesPath", "sourcesPath", "collector", "Lorg/jetbrains/kotlin/idea/configuration/NotificationMessageCollector;", "forceJarState", "Lorg/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator$FileState;", "useBundled", "getLibraryJarDescriptors", "Lorg/jetbrains/kotlin/idea/versions/LibraryJarDescriptor;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "Lorg/jetbrains/kotlin/platform/jvm/JvmPlatforms$CompatJvmPlatform;", "hasBrokenJsRuntime", "isApplicable", "isConfigured", "Companion", "idea-jvm"})
public class KotlinJavaModuleConfigurator
extends KotlinWithLibraryConfigurator {
    @NotNull
    private final Function2<Library, Project, Boolean> libraryMatcher = libraryMatcher.1.INSTANCE;
    @NotNull
    public static final String NAME = "java";
    public static final Companion Companion = new Companion(null);

    @Override
    protected boolean isApplicable(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        return super.isApplicable(module) && !this.hasBrokenJsRuntime(module);
    }

    @Override
    public boolean isConfigured(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        return ConfigureKotlinInProjectUtilsKt.hasKotlinJvmRuntimeInScope(module);
    }

    @Override
    @NotNull
    protected String getLibraryName() {
        return JavaRuntimeLibraryDescription.Companion.getLIBRARY_NAME();
    }

    @Override
    @NotNull
    protected String getDialogTitle() {
        return JavaRuntimeLibraryDescription.Companion.getDIALOG_TITLE();
    }

    @Override
    @NotNull
    protected String getLibraryCaption() {
        return JavaRuntimeLibraryDescription.Companion.getLIBRARY_CAPTION();
    }

    @Override
    @NotNull
    protected String getMessageForOverrideDialog() {
        return JavaRuntimeLibraryDescription.Companion.getJAVA_RUNTIME_LIBRARY_CREATION();
    }

    @Override
    @NotNull
    public String getPresentableText() {
        return "Java";
    }

    @Override
    @NotNull
    public String getName() {
        return NAME;
    }

    @Override
    @NotNull
    public TargetPlatform getTargetPlatform() {
        return JvmPlatforms.INSTANCE.getUnspecifiedJvmPlatform();
    }

    @Override
    @NotNull
    public JvmPlatforms.CompatJvmPlatform getTargetPlatform() {
        return JvmPlatforms.CompatJvmPlatform.INSTANCE;
    }

    @Override
    @NotNull
    public List<LibraryJarDescriptor> getLibraryJarDescriptors(@Nullable Sdk sdk2) {
        boolean bl;
        Iterable iterable;
        Collection collection;
        List result2 = CollectionsKt.mutableListOf((Object[])new LibraryJarDescriptor[]{LibraryJarDescriptor.RUNTIME_JAR, LibraryJarDescriptor.RUNTIME_SRC_JAR, LibraryJarDescriptor.REFLECT_JAR, LibraryJarDescriptor.REFLECT_SRC_JAR, LibraryJarDescriptor.TEST_JAR, LibraryJarDescriptor.TEST_SRC_JAR});
        Sdk sdk3 = sdk2;
        if (sdk3 == null || (sdk3 = ProjectStructureUtilKt.getVersion(sdk3)) == null) {
            return result2;
        }
        Sdk sdkVersion = sdk3;
        if (sdkVersion.isAtLeast(JavaSdkVersion.JDK_1_7)) {
            collection = result2;
            iterable = CollectionsKt.listOf((Object[])new LibraryJarDescriptor[]{LibraryJarDescriptor.RUNTIME_JDK7_JAR, LibraryJarDescriptor.RUNTIME_JDK7_SOURCES_JAR});
            bl = false;
            CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        }
        if (sdkVersion.isAtLeast(JavaSdkVersion.JDK_1_8)) {
            collection = result2;
            iterable = CollectionsKt.listOf((Object[])new LibraryJarDescriptor[]{LibraryJarDescriptor.RUNTIME_JDK8_JAR, LibraryJarDescriptor.RUNTIME_JDK8_SOURCES_JAR});
            bl = false;
            CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        }
        return result2;
    }

    @Override
    @NotNull
    protected Function2<Library, Project, Boolean> getLibraryMatcher() {
        return this.libraryMatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void configureKotlinSettings(@NotNull List<? extends Module> modules2) {
        boolean canChangeProjectSettings;
        Module project2;
        block11: {
            boolean bl;
            Intrinsics.checkParameterIsNotNull(modules2, (String)"modules");
            Module module = (Module)CollectionsKt.firstOrNull(modules2);
            if (module == null || (module = module.getProject()) == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)module, (String)"modules.firstOrNull()?.project ?: return");
            project2 = module;
            Iterable iterable = ProjectStructureUtilKt.allModules((Project)project2);
            boolean $i$f$all = false;
            if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : iterable) {
                    Module it = (Module)element$iv;
                    boolean bl2 = false;
                    Module module2 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)module2, (String)"it");
                    Sdk sdk2 = ProjectStructureUtilKt.getSdk(module2);
                    if (sdk2 != null && (sdk2 = ProjectStructureUtilKt.getVersion(sdk2)) != null ? sdk2.isAtLeast(JavaSdkVersion.JDK_1_8) : true) continue;
                    bl = false;
                    break block11;
                }
                bl = canChangeProjectSettings = true;
            }
        }
        if (canChangeProjectSettings) {
            Kotlin2JvmCompilerArgumentsHolder.Companion.getInstance((Project)project2).update(configureKotlinSettings.1.INSTANCE);
        } else {
            for (Module module : modules2) {
                Sdk sdk3 = ProjectStructureUtilKt.getSdk(module);
                Object sdkVersion = sdk3 != null ? ProjectStructureUtilKt.getVersion(sdk3) : null;
                if (sdkVersion == null || !sdkVersion.isAtLeast(JavaSdkVersion.JDK_1_8)) continue;
                IdeModifiableModelsProviderImpl modelsProvider = new IdeModifiableModelsProviderImpl((Project)project2);
                try {
                    KotlinFacet facet = FacetUtilsKt.getOrCreateFacet$default(module, (IdeModifiableModelsProvider)modelsProvider, false, null, true, 4, null);
                    KotlinFacetSettings facetSettings = ((KotlinFacetConfiguration)facet.getConfiguration()).getSettings();
                    FacetUtilsKt.initializeIfNeeded$default(facetSettings, module, null, JvmPlatforms.INSTANCE.getJvm18(), null, 8, null);
                    CommonCompilerArguments commonCompilerArguments = facetSettings.getCompilerArguments();
                    if (!(commonCompilerArguments instanceof K2JVMCompilerArguments)) {
                        commonCompilerArguments = null;
                    }
                    K2JVMCompilerArguments k2JVMCompilerArguments = (K2JVMCompilerArguments)commonCompilerArguments;
                    if (k2JVMCompilerArguments == null) continue;
                    k2JVMCompilerArguments.setJvmTarget("1.8");
                }
                finally {
                    modelsProvider.dispose();
                }
            }
        }
    }

    @Override
    public void configureModule(@NotNull Module module, @NotNull String classesPath, @NotNull String sourcesPath, @NotNull NotificationMessageCollector collector2, @Nullable KotlinWithLibraryConfigurator.FileState forceJarState, boolean useBundled) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)classesPath, (String)"classesPath");
        Intrinsics.checkParameterIsNotNull((Object)sourcesPath, (String)"sourcesPath");
        Intrinsics.checkParameterIsNotNull((Object)collector2, (String)"collector");
        super.configureModule(module, classesPath, sourcesPath, collector2, forceJarState, useBundled);
        ConfigureKotlinInProjectUtilsKt.addStdlibToJavaModuleInfo(module, collector2);
    }

    private final boolean hasBrokenJsRuntime(Module module) {
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
        for (OrderEntry orderEntry : moduleRootManager.getOrderEntries()) {
            LibraryEx library2;
            OrderEntry orderEntry2 = orderEntry;
            if (!(orderEntry2 instanceof LibraryOrderEntry)) {
                orderEntry2 = null;
            }
            LibraryOrderEntry libraryOrderEntry = (LibraryOrderEntry)orderEntry2;
            Object object = libraryOrderEntry != null ? libraryOrderEntry.getLibrary() : null;
            if (!(object instanceof LibraryEx)) {
                object = null;
            }
            if ((LibraryEx)object == null) {
                continue;
            }
            Library library3 = (Library)library2;
            Project project2 = module.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"module.project");
            if (!JsLibraryStdDetectionUtil.INSTANCE.hasJsStdlibJar(library3, project2, true)) continue;
            return true;
        }
        return false;
    }

    protected KotlinJavaModuleConfigurator() {
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinJavaModuleConfigurator$Companion;", "", "()V", "NAME", "", "instance", "Lorg/jetbrains/kotlin/idea/configuration/KotlinJavaModuleConfigurator;", "getInstance", "()Lorg/jetbrains/kotlin/idea/configuration/KotlinJavaModuleConfigurator;", "idea-jvm"})
    public static final class Companion {
        @NotNull
        public final KotlinJavaModuleConfigurator getInstance() {
            Object object = Extensions.findExtension(KotlinProjectConfigurator.Companion.getEP_NAME(), KotlinJavaModuleConfigurator.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"Extensions.findExtension\u2026Configurator::class.java)");
            return (KotlinJavaModuleConfigurator)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

