/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.configuration.RepositoryDescription;
import org.jetbrains.kotlin.idea.configuration.SettingsScriptBuilder;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0005J\u0014\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\u0006\u0010\u0011\u001a\u00020\rJ\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H&J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0010H\u0004J\u000e\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0010J\u0018\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0006\u0010\u001c\u001a\u00020\u0010J\u0015\u0010\u001d\u001a\u00028\u00002\u0006\u0010\u001e\u001a\u00020\u001fH&\u00a2\u0006\u0002\u0010 J\u001a\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u00102\b\b\u0002\u0010#\u001a\u00020\u001bH\u0002J\u0018\u0010$\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010%\u001a\u00020\u001bH\u0002J\u0010\u0010&\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u0010H\u0002R\u0012\u0010\u0006\u001a\u00060\u0007j\u0002`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\n\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/SettingsScriptBuilder;", "T", "Lcom/intellij/psi/PsiFile;", "", "scriptFile", "(Lcom/intellij/psi/PsiFile;)V", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getScriptFile", "()Lcom/intellij/psi/PsiFile;", "Lcom/intellij/psi/PsiFile;", "addIncludedModules", "", "modules", "", "", "addMavenCentralPluginRepository", "addPluginRepository", "repository", "Lorg/jetbrains/kotlin/idea/configuration/RepositoryDescription;", "addPluginRepositoryExpression", "expression", "addResolutionStrategy", "pluginId", "appendExpressionToBlockIfAbsent", "offset", "", "build", "buildPsiFile", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)Lcom/intellij/psi/PsiFile;", "findBlockBody", "blockName", "startFrom", "getOrAppendInnerBlockBody", "getOrCreatePluginManagementBody", "getOrPrependTopLevelBlockBody", "idea-gradle"})
public abstract class SettingsScriptBuilder<T extends PsiFile> {
    private final StringBuilder builder;
    @NotNull
    private final T scriptFile;

    private final int findBlockBody(String blockName, int startFrom) {
        int blockOffset = this.builder.indexOf(blockName, startFrom);
        if (blockOffset < 0) {
            return -1;
        }
        return StringsKt.indexOf$default((CharSequence)this.builder, (char)'{', (int)(blockOffset + 1), (boolean)false, (int)4, null) + 1;
    }

    static /* synthetic */ int findBlockBody$default(SettingsScriptBuilder settingsScriptBuilder, String string, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findBlockBody");
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return settingsScriptBuilder.findBlockBody(string, n);
    }

    private final int getOrPrependTopLevelBlockBody(String blockName) {
        int blockBody = SettingsScriptBuilder.findBlockBody$default(this, blockName, 0, 2, null);
        if (blockBody >= 0) {
            return blockBody;
        }
        this.builder.insert(0, blockName + " {}\n");
        return SettingsScriptBuilder.findBlockBody$default(this, blockName, 0, 2, null);
    }

    private final int getOrAppendInnerBlockBody(String blockName, int offset2) {
        int repositoriesBody = this.findBlockBody(blockName, offset2);
        if (repositoriesBody >= 0) {
            return repositoriesBody;
        }
        this.builder.insert(offset2, '\n' + blockName + " {}\n");
        return this.findBlockBody(blockName, offset2);
    }

    /*
     * WARNING - void declaration
     */
    private final void appendExpressionToBlockIfAbsent(String expression2, int offset2) {
        int braceCount = 1;
        int blockEnd = offset2;
        int n = offset2;
        int n2 = StringsKt.getLastIndex((CharSequence)this.builder);
        if (n <= n2) {
            while (true) {
                void i2;
                switch (this.builder.charAt((int)i2)) {
                    case '{': {
                        ++braceCount;
                        break;
                    }
                    case '}': {
                        --braceCount;
                        break;
                    }
                }
                if (braceCount == 0) {
                    blockEnd = i2;
                    break;
                }
                if (i2 == n2) break;
                ++i2;
            }
        }
        String string = this.builder.substring(offset2, blockEnd);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"builder.substring(offset, blockEnd)");
        String string2 = expression2;
        CharSequence charSequence = string;
        n2 = 0;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String string4 = ((Object)StringsKt.trim((CharSequence)string3)).toString();
        if (!StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string4, (boolean)false, (int)2, null)) {
            this.builder.insert(blockEnd, '\n' + expression2 + '\n');
        }
    }

    private final int getOrCreatePluginManagementBody() {
        return this.getOrPrependTopLevelBlockBody("pluginManagement");
    }

    protected final void addPluginRepositoryExpression(@NotNull String expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        int repositoriesBody = this.getOrAppendInnerBlockBody("repositories", this.getOrCreatePluginManagementBody());
        this.appendExpressionToBlockIfAbsent(expression2, repositoriesBody);
    }

    public final void addMavenCentralPluginRepository() {
        this.addPluginRepositoryExpression("mavenCentral()");
    }

    public abstract void addPluginRepository(@NotNull RepositoryDescription var1);

    public final void addResolutionStrategy(@NotNull String pluginId) {
        Intrinsics.checkParameterIsNotNull((Object)pluginId, (String)"pluginId");
        int resolutionStrategyBody = this.getOrAppendInnerBlockBody("resolutionStrategy", this.getOrCreatePluginManagementBody());
        int eachPluginBody = this.getOrAppendInnerBlockBody("eachPlugin", resolutionStrategyBody);
        this.appendExpressionToBlockIfAbsent(StringsKt.trimIndent((String)("\n                if (requested.id.id == \"" + pluginId + "\") {\n                    useModule(\"org.jetbrains.kotlin:kotlin-gradle-plugin:${requested.version}\")\n                }\n            ")), eachPluginBody);
    }

    public final void addIncludedModules(@NotNull List<String> modules2) {
        Intrinsics.checkParameterIsNotNull(modules2, (String)"modules");
        this.builder.append(CollectionsKt.joinToString$default((Iterable)modules2, null, (CharSequence)"include ", (CharSequence)"\n", (int)0, null, (Function1)addIncludedModules.1.INSTANCE, (int)25, null));
    }

    @NotNull
    public final String build() {
        String string = this.builder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"builder.toString()");
        return string;
    }

    @NotNull
    public abstract T buildPsiFile(@NotNull Project var1);

    @NotNull
    public final T getScriptFile() {
        return this.scriptFile;
    }

    public SettingsScriptBuilder(@NotNull T scriptFile) {
        Intrinsics.checkParameterIsNotNull(scriptFile, (String)"scriptFile");
        this.scriptFile = scriptFile;
        this.builder = new StringBuilder(this.scriptFile.getText());
    }
}

