/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.formatter;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.PackageEntry;
import com.intellij.psi.codeStyle.PackageEntryTable;
import com.intellij.util.ReflectionUtil;
import java.lang.reflect.Field;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.formatter.KotlinObsoleteCodeStyle;
import org.jetbrains.kotlin.idea.formatter.KotlinStyleGuideCodeStyle;
import org.jetbrains.kotlin.idea.util.FormatterUtilKt;
import org.jetbrains.kotlin.idea.util.ReflectionUtil;

public class KotlinCodeStyleSettings
extends CustomCodeStyleSettings {
    public final PackageEntryTable PACKAGES_TO_USE_STAR_IMPORTS = new PackageEntryTable();
    public boolean SPACE_AROUND_RANGE = false;
    public boolean SPACE_BEFORE_TYPE_COLON = false;
    public boolean SPACE_AFTER_TYPE_COLON = true;
    public boolean SPACE_BEFORE_EXTEND_COLON = true;
    public boolean SPACE_AFTER_EXTEND_COLON = true;
    public boolean INSERT_WHITESPACES_IN_SIMPLE_ONE_LINE_METHOD = true;
    public boolean ALIGN_IN_COLUMNS_CASE_BRANCH = false;
    public boolean SPACE_AROUND_FUNCTION_TYPE_ARROW = true;
    public boolean SPACE_AROUND_WHEN_ARROW = true;
    public boolean SPACE_BEFORE_LAMBDA_ARROW = true;
    public boolean SPACE_BEFORE_WHEN_PARENTHESES = true;
    public boolean LBRACE_ON_NEXT_LINE = false;
    public int NAME_COUNT_TO_USE_STAR_IMPORT = ApplicationManager.getApplication().isUnitTestMode() ? Integer.MAX_VALUE : 5;
    public int NAME_COUNT_TO_USE_STAR_IMPORT_FOR_MEMBERS = ApplicationManager.getApplication().isUnitTestMode() ? Integer.MAX_VALUE : 3;
    public boolean IMPORT_NESTED_CLASSES = false;
    public boolean CONTINUATION_INDENT_IN_PARAMETER_LISTS = true;
    public boolean CONTINUATION_INDENT_IN_ARGUMENT_LISTS = true;
    public boolean CONTINUATION_INDENT_FOR_EXPRESSION_BODIES = true;
    public boolean CONTINUATION_INDENT_FOR_CHAINED_CALLS = true;
    public boolean CONTINUATION_INDENT_IN_SUPERTYPE_LISTS = true;
    public boolean CONTINUATION_INDENT_IN_IF_CONDITIONS = true;
    public boolean CONTINUATION_INDENT_IN_ELVIS = true;
    public int BLANK_LINES_AROUND_BLOCK_WHEN_BRANCHES = 0;
    public int WRAP_EXPRESSION_BODY_FUNCTIONS = 0;
    public int WRAP_ELVIS_EXPRESSIONS = 1;
    public boolean IF_RPAREN_ON_NEW_LINE = false;
    @ReflectionUtil.SkipInEquals
    public String CODE_STYLE_DEFAULTS = null;
    @Nullable
    private KotlinCodeStyleSettings settingsAgainstPreviousDefaults = null;
    private final boolean isTempForDeserialize;

    public KotlinCodeStyleSettings(CodeStyleSettings container2) {
        this(container2, false);
    }

    private KotlinCodeStyleSettings(CodeStyleSettings container2, boolean isTempForDeserialize) {
        super("JetCodeStyleSettings", container2);
        this.isTempForDeserialize = isTempForDeserialize;
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.PACKAGES_TO_USE_STAR_IMPORTS.addEntry(new PackageEntry(false, "java.util", false));
            this.PACKAGES_TO_USE_STAR_IMPORTS.addEntry(new PackageEntry(false, "kotlinx.android.synthetic", true));
        }
    }

    public static KotlinCodeStyleSettings getInstance(Project project2) {
        return (KotlinCodeStyleSettings)CodeStyle.getSettings((Project)project2).getCustomSettings(KotlinCodeStyleSettings.class);
    }

    public Object clone() {
        return this.cloneSettings();
    }

    @NotNull
    public KotlinCodeStyleSettings cloneSettings() {
        KotlinCodeStyleSettings clone2 = new KotlinCodeStyleSettings(this.getContainer());
        clone2.copyFrom(this);
        clone2.settingsAgainstPreviousDefaults = this.settingsAgainstPreviousDefaults;
        KotlinCodeStyleSettings kotlinCodeStyleSettings = clone2;
        if (kotlinCodeStyleSettings == null) {
            KotlinCodeStyleSettings.$$$reportNull$$$0(0);
        }
        return kotlinCodeStyleSettings;
    }

    private void copyFrom(@NotNull KotlinCodeStyleSettings from) {
        if (from == null) {
            KotlinCodeStyleSettings.$$$reportNull$$$0(1);
        }
        ReflectionUtil.copyFields((Field[])((Object)((Object)this)).getClass().getFields(), (Object)((Object)from), (Object)((Object)this));
        this.PACKAGES_TO_USE_STAR_IMPORTS.copyFrom(from.PACKAGES_TO_USE_STAR_IMPORTS);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof KotlinCodeStyleSettings)) {
            return false;
        }
        return org.jetbrains.kotlin.idea.util.ReflectionUtil.comparePublicNonFinalFieldsWithSkip((Object)this, obj);
    }

    public void writeExternal(Element parentElement, @NotNull CustomCodeStyleSettings parentSettings) throws WriteExternalException {
        if (parentSettings == null) {
            KotlinCodeStyleSettings.$$$reportNull$$$0(2);
        }
        if (this.CODE_STYLE_DEFAULTS != null) {
            KotlinCodeStyleSettings defaultKotlinCodeStyle = (KotlinCodeStyleSettings)((Object)parentSettings.clone());
            if ("KOTLIN_OFFICIAL".equals(this.CODE_STYLE_DEFAULTS)) {
                KotlinStyleGuideCodeStyle.Companion.applyToKotlinCustomSettings(defaultKotlinCodeStyle, false);
            } else if ("KOTLIN_OLD_DEFAULTS".equals(this.CODE_STYLE_DEFAULTS)) {
                KotlinObsoleteCodeStyle.Companion.applyToKotlinCustomSettings(defaultKotlinCodeStyle, false);
            }
            parentSettings = defaultKotlinCodeStyle;
        }
        super.writeExternal(parentElement, parentSettings);
    }

    public void readExternal(Element parentElement) throws InvalidDataException {
        if (this.isTempForDeserialize) {
            super.readExternal(parentElement);
            return;
        }
        KotlinCodeStyleSettings tempSettings = KotlinCodeStyleSettings.readExternalToTemp(parentElement);
        String customDefaults = tempSettings.CODE_STYLE_DEFAULTS;
        if ("KOTLIN_OFFICIAL".equals(customDefaults)) {
            KotlinStyleGuideCodeStyle.Companion.applyToKotlinCustomSettings(this, true);
        } else if ("KOTLIN_OLD_DEFAULTS".equals(customDefaults)) {
            KotlinObsoleteCodeStyle.Companion.applyToKotlinCustomSettings(this, true);
        } else if (customDefaults == null && FormatterUtilKt.isDefaultOfficialCodeStyle()) {
            this.settingsAgainstPreviousDefaults = new KotlinCodeStyleSettings(null, true);
            KotlinObsoleteCodeStyle.Companion.applyToKotlinCustomSettings(this.settingsAgainstPreviousDefaults, true);
            this.settingsAgainstPreviousDefaults.readExternal(parentElement);
        }
        super.readExternal(parentElement);
    }

    private static KotlinCodeStyleSettings readExternalToTemp(Element parentElement) {
        KotlinCodeStyleSettings tempSettings = new KotlinCodeStyleSettings(null, true);
        tempSettings.readExternal(parentElement);
        return tempSettings;
    }

    public boolean canRestore() {
        return this.settingsAgainstPreviousDefaults != null;
    }

    public void restore() {
        if (this.settingsAgainstPreviousDefaults != null) {
            this.copyFrom(this.settingsAgainstPreviousDefaults);
        }
    }

    public static KotlinCodeStyleSettings defaultSettings() {
        return ((KotlinCodeStyleSettingsHolder)ServiceManager.getService(KotlinCodeStyleSettingsHolder.class)).defaultSettings;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/core/formatter/KotlinCodeStyleSettings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneSettings";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/core/formatter/KotlinCodeStyleSettings";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "copyFrom";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class KotlinCodeStyleSettingsHolder {
        private final KotlinCodeStyleSettings defaultSettings = new KotlinCodeStyleSettings(new CodeStyleSettings());
    }
}

