/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script;

import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.TrafficLightRenderer;
import com.intellij.codeInsight.daemon.impl.TrafficLightRendererContributor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.script.ScriptConfigurationManager;
import org.jetbrains.kotlin.idea.core.script.ScriptDefinitionsManager;
import org.jetbrains.kotlin.idea.core.util.KotlinIdeaCoreBundle;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/ScriptTrafficLightRendererContributor;", "Lcom/intellij/codeInsight/daemon/impl/TrafficLightRendererContributor;", "()V", "createRenderer", "Lcom/intellij/codeInsight/daemon/impl/TrafficLightRenderer;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "ScriptTrafficLightRenderer", "idea-core"})
public final class ScriptTrafficLightRendererContributor
implements TrafficLightRendererContributor {
    @Nullable
    public TrafficLightRenderer createRenderer(@NotNull Editor editor2, @Nullable PsiFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)editor2, (String)"editor");
        PsiFile psiFile2 = file2;
        if (!(psiFile2 instanceof KtFile)) {
            psiFile2 = null;
        }
        KtFile ktFile = (KtFile)psiFile2;
        if (ktFile != null) {
            if (ktFile.isScript()) {
                Project project2 = ((KtFile)file2).getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"file.project");
                Document document = editor2.getDocument();
                Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"editor.document");
                return new ScriptTrafficLightRenderer(project2, document, (KtFile)file2);
            }
        }
        return null;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/ScriptTrafficLightRendererContributor$ScriptTrafficLightRenderer;", "Lcom/intellij/codeInsight/daemon/impl/TrafficLightRenderer;", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Document;Lorg/jetbrains/kotlin/psi/KtFile;)V", "getDaemonCodeAnalyzerStatus", "Lcom/intellij/codeInsight/daemon/impl/TrafficLightRenderer$DaemonCodeAnalyzerStatus;", "severityRegistrar", "Lcom/intellij/codeInsight/daemon/impl/SeverityRegistrar;", "idea-core"})
    public static final class ScriptTrafficLightRenderer
    extends TrafficLightRenderer {
        private final KtFile file;

        @NotNull
        protected TrafficLightRenderer.DaemonCodeAnalyzerStatus getDaemonCodeAnalyzerStatus(@NotNull SeverityRegistrar severityRegistrar) {
            Intrinsics.checkParameterIsNotNull((Object)severityRegistrar, (String)"severityRegistrar");
            TrafficLightRenderer.DaemonCodeAnalyzerStatus daemonCodeAnalyzerStatus = super.getDaemonCodeAnalyzerStatus(severityRegistrar);
            Intrinsics.checkExpressionValueIsNotNull((Object)daemonCodeAnalyzerStatus, (String)"super.getDaemonCodeAnaly\u2026Status(severityRegistrar)");
            TrafficLightRenderer.DaemonCodeAnalyzerStatus status2 = daemonCodeAnalyzerStatus;
            Project project2 = this.file.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"file.project");
            if (!ScriptDefinitionsManager.Companion.getInstance(project2).isReady()) {
                status2.reasonWhySuspended = KotlinIdeaCoreBundle.message("text.loading.kotlin.script.definitions", new Object[0]);
                status2.errorAnalyzingFinished = false;
            } else {
                Project project3 = this.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
                if (!ScriptConfigurationManager.Companion.getInstance(project3).hasConfiguration(this.file)) {
                    PsiFile psiFile2 = this.file.getOriginalFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiFile2, (String)"file.originalFile");
                    VirtualFile virtualFile2 = psiFile2.getVirtualFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"file.originalFile.virtualFile");
                    if (!ScriptConfigurationManager.Companion.isManualConfigurationLoading(virtualFile2)) {
                        status2.reasonWhySuspended = KotlinIdeaCoreBundle.message("text.loading.kotlin.script.dependencies", new Object[0]);
                        status2.errorAnalyzingFinished = false;
                    }
                }
            }
            return status2;
        }

        public ScriptTrafficLightRenderer(@NotNull Project project2, @NotNull Document document, @NotNull KtFile file2) {
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            super(project2, document, (PsiFile)file2);
            this.file = file2;
        }
    }
}

