/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.JVMName;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.jdi.ClassesByNameProvider;
import com.intellij.debugger.jdi.MethodBytecodeUtil;
import com.intellij.debugger.requests.Requestor;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointWithHighlighter;
import com.intellij.debugger.ui.breakpoints.FilteredRequestor;
import com.intellij.debugger.ui.breakpoints.MethodBreakpoint;
import com.intellij.debugger.ui.breakpoints.MethodBreakpointBase;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.DocumentUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointListener;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.sun.jdi.ClassType;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.MethodExitEvent;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.MethodEntryRequest;
import com.sun.jdi.request.MethodExitRequest;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaMethodBreakpointProperties;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.idea.debugger.KotlinDebuggerCoreBundle;
import org.jetbrains.kotlin.idea.debugger.breakpoints.BreakpointListenerConnector;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

public class KotlinFunctionBreakpoint
extends BreakpointWithHighlighter<JavaMethodBreakpointProperties>
implements MethodBreakpointBase {
    private static final Logger LOG = Logger.getInstance(KotlinFunctionBreakpoint.class);
    @Nullable
    private JVMName mySignature;
    private boolean myIsStatic;

    protected KotlinFunctionBreakpoint(@NotNull Project project2, XBreakpoint breakpoint) {
        if (project2 == null) {
            KotlinFunctionBreakpoint.$$$reportNull$$$0(0);
        }
        super(project2, breakpoint);
    }

    public boolean isStatic() {
        return this.myIsStatic;
    }

    @NotNull
    public Key<MethodBreakpoint> getCategory() {
        Key key = MethodBreakpoint.CATEGORY;
        if (key == null) {
            KotlinFunctionBreakpoint.$$$reportNull$$$0(1);
        }
        return key;
    }

    public boolean isValid() {
        return super.isValid() && this.getMethodName() != null;
    }

    public void reload() {
        super.reload();
        this.setMethodName(null);
        this.mySignature = null;
        final Project project2 = this.myProject;
        Task.Backgroundable task2 = new Task.Backgroundable(this.myProject, KotlinDebuggerCoreBundle.message("function.breakpoint.initialize", new Object[0])){

            public void run(@NotNull ProgressIndicator indicator) {
                SourcePosition sourcePosition2;
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                MethodDescriptor descriptor2 = (sourcePosition2 = KotlinFunctionBreakpoint.this.getSourcePosition()) == null ? null : (MethodDescriptor)DumbService.getInstance((Project)project2).runReadActionInSmartMode(() -> KotlinFunctionBreakpoint.getMethodDescriptor(project2, sourcePosition2));
                ProgressIndicatorProvider.checkCanceled();
                String methodName2 = descriptor2 == null ? null : descriptor2.methodName;
                JVMName methodSignature = descriptor2 == null ? null : descriptor2.methodSignature;
                boolean methodIsStatic = descriptor2 != null && descriptor2.isStatic;
                PsiClass psiClass2 = KotlinFunctionBreakpoint.this.getPsiClass();
                ProgressIndicatorProvider.checkCanceled();
                ApplicationManager.getApplication().invokeLater(() -> {
                    KotlinFunctionBreakpoint.this.setMethodName(methodName2);
                    KotlinFunctionBreakpoint.this.mySignature = methodSignature;
                    KotlinFunctionBreakpoint.this.myIsStatic = methodIsStatic;
                    if (psiClass2 != null) {
                        ((JavaMethodBreakpointProperties)((KotlinFunctionBreakpoint)KotlinFunctionBreakpoint.this).getProperties()).myClassPattern = psiClass2.getQualifiedName();
                    }
                    if (methodIsStatic) {
                        KotlinFunctionBreakpoint.this.setInstanceFiltersEnabled(false);
                    }
                }, ModalityState.defaultModalityState());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/kotlin/idea/debugger/breakpoints/KotlinFunctionBreakpoint$1", "run"));
            }
        };
        ProgressManager progressManager = ProgressManager.getInstance();
        if (ApplicationManager.getApplication().isDispatchThread() && !ApplicationManager.getApplication().isUnitTestMode()) {
            progressManager.runProcessWithProgressAsynchronously(task2, (ProgressIndicator)new BackgroundableProcessIndicator(task2));
        } else {
            EmptyProgressIndicator progressIndicator = new EmptyProgressIndicator();
            progressManager.runProcess(() -> task2.run((ProgressIndicator)progressIndicator), (ProgressIndicator)progressIndicator);
        }
    }

    public PsiClass getPsiClass() {
        SourcePosition sourcePosition2 = this.getSourcePosition();
        KtClassOrObject declaration2 = (KtClassOrObject)PositionUtil.getPsiElementAt((Project)this.myProject, KtClassOrObject.class, (SourcePosition)sourcePosition2);
        if (declaration2 == null) {
            return null;
        }
        return (PsiClass)DumbService.getInstance((Project)this.myProject).runReadActionInSmartMode(() -> LightClassUtilsKt.toLightClass(declaration2));
    }

    private static void createRequestForSubClasses(final @NotNull MethodBreakpointBase breakpoint, @NotNull DebugProcessImpl debugProcess, @NotNull ReferenceType baseType) {
        if (breakpoint == null) {
            KotlinFunctionBreakpoint.$$$reportNull$$$0(2);
        }
        if (debugProcess == null) {
            KotlinFunctionBreakpoint.$$$reportNull$$$0(3);
        }
        if (baseType == null) {
            KotlinFunctionBreakpoint.$$$reportNull$$$0(4);
        }
        DebuggerManagerThreadImpl.assertIsManagerThread();
        RequestManagerImpl requestsManager = debugProcess.getRequestsManager();
        ClassPrepareRequest request = requestsManager.createClassPrepareRequest((debuggerProcess, referenceType) -> {
            if (KotlinFunctionBreakpoint.instanceOf(referenceType, baseType)) {
                KotlinFunctionBreakpoint.createRequestForPreparedClassEmulated(breakpoint, debugProcess, referenceType, false);
            }
        }, null);
        if (request != null) {
            requestsManager.registerRequest((Requestor)breakpoint, (EventRequest)request);
            request.enable();
        }
        AtomicReference indicatorRef = new AtomicReference();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            ProgressWindow progress2 = new ProgressWindow(true, false, debugProcess.getProject(), KotlinDebuggerCoreBundle.message("function.breakpoint.cancel.emulation", new Object[0]));
            progress2.setDelayInMillis(2000);
            indicatorRef.set(progress2);
        });
        final ProgressWindow indicator = (ProgressWindow)indicatorRef.get();
        final AtomicBoolean changed = new AtomicBoolean();
        XBreakpointListener listener2 = new XBreakpointListener<XBreakpoint<?>>(){

            void changed(@NotNull XBreakpoint b) {
                if (b == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (b == breakpoint.getXBreakpoint()) {
                    changed.set(true);
                    indicator.cancel();
                }
            }

            public void breakpointRemoved(@NotNull XBreakpoint b) {
                if (b == null) {
                    2.$$$reportNull$$$0(1);
                }
                this.changed(b);
            }

            public void breakpointChanged(@NotNull XBreakpoint b) {
                if (b == null) {
                    2.$$$reportNull$$$0(2);
                }
                this.changed(b);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "b";
                objectArray2[1] = "org/jetbrains/kotlin/idea/debugger/breakpoints/KotlinFunctionBreakpoint$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "changed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "breakpointRemoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "breakpointChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        BreakpointListenerConnector.subscribe(debugProcess, indicator, listener2);
        ProgressManager.getInstance().executeProcessUnderProgress(() -> KotlinFunctionBreakpoint.processPreparedSubTypes(baseType, (subType, classesByName) -> KotlinFunctionBreakpoint.createRequestForPreparedClassEmulated(breakpoint, debugProcess, subType, classesByName, false), (ProgressIndicator)indicator), (ProgressIndicator)indicator);
        if (indicator.isCanceled() && !changed.get()) {
            breakpoint.disableEmulation();
        }
    }

    public void disableEmulation() {
        MethodBreakpointBase.disableEmulation((Breakpoint)this);
    }

    private static void createRequestForPreparedClassEmulated(@NotNull MethodBreakpointBase breakpoint, @NotNull DebugProcessImpl debugProcess, @NotNull ReferenceType classType, boolean base) {
        if (breakpoint == null) {
            KotlinFunctionBreakpoint.$$$reportNull$$$0(5);
        }
        if (debugProcess == null) {
            KotlinFunctionBreakpoint.$$$reportNull$$$0(6);
        }
        if (classType == null) {
            KotlinFunctionBreakpoint.$$$reportNull$$$0(7);
        }
        KotlinFunctionBreakpoint.createRequestForPreparedClassEmulated(breakpoint, debugProcess, classType, debugProcess.getVirtualMachineProxy().getClassesByNameProvider(), base);
    }

    private static boolean shouldCreateRequest(Requestor requestor, XBreakpoint xBreakpoint, DebugProcessImpl debugProcess, boolean forPreparedClass) {
        return (Boolean)DumbService.getInstance((Project)debugProcess.getProject()).runReadActionInSmartMode(() -> {
            JavaDebugProcess process2 = debugProcess.getXdebugProcess();
            return !(process2 == null || !debugProcess.isAttached() || xBreakpoint != null && !((XDebugSessionImpl)process2.getSession()).isBreakpointActive(xBreakpoint) || !forPreparedClass && !debugProcess.getRequestsManager().findRequests(requestor).isEmpty());
        });
    }

    private static void createRequestForPreparedClassEmulated(final @NotNull MethodBreakpointBase breakpoint, final @NotNull DebugProcessImpl debugProcess, @NotNull ReferenceType classType, @NotNull ClassesByNameProvider classesByName, boolean base) {
        if (breakpoint == null) {
            KotlinFunctionBreakpoint.$$$reportNull$$$0(8);
        }
        if (debugProcess == null) {
            KotlinFunctionBreakpoint.$$$reportNull$$$0(9);
        }
        if (classType == null) {
            KotlinFunctionBreakpoint.$$$reportNull$$$0(10);
        }
        if (classesByName == null) {
            KotlinFunctionBreakpoint.$$$reportNull$$$0(11);
        }
        if (!MethodBreakpointBase.canBeEmulated((DebugProcessImpl)debugProcess)) {
            breakpoint.disableEmulation();
            return;
        }
        if (!base && !KotlinFunctionBreakpoint.shouldCreateRequest((Requestor)breakpoint, breakpoint.getXBreakpoint(), debugProcess, true)) {
            return;
        }
        Method lambdaMethod = MethodBytecodeUtil.getLambdaMethod((ReferenceType)classType, (ClassesByNameProvider)classesByName);
        if (lambdaMethod != null && !breakpoint.matchingMethods(StreamEx.of(((ClassType)classType).interfaces()).flatCollection(ReferenceType::allMethods), debugProcess).findFirst().isPresent()) {
            return;
        }
        StreamEx methods2 = lambdaMethod != null ? StreamEx.of((Object)lambdaMethod) : breakpoint.matchingMethods((StreamEx)StreamEx.of(classType.methods()).filter(m -> base || !m.isAbstract()), debugProcess);
        boolean found2 = false;
        for (Method method : methods2) {
            List allLineLocations;
            found2 = true;
            if (method.isNative()) {
                breakpoint.disableEmulation();
                return;
            }
            Method target = MethodBytecodeUtil.getBridgeTargetMethod((Method)method, (ClassesByNameProvider)classesByName);
            if (target != null && !ContainerUtil.isEmpty((Collection)DebuggerUtilsEx.allLineLocations((Method)target))) {
                method = target;
            }
            if ((allLineLocations = DebuggerUtilsEx.allLineLocations((Method)method)) == null && !method.isBridge()) {
                breakpoint.disableEmulation();
                return;
            }
            if (ContainerUtil.isEmpty((Collection)allLineLocations)) continue;
            if (breakpoint.isWatchEntry()) {
                KotlinFunctionBreakpoint.createLocationBreakpointRequest((FilteredRequestor)breakpoint, (Location)ContainerUtil.getFirstItem((List)allLineLocations), debugProcess, true);
            }
            if (!breakpoint.isWatchExit()) continue;
            MethodBytecodeUtil.visit((Method)method, (MethodVisitor)new MethodVisitor(458752){
                int myLastLine;
                {
                    super(x0);
                    this.myLastLine = 0;
                }

                public void visitLineNumber(int line, Label start2) {
                    this.myLastLine = line;
                }

                public void visitInsn(int opcode) {
                    switch (opcode) {
                        case 172: 
                        case 173: 
                        case 174: 
                        case 175: 
                        case 176: 
                        case 177: {
                            allLineLocations.stream().filter(l -> l.lineNumber() == this.myLastLine).findFirst().ifPresent(location2 -> KotlinFunctionBreakpoint.createLocationBreakpointRequest((FilteredRequestor)breakpoint, location2, debugProcess, false));
                        }
                    }
                }
            }, (boolean)true);
        }
        if (base && found2) {
            KotlinFunctionBreakpoint.createRequestForSubClasses(breakpoint, debugProcess, classType);
        }
    }

    private static void createLocationBreakpointRequest(@NotNull FilteredRequestor requestor, @Nullable Location location2, @NotNull DebugProcessImpl debugProcess, boolean methodEntry) {
        BreakpointRequest request;
        if (requestor == null) {
            KotlinFunctionBreakpoint.$$$reportNull$$$0(12);
        }
        if (debugProcess == null) {
            KotlinFunctionBreakpoint.$$$reportNull$$$0(13);
        }
        if ((request = KotlinFunctionBreakpoint.createLocationBreakpointRequest(requestor, location2, debugProcess)) != null) {
            request.putProperty("METHOD_ENTRY_KEY", methodEntry);
        }
    }

    @Nullable
    private static BreakpointRequest createLocationBreakpointRequest(@NotNull FilteredRequestor requestor, @Nullable Location location2, @NotNull DebugProcessImpl debugProcess) {
        if (requestor == null) {
            KotlinFunctionBreakpoint.$$$reportNull$$$0(14);
        }
        if (debugProcess == null) {
            KotlinFunctionBreakpoint.$$$reportNull$$$0(15);
        }
        if (location2 != null) {
            RequestManagerImpl requestsManager = debugProcess.getRequestsManager();
            BreakpointRequest request = requestsManager.createBreakpointRequest(requestor, location2);
            requestsManager.enableRequest((EventRequest)request);
            return request;
        }
        return null;
    }

    protected void createRequestForPreparedClass(@NotNull DebugProcessImpl debugProcess, @NotNull ReferenceType classType) {
        if (debugProcess == null) {
            KotlinFunctionBreakpoint.$$$reportNull$$$0(16);
        }
        if (classType == null) {
            KotlinFunctionBreakpoint.$$$reportNull$$$0(17);
        }
        if (this.isEmulated()) {
            KotlinFunctionBreakpoint.createRequestForPreparedClassEmulated(this, debugProcess, classType, true);
        } else {
            this.createRequestForPreparedClassOriginal(debugProcess, classType);
        }
    }

    private void createRequestForPreparedClassOriginal(@NotNull DebugProcessImpl debugProcess, @NotNull ReferenceType classType) {
        if (debugProcess == null) {
            KotlinFunctionBreakpoint.$$$reportNull$$$0(18);
        }
        if (classType == null) {
            KotlinFunctionBreakpoint.$$$reportNull$$$0(19);
        }
        try {
            boolean hasMethod = false;
            for (Method method : classType.allMethods()) {
                String signature = method.signature();
                String name2 = method.name();
                String nameFromProperties = this.getMethodName();
                if (nameFromProperties == null || this.mySignature == null || !nameFromProperties.equals(name2) || !this.mySignature.getName(debugProcess).equals(signature)) continue;
                hasMethod = true;
                break;
            }
            if (!hasMethod) {
                debugProcess.getRequestsManager().setInvalid((Requestor)this, DebuggerBundle.message((String)"error.invalid.breakpoint.method.not.found", (Object[])new Object[]{classType.name()}));
                return;
            }
            RequestManagerImpl requestManager = debugProcess.getRequestsManager();
            if (this.isWatchEntry()) {
                MethodEntryRequest entryRequest = KotlinFunctionBreakpoint.findRequest(debugProcess, MethodEntryRequest.class, (Requestor)this);
                if (entryRequest == null) {
                    entryRequest = requestManager.createMethodEntryRequest((FilteredRequestor)this);
                } else {
                    entryRequest.disable();
                }
                entryRequest.addClassFilter(classType);
                debugProcess.getRequestsManager().enableRequest((EventRequest)entryRequest);
            }
            if (this.isWatchExit()) {
                MethodExitRequest exitRequest = KotlinFunctionBreakpoint.findRequest(debugProcess, MethodExitRequest.class, (Requestor)this);
                if (exitRequest == null) {
                    exitRequest = requestManager.createMethodExitRequest((FilteredRequestor)this);
                } else {
                    exitRequest.disable();
                }
                exitRequest.addClassFilter(classType);
                debugProcess.getRequestsManager().enableRequest((EventRequest)exitRequest);
            }
        }
        catch (Exception e) {
            LOG.debug((Throwable)e);
        }
    }

    public String getEventMessage(@NotNull LocatableEvent event) {
        if (event == null) {
            KotlinFunctionBreakpoint.$$$reportNull$$$0(20);
        }
        return KotlinFunctionBreakpoint.getEventMessage(event, this.getFileName());
    }

    private static String getEventMessage(@NotNull LocatableEvent event, @NotNull String defaultFileName) {
        if (event == null) {
            KotlinFunctionBreakpoint.$$$reportNull$$$0(21);
        }
        if (defaultFileName == null) {
            KotlinFunctionBreakpoint.$$$reportNull$$$0(22);
        }
        Location location2 = event.location();
        if (event instanceof MethodEntryEvent) {
            return KotlinFunctionBreakpoint.getEventMessage(true, ((MethodEntryEvent)event).method(), location2, defaultFileName);
        }
        if (event instanceof MethodExitEvent) {
            return KotlinFunctionBreakpoint.getEventMessage(false, ((MethodExitEvent)event).method(), location2, defaultFileName);
        }
        Object entryProperty = event.request().getProperty("METHOD_ENTRY_KEY");
        if (entryProperty instanceof Boolean) {
            return KotlinFunctionBreakpoint.getEventMessage((Boolean)entryProperty, location2.method(), location2, defaultFileName);
        }
        return "";
    }

    private static String getEventMessage(boolean entry, Method method, Location location2, String defaultFileName) {
        String locationQName = DebuggerUtilsEx.getLocationMethodQName((Location)location2);
        String locationFileName = DebuggerUtilsEx.getSourceName((Location)location2, e -> defaultFileName);
        int locationLine = location2.lineNumber();
        return DebuggerBundle.message((String)(entry ? "status.method.entry.breakpoint.reached" : "status.method.exit.breakpoint.reached"), (Object[])new Object[]{method.declaringType().name() + "." + method.name() + "()", locationQName, locationFileName, locationLine});
    }

    public PsiElement getEvaluationElement() {
        return this.getPsiClass();
    }

    protected Icon getDisabledIcon(boolean isMuted) {
        if (DebuggerManagerEx.getInstanceEx((Project)this.myProject).getBreakpointManager().findMasterBreakpoint((Breakpoint)this) != null && isMuted) {
            return AllIcons.Debugger.Db_muted_dep_method_breakpoint;
        }
        return null;
    }

    protected Icon getVerifiedIcon(boolean isMuted) {
        return this.isSuspend() ? AllIcons.Debugger.Db_verified_method_breakpoint : AllIcons.Debugger.Db_verified_no_suspend_method_breakpoint;
    }

    @NotNull
    protected Icon getVerifiedWarningsIcon(boolean isMuted) {
        return new LayeredIcon(new Icon[]{isMuted ? AllIcons.Debugger.Db_muted_method_breakpoint : AllIcons.Debugger.Db_method_breakpoint, AllIcons.General.WarningDecorator});
    }

    public String getDisplayName() {
        StringBuilder buffer = new StringBuilder();
        if (this.isValid()) {
            boolean classNameExists;
            String className2 = this.getClassName();
            boolean bl = classNameExists = className2 != null && className2.length() > 0;
            if (classNameExists) {
                buffer.append(className2);
            }
            if (this.getMethodName() != null) {
                if (classNameExists) {
                    buffer.append(".");
                }
                buffer.append(this.getMethodName());
            }
        } else {
            buffer.append(DebuggerBundle.message((String)"status.breakpoint.invalid", (Object[])new Object[0]));
        }
        return buffer.toString();
    }

    public boolean evaluateCondition(@NotNull EvaluationContextImpl context2, @NotNull LocatableEvent event) throws EvaluateException {
        if (context2 == null) {
            KotlinFunctionBreakpoint.$$$reportNull$$$0(23);
        }
        if (event == null) {
            KotlinFunctionBreakpoint.$$$reportNull$$$0(24);
        }
        if (!this.matchesEvent(event, context2.getDebugProcess())) {
            return false;
        }
        return super.evaluateCondition(context2, event);
    }

    private boolean matchesEvent(@NotNull LocatableEvent event, DebugProcessImpl process2) throws EvaluateException {
        if (event == null) {
            KotlinFunctionBreakpoint.$$$reportNull$$$0(25);
        }
        if (this.isEmulated()) {
            return true;
        }
        if (this.getMethodName() == null || this.mySignature == null) {
            return false;
        }
        Method method = event.location().method();
        return method != null && method.name().equals(this.getMethodName()) && method.signature().equals(this.mySignature.getName(process2));
    }

    @Nullable
    public static KotlinFunctionBreakpoint create(@NotNull Project project2, XBreakpoint xBreakpoint) {
        if (project2 == null) {
            KotlinFunctionBreakpoint.$$$reportNull$$$0(26);
        }
        KotlinFunctionBreakpoint breakpoint = new KotlinFunctionBreakpoint(project2, xBreakpoint);
        return (KotlinFunctionBreakpoint)breakpoint.init();
    }

    @Nullable
    private static MethodDescriptor getMethodDescriptor(@NotNull Project project2, @NotNull SourcePosition sourcePosition2) {
        Document document;
        if (project2 == null) {
            KotlinFunctionBreakpoint.$$$reportNull$$$0(27);
        }
        if (sourcePosition2 == null) {
            KotlinFunctionBreakpoint.$$$reportNull$$$0(28);
        }
        if ((document = PsiDocumentManager.getInstance((Project)project2).getDocument(sourcePosition2.getFile())) == null) {
            return null;
        }
        MethodDescriptor descriptor2 = (MethodDescriptor)DumbService.getInstance((Project)project2).runReadActionInSmartMode(() -> {
            PsiMethod method = KotlinFunctionBreakpoint.resolveJvmMethodFromKotlinDeclaration(project2, sourcePosition2);
            if (method == null) {
                return null;
            }
            int methodOffset = method.getTextOffset();
            if (!DocumentUtil.isValidOffset((int)methodOffset, (Document)document) || document.getLineNumber(methodOffset) < sourcePosition2.getLine()) {
                return null;
            }
            PsiIdentifier identifier2 = method.getNameIdentifier();
            int methodNameOffset = identifier2 != null ? identifier2.getTextOffset() : methodOffset;
            MethodDescriptor res2 = new MethodDescriptor();
            res2.methodName = JVMNameUtil.getJVMMethodName((PsiMethod)method);
            try {
                res2.methodSignature = JVMNameUtil.getJVMSignature((PsiMethod)method);
                res2.isStatic = method.hasModifierProperty("static");
            }
            catch (IndexNotReadyException ignored) {
                return null;
            }
            res2.methodLine = document.getLineNumber(methodNameOffset);
            return res2;
        });
        if (descriptor2 == null || descriptor2.methodName == null || descriptor2.methodSignature == null) {
            return null;
        }
        return descriptor2;
    }

    @Nullable
    private static PsiMethod resolveJvmMethodFromKotlinDeclaration(@NotNull Project project2, @NotNull SourcePosition sourcePosition2) {
        KtDeclaration declaration2;
        if (project2 == null) {
            KotlinFunctionBreakpoint.$$$reportNull$$$0(29);
        }
        if (sourcePosition2 == null) {
            KotlinFunctionBreakpoint.$$$reportNull$$$0(30);
        }
        if ((declaration2 = (KtDeclaration)PositionUtil.getPsiElementAt((Project)project2, KtDeclaration.class, (SourcePosition)sourcePosition2)) instanceof KtClass) {
            KtPrimaryConstructor constructor2 = ((KtClass)declaration2).getPrimaryConstructor();
            if (constructor2 != null) {
                declaration2 = constructor2;
            } else {
                PsiMethod[] constructors2;
                KtLightClass ktLightClass = LightClassUtilsKt.toLightClass((KtClassOrObject)declaration2);
                if (ktLightClass != null && (constructors2 = ktLightClass.getConstructors()).length > 0) {
                    return constructors2[0];
                }
                return null;
            }
        }
        if (declaration2 == null) {
            return null;
        }
        for (PsiElement psiElement2 : LightClassUtilsKt.toLightElements(declaration2)) {
            if (!(psiElement2 instanceof PsiMethod)) continue;
            return (PsiMethod)psiElement2;
        }
        return null;
    }

    @Nullable
    private static <T extends EventRequest> T findRequest(@NotNull DebugProcessImpl debugProcess, Class<T> requestClass, Requestor requestor) {
        if (debugProcess == null) {
            KotlinFunctionBreakpoint.$$$reportNull$$$0(31);
        }
        return (T)((EventRequest)StreamEx.of((Collection)debugProcess.getRequestsManager().findRequests(requestor)).select(requestClass).findFirst().orElse(null));
    }

    public void readExternal(@NotNull Element breakpointNode) throws InvalidDataException {
        if (breakpointNode == null) {
            KotlinFunctionBreakpoint.$$$reportNull$$$0(32);
        }
        super.readExternal(breakpointNode);
        try {
            ((JavaMethodBreakpointProperties)this.getProperties()).WATCH_ENTRY = Boolean.valueOf(JDOMExternalizerUtil.readField((Element)breakpointNode, (String)"WATCH_ENTRY"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ((JavaMethodBreakpointProperties)this.getProperties()).WATCH_EXIT = Boolean.valueOf(JDOMExternalizerUtil.readField((Element)breakpointNode, (String)"WATCH_EXIT"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean isEmulated() {
        return ((JavaMethodBreakpointProperties)this.getProperties()).EMULATED;
    }

    public boolean isWatchEntry() {
        return ((JavaMethodBreakpointProperties)this.getProperties()).WATCH_ENTRY;
    }

    public boolean isWatchExit() {
        return ((JavaMethodBreakpointProperties)this.getProperties()).WATCH_EXIT;
    }

    public StreamEx matchingMethods(StreamEx<Method> methods2, DebugProcessImpl debugProcess) {
        try {
            String methodName2 = this.getMethodName();
            String signature = this.mySignature != null ? this.mySignature.getName(debugProcess) : null;
            return (StreamEx)((StreamEx)methods2.filter(m -> Comparing.equal((String)methodName2, (String)m.name()) && Comparing.equal((String)signature, (String)m.signature()))).limit(1L);
        }
        catch (EvaluateException e) {
            LOG.warn((Throwable)e);
            return StreamEx.empty();
        }
    }

    @Nullable
    private String getMethodName() {
        return ((JavaMethodBreakpointProperties)this.getProperties()).myMethodName;
    }

    private void setMethodName(@Nullable String methodName2) {
        ((JavaMethodBreakpointProperties)this.getProperties()).myMethodName = methodName2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processPreparedSubTypes(ReferenceType classType, BiConsumer<ReferenceType, ClassesByNameProvider> consumer2, ProgressIndicator progressIndicator) {
        long start2 = 0L;
        if (LOG.isDebugEnabled()) {
            start2 = System.currentTimeMillis();
        }
        progressIndicator.setIndeterminate(false);
        progressIndicator.start();
        progressIndicator.setText(DebuggerBundle.message((String)"label.method.breakpoints.processing.classes", (Object[])new Object[0]));
        try {
            MultiMap inheritance = new MultiMap();
            List<ReferenceType> allTypes = classType.virtualMachine().allClasses();
            for (int i2 = 0; i2 < allTypes.size(); ++i2) {
                if (progressIndicator.isCanceled()) {
                    return;
                }
                ReferenceType type2 = allTypes.get(i2);
                if (type2.isPrepared()) {
                    try {
                        KotlinFunctionBreakpoint.supertypes(type2).forEach(st -> inheritance.putValue(st, (Object)type2));
                    }
                    catch (ObjectCollectedException objectCollectedException) {
                        // empty catch block
                    }
                }
                progressIndicator.setText2(i2 + "/" + allTypes.size());
                progressIndicator.setFraction((double)i2 / (double)allTypes.size());
            }
            List types2 = ((StreamEx)StreamEx.ofTree((Object)classType, t -> StreamEx.of((Collection)inheritance.get(t))).skip(1L)).toList();
            progressIndicator.setText(DebuggerBundle.message((String)"label.method.breakpoints.setting.breakpoints", (Object[])new Object[0]));
            ClassesByNameProvider classesByName = ClassesByNameProvider.createCache(allTypes);
            for (int i3 = 0; i3 < types2.size(); ++i3) {
                if (progressIndicator.isCanceled()) {
                    return;
                }
                consumer2.accept((ReferenceType)types2.get(i3), classesByName);
                progressIndicator.setText2(i3 + "/" + types2.size());
                progressIndicator.setFraction((double)i3 / (double)types2.size());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processed " + types2.size() + " classes in " + (System.currentTimeMillis() - start2) + "ms");
            }
        }
        finally {
            progressIndicator.stop();
        }
    }

    private static boolean instanceOf(@Nullable ReferenceType type2, @NotNull ReferenceType superType) {
        if (superType == null) {
            KotlinFunctionBreakpoint.$$$reportNull$$$0(33);
        }
        if (type2 == null) {
            return false;
        }
        if (superType.equals(type2)) {
            return true;
        }
        return KotlinFunctionBreakpoint.supertypes(type2).anyMatch(t -> KotlinFunctionBreakpoint.instanceOf(t, superType));
    }

    private static Stream<? extends ReferenceType> supertypes(ReferenceType type2) {
        if (type2 instanceof InterfaceType) {
            return ((InterfaceType)type2).superinterfaces().stream();
        }
        if (type2 instanceof ClassType) {
            return StreamEx.ofNullable((Object)((ClassType)type2).superclass()).prepend(((ClassType)type2).interfaces());
        }
        return StreamEx.empty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/debugger/breakpoints/KotlinFunctionBreakpoint";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseType";
                break;
            }
            case 7: 
            case 10: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classesByName";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
            case 20: 
            case 21: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultFileName";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourcePosition";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpointNode";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/debugger/breakpoints/KotlinFunctionBreakpoint";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCategory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createRequestForSubClasses";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createRequestForPreparedClassEmulated";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createLocationBreakpointRequest";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createRequestForPreparedClass";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createRequestForPreparedClassOriginal";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getEventMessage";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "evaluateCondition";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "matchesEvent";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getMethodDescriptor";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "resolveJvmMethodFromKotlinDeclaration";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "findRequest";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "instanceOf";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MethodDescriptor {
        String methodName;
        JVMName methodSignature;
        boolean isStatic;
        int methodLine;

        private MethodDescriptor() {
        }
    }
}

