/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.command;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.execution.filters.ExceptionFilters;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.impl.RunnerContentUi;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.content.Content;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.debugger.coroutine.CoroutineProjectConnectionListenerKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.KotlinDebuggerCoroutinesBundle;
import org.jetbrains.kotlin.idea.debugger.coroutine.command.CoroutineDumpAction;
import org.jetbrains.kotlin.idea.debugger.coroutine.command.CoroutineDumpAction$sam$java_lang_Runnable$0;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineInfoCache;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineInfoData;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.CoroutineDebugProbesProxy;
import org.jetbrains.kotlin.idea.debugger.coroutine.view.CoroutineDumpPanel;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J,\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/command/CoroutineDumpAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/actionSystem/AnAction$TransparentUpdate;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "addCoroutineDump", "project", "Lcom/intellij/openapi/project/Project;", "coroutines", "", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineInfoData;", "ui", "Lcom/intellij/execution/ui/RunnerLayoutUi;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "update", "jvm-debugger-coroutine"})
public final class CoroutineDumpAction
extends AnAction
implements AnAction.TransparentUpdate {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"e.project ?: return");
        Project project3 = project2;
        DebuggerManagerEx debuggerManagerEx = DebuggerManagerEx.getInstanceEx((Project)project3);
        Intrinsics.checkExpressionValueIsNotNull((Object)debuggerManagerEx, (String)"DebuggerManagerEx.getInstanceEx(project)");
        DebuggerContextImpl debuggerContextImpl = debuggerManagerEx.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)debuggerContextImpl, (String)"DebuggerManagerEx.getInstanceEx(project).context");
        DebuggerContextImpl context2 = debuggerContextImpl;
        DebuggerSession session2 = context2.getDebuggerSession();
        if (session2 != null && session2.isAttached()) {
            DebugProcessImpl debugProcessImpl = context2.getDebugProcess();
            if (debugProcessImpl == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)debugProcessImpl, (String)"context.debugProcess ?: return");
            DebugProcessImpl process2 = debugProcessImpl;
            process2.getManagerThread().schedule((DebuggerCommandImpl)new SuspendContextCommandImpl(this, context2, project3, session2, context2.getSuspendContext()){
                final /* synthetic */ CoroutineDumpAction this$0;
                final /* synthetic */ DebuggerContextImpl $context;
                final /* synthetic */ Project $project;
                final /* synthetic */ DebuggerSession $session;

                public void contextAction() {
                    SuspendContextImpl suspendContextImpl = this.$context.getSuspendContext();
                    if (suspendContextImpl == null) {
                        return;
                    }
                    CoroutineInfoCache states = new CoroutineDebugProbesProxy((XSuspendContext)suspendContextImpl).dumpCoroutines();
                    if (states.isOk()) {
                        String message2 = KotlinDebuggerCoroutinesBundle.message("coroutine.dump.failed", new Object[0]);
                        MessageType messageType = MessageType.ERROR;
                        Intrinsics.checkExpressionValueIsNotNull((Object)messageType, (String)"MessageType.ERROR");
                        XDebuggerManagerImpl.NOTIFICATION_GROUP.createNotification(message2, messageType).notify(this.$project);
                    } else {
                        Function0 f2;
                        Function0 function0 = f2 = (Function0)new Function0<Unit>(this, states){
                            final /* synthetic */ actionPerformed.1 this$0;
                            final /* synthetic */ CoroutineInfoCache $states;

                            public final void invoke() {
                                XDebugSession xDebugSession = this.this$0.$session.getXDebugSession();
                                if (xDebugSession == null || (xDebugSession = xDebugSession.getUI()) == null) {
                                    return;
                                }
                                XDebugSession ui = xDebugSession;
                                CoroutineDumpAction coroutineDumpAction = this.this$0.this$0;
                                Project project2 = this.this$0.$project;
                                List<CoroutineInfoData> list2 = this.$states.getCache();
                                GlobalSearchScope globalSearchScope = this.this$0.$session.getSearchScope();
                                Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"session.searchScope");
                                coroutineDumpAction.addCoroutineDump(project2, list2, (RunnerLayoutUi)ui, globalSearchScope);
                            }
                            {
                                this.this$0 = var1_1;
                                this.$states = coroutineInfoCache;
                                super(0);
                            }
                        };
                        ApplicationManager.getApplication().invokeLater((Runnable)new CoroutineDumpAction$sam$java_lang_Runnable$0(function0), ModalityState.NON_MODAL);
                    }
                }
                {
                    this.this$0 = $outer;
                    this.$context = $captured_local_variable$1;
                    this.$project = $captured_local_variable$2;
                    this.$session = $captured_local_variable$3;
                    super($super_call_param$4);
                }
            });
        }
    }

    public final void addCoroutineDump(@NotNull Project project2, @NotNull List<CoroutineInfoData> coroutines, @NotNull RunnerLayoutUi ui, @NotNull GlobalSearchScope searchScope2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull(coroutines, (String)"coroutines");
        Intrinsics.checkParameterIsNotNull((Object)ui, (String)"ui");
        Intrinsics.checkParameterIsNotNull((Object)searchScope2, (String)"searchScope");
        TextConsoleBuilder textConsoleBuilder = TextConsoleBuilderFactory.getInstance().createBuilder(project2);
        Intrinsics.checkExpressionValueIsNotNull((Object)textConsoleBuilder, (String)"TextConsoleBuilderFactor\u2026().createBuilder(project)");
        TextConsoleBuilder consoleBuilder = textConsoleBuilder;
        consoleBuilder.filters(ExceptionFilters.getFilters((GlobalSearchScope)searchScope2));
        ConsoleView consoleView2 = consoleBuilder.getConsole();
        Intrinsics.checkExpressionValueIsNotNull((Object)consoleView2, (String)"consoleBuilder.console");
        ConsoleView consoleView3 = consoleView2;
        DefaultActionGroup toolbarActions = new DefaultActionGroup();
        consoleView3.allowHeavyFilters();
        CoroutineDumpPanel panel2 = new CoroutineDumpPanel(project2, consoleView3, toolbarActions, coroutines);
        String id = "DumpKt " + DateFormatUtil.formatTimeWithSeconds((long)System.currentTimeMillis());
        Content content2 = ui.createContent(id, (JComponent)panel2, id, null, null);
        boolean bl = false;
        boolean bl2 = false;
        Content $this$apply = content2;
        boolean bl3 = false;
        $this$apply.putUserData(RunnerContentUi.LIGHTWEIGHT_CONTENT_MARKER, (Object)true);
        $this$apply.setCloseable(true);
        $this$apply.setDescription(KotlinDebuggerCoroutinesBundle.message("coroutine.dump.panel.title", new Object[0]));
        Content content3 = content2;
        Intrinsics.checkExpressionValueIsNotNull((Object)content3, (String)"ui.createContent(id, pan\u2026p.panel.title\")\n        }");
        Content content4 = content3;
        ui.addContent(content4);
        ui.selectAndFocus(content4, true, true);
        Disposer.register((Disposable)((Disposable)content4), (Disposable)((Disposable)consoleView3));
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
        Presentation presentation2 = presentation;
        Project project2 = e.getProject();
        if (project2 == null) {
            presentation2.setEnabled(false);
            presentation2.setVisible(false);
            return;
        }
        DebuggerManagerEx debuggerManagerEx = DebuggerManagerEx.getInstanceEx((Project)project2);
        Intrinsics.checkExpressionValueIsNotNull((Object)debuggerManagerEx, (String)"DebuggerManagerEx.getInstanceEx(project)");
        DebuggerContextImpl debuggerContextImpl = debuggerManagerEx.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)debuggerContextImpl, (String)"DebuggerManagerEx.getInstanceEx(project).context");
        if (debuggerContextImpl.getSuspendContext() == null) {
            presentation2.setEnabled(false);
            return;
        }
        DebuggerManagerEx debuggerManagerEx2 = DebuggerManagerEx.getInstanceEx((Project)project2);
        Intrinsics.checkExpressionValueIsNotNull((Object)debuggerManagerEx2, (String)"DebuggerManagerEx.getInstanceEx(project)");
        DebuggerContextImpl debuggerContextImpl2 = debuggerManagerEx2.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)debuggerContextImpl2, (String)"DebuggerManagerEx.getInstanceEx(project).context");
        DebuggerSession debuggerSession = debuggerContextImpl2.getDebuggerSession();
        presentation2.setEnabled(debuggerSession != null && debuggerSession.isAttached() && CoroutineProjectConnectionListenerKt.coroutineDebuggerEnabled());
        presentation2.setVisible(presentation2.isEnabled());
    }
}

