/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.proxy;

import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.jdi.GeneratedLocation;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.xdebugger.frame.XNamedValue;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.CoroutineUtilsKt;
import org.jetbrains.kotlin.idea.debugger.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.TypeUtilsKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineStackFrameItem;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.ProvidersKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.ExecutionContext;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 +2\u00020\u0001:\u0001+B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0013\u0010\u001e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001f\u001a\u00020\u0007H\u0082\u0010J\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aJ\u0016\u0010!\u001a\n\u0012\u0004\u0012\u00020\"\u0018\u00010\u001a2\u0006\u0010\u0017\u001a\u00020\u0018J\u0012\u0010#\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010&\u001a\u00020%2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010'\u001a\u00020%2\u0006\u0010(\u001a\u00020)H\u0002J\n\u0010*\u001a\u0004\u0018\u00010\u0018H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\r\u001a\u00020\u000e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/AsyncStackTraceContext;", "", "context", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/ExecutionContext;", "method", "Lcom/sun/jdi/Method;", "debugMetadataKtType", "Lcom/sun/jdi/ClassType;", "(Lorg/jetbrains/kotlin/idea/debugger/evaluate/ExecutionContext;Lcom/sun/jdi/Method;Lcom/sun/jdi/ClassType;)V", "getContext", "()Lorg/jetbrains/kotlin/idea/debugger/evaluate/ExecutionContext;", "getDebugMetadataKtType", "()Lcom/sun/jdi/ClassType;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "log$delegate", "Lkotlin/properties/ReadOnlyProperty;", "getMethod", "()Lcom/sun/jdi/Method;", "collectFramesRecursively", "", "continuation", "Lcom/sun/jdi/ObjectReference;", "consumer", "", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineStackFrameItem;", "createLocation", "Lcom/intellij/debugger/jdi/GeneratedLocation;", "findBaseContinuationSuperSupertype", "type", "getAsyncStackTraceIfAny", "getSpilledVariables", "Lcom/intellij/xdebugger/frame/XNamedValue;", "invokeGetStackTraceElement", "isContinuationProvider", "", "isInvokeSuspendMethod", "isSuspendLambda", "referenceType", "Lcom/sun/jdi/ReferenceType;", "locateContinuation", "Companion", "jvm-debugger-coroutine"})
public final class AsyncStackTraceContext {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private final ReadOnlyProperty log$delegate;
    @NotNull
    private final ExecutionContext context;
    @NotNull
    private final Method method;
    @NotNull
    private final ClassType debugMetadataKtType;
    @NotNull
    public static final String DEBUG_METADATA_KT = "kotlin.coroutines.jvm.internal.DebugMetadataKt";
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(AsyncStackTraceContext.class), "log", "getLog()Lcom/intellij/openapi/diagnostic/Logger;"))};
        Companion = new Companion(null);
    }

    @NotNull
    public final Logger getLog() {
        return (Logger)this.log$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @NotNull
    public final List<CoroutineStackFrameItem> getAsyncStackTraceIfAny() {
        ObjectReference objectReference = this.locateContinuation();
        if (objectReference == null) {
            boolean bl = false;
            return new ArrayList();
        }
        ObjectReference continuation2 = objectReference;
        boolean bl = false;
        List frames2 = new ArrayList();
        try {
            this.collectFramesRecursively(continuation2, frames2);
        }
        catch (Exception e) {
            this.getLog().error("Error while looking for variables.", (Throwable)e);
        }
        return frames2;
    }

    private final ObjectReference locateContinuation() {
        ObjectReference continuation2 = null;
        if (this.isInvokeSuspendMethod(this.method)) {
            ObjectReference objectReference = this.context.getFrameProxy().thisObject();
            if (objectReference == null) {
                return null;
            }
            continuation2 = objectReference;
            ReferenceType referenceType = continuation2.referenceType();
            Intrinsics.checkExpressionValueIsNotNull((Object)referenceType, (String)"continuation.referenceType()");
            if (!this.isSuspendLambda(referenceType)) {
                return null;
            }
        } else if (this.isContinuationProvider(this.method)) {
            StackFrameProxyImpl frameProxy = this.context.getFrameProxy();
            LocalVariableProxyImpl localVariableProxyImpl = SafeUtilKt.safeVisibleVariableByName(frameProxy, "$continuation");
            if (localVariableProxyImpl == null) {
                return null;
            }
            LocalVariableProxyImpl continuationVariable = localVariableProxyImpl;
            Value value2 = frameProxy.getValue(continuationVariable);
            if (!(value2 instanceof ObjectReference)) {
                value2 = null;
            }
            ObjectReference objectReference = (ObjectReference)value2;
            if (objectReference == null) {
                return null;
            }
            continuation2 = objectReference;
            this.context.keepReference(continuation2);
        } else {
            continuation2 = null;
        }
        return continuation2;
    }

    private final boolean isInvokeSuspendMethod(Method method) {
        return Intrinsics.areEqual((Object)method.name(), (Object)"invokeSuspend") && Intrinsics.areEqual((Object)method.signature(), (Object)"(Ljava/lang/Object;)Ljava/lang/Object;");
    }

    private final boolean isContinuationProvider(Method method) {
        String string = method.signature();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"method.signature()");
        return StringsKt.contains$default((CharSequence)string, (CharSequence)"Lkotlin/coroutines/Continuation;)", (boolean)false, (int)2, null);
    }

    private final boolean isSuspendLambda(ReferenceType referenceType) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = CoroutineUtilsKt.getSUSPEND_LAMBDA_CLASSES();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!TypeUtilsKt.isSubtype((Type)referenceType, it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final void collectFramesRecursively(ObjectReference continuation2, List<CoroutineStackFrameItem> consumer2) {
        GeneratedLocation location2;
        ReferenceType referenceType = continuation2.referenceType();
        if (!(referenceType instanceof ClassType)) {
            referenceType = null;
        }
        ClassType classType = (ClassType)referenceType;
        if (classType == null) {
            return;
        }
        ClassType continuationType = classType;
        ClassType classType2 = this.findBaseContinuationSuperSupertype(continuationType);
        if (classType2 == null) {
            return;
        }
        ClassType baseContinuationSupertype = classType2;
        GeneratedLocation generatedLocation = location2 = this.createLocation(continuation2);
        if (generatedLocation != null) {
            GeneratedLocation generatedLocation2 = generatedLocation;
            boolean bl = false;
            boolean bl2 = false;
            GeneratedLocation it = generatedLocation2;
            boolean bl3 = false;
            List list2 = this.getSpilledVariables(continuation2);
            if (list2 == null) {
                boolean bl4 = false;
                list2 = new ArrayList();
            }
            List spilledVariables = list2;
            consumer2.add(new CoroutineStackFrameItem((Location)location2, spilledVariables));
        }
        Field field2 = baseContinuationSupertype.fieldByName("completion");
        if (field2 == null) {
            return;
        }
        Field completionField = field2;
        Value value2 = continuation2.getValue(completionField);
        if (!(value2 instanceof ObjectReference)) {
            value2 = null;
        }
        ObjectReference objectReference = (ObjectReference)value2;
        if (objectReference == null) {
            return;
        }
        ObjectReference completion = objectReference;
        this.collectFramesRecursively(completion, consumer2);
    }

    private final GeneratedLocation createLocation(ObjectReference continuation2) {
        Integer n;
        String methodName2;
        String className2;
        block8: {
            block7: {
                ObjectReference objectReference = this.invokeGetStackTraceElement(continuation2);
                if (objectReference == null) {
                    return null;
                }
                ObjectReference instance = objectReference;
                String string = this.context.invokeMethodAsString(instance, "getClassName");
                if (string == null) {
                    return null;
                }
                className2 = string;
                String string2 = this.context.invokeMethodAsString(instance, "getMethodName");
                if (string2 == null) {
                    return null;
                }
                methodName2 = string2;
                n = this.context.invokeMethodAsInt(instance, "getLineNumber");
                if (n == null) break block7;
                Integer n2 = n;
                boolean bl = false;
                boolean bl2 = false;
                int it = ((Number)n2).intValue();
                boolean bl3 = false;
                n = it >= 0 ? n2 : null;
                if (n != null) break block8;
            }
            return null;
        }
        int lineNumber2 = n;
        ClassType classType = this.context.findClassSafe(className2);
        if (classType == null) {
            return null;
        }
        ClassType locationClass = classType;
        return new GeneratedLocation(this.context.getDebugProcess(), (ReferenceType)locationClass, methodName2, lineNumber2);
    }

    private final ObjectReference invokeGetStackTraceElement(ObjectReference continuation2) {
        ObjectReference objectReference = this.context.invokeMethodAsObject(this.debugMetadataKtType, "getStackTraceElement", continuation2);
        if (objectReference == null) {
            return null;
        }
        ObjectReference stackTraceElement = objectReference;
        ReferenceType referenceType = stackTraceElement.referenceType();
        boolean bl = false;
        boolean bl2 = false;
        ReferenceType it = referenceType;
        boolean bl3 = false;
        if ((Intrinsics.areEqual((Object)it.name(), (Object)StackTraceElement.class.getName()) ? referenceType : null) == null) {
            return null;
        }
        this.context.keepReference(stackTraceElement);
        return stackTraceElement;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final List<XNamedValue> getSpilledVariables(@NotNull ObjectReference continuation2) {
        Intrinsics.checkParameterIsNotNull((Object)continuation2, (String)"continuation");
        ArrayReference arrayReference = this.context.invokeMethodAsArray(this.debugMetadataKtType, "getSpilledVariableFieldMapping", "(Lkotlin/coroutines/jvm/internal/BaseContinuationImpl;)[Ljava/lang/String;", continuation2);
        if (arrayReference == null) {
            return null;
        }
        ArrayReference rawSpilledVariables = arrayReference;
        this.context.keepReference(rawSpilledVariables);
        int length = rawSpilledVariables.length() / 2;
        ArrayList spilledVariables = new ArrayList(length);
        int n = 0;
        int n2 = length;
        while (n < n2) {
            Object object;
            void index2;
            Value value2 = rawSpilledVariables.getValue(2 * index2);
            if (!(value2 instanceof StringReference)) {
                value2 = null;
            }
            if ((object = (StringReference)value2) == null || (object = object.value()) == null) {
            } else {
                Object object2;
                Object fieldName = object;
                Value value3 = rawSpilledVariables.getValue(2 * index2 + 1);
                if (!(value3 instanceof StringReference)) {
                    value3 = null;
                }
                if ((object2 = (StringReference)value3) == null || (object2 = object2.value()) == null) {
                } else {
                    Object variableName = object2;
                    if (continuation2.referenceType().fieldByName((String)fieldName) == null) {
                    } else {
                        Field field2;
                        ValueDescriptorImpl valueDescriptor2 = new ValueDescriptorImpl(this, (String)variableName, continuation2, field2, this.context.getProject()){
                            final /* synthetic */ AsyncStackTraceContext this$0;
                            final /* synthetic */ String $variableName;
                            final /* synthetic */ ObjectReference $continuation;
                            final /* synthetic */ Field $field;

                            @NotNull
                            public String calcValueName() {
                                return this.$variableName;
                            }

                            public Value calcValue(@Nullable EvaluationContextImpl evaluationContext) {
                                return this.$continuation.getValue(this.$field);
                            }

                            @NotNull
                            public Void getDescriptorEvaluation(@Nullable DebuggerContext context2) {
                                throw (Throwable)new EvaluateException("Spilled variable evaluation is not supported");
                            }
                            {
                                this.this$0 = $outer;
                                this.$variableName = $captured_local_variable$1;
                                this.$continuation = $captured_local_variable$2;
                                this.$field = $captured_local_variable$3;
                                super($super_call_param$4);
                            }
                        };
                        Collection collection = spilledVariables;
                        ValueDescriptorImpl valueDescriptorImpl = valueDescriptor2;
                        EvaluationContextImpl evaluationContextImpl = this.context.getEvaluationContext();
                        JavaDebugProcess javaDebugProcess = this.context.getDebugProcess().getXdebugProcess();
                        if (javaDebugProcess == null) {
                            Intrinsics.throwNpe();
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)javaDebugProcess, (String)"context.debugProcess.xdebugProcess!!");
                        JavaValue javaValue = JavaValue.create(null, (ValueDescriptorImpl)valueDescriptorImpl, (EvaluationContextImpl)evaluationContextImpl, (NodeManagerImpl)javaDebugProcess.getNodeManager(), (boolean)false);
                        boolean bl = false;
                        collection.add(javaValue);
                    }
                }
            }
            ++index2;
        }
        return spilledVariables;
    }

    private final ClassType findBaseContinuationSuperSupertype(ClassType type2) {
        while (!Intrinsics.areEqual((Object)type2.name(), (Object)"kotlin.coroutines.jvm.internal.BaseContinuationImpl")) {
            if (type2.superclass() != null) continue;
            return null;
        }
        return type2;
    }

    @NotNull
    public final ExecutionContext getContext() {
        return this.context;
    }

    @NotNull
    public final Method getMethod() {
        return this.method;
    }

    @NotNull
    public final ClassType getDebugMetadataKtType() {
        return this.debugMetadataKtType;
    }

    public AsyncStackTraceContext(@NotNull ExecutionContext context2, @NotNull Method method, @NotNull ClassType debugMetadataKtType) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        Intrinsics.checkParameterIsNotNull((Object)debugMetadataKtType, (String)"debugMetadataKtType");
        this.context = context2;
        this.method = method;
        this.debugMetadataKtType = debugMetadataKtType;
        this.log$delegate = ProvidersKt.getLogger();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/AsyncStackTraceContext$Companion;", "", "()V", "DEBUG_METADATA_KT", "", "jvm-debugger-coroutine"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

