/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate.compilation;

import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.sun.jdi.Location;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithSource;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SyntheticFieldDescriptor;
import org.jetbrains.kotlin.idea.debugger.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.DebuggerFieldPropertyDescriptor;
import org.jetbrains.kotlin.idea.debugger.evaluate.EvaluationError;
import org.jetbrains.kotlin.idea.debugger.evaluate.EvaluationStatus;
import org.jetbrains.kotlin.idea.debugger.evaluate.ExecutionContext;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerEvaluationBundle;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentParameter;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentParameterAnalyzer;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentParameterInfo;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.DebugLabelPropertyDescriptor;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.OnceUsedChecker;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitor;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CoroutineCallCheckerKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitClassReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.expressions.BasicExpressionTypingVisitor;
import org.jetbrains.kotlin.types.expressions.FunctionsTypingVisitorKt;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u001b\u001a\u00020\u001cJ\"\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u00182\u0006\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u0019J\u0018\u0010#\u001a\u00020$2\u0006\u0010 \u001a\u00020%2\u0006\u0010&\u001a\u00020%H\u0002J\u0012\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020*H\u0002J\u0012\u0010+\u001a\u00020$2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0018H\u0002J\u0010\u0010,\u001a\u00020$2\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u0010/\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020*H\u0002J\u0012\u00100\u001a\u0004\u0018\u00010\u00192\u0006\u0010-\u001a\u00020\u0018H\u0002J\u0012\u00101\u001a\u0004\u0018\u00010\u00192\u0006\u0010-\u001a\u00020\u0018H\u0002J\u0012\u00102\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001f\u001a\u000203H\u0002J$\u00104\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001f\u001a\u00020*2\u0006\u00105\u001a\u0002062\b\u00107\u001a\u0004\u0018\u00010(H\u0002J\u0012\u00108\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001f\u001a\u00020*H\u0002J\u0012\u00109\u001a\u0004\u0018\u00010\u00192\u0006\u0010:\u001a\u00020;H\u0002J\u001a\u0010<\u001a\u0004\u0018\u00010\u00192\u0006\u0010-\u001a\u00020\u00182\u0006\u0010 \u001a\u00020=H\u0002J\u0012\u0010>\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001f\u001a\u00020?H\u0002J\u0015\u0010@\u001a\u00020$*\u00020%2\u0006\u0010A\u001a\u00020%H\u0082\u0010R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000b\u001a\u0004\u0018\u00010\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0016\u001a\u001e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017j\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0019`\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentParameterAnalyzer;", "", "context", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/ExecutionContext;", "codeFragment", "Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "evaluationStatus", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/EvaluationStatus;", "(Lorg/jetbrains/kotlin/idea/debugger/evaluate/ExecutionContext;Lorg/jetbrains/kotlin/psi/KtCodeFragment;Lorg/jetbrains/kotlin/resolve/BindingContext;Lorg/jetbrains/kotlin/idea/debugger/evaluate/EvaluationStatus;)V", "containingPrimaryConstructor", "Lorg/jetbrains/kotlin/descriptors/ConstructorDescriptor;", "getContainingPrimaryConstructor", "()Lorg/jetbrains/kotlin/descriptors/ConstructorDescriptor;", "containingPrimaryConstructor$delegate", "Lkotlin/Lazy;", "crossingBounds", "", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentParameter$Dumb;", "onceUsedChecker", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/OnceUsedChecker;", "parameters", "Ljava/util/LinkedHashMap;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentParameter$Smart;", "Lkotlin/collections/LinkedHashMap;", "analyze", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentParameterInfo;", "checkBounds", "", "descriptor", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "parameter", "doesCrossInlineBounds", "", "Lcom/intellij/psi/PsiElement;", "declaration", "getLabel", "", "callableDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "isCodeFragmentDeclaration", "isContainingPrimaryConstructorParameter", "target", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "isFakeFunctionForJavaContext", "processCoroutineContextCall", "processDebugLabel", "processDispatchReceiver", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "processExtensionReceiver", "receiverType", "Lorg/jetbrains/kotlin/types/KotlinType;", "label", "processFakeJavaCodeReceiver", "processReceiver", "receiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ImplicitReceiver;", "processSimpleNameExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "processSyntheticFieldVariable", "Lorg/jetbrains/kotlin/descriptors/impl/SyntheticFieldDescriptor;", "isInside", "parent", "jvm-debugger-evaluation"})
public final class CodeFragmentParameterAnalyzer {
    private final LinkedHashMap<DeclarationDescriptor, CodeFragmentParameter.Smart> parameters;
    private final Set<CodeFragmentParameter.Dumb> crossingBounds;
    private final OnceUsedChecker onceUsedChecker;
    private final Lazy containingPrimaryConstructor$delegate;
    private final ExecutionContext context;
    private final KtCodeFragment codeFragment;
    private final BindingContext bindingContext;
    private final EvaluationStatus evaluationStatus;

    private final ConstructorDescriptor getContainingPrimaryConstructor() {
        Lazy lazy = this.containingPrimaryConstructor$delegate;
        CodeFragmentParameterAnalyzer codeFragmentParameterAnalyzer = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ConstructorDescriptor)lazy.getValue();
    }

    @NotNull
    public final CodeFragmentParameterInfo analyze() {
        this.onceUsedChecker.trigger();
        this.codeFragment.accept((KtVisitor)new KtTreeVisitor<Unit>(this){
            final /* synthetic */ CodeFragmentParameterAnalyzer this$0;

            @Nullable
            public Void visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression2, @Nullable Unit data2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(expression2, CodeFragmentParameterAnalyzer.access$getBindingContext$p(this.this$0));
                if (resolvedCall2 == null) {
                    return null;
                }
                ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
                this.processResolvedCall(resolvedCall3, expression2);
                return null;
            }

            private final void processResolvedCall(ResolvedCall<?> resolvedCall2, KtSimpleNameExpression expression2) {
                DeclarationDescriptor descriptor2;
                ReceiverValue dispatchReceiver;
                ReceiverParameterDescriptor extensionParameter;
                ? descriptor3;
                if (resolvedCall2 instanceof VariableAsFunctionResolvedCall) {
                    this.processResolvedCall(((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getFunctionCall(), expression2);
                    this.processResolvedCall(((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getVariableCall(), expression2);
                    return;
                }
                analyze.1 var3_3 = this;
                boolean bl = false;
                boolean bl2 = false;
                analyze.1 $this$run = var3_3;
                boolean bl3 = false;
                ? obj = descriptor3 = resolvedCall2.getResultingDescriptor();
                DeclarationDescriptor declarationDescriptor = obj != null ? obj.getContainingDeclaration() : null;
                if (!(declarationDescriptor instanceof ClassDescriptor)) {
                    declarationDescriptor = null;
                }
                ClassDescriptor containingClass2 = (ClassDescriptor)declarationDescriptor;
                ? obj2 = descriptor3;
                ReceiverParameterDescriptor receiverParameterDescriptor = extensionParameter = obj2 != null ? obj2.getExtensionReceiverParameter() : null;
                if (descriptor3 != null && !(descriptor3 instanceof DebuggerFieldPropertyDescriptor) && extensionParameter != null && containingClass2 != null && containingClass2.getKind() != ClassKind.OBJECT) {
                    CodeFragmentParameter.Smart parameter = CodeFragmentParameterAnalyzer.access$processDispatchReceiver(this.this$0, containingClass2);
                    this.this$0.checkBounds((DeclarationDescriptor)descriptor3, expression2, parameter);
                }
                if (((Boolean)ApplicationUtilsKt.runReadAction((Function0)new Function0<Boolean>(expression2){
                    final /* synthetic */ KtSimpleNameExpression $expression;

                    public final boolean invoke() {
                        return KtPsiUtilKt.isDotSelector(this.$expression);
                    }
                    {
                        this.$expression = ktSimpleNameExpression;
                        super(0);
                    }
                })).booleanValue()) {
                    return;
                }
                if (CodeFragmentParameterAnalyzer.access$isCodeFragmentDeclaration(this.this$0, (DeclarationDescriptor)resolvedCall2.getResultingDescriptor())) {
                    return;
                }
                boolean processed = false;
                ReceiverValue extensionReceiver = resolvedCall2.getExtensionReceiver();
                if (extensionReceiver instanceof ImplicitReceiver) {
                    DeclarationDescriptor descriptor4 = ((ImplicitReceiver)extensionReceiver).getDeclarationDescriptor();
                    CodeFragmentParameter.Smart parameter = CodeFragmentParameterAnalyzer.access$processReceiver(this.this$0, (ImplicitReceiver)extensionReceiver);
                    this.this$0.checkBounds(descriptor4, expression2, parameter);
                    processed = true;
                }
                if ((dispatchReceiver = resolvedCall2.getDispatchReceiver()) instanceof ImplicitReceiver) {
                    descriptor2 = ((ImplicitReceiver)dispatchReceiver).getDeclarationDescriptor();
                    CodeFragmentParameter.Smart parameter = CodeFragmentParameterAnalyzer.access$processReceiver(this.this$0, (ImplicitReceiver)dispatchReceiver);
                    if (parameter != null) {
                        this.this$0.checkBounds(descriptor2, expression2, parameter);
                        processed = true;
                    }
                }
                if (!processed && resolvedCall2.getResultingDescriptor() instanceof SyntheticFieldDescriptor) {
                    ? obj3 = resolvedCall2.getResultingDescriptor();
                    if (obj3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.impl.SyntheticFieldDescriptor");
                    }
                    descriptor2 = (SyntheticFieldDescriptor)obj3;
                    CodeFragmentParameter.Smart parameter = CodeFragmentParameterAnalyzer.access$processSyntheticFieldVariable(this.this$0, (SyntheticFieldDescriptor)descriptor2);
                    if (parameter != null) {
                        this.this$0.checkBounds(descriptor2, expression2, parameter);
                        processed = true;
                    }
                }
                if (!processed) {
                    DeclarationDescriptor declarationDescriptor2 = descriptor2 = resolvedCall2.getResultingDescriptor();
                    Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor2, (String)"descriptor");
                    CodeFragmentParameter.Smart parameter = this.processDescriptor(declarationDescriptor2, expression2);
                    this.this$0.checkBounds(descriptor2, expression2, parameter);
                }
            }

            private final CodeFragmentParameter.Smart processDescriptor(DeclarationDescriptor descriptor2, KtSimpleNameExpression expression2) {
                CodeFragmentParameter.Smart smart;
                CodeFragmentParameter.Smart smart2 = CodeFragmentParameterAnalyzer.access$processDebugLabel(this.this$0, descriptor2);
                if (smart2 == null) {
                    smart2 = smart = CodeFragmentParameterAnalyzer.access$processCoroutineContextCall(this.this$0, descriptor2);
                }
                if (smart2 == null) {
                    smart = CodeFragmentParameterAnalyzer.access$processSimpleNameExpression(this.this$0, descriptor2, expression2);
                }
                return smart;
            }

            @Nullable
            public Void visitThisExpression(@NotNull KtThisExpression expression2, @Nullable Unit data2) {
                CodeFragmentParameter.Smart parameter;
                CodeFragmentParameter.Smart smart;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                T t = ApplicationUtilsKt.runReadAction((Function0)new Function0<KtReferenceExpression>(expression2){
                    final /* synthetic */ KtThisExpression $expression;

                    @NotNull
                    public final KtReferenceExpression invoke() {
                        return this.$expression.getInstanceReference();
                    }
                    {
                        this.$expression = ktThisExpression;
                        super(0);
                    }
                });
                Intrinsics.checkExpressionValueIsNotNull(t, (String)"runReadAction { expression.instanceReference }");
                KtReferenceExpression instanceReference2 = (KtReferenceExpression)t;
                DeclarationDescriptor target = (DeclarationDescriptor)CodeFragmentParameterAnalyzer.access$getBindingContext$p(this.this$0).get(BindingContext.REFERENCE_TARGET, instanceReference2);
                if (CodeFragmentParameterAnalyzer.access$isCodeFragmentDeclaration(this.this$0, target)) {
                    return null;
                }
                DeclarationDescriptor declarationDescriptor = target;
                if (declarationDescriptor instanceof ClassDescriptor) {
                    smart = CodeFragmentParameterAnalyzer.access$processDispatchReceiver(this.this$0, (ClassDescriptor)target);
                } else if (declarationDescriptor instanceof CallableDescriptor) {
                    KotlinType type2;
                    KotlinTypeInfo kotlinTypeInfo = (KotlinTypeInfo)CodeFragmentParameterAnalyzer.access$getBindingContext$p(this.this$0).get(BindingContext.EXPRESSION_TYPE_INFO, expression2);
                    KotlinType kotlinType = type2 = kotlinTypeInfo != null ? kotlinTypeInfo.getType() : null;
                    if (kotlinType != null) {
                        KotlinType kotlinType2 = kotlinType;
                        boolean bl = false;
                        boolean bl2 = false;
                        KotlinType it = kotlinType2;
                        boolean bl3 = false;
                        smart = CodeFragmentParameterAnalyzer.access$processExtensionReceiver(this.this$0, (CallableDescriptor)target, type2, expression2.getLabelName());
                    } else {
                        smart = null;
                    }
                } else {
                    smart = parameter = null;
                }
                if (parameter != null) {
                    this.this$0.checkBounds(target, expression2, parameter);
                }
                return null;
            }

            @Nullable
            public Void visitSuperExpression(@NotNull KtSuperExpression expression2, @Nullable Unit data2) {
                block3: {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    KotlinType kotlinType = (KotlinType)CodeFragmentParameterAnalyzer.access$getBindingContext$p(this.this$0).get(BindingContext.THIS_TYPE_FOR_SUPER_EXPRESSION, expression2);
                    if (kotlinType == null) {
                        return null;
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"bindingContext[BindingCo\u2026xpression] ?: return null");
                    KotlinType type2 = kotlinType;
                    ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
                    if (!(classifierDescriptor instanceof ClassDescriptor)) {
                        classifierDescriptor = null;
                    }
                    ClassDescriptor classDescriptor2 = (ClassDescriptor)classifierDescriptor;
                    if (classDescriptor2 == null) {
                        return null;
                    }
                    ClassDescriptor descriptor2 = classDescriptor2;
                    Map $this$getOrPut$iv = CodeFragmentParameterAnalyzer.access$getParameters$p(this.this$0);
                    boolean $i$f$getOrPut = false;
                    V value$iv = $this$getOrPut$iv.get(descriptor2);
                    if (value$iv != null) break block3;
                    boolean bl = false;
                    String string = descriptor2.getName().asString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"descriptor.name.asString()");
                    String name2 = string;
                    CodeFragmentParameter.Smart answer$iv = new CodeFragmentParameter.Smart(new CodeFragmentParameter.Dumb(CodeFragmentParameter.Kind.DISPATCH_RECEIVER, "", "super@" + name2), type2, descriptor2, false, 8, null);
                    $this$getOrPut$iv.put(descriptor2, answer$iv);
                }
                return null;
            }

            @Nullable
            public Void visitCallExpression(@NotNull KtCallExpression expression2, @Nullable Unit data2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(expression2, CodeFragmentParameterAnalyzer.access$getBindingContext$p(this.this$0));
                if (resolvedCall2 != null) {
                    CallableDescriptor descriptor2 = resolvedCall2.getResultingDescriptor();
                    if (descriptor2 instanceof FunctionDescriptor && ((FunctionDescriptor)descriptor2).isSuspend()) {
                        CodeFragmentParameterAnalyzer.access$getEvaluationStatus$p(this.this$0).error(EvaluationError.SuspendCall);
                        EvaluateException evaluateException = EvaluateExceptionUtil.createEvaluateException((String)KotlinDebuggerEvaluationBundle.message("error.suspend.calls.not.supported", new Object[0]));
                        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)evaluateException), (String)"EvaluateExceptionUtil.cr\u2026                        )");
                        throw (Throwable)evaluateException;
                    }
                    if (descriptor2 instanceof ConstructorDescriptor && KotlinBuiltIns.isNothing(((ConstructorDescriptor)descriptor2).getReturnType())) {
                        EvaluateException evaluateException = EvaluateExceptionUtil.createEvaluateException((String)KotlinDebuggerEvaluationBundle.message("error.nothing.initialization", new Object[0]));
                        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)evaluateException), (String)"EvaluateExceptionUtil.cr\u2026                        )");
                        throw (Throwable)evaluateException;
                    }
                }
                return (Void)super.visitCallExpression(expression2, data2);
            }
            {
                this.this$0 = $outer;
            }
        }, Unit.INSTANCE);
        Collection<CodeFragmentParameter.Smart> collection = this.parameters.values();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"parameters.values");
        return new CodeFragmentParameterInfo(CollectionsKt.toList((Iterable)collection), this.crossingBounds);
    }

    private final CodeFragmentParameter.Smart processReceiver(ImplicitReceiver receiver2) {
        CodeFragmentParameter.Smart smart;
        ImplicitReceiver implicitReceiver = receiver2;
        if (implicitReceiver instanceof ImplicitClassReceiver) {
            smart = this.processDispatchReceiver(((ImplicitClassReceiver)receiver2).getClassDescriptor());
        } else if (implicitReceiver instanceof ExtensionReceiver) {
            CallableDescriptor callableDescriptor = ((ExtensionReceiver)receiver2).getDeclarationDescriptor();
            Intrinsics.checkExpressionValueIsNotNull((Object)callableDescriptor, (String)"receiver.declarationDescriptor");
            KotlinType kotlinType = ((ExtensionReceiver)receiver2).getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"receiver.type");
            smart = this.processExtensionReceiver(callableDescriptor, kotlinType, null);
        } else {
            smart = null;
        }
        return smart;
    }

    private final CodeFragmentParameter.Smart processDispatchReceiver(ClassDescriptor descriptor2) {
        Object object;
        if (descriptor2.getKind() == ClassKind.OBJECT || this.getContainingPrimaryConstructor() != null) {
            return null;
        }
        SimpleType simpleType2 = descriptor2.getDefaultType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"descriptor.defaultType");
        SimpleType type2 = simpleType2;
        Map $this$getOrPut$iv = this.parameters;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(descriptor2);
        if (value$iv == null) {
            boolean bl = false;
            Name name2 = descriptor2.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"descriptor.name");
            Name name3 = name2;
            String debugLabel = name3.isSpecial() ? "" : "@" + name3.asString();
            CodeFragmentParameter.Smart answer$iv = new CodeFragmentParameter.Smart(new CodeFragmentParameter.Dumb(CodeFragmentParameter.Kind.DISPATCH_RECEIVER, "", "this" + debugLabel), type2, descriptor2, false, 8, null);
            $this$getOrPut$iv.put(descriptor2, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (CodeFragmentParameter.Smart)object;
    }

    private final CodeFragmentParameter.Smart processExtensionReceiver(CallableDescriptor descriptor2, KotlinType receiverType2, String label2) {
        Object object;
        if (this.isFakeFunctionForJavaContext(descriptor2)) {
            return this.processFakeJavaCodeReceiver(descriptor2);
        }
        String string = label2;
        if (string == null) {
            string = this.getLabel(descriptor2);
        }
        if (string == null) {
            return null;
        }
        String actualLabel = string;
        ReceiverParameterDescriptor receiverParameterDescriptor = descriptor2.getExtensionReceiverParameter();
        if (receiverParameterDescriptor == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)receiverParameterDescriptor, (String)"descriptor.extensionRece\u2026rParameter ?: return null");
        ReceiverParameterDescriptor receiverParameter = receiverParameterDescriptor;
        Map $this$getOrPut$iv = this.parameters;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(descriptor2);
        if (value$iv == null) {
            boolean bl = false;
            CodeFragmentParameter.Smart answer$iv = new CodeFragmentParameter.Smart(new CodeFragmentParameter.Dumb(CodeFragmentParameter.Kind.EXTENSION_RECEIVER, actualLabel, "this@" + actualLabel), receiverType2, receiverParameter, false, 8, null);
            $this$getOrPut$iv.put(descriptor2, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (CodeFragmentParameter.Smart)object;
    }

    private final String getLabel(CallableDescriptor callableDescriptor) {
        SourceElement sourceElement = callableDescriptor.getSource();
        Intrinsics.checkExpressionValueIsNotNull((Object)sourceElement, (String)"callableDescriptor.source");
        PsiElement source = KotlinSourceElementKt.getPsi(sourceElement);
        if (source instanceof KtFunctionLiteral) {
            String string = CodegenUtilKt.getCallLabelForLambdaArgument((KtFunctionLiteral)source, this.bindingContext);
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                return it;
            }
        }
        Name name2 = callableDescriptor.getName();
        boolean bl = false;
        boolean bl4 = false;
        Name it = name2;
        boolean bl5 = false;
        Name name3 = it;
        Intrinsics.checkExpressionValueIsNotNull((Object)name3, (String)"it");
        Name name4 = !name3.isSpecial() ? name2 : null;
        return name4 != null ? name4.asString() : null;
    }

    private final boolean isFakeFunctionForJavaContext(CallableDescriptor descriptor2) {
        return descriptor2 instanceof FunctionDescriptor && Intrinsics.areEqual((Object)((FunctionDescriptor)descriptor2).getName().asString(), (Object)"_java_locals_debug_fun_") && this.codeFragment.getCopyableUserData(KtCodeFragment.Companion.getFAKE_CONTEXT_FOR_JAVA_FILE()) != null;
    }

    private final CodeFragmentParameter.Smart processFakeJavaCodeReceiver(CallableDescriptor descriptor2) {
        Object object;
        CallableDescriptor callableDescriptor = descriptor2;
        boolean bl = false;
        boolean bl2 = false;
        CallableDescriptor it = callableDescriptor;
        boolean bl3 = false;
        CallableDescriptor callableDescriptor2 = descriptor2 instanceof FunctionDescriptor ? callableDescriptor : null;
        if (callableDescriptor2 == null || (callableDescriptor2 = callableDescriptor2.getExtensionReceiverParameter()) == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)callableDescriptor2, (String)"descriptor\n            .\u2026           ?: return null");
        CallableDescriptor receiverParameter = callableDescriptor2;
        String label2 = "_java_locals_debug_fun_";
        KotlinType kotlinType = receiverParameter.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"receiverParameter.type");
        KotlinType type2 = kotlinType;
        Map $this$getOrPut$iv = this.parameters;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(descriptor2);
        if (value$iv == null) {
            boolean bl4 = false;
            CodeFragmentParameter.Smart answer$iv = new CodeFragmentParameter.Smart(new CodeFragmentParameter.Dumb(CodeFragmentParameter.Kind.FAKE_JAVA_OUTER_CLASS, label2, "this"), type2, receiverParameter, false, 8, null);
            $this$getOrPut$iv.put(descriptor2, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (CodeFragmentParameter.Smart)object;
    }

    private final CodeFragmentParameter.Smart processSyntheticFieldVariable(SyntheticFieldDescriptor descriptor2) {
        Object object;
        PropertyDescriptor propertyDescriptor = descriptor2.getPropertyDescriptor();
        String string = propertyDescriptor.getName().asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"propertyDescriptor.name.asString()");
        String fieldName = string;
        KotlinType kotlinType = propertyDescriptor.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"propertyDescriptor.type");
        KotlinType type2 = kotlinType;
        Map $this$getOrPut$iv = this.parameters;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(descriptor2);
        if (value$iv == null) {
            boolean bl = false;
            CodeFragmentParameter.Smart answer$iv = new CodeFragmentParameter.Smart(new CodeFragmentParameter.Dumb(CodeFragmentParameter.Kind.FIELD_VAR, fieldName, "field"), type2, descriptor2, false, 8, null);
            $this$getOrPut$iv.put(descriptor2, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (CodeFragmentParameter.Smart)object;
    }

    private final CodeFragmentParameter.Smart processSimpleNameExpression(DeclarationDescriptor target, KtSimpleNameExpression expression2) {
        CodeFragmentParameter.Smart smart;
        boolean isPrimaryConstructorParameter;
        if (target instanceof ValueParameterDescriptor && ((ValueParameterDescriptor)target).isCrossinline()) {
            this.evaluationStatus.error(EvaluationError.CrossInlineLambda);
            EvaluateException evaluateException = EvaluateExceptionUtil.createEvaluateException((String)KotlinDebuggerEvaluationBundle.message("error.crossinline.lambda.evaluation", new Object[0]));
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)evaluateException), (String)"EvaluateExceptionUtil.cr\u2026valuation\")\n            )");
            throw (Throwable)evaluateException;
        }
        DeclarationDescriptor declarationDescriptor = target;
        if (!(declarationDescriptor instanceof DeclarationDescriptorWithVisibility)) {
            declarationDescriptor = null;
        }
        DeclarationDescriptorWithVisibility declarationDescriptorWithVisibility = (DeclarationDescriptorWithVisibility)declarationDescriptor;
        boolean isLocalTarget = Intrinsics.areEqual((Object)(declarationDescriptorWithVisibility != null ? declarationDescriptorWithVisibility.getVisibility() : null), (Object)Visibilities.LOCAL);
        boolean bl = isPrimaryConstructorParameter = !isLocalTarget && target instanceof PropertyDescriptor && this.isContainingPrimaryConstructorParameter((PropertyDescriptor)target);
        if (!isLocalTarget && !isPrimaryConstructorParameter) {
            return null;
        }
        DeclarationDescriptor declarationDescriptor2 = target;
        if (declarationDescriptor2 instanceof SimpleFunctionDescriptor) {
            Object object;
            KotlinType kotlinType = FunctionsTypingVisitorKt.createFunctionType((SimpleFunctionDescriptor)target, DescriptorUtilsKt.getBuiltIns(target), ((SimpleFunctionDescriptor)target).isSuspend());
            if (kotlinType == null) {
                return null;
            }
            KotlinType type2 = kotlinType;
            Map $this$getOrPut$iv = this.parameters;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(target);
            if (value$iv == null) {
                boolean bl2 = false;
                String string = ((SimpleFunctionDescriptor)target).getName().asString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"target.name.asString()");
                CodeFragmentParameter.Dumb dumb = new CodeFragmentParameter.Dumb(CodeFragmentParameter.Kind.LOCAL_FUNCTION, string, null, 4, null);
                SimpleFunctionDescriptor simpleFunctionDescriptor = ((SimpleFunctionDescriptor)target).getOriginal();
                Intrinsics.checkExpressionValueIsNotNull((Object)simpleFunctionDescriptor, (String)"target.original");
                CodeFragmentParameter.Smart answer$iv = new CodeFragmentParameter.Smart(dumb, type2, simpleFunctionDescriptor, false, 8, null);
                $this$getOrPut$iv.put(target, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            smart = (CodeFragmentParameter.Smart)object;
        } else if (declarationDescriptor2 instanceof ValueDescriptor) {
            Object object;
            PsiElement parent2 = PsiTreeUtil.skipParentsOfType((PsiElement)((PsiElement)expression2), (Class[])new Class[]{KtParenthesizedExpression.class});
            boolean isLValue = BasicExpressionTypingVisitor.isLValue(expression2, parent2);
            Map $this$getOrPut$iv = this.parameters;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(target);
            if (value$iv == null) {
                boolean bl3 = false;
                KotlinType kotlinType = ((ValueDescriptor)target).getType();
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"target.type");
                KotlinType type3 = kotlinType;
                CodeFragmentParameter.Kind kind2 = target instanceof LocalVariableDescriptor && ((LocalVariableDescriptor)target).isDelegated() ? CodeFragmentParameter.Kind.DELEGATED : CodeFragmentParameter.Kind.ORDINARY;
                String string = ((ValueDescriptor)target).getName().asString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"target.name.asString()");
                CodeFragmentParameter.Smart answer$iv = new CodeFragmentParameter.Smart(new CodeFragmentParameter.Dumb(kind2, string, null, 4, null), type3, target, isLValue);
                $this$getOrPut$iv.put(target, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            smart = (CodeFragmentParameter.Smart)object;
        } else {
            smart = null;
        }
        return smart;
    }

    private final boolean isContainingPrimaryConstructorParameter(PropertyDescriptor target) {
        ConstructorDescriptor constructorDescriptor = this.getContainingPrimaryConstructor();
        if (constructorDescriptor == null) {
            return false;
        }
        ConstructorDescriptor primaryConstructor2 = constructorDescriptor;
        for (ValueParameterDescriptor parameter : primaryConstructor2.getValueParameters()) {
            PropertyDescriptor property2 = (PropertyDescriptor)this.bindingContext.get(BindingContext.VALUE_PARAMETER_AS_PROPERTY, parameter);
            if (!Intrinsics.areEqual((Object)target, (Object)property2)) continue;
            return true;
        }
        return false;
    }

    private final CodeFragmentParameter.Smart processCoroutineContextCall(DeclarationDescriptor target) {
        if (target instanceof PropertyDescriptor && Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe(target), (Object)CoroutineCallCheckerKt.getCOROUTINE_CONTEXT_1_3_FQ_NAME())) {
            Object object;
            Map $this$getOrPut$iv = this.parameters;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(target);
            if (value$iv == null) {
                boolean bl = false;
                CodeFragmentParameter.Dumb dumb = new CodeFragmentParameter.Dumb(CodeFragmentParameter.Kind.COROUTINE_CONTEXT, "", null, 4, null);
                KotlinType kotlinType = ((PropertyDescriptor)target).getType();
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"target.type");
                CodeFragmentParameter.Smart answer$iv = new CodeFragmentParameter.Smart(dumb, kotlinType, target, false, 8, null);
                $this$getOrPut$iv.put(target, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            return (CodeFragmentParameter.Smart)object;
        }
        return null;
    }

    private final CodeFragmentParameter.Smart processDebugLabel(DeclarationDescriptor target) {
        Object object;
        DeclarationDescriptor declarationDescriptor = target;
        if (!(declarationDescriptor instanceof DebugLabelPropertyDescriptor)) {
            declarationDescriptor = null;
        }
        DebugLabelPropertyDescriptor debugLabelPropertyDescriptor = (DebugLabelPropertyDescriptor)declarationDescriptor;
        if (debugLabelPropertyDescriptor == null) {
            return null;
        }
        DebugLabelPropertyDescriptor debugLabelPropertyDescriptor2 = debugLabelPropertyDescriptor;
        String labelName2 = debugLabelPropertyDescriptor2.getLabelName();
        String string = debugLabelPropertyDescriptor2.getName().asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"debugLabelPropertyDescriptor.name.asString()");
        String debugString = string;
        Map $this$getOrPut$iv = this.parameters;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(target);
        if (value$iv == null) {
            boolean bl = false;
            KotlinType kotlinType = debugLabelPropertyDescriptor2.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"debugLabelPropertyDescriptor.type");
            KotlinType type2 = kotlinType;
            CodeFragmentParameter.Smart answer$iv = new CodeFragmentParameter.Smart(new CodeFragmentParameter.Dumb(CodeFragmentParameter.Kind.DEBUG_LABEL, labelName2, debugString), type2, debugLabelPropertyDescriptor2, false, 8, null);
            $this$getOrPut$iv.put(target, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (CodeFragmentParameter.Smart)object;
    }

    public final void checkBounds(@Nullable DeclarationDescriptor descriptor2, @NotNull KtExpression expression2, @Nullable CodeFragmentParameter.Smart parameter) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        if (parameter == null || !(descriptor2 instanceof DeclarationDescriptorWithSource)) {
            return;
        }
        SourceElement sourceElement = ((DeclarationDescriptorWithSource)descriptor2).getSource();
        Intrinsics.checkExpressionValueIsNotNull((Object)sourceElement, (String)"descriptor.source");
        PsiElement targetPsi = KotlinSourceElementKt.getPsi(sourceElement);
        if (targetPsi != null && this.doesCrossInlineBounds((PsiElement)expression2, targetPsi)) {
            Collection collection = this.crossingBounds;
            CodeFragmentParameter.Dumb dumb = parameter.getDumb();
            boolean bl = false;
            collection.add(dumb);
        }
    }

    private final boolean doesCrossInlineBounds(PsiElement expression2, PsiElement declaration2) {
        PsiElement psiElement2;
        Object object;
        PsiElement declarationParent;
        block7: {
            block6: {
                PsiElement psiElement3 = declaration2.getParent();
                if (psiElement3 == null) {
                    return false;
                }
                declarationParent = psiElement3;
                object = expression2.getParent();
                if (object == null) break block6;
                psiElement2 = object;
                boolean bl = false;
                boolean bl2 = false;
                PsiElement it = psiElement2;
                boolean bl3 = false;
                object = this.isInside(it, declarationParent) ? psiElement2 : null;
                if (object != null) break block7;
            }
            return false;
        }
        PsiElement currentParent = object;
        while (currentParent != null && Intrinsics.areEqual((Object)currentParent, (Object)declarationParent) ^ true) {
            SimpleFunctionDescriptor functionDescriptor2;
            if (currentParent instanceof KtFunction && (functionDescriptor2 = (SimpleFunctionDescriptor)this.bindingContext.get(BindingContext.FUNCTION, currentParent)) != null && !functionDescriptor2.isInline()) {
                return true;
            }
            psiElement2 = currentParent;
            currentParent = psiElement2 instanceof KtCodeFragment ? ((KtCodeFragment)currentParent).getContext() : currentParent.getParent();
        }
        return false;
    }

    private final boolean isCodeFragmentDeclaration(DeclarationDescriptor descriptor2) {
        if (descriptor2 instanceof ValueParameterDescriptor && this.isCodeFragmentDeclaration(((ValueParameterDescriptor)descriptor2).getContainingDeclaration())) {
            return true;
        }
        if (!(descriptor2 instanceof DeclarationDescriptorWithSource)) {
            return false;
        }
        SourceElement sourceElement = ((DeclarationDescriptorWithSource)descriptor2).getSource();
        Intrinsics.checkExpressionValueIsNotNull((Object)sourceElement, (String)"descriptor.source");
        PsiElement psiElement2 = KotlinSourceElementKt.getPsi(sourceElement);
        return (psiElement2 != null ? psiElement2.getContainingFile() : null) instanceof KtCodeFragment;
    }

    private final boolean isInside(@NotNull PsiElement $this$isInside, PsiElement parent2) {
        while (!PsiUtilsKt.isAncestor$default(parent2, $this$isInside, false, 2, null)) {
            KtCodeFragment ktCodeFragment;
            PsiFile psiFile2 = $this$isInside.getContainingFile();
            if (!(psiFile2 instanceof KtCodeFragment)) {
                psiFile2 = null;
            }
            if ((ktCodeFragment = (KtCodeFragment)psiFile2) == null || (ktCodeFragment = ktCodeFragment.getContext()) == null) {
                return false;
            }
            KtCodeFragment context2 = ktCodeFragment;
            $this$isInside = context2;
        }
        return true;
    }

    public CodeFragmentParameterAnalyzer(@NotNull ExecutionContext context2, @NotNull KtCodeFragment codeFragment, @NotNull BindingContext bindingContext2, @NotNull EvaluationStatus evaluationStatus) {
        Set set2;
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)codeFragment, (String)"codeFragment");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
        Intrinsics.checkParameterIsNotNull((Object)evaluationStatus, (String)"evaluationStatus");
        this.context = context2;
        this.codeFragment = codeFragment;
        this.bindingContext = bindingContext2;
        this.evaluationStatus = evaluationStatus;
        this.parameters = new LinkedHashMap();
        CodeFragmentParameterAnalyzer codeFragmentParameterAnalyzer = this;
        boolean bl = false;
        codeFragmentParameterAnalyzer.crossingBounds = set2 = (Set)new LinkedHashSet();
        this.onceUsedChecker = new OnceUsedChecker(CodeFragmentParameterAnalyzer.class);
        this.containingPrimaryConstructor$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ConstructorDescriptor>(this){
            final /* synthetic */ CodeFragmentParameterAnalyzer this$0;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final ConstructorDescriptor invoke() {
                PsiElement psiElement2;
                block7: {
                    block6: {
                        void $this$getParentOfType$iv;
                        block5: {
                            block4: {
                                Comparable<Location> comparable = SafeUtilKt.safeLocation((StackFrameProxy)CodeFragmentParameterAnalyzer.access$getContext$p(this.this$0).getFrameProxy());
                                if (comparable == null || (comparable = SafeUtilKt.safeMethod((Location)comparable)) == null) break block4;
                                Comparable<Location> comparable2 = comparable;
                                boolean bl = false;
                                boolean bl2 = false;
                                Comparable<Location> it = comparable2;
                                boolean bl3 = false;
                                comparable = it.isConstructor() ? comparable2 : null;
                                if (comparable != null) break block5;
                            }
                            return null;
                        }
                        psiElement2 = CodeFragmentParameterAnalyzer.access$getCodeFragment$p(this.this$0).getContext();
                        if (psiElement2 == null) break block6;
                        PsiElement psiElement3 = psiElement2;
                        boolean strict$iv = false;
                        boolean $i$f$getParentOfType = false;
                        psiElement2 = (KtPrimaryConstructor)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtPrimaryConstructor.class, (boolean)strict$iv);
                        if (psiElement2 != null) break block7;
                    }
                    return null;
                }
                PsiElement constructor2 = psiElement2;
                return (ConstructorDescriptor)CodeFragmentParameterAnalyzer.access$getBindingContext$p(this.this$0).get(BindingContext.CONSTRUCTOR, constructor2);
            }
            {
                this.this$0 = codeFragmentParameterAnalyzer;
                super(0);
            }
        }));
    }

    public static final /* synthetic */ BindingContext access$getBindingContext$p(CodeFragmentParameterAnalyzer $this) {
        return $this.bindingContext;
    }

    public static final /* synthetic */ CodeFragmentParameter.Smart access$processDispatchReceiver(CodeFragmentParameterAnalyzer $this, ClassDescriptor descriptor2) {
        return $this.processDispatchReceiver(descriptor2);
    }

    public static final /* synthetic */ boolean access$isCodeFragmentDeclaration(CodeFragmentParameterAnalyzer $this, DeclarationDescriptor descriptor2) {
        return $this.isCodeFragmentDeclaration(descriptor2);
    }

    public static final /* synthetic */ CodeFragmentParameter.Smart access$processReceiver(CodeFragmentParameterAnalyzer $this, ImplicitReceiver receiver2) {
        return $this.processReceiver(receiver2);
    }

    public static final /* synthetic */ CodeFragmentParameter.Smart access$processSyntheticFieldVariable(CodeFragmentParameterAnalyzer $this, SyntheticFieldDescriptor descriptor2) {
        return $this.processSyntheticFieldVariable(descriptor2);
    }

    public static final /* synthetic */ CodeFragmentParameter.Smart access$processDebugLabel(CodeFragmentParameterAnalyzer $this, DeclarationDescriptor target) {
        return $this.processDebugLabel(target);
    }

    public static final /* synthetic */ CodeFragmentParameter.Smart access$processCoroutineContextCall(CodeFragmentParameterAnalyzer $this, DeclarationDescriptor target) {
        return $this.processCoroutineContextCall(target);
    }

    public static final /* synthetic */ CodeFragmentParameter.Smart access$processSimpleNameExpression(CodeFragmentParameterAnalyzer $this, DeclarationDescriptor target, KtSimpleNameExpression expression2) {
        return $this.processSimpleNameExpression(target, expression2);
    }

    public static final /* synthetic */ CodeFragmentParameter.Smart access$processExtensionReceiver(CodeFragmentParameterAnalyzer $this, CallableDescriptor descriptor2, KotlinType receiverType2, String label2) {
        return $this.processExtensionReceiver(descriptor2, receiverType2, label2);
    }

    public static final /* synthetic */ LinkedHashMap access$getParameters$p(CodeFragmentParameterAnalyzer $this) {
        return $this.parameters;
    }

    public static final /* synthetic */ EvaluationStatus access$getEvaluationStatus$p(CodeFragmentParameterAnalyzer $this) {
        return $this.evaluationStatus;
    }

    public static final /* synthetic */ ExecutionContext access$getContext$p(CodeFragmentParameterAnalyzer $this) {
        return $this.context;
    }

    public static final /* synthetic */ KtCodeFragment access$getCodeFragment$p(CodeFragmentParameterAnalyzer $this) {
        return $this.codeFragment;
    }
}

