/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.filter;

import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.ui.classFilter.ClassFilter;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.kotlin.idea.debugger.KotlinDebuggerSettings;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u000e\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\u001a\u0006\u0010\u0002\u001a\u00020\u0003\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0004"}, d2={"KOTLIN_STDLIB_FILTER", "", "addKotlinStdlibDebugFilterIfNeeded", "", "jvm-debugger-core"})
public final class DebuggerFiltersUtilKt {
    private static final String KOTLIN_STDLIB_FILTER = "kotlin.*";

    public static final void addKotlinStdlibDebugFilterIfNeeded() {
        if (!KotlinDebuggerSettings.Companion.getInstance().getDEBUG_IS_FILTER_FOR_STDLIB_ALREADY_ADDED()) {
            DebuggerSettings debuggerSettings = DebuggerSettings.getInstance();
            if (debuggerSettings == null) {
                Intrinsics.throwNpe();
            }
            DebuggerSettings settings2 = debuggerSettings;
            Object[] objectArray = settings2.getSteppingFilters();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"settings.steppingFilters");
            ClassFilter[] newFilters = (ClassFilter[])ArraysKt.plus((Object[])objectArray, (Object)new ClassFilter(KOTLIN_STDLIB_FILTER));
            settings2.setSteppingFilters(newFilters);
            KotlinDebuggerSettings.Companion.getInstance().setDEBUG_IS_FILTER_FOR_STDLIB_ALREADY_ADDED(true);
        }
    }

    static {
        KOTLIN_STDLIB_FILTER = KOTLIN_STDLIB_FILTER;
    }
}

