/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.navigation;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StringStubIndexExtension;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.caches.project.BinaryModuleInfo;
import org.jetbrains.kotlin.idea.caches.project.GetModuleInfoKt;
import org.jetbrains.kotlin.idea.caches.project.LibrarySourceInfo;
import org.jetbrains.kotlin.idea.caches.project.SourceForBinaryModuleInfo;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.decompiler.navigation.MemberMatching;
import org.jetbrains.kotlin.idea.decompiler.navigation.SourceNavigationHelper$WhenMappings;
import org.jetbrains.kotlin.idea.decompiler.navigation.SourceNavigationHelperKt;
import org.jetbrains.kotlin.idea.stubindex.KotlinFullClassNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelFunctionFqnNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelPropertyFqnNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelTypeAliasFqNameIndex;
import org.jetbrains.kotlin.idea.util.ExpectActualUtilKt;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.TargetPlatformKt;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationStub;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.debugText.DebugTextUtilKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u000256B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J7\u0010\u0010\u001a\u0004\u0018\u0001H\u0011\"\b\b\u0000\u0010\u0011*\u00020\t2\u0006\u0010\u0012\u001a\u0002H\u00112\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0014H\u0002\u00a2\u0006\u0002\u0010\u0015J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J.\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\t0\u001c2\u0006\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u00182\u000e\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0 H\u0002J\u001e\u0010!\u001a\b\u0012\u0004\u0012\u00020\t0\"2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010#\u001a\u00020$2\u0006\u0010\n\u001a\u00020$J\u0010\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020\u000eJ\u000e\u0010(\u001a\u00020$2\u0006\u0010\n\u001a\u00020$J\u0016\u0010)\u001a\u00020\u00072\f\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\"H\u0002J\u0018\u0010,\u001a\u00020$2\u0006\u0010-\u001a\u00020$2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010.\u001a\u00020/2\u0006\u0010\u0006\u001a\u00020\u0007J\u001e\u00100\u001a\b\u0012\u0004\u0012\u0002010\u001c2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u00102\u001a\b\u0012\u0004\u0012\u0002030\u001c*\u000203H\u0002J\u0018\u00104\u001a\b\u0012\u0004\u0012\u0002010\u001c*\b\u0012\u0004\u0012\u0002010\"H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "forceResolve", "", "convertPropertyOrFunction", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "declaration", "navigationKind", "Lorg/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper$NavigationKind;", "findClassOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "decompiledClassOrObject", "findFirstMatchingInIndex", "T", "entity", "index", "Lcom/intellij/psi/stubs/StringStubIndexExtension;", "(Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;Lorg/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper$NavigationKind;Lcom/intellij/psi/stubs/StringStubIndexExtension;)Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "findSpecialProperty", "memberName", "Lorg/jetbrains/kotlin/name/Name;", "containingClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "getInitialMemberCandidates", "", "sourceClassOrObject", "name", "declarationClass", "Ljava/lang/Class;", "getInitialTopLevelCandidates", "", "getNavigationElement", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "getOriginalClass", "Lcom/intellij/psi/PsiClass;", "classOrObject", "getOriginalElement", "haveRenamesInImports", "files", "Lorg/jetbrains/kotlin/psi/KtFile;", "navigateToDeclaration", "from", "setForceResolve", "", "targetScopes", "Lcom/intellij/psi/search/GlobalSearchScope;", "associatedCommonLibraries", "Lorg/jetbrains/kotlin/idea/caches/project/BinaryModuleInfo;", "union", "NavigationKind", "SourceAndDecompiledConversionVisitor", "idea-core"})
public final class SourceNavigationHelper {
    private static final Logger LOG;
    private static boolean forceResolve;
    public static final SourceNavigationHelper INSTANCE;

    public final void setForceResolve(boolean forceResolve) {
        SourceNavigationHelper.forceResolve = forceResolve;
    }

    /*
     * WARNING - void declaration
     */
    private final List<GlobalSearchScope> targetScopes(KtNamedDeclaration declaration2, NavigationKind navigationKind) {
        List list2;
        KtFile ktFile = declaration2.getContainingKtFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktFile, (String)"declaration.containingKtFile");
        KtFile containingFile = ktFile;
        VirtualFile virtualFile2 = containingFile.getVirtualFile();
        if (virtualFile2 == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile vFile = virtualFile2;
        switch (SourceNavigationHelper$WhenMappings.$EnumSwitchMapping$0[navigationKind.ordinal()]) {
            case 1: {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                void $this$flatMapTo$iv$iv;
                Iterable $this$flatMap$iv;
                boolean bl;
                void $this$mapNotNullTo$iv$iv2;
                void $this$mapNotNull$iv2;
                Project project2 = declaration2.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"declaration.project");
                Collection<BinaryModuleInfo> binaryModuleInfos = GetModuleInfoKt.getBinaryLibrariesModuleInfos(project2, vFile);
                Iterable iterable = binaryModuleInfos;
                SourceNavigationHelper sourceNavigationHelper = this;
                boolean $i$f$mapNotNull22 = false;
                void var9_14 = $this$mapNotNull$iv2;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    GlobalSearchScope globalSearchScope;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl2 = false;
                    BinaryModuleInfo it = (BinaryModuleInfo)element$iv$iv;
                    boolean bl3 = false;
                    SourceForBinaryModuleInfo sourceForBinaryModuleInfo = it.getSourcesModuleInfo();
                    if ((sourceForBinaryModuleInfo != null ? sourceForBinaryModuleInfo.sourceScope() : null) == null) continue;
                    globalSearchScope = globalSearchScope;
                    boolean bl4 = false;
                    bl = false;
                    GlobalSearchScope it$iv$iv = globalSearchScope;
                    boolean bl5 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List list3 = (List)destination$iv$iv;
                List<GlobalSearchScope> primaryScope = sourceNavigationHelper.union(list3);
                Iterable $i$f$mapNotNull22 = binaryModuleInfos;
                sourceNavigationHelper = this;
                boolean $i$f$flatMap = false;
                destination$iv$iv = $this$flatMap$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    BinaryModuleInfo it = (BinaryModuleInfo)element$iv$iv;
                    boolean bl6 = false;
                    Iterable list$iv$iv = INSTANCE.associatedCommonLibraries(it);
                    CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
                }
                list3 = (List)destination$iv$iv2;
                $this$flatMap$iv = list3;
                boolean $i$f$mapNotNull = false;
                $this$flatMapTo$iv$iv = $this$mapNotNull$iv;
                destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo2 = false;
                void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach2 = false;
                Iterator iterator3 = $this$forEach$iv$iv$iv2.iterator();
                while (iterator3.hasNext()) {
                    GlobalSearchScope globalSearchScope;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator3.next();
                    boolean bl7 = false;
                    BinaryModuleInfo it = (BinaryModuleInfo)element$iv$iv;
                    boolean bl8 = false;
                    SourceForBinaryModuleInfo sourceForBinaryModuleInfo = it.getSourcesModuleInfo();
                    if ((sourceForBinaryModuleInfo != null ? sourceForBinaryModuleInfo.sourceScope() : null) == null) continue;
                    globalSearchScope = globalSearchScope;
                    bl = false;
                    boolean bl9 = false;
                    GlobalSearchScope it$iv$iv = globalSearchScope;
                    boolean bl10 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                list3 = (List)destination$iv$iv2;
                List<GlobalSearchScope> additionalScope = sourceNavigationHelper.union(list3);
                list2 = CollectionsKt.plus((Collection)primaryScope, (Iterable)additionalScope);
                break;
            }
            case 2: {
                Collection<GlobalSearchScope> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Project project3 = declaration2.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"declaration.project");
                Iterable binaryModuleInfos = GetModuleInfoKt.getLibrarySourcesModuleInfos(project3, vFile);
                SourceNavigationHelper sourceNavigationHelper = this;
                boolean $i$f$map = false;
                void additionalScope = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    LibrarySourceInfo $i$f$mapNotNullTo2 = (LibrarySourceInfo)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    GlobalSearchScope globalSearchScope = it.getBinariesModuleInfo().binariesScope();
                    collection.add(globalSearchScope);
                }
                collection = (List)destination$iv$iv;
                list2 = sourceNavigationHelper.union((Collection<? extends GlobalSearchScope>)collection);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<BinaryModuleInfo> associatedCommonLibraries(@NotNull BinaryModuleInfo $this$associatedCommonLibraries) {
        void $this$filterTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        TargetPlatform platform = $this$associatedCommonLibraries.getPlatform();
        if (platform == null || TargetPlatformKt.isCommon(platform)) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$filterIsInstance$iv = $this$associatedCommonLibraries.dependencies();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof BinaryModuleInfo)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            BinaryModuleInfo it = (BinaryModuleInfo)element$iv$iv;
            boolean bl = false;
            if (!TargetPlatformKt.isCommon(it.getPlatform())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<GlobalSearchScope> union(@NotNull Collection<? extends GlobalSearchScope> $this$union) {
        List list2;
        Collection<? extends GlobalSearchScope> collection = $this$union;
        boolean bl = false;
        if (!collection.isEmpty()) {
            Collection<? extends GlobalSearchScope> $this$toTypedArray$iv = $this$union;
            boolean $i$f$toTypedArray = false;
            Collection<? extends GlobalSearchScope> thisCollection$iv = $this$toTypedArray$iv;
            GlobalSearchScope[] globalSearchScopeArray = thisCollection$iv.toArray(new GlobalSearchScope[0]);
            if (globalSearchScopeArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            list2 = CollectionsKt.listOf((Object)GlobalSearchScope.union((GlobalSearchScope[])globalSearchScopeArray));
        } else {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    private final boolean haveRenamesInImports(Collection<? extends KtFile> files2) {
        boolean bl;
        block7: {
            Iterable $this$any$iv = files2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    block6: {
                        KtFile file2 = (KtFile)element$iv;
                        boolean bl3 = false;
                        Iterable $this$any$iv2 = file2.getImportDirectives();
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                KtImportDirective it = (KtImportDirective)element$iv2;
                                boolean bl4 = false;
                                if (!(it.getAliasName() != null)) continue;
                                bl2 = true;
                                break block6;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final KtNamedDeclaration findSpecialProperty(Name memberName2, KtClass containingClass2) {
        List<KtParameter> constructorParameters = containingClass2.getPrimaryConstructorParameters();
        for (KtParameter constructorParameter : constructorParameters) {
            if (!Intrinsics.areEqual((Object)memberName2, (Object)constructorParameter.getNameAsName()) || !constructorParameter.hasValOrVar()) continue;
            return constructorParameter;
        }
        if (containingClass2.hasModifier(KtTokens.ENUM_KEYWORD)) {
            Iterator<KtParameter> iterator2 = ContainerUtil.findAll((Collection)containingClass2.getDeclarations(), KtEnumEntry.class).iterator();
            while (iterator2.hasNext()) {
                KtEnumEntry enumEntry;
                KtEnumEntry ktEnumEntry = enumEntry = (KtEnumEntry)((Object)iterator2.next());
                Intrinsics.checkExpressionValueIsNotNull((Object)ktEnumEntry, (String)"enumEntry");
                if (!Intrinsics.areEqual((Object)memberName2, (Object)ktEnumEntry.getNameAsName())) continue;
                return enumEntry;
            }
        }
        return null;
    }

    private final KtNamedDeclaration convertPropertyOrFunction(KtNamedDeclaration declaration2, NavigationKind navigationKind) {
        Object sourceClassOrObject;
        if (declaration2 instanceof KtPrimaryConstructor) {
            KtClassOrObject sourceClassOrObject2 = this.findClassOrObject(((KtPrimaryConstructor)declaration2).getContainingClassOrObject(), navigationKind);
            KtDeclarationStub ktDeclarationStub = sourceClassOrObject2;
            return ktDeclarationStub != null && (ktDeclarationStub = ktDeclarationStub.getPrimaryConstructor()) != null ? (KtNamedDeclaration)((Object)ktDeclarationStub) : (KtNamedDeclaration)sourceClassOrObject2;
        }
        String memberNameAsString = declaration2.getName();
        if (memberNameAsString == null) {
            LOG.debug("Declaration with null name:" + DebugTextUtilKt.getDebugText(declaration2));
            return null;
        }
        Name name2 = Name.identifier(memberNameAsString);
        Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"Name.identifier(memberNameAsString)");
        Name memberName2 = name2;
        PsiElement decompiledContainer = declaration2.getParent();
        Collection candidates2 = null;
        PsiElement psiElement2 = decompiledContainer;
        if (psiElement2 instanceof KtFile) {
            candidates2 = this.getInitialTopLevelCandidates(declaration2, navigationKind);
        } else if (psiElement2 instanceof KtClassBody) {
            List<KtNamedDeclaration> list2;
            boolean bl;
            KtClassOrObject ktClassOrObject;
            PsiElement psiElement3 = decompiledContainer.getParent();
            if (psiElement3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtClassOrObject");
            }
            KtClassOrObject decompiledClassOrObject = (KtClassOrObject)psiElement3;
            sourceClassOrObject = this.findClassOrObject(decompiledClassOrObject, navigationKind);
            KtClassOrObject ktClassOrObject2 = sourceClassOrObject;
            if (ktClassOrObject2 != null) {
                ktClassOrObject = ktClassOrObject2;
                bl = false;
                boolean bl2 = false;
                KtClassOrObject it = ktClassOrObject;
                boolean bl3 = false;
                list2 = INSTANCE.getInitialMemberCandidates((KtClassOrObject)sourceClassOrObject, memberName2, declaration2.getClass());
            } else {
                list2 = null;
            }
            ktClassOrObject = list2;
            bl = false;
            Object object = ktClassOrObject;
            if (object == null) {
                object = CollectionsKt.emptyList();
            }
            candidates2 = (Collection)object;
            if (candidates2.isEmpty() && declaration2 instanceof KtProperty && sourceClassOrObject instanceof KtClass) {
                return this.findSpecialProperty(memberName2, (KtClass)sourceClassOrObject);
            }
        } else {
            throw (Throwable)new IllegalStateException("Unexpected container of " + (navigationKind == NavigationKind.CLASS_FILES_TO_SOURCES ? "decompiled" : "source") + " declaration: " + decompiledContainer.getClass().getSimpleName());
        }
        if (candidates2.isEmpty()) {
            return null;
        }
        if (!forceResolve) {
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv = candidates2;
            boolean $i$f$filter = false;
            sourceClassOrObject = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KtNamedDeclaration it = (KtNamedDeclaration)element$iv$iv;
                boolean bl = false;
                if (!MemberMatching.sameReceiverPresenceAndParametersCount(it, declaration2)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            candidates2 = (List)destination$iv$iv;
            if (candidates2.size() <= 1) {
                return (KtNamedDeclaration)CollectionsKt.firstOrNull((List)((List)candidates2));
            }
            if (!this.haveRenamesInImports(SourceNavigationHelperKt.access$getContainingFiles(candidates2))) {
                $this$filter$iv = candidates2;
                $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    KtNamedDeclaration it = (KtNamedDeclaration)element$iv$iv;
                    boolean bl = false;
                    if (!MemberMatching.receiverAndParametersShortTypesMatch(it, declaration2)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                candidates2 = (List)destination$iv$iv;
                if (candidates2.size() <= 1) {
                    return (KtNamedDeclaration)CollectionsKt.firstOrNull((List)((List)candidates2));
                }
            }
        }
        for (KtNamedDeclaration candidate2 : candidates2) {
            CallableDescriptor candidateDescriptor;
            DeclarationDescriptor declarationDescriptor = ResolutionUtils.resolveToDescriptorIfAny$default((KtDeclaration)candidate2, null, (int)1, null);
            if (!(declarationDescriptor instanceof CallableDescriptor)) {
                declarationDescriptor = null;
            }
            if ((CallableDescriptor)declarationDescriptor == null) {
                continue;
            }
            if (!MemberMatching.receiversMatch(declaration2, candidateDescriptor) || !MemberMatching.valueParametersTypesMatch(declaration2, candidateDescriptor)) continue;
            KtNamedDeclaration ktNamedDeclaration = declaration2;
            if (ktNamedDeclaration == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtTypeParameterListOwner");
            }
            if (!MemberMatching.typeParametersMatch((KtTypeParameterListOwner)ktNamedDeclaration, candidateDescriptor.getTypeParameters())) continue;
            return candidate2;
        }
        return null;
    }

    private final <T extends KtNamedDeclaration> T findFirstMatchingInIndex(T entity, NavigationKind navigationKind, StringStubIndexExtension<T> index2) {
        KtNamedDeclaration ktNamedDeclaration;
        block7: {
            FqName fqName2 = entity.getFqName();
            if (fqName2 == null) {
                return null;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"entity.fqName ?: return null");
            FqName classFqName = fqName2;
            Iterable $this$firstNotNullResult$iv = this.targetScopes(entity, navigationKind);
            boolean $i$f$firstNotNullResult = false;
            for (Object element$iv : $this$firstNotNullResult$iv) {
                KtNamedDeclaration result$iv;
                Object v2;
                GlobalSearchScope scope2 = (GlobalSearchScope)element$iv;
                boolean bl = false;
                Collection collection = index2.get((Object)classFqName.asString(), entity.getProject(), scope2);
                Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"index.get(classFqName.as\u2026), entity.project, scope)");
                Iterable $this$minBy$iv = collection;
                boolean $i$f$minBy = false;
                Iterator iterator$iv = $this$minBy$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    v2 = null;
                } else {
                    Object minElem$iv = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        v2 = minElem$iv;
                    } else {
                        KtNamedDeclaration it = (KtNamedDeclaration)minElem$iv;
                        boolean bl2 = false;
                        KtNamedDeclaration ktNamedDeclaration2 = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)ktNamedDeclaration2, (String)"it");
                        boolean minValue$iv = ExpectActualUtilKt.isExpectDeclaration(ktNamedDeclaration2);
                        do {
                            Object e$iv = iterator$iv.next();
                            KtNamedDeclaration it2 = (KtNamedDeclaration)e$iv;
                            $i$a$-minBy-SourceNavigationHelper$findFirstMatchingInIndex$1$1 = false;
                            KtNamedDeclaration ktNamedDeclaration3 = it2;
                            Intrinsics.checkExpressionValueIsNotNull((Object)ktNamedDeclaration3, (String)"it");
                            boolean v$iv = ExpectActualUtilKt.isExpectDeclaration(ktNamedDeclaration3);
                            if (minValue$iv <= v$iv) continue;
                            minElem$iv = e$iv;
                            minValue$iv = v$iv;
                        } while (iterator$iv.hasNext());
                        v2 = minElem$iv;
                    }
                }
                if ((result$iv = (KtNamedDeclaration)v2) == null) continue;
                ktNamedDeclaration = result$iv;
                break block7;
            }
            ktNamedDeclaration = null;
        }
        return (T)ktNamedDeclaration;
    }

    private final KtClassOrObject findClassOrObject(KtClassOrObject decompiledClassOrObject, NavigationKind navigationKind) {
        KtNamedDeclaration ktNamedDeclaration = decompiledClassOrObject;
        KotlinFullClassNameIndex kotlinFullClassNameIndex = KotlinFullClassNameIndex.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)kotlinFullClassNameIndex), (String)"KotlinFullClassNameIndex.getInstance()");
        return (KtClassOrObject)this.findFirstMatchingInIndex(ktNamedDeclaration, navigationKind, kotlinFullClassNameIndex);
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<KtNamedDeclaration> getInitialTopLevelCandidates(KtNamedDeclaration declaration2, NavigationKind navigationKind) {
        void $this$flatMapTo$iv$iv;
        StringStubIndexExtension stringStubIndexExtension;
        List<GlobalSearchScope> scopes = this.targetScopes(declaration2, navigationKind);
        KtNamedDeclaration ktNamedDeclaration = declaration2;
        if (ktNamedDeclaration instanceof KtNamedFunction) {
            KotlinTopLevelFunctionFqnNameIndex kotlinTopLevelFunctionFqnNameIndex = KotlinTopLevelFunctionFqnNameIndex.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)kotlinTopLevelFunctionFqnNameIndex), (String)"KotlinTopLevelFunctionFqnNameIndex.getInstance()");
            stringStubIndexExtension = kotlinTopLevelFunctionFqnNameIndex;
        } else if (ktNamedDeclaration instanceof KtProperty) {
            KotlinTopLevelPropertyFqnNameIndex kotlinTopLevelPropertyFqnNameIndex = KotlinTopLevelPropertyFqnNameIndex.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)kotlinTopLevelPropertyFqnNameIndex), (String)"KotlinTopLevelPropertyFqnNameIndex.getInstance()");
            stringStubIndexExtension = kotlinTopLevelPropertyFqnNameIndex;
        } else {
            throw (Throwable)new IllegalArgumentException("Neither function nor declaration: " + declaration2.getClass().getName());
        }
        StringStubIndexExtension index2 = stringStubIndexExtension;
        Iterable $this$flatMap$iv = scopes;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            GlobalSearchScope scope2 = (GlobalSearchScope)element$iv$iv;
            boolean bl = false;
            FqName fqName2 = declaration2.getFqName();
            if (fqName2 == null) {
                Intrinsics.throwNpe();
            }
            Collection collection = index2.get((Object)fqName2.asString(), declaration2.getProject(), scope2);
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"index.get(declaration.fq\u2026claration.project, scope)");
            Iterable $this$sortedBy$iv = collection;
            boolean $i$f$sortedBy = false;
            Iterable iterable2 = $this$sortedBy$iv;
            boolean bl2 = false;
            Comparator comparator = new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    KtNamedDeclaration it = (KtNamedDeclaration)a;
                    boolean bl2 = false;
                    KtNamedDeclaration ktNamedDeclaration = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktNamedDeclaration, (String)"it");
                    it = (KtNamedDeclaration)b;
                    Comparable comparable = Boolean.valueOf(ExpectActualUtilKt.isExpectDeclaration(ktNamedDeclaration));
                    bl2 = false;
                    KtNamedDeclaration ktNamedDeclaration2 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktNamedDeclaration2, (String)"it");
                    Boolean bl3 = ExpectActualUtilKt.isExpectDeclaration(ktNamedDeclaration2);
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)bl3);
                }
            };
            Iterable list$iv$iv = CollectionsKt.sortedWith((Iterable)iterable2, (Comparator)comparator);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<KtNamedDeclaration> getInitialMemberCandidates(KtClassOrObject sourceClassOrObject, Name name2, Class<? extends KtNamedDeclaration> declarationClass2) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = CollectionsKt.filterIsInstance((Iterable)sourceClassOrObject.getDeclarations(), declarationClass2);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KtNamedDeclaration declaration2 = (KtNamedDeclaration)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)name2, (Object)declaration2.getNameAsSafeName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final PsiClass getOriginalClass(@NotNull KtClassOrObject classOrObject) {
        Intrinsics.checkParameterIsNotNull((Object)classOrObject, (String)"classOrObject");
        FqName fqName2 = classOrObject.getFqName();
        if (fqName2 == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"classOrObject.fqName ?: return null");
        FqName fqName3 = fqName2;
        KtFile ktFile = classOrObject.getContainingKtFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktFile, (String)"classOrObject.containingKtFile");
        KtFile file2 = ktFile;
        VirtualFile vFile = file2.getVirtualFile();
        Project project2 = file2.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"file.project");
        Project project3 = project2;
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)project3);
        Intrinsics.checkExpressionValueIsNotNull((Object)projectRootManager, (String)"ProjectRootManager.getInstance(project)");
        ProjectFileIndex projectFileIndex = projectRootManager.getFileIndex();
        Intrinsics.checkExpressionValueIsNotNull((Object)projectFileIndex, (String)"ProjectRootManager.getInstance(project).fileIndex");
        ProjectFileIndex idx = projectFileIndex;
        if (vFile == null || !idx.isInLibrarySource(vFile)) {
            return null;
        }
        THashSet orderEntries = new THashSet((Collection)idx.getOrderEntriesForFile(vFile));
        return JavaPsiFacade.getInstance((Project)project3).findClass(fqName3.asString(), new GlobalSearchScope(idx, orderEntries, project3, project3){
            final /* synthetic */ ProjectFileIndex $idx;
            final /* synthetic */ THashSet $orderEntries;
            final /* synthetic */ Project $project;

            public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
                Intrinsics.checkParameterIsNotNull((Object)file1, (String)"file1");
                Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file2");
                return 0;
            }

            public boolean contains(@NotNull VirtualFile file2) {
                boolean bl;
                block3: {
                    Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
                    List list2 = this.$idx.getOrderEntriesForFile(file2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"idx.getOrderEntriesForFile(file)");
                    List entries2 = list2;
                    Iterable $this$any$iv = entries2;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            OrderEntry it = (OrderEntry)element$iv;
                            boolean bl2 = false;
                            if (!this.$orderEntries.contains((Object)it)) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                return bl;
            }

            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                Intrinsics.checkParameterIsNotNull((Object)aModule, (String)"aModule");
                return false;
            }

            public boolean isSearchInLibraries() {
                return true;
            }
            {
                this.$idx = $captured_local_variable$0;
                this.$orderEntries = $captured_local_variable$1;
                this.$project = $captured_local_variable$2;
                super($super_call_param$3);
            }
        });
    }

    @NotNull
    public final KtDeclaration getNavigationElement(@NotNull KtDeclaration declaration2) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        return this.navigateToDeclaration(declaration2, NavigationKind.CLASS_FILES_TO_SOURCES);
    }

    @NotNull
    public final KtDeclaration getOriginalElement(@NotNull KtDeclaration declaration2) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        return this.navigateToDeclaration(declaration2, NavigationKind.SOURCES_TO_CLASS_FILES);
    }

    private final KtDeclaration navigateToDeclaration(KtDeclaration from, NavigationKind navigationKind) {
        KtDeclaration ktDeclaration;
        if (DumbService.isDumb((Project)from.getProject())) {
            return from;
        }
        switch (SourceNavigationHelper$WhenMappings.$EnumSwitchMapping$1[navigationKind.ordinal()]) {
            case 1: {
                if (from.getContainingKtFile().isCompiled()) break;
                return from;
            }
            case 2: {
                PsiFile file2 = from.getContainingFile();
                if (file2 instanceof KtFile && ((KtFile)file2).isCompiled()) {
                    return from;
                }
                if (!ProjectRootsUtil.isInContent(from, false, true, false, true, false)) {
                    return from;
                }
                if (!KtPsiUtil.isLocal(from)) break;
                return from;
            }
        }
        if ((ktDeclaration = (KtDeclaration)from.accept(new SourceAndDecompiledConversionVisitor(navigationKind), Unit.INSTANCE)) == null) {
            ktDeclaration = from;
        }
        return ktDeclaration;
    }

    private SourceNavigationHelper() {
    }

    static {
        SourceNavigationHelper sourceNavigationHelper;
        INSTANCE = sourceNavigationHelper = new SourceNavigationHelper();
        Logger logger = Logger.getInstance(SourceNavigationHelper.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(Sourc\u2026gationHelper::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper$NavigationKind;", "", "(Ljava/lang/String;I)V", "CLASS_FILES_TO_SOURCES", "SOURCES_TO_CLASS_FILES", "idea-core"})
    public static final class NavigationKind
    extends Enum<NavigationKind> {
        public static final /* enum */ NavigationKind CLASS_FILES_TO_SOURCES;
        public static final /* enum */ NavigationKind SOURCES_TO_CLASS_FILES;
        private static final /* synthetic */ NavigationKind[] $VALUES;

        static {
            NavigationKind[] navigationKindArray = new NavigationKind[2];
            NavigationKind[] navigationKindArray2 = navigationKindArray;
            navigationKindArray[0] = CLASS_FILES_TO_SOURCES = new NavigationKind();
            navigationKindArray[1] = SOURCES_TO_CLASS_FILES = new NavigationKind();
            $VALUES = navigationKindArray;
        }

        public static NavigationKind[] values() {
            return (NavigationKind[])$VALUES.clone();
        }

        public static NavigationKind valueOf(String string) {
            return Enum.valueOf(NavigationKind.class, string);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001f\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\fJ\u001f\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u0011J\u001f\u0010\u0012\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u0015J\u001f\u0010\u0016\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u0019J\u001f\u0010\u001a\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u001f\u0010\u001e\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010!J\u001f\u0010\"\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001b\u001a\u00020#2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010$J\u001f\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020&2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010(R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper$SourceAndDecompiledConversionVisitor;", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "", "navigationKind", "Lorg/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper$NavigationKind;", "(Lorg/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper$NavigationKind;)V", "visitClass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "data", "(Lorg/jetbrains/kotlin/psi/KtClass;Lkotlin/Unit;)Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "visitNamedFunction", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "(Lorg/jetbrains/kotlin/psi/KtNamedFunction;Lkotlin/Unit;)Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "visitObjectDeclaration", "declaration", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "(Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;Lkotlin/Unit;)Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "visitParameter", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "(Lorg/jetbrains/kotlin/psi/KtParameter;Lkotlin/Unit;)Lorg/jetbrains/kotlin/psi/KtDeclaration;", "visitPrimaryConstructor", "constructor", "Lorg/jetbrains/kotlin/psi/KtPrimaryConstructor;", "(Lorg/jetbrains/kotlin/psi/KtPrimaryConstructor;Lkotlin/Unit;)Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "visitProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "(Lorg/jetbrains/kotlin/psi/KtProperty;Lkotlin/Unit;)Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "visitSecondaryConstructor", "Lorg/jetbrains/kotlin/psi/KtSecondaryConstructor;", "(Lorg/jetbrains/kotlin/psi/KtSecondaryConstructor;Lkotlin/Unit;)Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "visitTypeAlias", "Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "typeAlias", "(Lorg/jetbrains/kotlin/psi/KtTypeAlias;Lkotlin/Unit;)Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "idea-core"})
    private static final class SourceAndDecompiledConversionVisitor
    extends KtVisitor<KtDeclaration, Unit> {
        private final NavigationKind navigationKind;

        @Override
        @Nullable
        public KtNamedDeclaration visitNamedFunction(@NotNull KtNamedFunction function2, @NotNull Unit data2) {
            Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
            Intrinsics.checkParameterIsNotNull((Object)data2, (String)"data");
            return INSTANCE.convertPropertyOrFunction(function2, this.navigationKind);
        }

        @Override
        @Nullable
        public KtNamedDeclaration visitProperty(@NotNull KtProperty property2, @NotNull Unit data2) {
            Intrinsics.checkParameterIsNotNull((Object)property2, (String)"property");
            Intrinsics.checkParameterIsNotNull((Object)data2, (String)"data");
            return INSTANCE.convertPropertyOrFunction(property2, this.navigationKind);
        }

        @Override
        @Nullable
        public KtClassOrObject visitObjectDeclaration(@NotNull KtObjectDeclaration declaration2, @NotNull Unit data2) {
            Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
            Intrinsics.checkParameterIsNotNull((Object)data2, (String)"data");
            return INSTANCE.findClassOrObject(declaration2, this.navigationKind);
        }

        @Override
        @Nullable
        public KtClassOrObject visitClass(@NotNull KtClass klass2, @NotNull Unit data2) {
            Intrinsics.checkParameterIsNotNull((Object)klass2, (String)"klass");
            Intrinsics.checkParameterIsNotNull((Object)data2, (String)"data");
            return INSTANCE.findClassOrObject(klass2, this.navigationKind);
        }

        @Override
        @Nullable
        public KtTypeAlias visitTypeAlias(@NotNull KtTypeAlias typeAlias2, @NotNull Unit data2) {
            Intrinsics.checkParameterIsNotNull((Object)typeAlias2, (String)"typeAlias");
            Intrinsics.checkParameterIsNotNull((Object)data2, (String)"data");
            return (KtTypeAlias)INSTANCE.findFirstMatchingInIndex(typeAlias2, this.navigationKind, KotlinTopLevelTypeAliasFqNameIndex.Companion.getInstance());
        }

        @Override
        @Nullable
        public KtDeclaration visitParameter(@NotNull KtParameter parameter, @NotNull Unit data2) {
            Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
            Intrinsics.checkParameterIsNotNull((Object)data2, (String)"data");
            PsiElement psiElement2 = parameter.getParent();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"parameter.parent");
            PsiElement psiElement3 = psiElement2.getParent();
            if (psiElement3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallableDeclaration");
            }
            KtCallableDeclaration callableDeclaration = (KtCallableDeclaration)psiElement3;
            List<KtParameter> list2 = callableDeclaration.getValueParameters();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"callableDeclaration.valueParameters");
            List<KtParameter> parameters2 = list2;
            int index2 = parameters2.indexOf(parameter);
            Object r = callableDeclaration.accept(this, Unit.INSTANCE);
            if (!(r instanceof KtCallableDeclaration)) {
                r = null;
            }
            KtCallableDeclaration ktCallableDeclaration = (KtCallableDeclaration)r;
            if (ktCallableDeclaration == null) {
                return null;
            }
            KtCallableDeclaration sourceCallable = ktCallableDeclaration;
            List<KtParameter> list3 = sourceCallable.getValueParameters();
            Intrinsics.checkExpressionValueIsNotNull(list3, (String)"sourceCallable.valueParameters");
            List<KtParameter> sourceParameters = list3;
            if (sourceParameters.size() != parameters2.size()) {
                return null;
            }
            return sourceParameters.get(index2);
        }

        @Override
        @Nullable
        public KtNamedDeclaration visitPrimaryConstructor(@NotNull KtPrimaryConstructor constructor2, @NotNull Unit data2) {
            Intrinsics.checkParameterIsNotNull((Object)constructor2, (String)"constructor");
            Intrinsics.checkParameterIsNotNull((Object)data2, (String)"data");
            return INSTANCE.convertPropertyOrFunction(constructor2, this.navigationKind);
        }

        @Override
        @Nullable
        public KtNamedDeclaration visitSecondaryConstructor(@NotNull KtSecondaryConstructor constructor2, @NotNull Unit data2) {
            Intrinsics.checkParameterIsNotNull((Object)constructor2, (String)"constructor");
            Intrinsics.checkParameterIsNotNull((Object)data2, (String)"data");
            return INSTANCE.convertPropertyOrFunction(constructor2, this.navigationKind);
        }

        public SourceAndDecompiledConversionVisitor(@NotNull NavigationKind navigationKind) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)navigationKind), (String)"navigationKind");
            this.navigationKind = navigationKind;
        }
    }
}

