/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.stubBuilder;

import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.io.StringRef;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClsStubBuilderContext;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClsStubBuildingKt;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.TypeClsStubBuilder;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.flags.FlagsKt;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.flags.FlagsToModifiers;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.Flags;
import org.jetbrains.kotlin.metadata.deserialization.NameResolver;
import org.jetbrains.kotlin.metadata.deserialization.ProtoTypeTableUtilKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinModifierListStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinTypeAliasStubImpl;
import org.jetbrains.kotlin.serialization.deserialization.NameResolverUtilKt;
import org.jetbrains.kotlin.serialization.deserialization.ProtoContainer;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a.\u0010\u0000\u001a\u00020\u00012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"createTypeAliasStub", "", "parent", "Lcom/intellij/psi/stubs/StubElement;", "Lcom/intellij/psi/PsiElement;", "typeAliasProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$TypeAlias;", "protoContainer", "Lorg/jetbrains/kotlin/serialization/deserialization/ProtoContainer;", "context", "Lorg/jetbrains/kotlin/idea/decompiler/stubBuilder/ClsStubBuilderContext;", "idea-core"})
public final class TypeAliasClsStubBuildingKt {
    /*
     * WARNING - void declaration
     */
    public static final void createTypeAliasStub(@NotNull StubElement<? extends PsiElement> parent2, @NotNull ProtoBuf.TypeAlias typeAliasProto, @NotNull ProtoContainer protoContainer, @NotNull ClsStubBuilderContext context2) {
        ClassId classId;
        Intrinsics.checkParameterIsNotNull(parent2, (String)"parent");
        Intrinsics.checkParameterIsNotNull((Object)typeAliasProto, (String)"typeAliasProto");
        Intrinsics.checkParameterIsNotNull((Object)protoContainer, (String)"protoContainer");
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Name shortName = NameResolverUtilKt.getName(context2.getNameResolver(), typeAliasProto.getName());
        ProtoContainer protoContainer2 = protoContainer;
        if (protoContainer2 instanceof ProtoContainer.Class) {
            classId = ((ProtoContainer.Class)protoContainer).getClassId().createNestedClassId(shortName);
        } else if (protoContainer2 instanceof ProtoContainer.Package) {
            classId = ClassId.topLevel(((ProtoContainer.Package)protoContainer).getFqName().child(shortName));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)classId, (String)"when (protoContainer) {\n\u2026e.child(shortName))\n    }");
        ClassId classId2 = classId;
        Name name2 = classId2.getShortClassName();
        Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"classId.shortClassName");
        StringRef stringRef = ClsStubBuildingKt.ref(name2);
        FqName fqName2 = classId2.asSingleFqName();
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"classId.asSingleFqName()");
        KotlinTypeAliasStubImpl typeAlias2 = new KotlinTypeAliasStubImpl(parent2, stringRef, ClsStubBuildingKt.ref(fqName2), !classId2.isNestedClass());
        List list2 = CollectionsKt.arrayListOf((Object[])new FlagsToModifiers[]{FlagsKt.getVISIBILITY()});
        int n = typeAliasProto.getFlags();
        Object object = (StubElement)typeAlias2;
        boolean bl = false;
        List list3 = CollectionsKt.emptyList();
        KotlinModifierListStubImpl modifierList2 = ClsStubBuildingKt.createModifierListStubForDeclaration((StubElement<? extends PsiElement>)object, n, list2, list3);
        TypeClsStubBuilder typeStubBuilder = new TypeClsStubBuilder(context2);
        StubElement stubElement = (StubElement)typeAlias2;
        List<ProtoBuf.TypeParameter> list4 = typeAliasProto.getTypeParameterList();
        Intrinsics.checkExpressionValueIsNotNull(list4, (String)"typeAliasProto.typeParameterList");
        List<Pair<Name, ProtoBuf.Type>> restConstraints = typeStubBuilder.createTypeParameterListStub((StubElement<? extends PsiElement>)stubElement, list4);
        boolean bl2 = restConstraints.isEmpty();
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl2) {
            boolean $i$a$-assert-TypeAliasClsStubBuildingKt$createTypeAliasStub$22 = false;
            String $i$a$-assert-TypeAliasClsStubBuildingKt$createTypeAliasStub$22 = "'where' constraints are not allowed for type aliases";
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-TypeAliasClsStubBuildingKt$createTypeAliasStub$22));
        }
        Boolean bl4 = Flags.HAS_ANNOTATIONS.get(typeAliasProto.getFlags());
        Intrinsics.checkExpressionValueIsNotNull((Object)bl4, (String)"Flags.HAS_ANNOTATIONS.get(typeAliasProto.flags)");
        if (bl4.booleanValue()) {
            void $this$mapTo$iv$iv;
            List<ProtoBuf.Annotation> list5 = typeAliasProto.getAnnotationList();
            Intrinsics.checkExpressionValueIsNotNull(list5, (String)"typeAliasProto.annotationList");
            Iterable $this$map$iv = list5;
            boolean $i$f$map = false;
            Iterable $i$a$-assert-TypeAliasClsStubBuildingKt$createTypeAliasStub$22 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ProtoBuf.Annotation annotation2 = (ProtoBuf.Annotation)item$iv$iv;
                object = destination$iv$iv;
                boolean bl5 = false;
                NameResolver nameResolver = context2.getNameResolver();
                void v9 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v9, (String)"it");
                ClassId classId3 = NameResolverUtilKt.getClassId(nameResolver, v9.getId());
                object.add(classId3);
            }
            ClsStubBuildingKt.createAnnotationStubs((List)destination$iv$iv, modifierList2);
        }
        ProtoBuf.Type typeAliasUnderlyingType = ProtoTypeTableUtilKt.underlyingType(typeAliasProto, context2.getTypeTable());
        TypeClsStubBuilder.createTypeReferenceStub$default(typeStubBuilder, (StubElement)typeAlias2, typeAliasUnderlyingType, null, 4, null);
    }
}

