/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.findUsages;

import com.intellij.CommonBundle;
import com.intellij.find.FindBundle;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesHandlerFactory;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.findUsages.JavaFindUsagesHandlerFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.findUsages.KotlinClassFindUsagesOptions;
import org.jetbrains.kotlin.idea.findUsages.KotlinFunctionFindUsagesOptions;
import org.jetbrains.kotlin.idea.findUsages.KotlinPropertyFindUsagesOptions;
import org.jetbrains.kotlin.idea.findUsages.handlers.DelegatingFindMemberUsagesHandler;
import org.jetbrains.kotlin.idea.findUsages.handlers.KotlinFindClassUsagesHandler;
import org.jetbrains.kotlin.idea.findUsages.handlers.KotlinFindMemberUsagesHandler;
import org.jetbrains.kotlin.idea.findUsages.handlers.KotlinTypeParameterFindUsagesHandler;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010 \u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u001aH\u0016J\u001e\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001f0'H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/idea/findUsages/KotlinFindUsagesHandlerFactory;", "Lcom/intellij/find/findUsages/FindUsagesHandlerFactory;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "defaultOptions", "Lcom/intellij/find/findUsages/FindUsagesOptions;", "getDefaultOptions", "()Lcom/intellij/find/findUsages/FindUsagesOptions;", "findClassOptions", "Lorg/jetbrains/kotlin/idea/findUsages/KotlinClassFindUsagesOptions;", "getFindClassOptions", "()Lorg/jetbrains/kotlin/idea/findUsages/KotlinClassFindUsagesOptions;", "findFunctionOptions", "Lorg/jetbrains/kotlin/idea/findUsages/KotlinFunctionFindUsagesOptions;", "getFindFunctionOptions", "()Lorg/jetbrains/kotlin/idea/findUsages/KotlinFunctionFindUsagesOptions;", "findPropertyOptions", "Lorg/jetbrains/kotlin/idea/findUsages/KotlinPropertyFindUsagesOptions;", "getFindPropertyOptions", "()Lorg/jetbrains/kotlin/idea/findUsages/KotlinPropertyFindUsagesOptions;", "javaHandlerFactory", "Lcom/intellij/find/findUsages/JavaFindUsagesHandlerFactory;", "getJavaHandlerFactory", "()Lcom/intellij/find/findUsages/JavaFindUsagesHandlerFactory;", "askWhetherShouldSearchForParameterInOverridingMethods", "", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "canFindUsages", "element", "Lcom/intellij/psi/PsiElement;", "createFindUsagesHandler", "Lcom/intellij/find/findUsages/FindUsagesHandler;", "forHighlightUsages", "handlerForMultiple", "originalDeclaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "declarations", "", "idea"})
public final class KotlinFindUsagesHandlerFactory
extends FindUsagesHandlerFactory {
    @NotNull
    private final JavaFindUsagesHandlerFactory javaHandlerFactory;
    @NotNull
    private final KotlinFunctionFindUsagesOptions findFunctionOptions;
    @NotNull
    private final KotlinPropertyFindUsagesOptions findPropertyOptions;
    @NotNull
    private final KotlinClassFindUsagesOptions findClassOptions;
    @NotNull
    private final FindUsagesOptions defaultOptions;

    @NotNull
    public final JavaFindUsagesHandlerFactory getJavaHandlerFactory() {
        return this.javaHandlerFactory;
    }

    @NotNull
    public final KotlinFunctionFindUsagesOptions getFindFunctionOptions() {
        return this.findFunctionOptions;
    }

    @NotNull
    public final KotlinPropertyFindUsagesOptions getFindPropertyOptions() {
        return this.findPropertyOptions;
    }

    @NotNull
    public final KotlinClassFindUsagesOptions getFindClassOptions() {
        return this.findClassOptions;
    }

    @NotNull
    public final FindUsagesOptions getDefaultOptions() {
        return this.defaultOptions;
    }

    public boolean canFindUsages(@NotNull PsiElement element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        return element3 instanceof KtClassOrObject || element3 instanceof KtNamedFunction || element3 instanceof KtProperty || element3 instanceof KtParameter || element3 instanceof KtTypeParameter || element3 instanceof KtConstructor;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public FindUsagesHandler createFindUsagesHandler(@NotNull PsiElement element3, boolean forHighlightUsages) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        PsiElement psiElement2 = element3;
        if (psiElement2 instanceof KtClassOrObject) {
            return new KotlinFindClassUsagesHandler((KtClassOrObject)element3, this);
        }
        if (psiElement2 instanceof KtParameter) {
            if (!forHighlightUsages) {
                PsiMethod psiMethod;
                if (((KtParameter)element3).hasValOrVar()) {
                    List<PsiElement> declarationsToSearch = KotlinRefactoringUtilKt.checkSuperMethods((KtDeclaration)element3, null, KotlinBundle.message("find.usages.action.text.find.usages.of", new Object[0]));
                    return this.handlerForMultiple((KtNamedDeclaration)element3, (Collection<? extends PsiElement>)declarationsToSearch);
                }
                KtDeclarationWithBody function2 = ((KtParameter)element3).getOwnerFunction();
                if (function2 != null && PsiModificationUtilsKt.isOverridable(function2) && (psiMethod = (PsiMethod)CollectionsKt.singleOrNull(LightClassUtilsKt.toLightMethods(function2))) != null) {
                    Query query = OverridingMethodsSearch.search((PsiMethod)psiMethod);
                    Intrinsics.checkExpressionValueIsNotNull((Object)query, (String)"OverridingMethodsSearch.search(psiMethod)");
                    boolean hasOverridden = CollectionsKt.any((Iterable)((Iterable)query));
                    if (hasOverridden && this.askWhetherShouldSearchForParameterInOverridingMethods((KtParameter)element3)) {
                        void $this$mapNotNullTo$iv$iv;
                        Iterable $this$filterTo$iv$iv;
                        PsiParameterList psiParameterList = psiMethod.getParameterList();
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterList, (String)"psiMethod.parameterList");
                        int parametersCount = psiParameterList.getParametersCount();
                        int parameterIndex2 = KtPsiUtilKt.parameterIndex(element3);
                        boolean bl = parameterIndex2 < parametersCount;
                        boolean bl2 = false;
                        boolean bl3 = false;
                        if (_Assertions.ENABLED && !bl) {
                            boolean bl4 = false;
                            String string = "Assertion failed";
                            throw (Throwable)((Object)new AssertionError((Object)string));
                        }
                        Query query2 = OverridingMethodsSearch.search((PsiMethod)psiMethod, (boolean)true);
                        Intrinsics.checkExpressionValueIsNotNull((Object)query2, (String)"OverridingMethodsSearch.search(psiMethod, true)");
                        Iterable $this$filter$iv = (Iterable)query2;
                        boolean $i$f$filter = false;
                        Iterable iterable = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$filterTo = false;
                        for (Object element$iv$iv : $this$filterTo$iv$iv) {
                            PsiMethod it = (PsiMethod)element$iv$iv;
                            boolean bl5 = false;
                            PsiMethod psiMethod2 = it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)psiMethod2, (String)"it");
                            PsiParameterList psiParameterList2 = psiMethod2.getParameterList();
                            Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterList2, (String)"it.parameterList");
                            if (!(psiParameterList2.getParametersCount() == parametersCount)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
                        boolean $i$f$mapNotNull = false;
                        $this$filterTo$iv$iv = $this$mapNotNull$iv;
                        destination$iv$iv = new ArrayList();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                        boolean $i$f$forEach = false;
                        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                        while (iterator2.hasNext()) {
                            PsiElement psiElement3;
                            Object element$iv$iv$iv;
                            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                            boolean bl6 = false;
                            PsiMethod it = (PsiMethod)element$iv$iv;
                            boolean bl7 = false;
                            PsiMethod psiMethod3 = it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)psiMethod3, (String)"it");
                            PsiParameterList psiParameterList3 = psiMethod3.getParameterList();
                            Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterList3, (String)"it.parameterList");
                            PsiParameter psiParameter = psiParameterList3.getParameters()[parameterIndex2];
                            Intrinsics.checkExpressionValueIsNotNull((Object)psiParameter, (String)"it.parameterList.parameters[parameterIndex]");
                            if (LightClassUtilsKt.getUnwrapped((PsiElement)psiParameter) == null) continue;
                            boolean bl8 = false;
                            boolean bl9 = false;
                            PsiElement it$iv$iv = psiElement3;
                            boolean bl10 = false;
                            destination$iv$iv.add(it$iv$iv);
                        }
                        List overridingParameters = (List)destination$iv$iv;
                        return this.handlerForMultiple((KtNamedDeclaration)element3, CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)element3), (Iterable)overridingParameters));
                    }
                }
            }
            return KotlinFindMemberUsagesHandler.Companion.getInstance$default(KotlinFindMemberUsagesHandler.Companion, (KtNamedDeclaration)element3, null, this, 2, null);
        }
        if (psiElement2 instanceof KtNamedFunction || psiElement2 instanceof KtProperty || psiElement2 instanceof KtConstructor) {
            KtNamedDeclaration declaration2 = (KtNamedDeclaration)element3;
            if (forHighlightUsages) {
                return KotlinFindMemberUsagesHandler.Companion.getInstance$default(KotlinFindMemberUsagesHandler.Companion, declaration2, null, this, 2, null);
            }
            List<PsiElement> declarationsToSearch = KotlinRefactoringUtilKt.checkSuperMethods(declaration2, null, KotlinBundle.message("find.usages.action.text.find.usages.of", new Object[0]));
            return this.handlerForMultiple(declaration2, (Collection<? extends PsiElement>)declarationsToSearch);
        }
        if (psiElement2 instanceof KtTypeParameter) {
            return new KotlinTypeParameterFindUsagesHandler((KtNamedDeclaration)element3, this);
        }
        throw (Throwable)new IllegalArgumentException("unexpected element type: " + element3);
    }

    private final FindUsagesHandler handlerForMultiple(KtNamedDeclaration originalDeclaration, Collection<? extends PsiElement> declarations2) {
        FindUsagesHandler findUsagesHandler;
        switch (declarations2.size()) {
            case 0: {
                FindUsagesHandler findUsagesHandler2 = FindUsagesHandler.NULL_HANDLER;
                findUsagesHandler = findUsagesHandler2;
                Intrinsics.checkExpressionValueIsNotNull((Object)findUsagesHandler2, (String)"FindUsagesHandler.NULL_HANDLER");
                break;
            }
            case 1: {
                PsiElement psiElement2 = LightClassUtilsKt.getUnwrapped((PsiElement)CollectionsKt.single((Iterable)declarations2));
                if (psiElement2 == null) {
                    FindUsagesHandler findUsagesHandler3 = FindUsagesHandler.NULL_HANDLER;
                    Intrinsics.checkExpressionValueIsNotNull((Object)findUsagesHandler3, (String)"FindUsagesHandler.NULL_HANDLER");
                    return findUsagesHandler3;
                }
                PsiElement target = psiElement2;
                if (target instanceof KtNamedDeclaration) {
                    findUsagesHandler = KotlinFindMemberUsagesHandler.Companion.getInstance$default(KotlinFindMemberUsagesHandler.Companion, (KtNamedDeclaration)target, null, this, 2, null);
                    break;
                }
                FindUsagesHandler findUsagesHandler4 = this.javaHandlerFactory.createFindUsagesHandler(target, false);
                if (findUsagesHandler4 == null) {
                    Intrinsics.throwNpe();
                }
                findUsagesHandler = findUsagesHandler4;
                Intrinsics.checkExpressionValueIsNotNull((Object)findUsagesHandler4, (String)"javaHandlerFactory.creat\u2026sHandler(target, false)!!");
                break;
            }
            default: {
                findUsagesHandler = new DelegatingFindMemberUsagesHandler(originalDeclaration, declarations2, this);
            }
        }
        return findUsagesHandler;
    }

    private final boolean askWhetherShouldSearchForParameterInOverridingMethods(KtParameter parameter) {
        return Messages.showOkCancelDialog((Project)parameter.getProject(), (String)FindBundle.message((String)"find.parameter.usages.in.overriding.methods.prompt", (Object[])new Object[]{parameter.getName()}), (String)FindBundle.message((String)"find.parameter.usages.in.overriding.methods.title", (Object[])new Object[0]), (String)CommonBundle.getYesButtonText(), (String)CommonBundle.getNoButtonText(), (Icon)Messages.getQuestionIcon()) == 0;
    }

    public KotlinFindUsagesHandlerFactory(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        this.javaHandlerFactory = new JavaFindUsagesHandlerFactory(project2);
        this.findFunctionOptions = new KotlinFunctionFindUsagesOptions(project2);
        this.findPropertyOptions = new KotlinPropertyFindUsagesOptions(project2);
        this.findClassOptions = new KotlinClassFindUsagesOptions(project2);
        this.defaultOptions = new FindUsagesOptions(project2);
    }
}

